/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.build.ui.subset.editors;

import com.ibm.team.enterprise.buildablesubset.common.internal.model.Visibility;
import com.ibm.team.enterprise.internal.build.ui.nls.Messages;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;

public class BuildSubsetPermissionDialog
extends TitleAreaDialog {
    private Visibility fVisibility = null;
    private Object fExistingOwner;

    protected BuildSubsetPermissionDialog(Shell parentShell) {
        this(parentShell, Visibility.PRIVATE_LITERAL, null);
    }

    public BuildSubsetPermissionDialog(Shell parentShell, Visibility existingVisibility, Object existingOwner) {
        super(parentShell);
        this.fVisibility = existingVisibility;
        this.fExistingOwner = existingOwner;
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = new Composite(parent, 64);
        Label titleBarSeparator = new Label(composite, 258);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)titleBarSeparator);
        this.setTitle(Messages.BuildSubsetPermissionDialog_TITLE);
        this.setMessage(Messages.BuildSubsetPermissionDialog_MESSAGE);
        GridLayoutFactory.fillDefaults().numColumns(1).margins(5, 5).applyTo(composite);
        GridDataFactory.fillDefaults().grab(true, true).hint(500, -1).applyTo((Control)composite);
        Button privateButton = new Button(composite, 16);
        GridDataFactory.fillDefaults().indent(5, 0).applyTo((Control)privateButton);
        privateButton.setText(Messages.BuildSubsetPermissionDialog_BUTTON_PRIVATE);
        if (this.fExistingOwner != null) {
            privateButton.setSelection(this.fVisibility != null ? this.fVisibility.getValue() == 1 : true);
        } else {
            privateButton.setSelection(false);
            privateButton.setEnabled(false);
        }
        privateButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BuildSubsetPermissionDialog.this.fVisibility = Visibility.PRIVATE_LITERAL;
            }
        });
        Label privateLabel = new Label(composite, 64);
        GridDataFactory.fillDefaults().indent(10, 0).applyTo((Control)privateLabel);
        privateLabel.setText(Messages.BuildSubsetPermissionDialog_LABEL_PRIVATE);
        if (this.fExistingOwner == null) {
            privateLabel.setEnabled(false);
        }
        new Label(composite, 0);
        Button publicButton = new Button(composite, 16);
        GridDataFactory.fillDefaults().indent(5, 0).applyTo((Control)publicButton);
        publicButton.setText(Messages.BuildSubsetPermissionDialog_BUTTON_PUBLIC);
        if (this.fExistingOwner != null) {
            publicButton.setSelection(this.fVisibility != null ? this.fVisibility.getValue() == 0 : false);
        } else {
            publicButton.setSelection(true);
        }
        publicButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BuildSubsetPermissionDialog.this.fVisibility = Visibility.PUBLIC_LITERAL;
            }
        });
        Label publicLabel = new Label(composite, 64);
        GridDataFactory.fillDefaults().indent(10, 0).hint(100, -1).applyTo((Control)publicLabel);
        publicLabel.setText(Messages.BuildSubsetPermissionDialog_LABEL_PUBLIC);
        BuildSubsetPermissionDialog.applyDialogFont((Control)composite);
        return composite;
    }

    public void create() {
        super.create();
        this.validate(false);
    }

    protected void validate(boolean suppressErrorMessage) {
        String errorMessage = this.getErrorMessage();
        if (errorMessage == null || suppressErrorMessage) {
            this.setErrorMessage(null);
        } else {
            this.setErrorMessage(errorMessage);
        }
        if (this.fExistingOwner == null && this.fVisibility.getValue() == 1) {
            this.setMessage(Messages.BuildSubsetPermissionDialog_ERROR_VISIBILITY_PERSONAL, 2);
            this.fVisibility = Visibility.PUBLIC_LITERAL;
        }
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.BuildSubsetPermissionDialog_MESSAGE_2);
    }

    public Visibility getVisibility() {
        return this.fVisibility;
    }
}

