/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.build.ui.subset.editors;

import com.ibm.team.build.common.model.IBuildDefinition;
import com.ibm.team.enterprise.build.ui.subset.editors.OwnerTreeContentProvider;
import com.ibm.team.enterprise.buildablesubset.common.internal.model.Visibility;
import com.ibm.team.enterprise.internal.build.ui.nls.Messages;
import com.ibm.team.internal.filesystem.ui.util.RepositoryUtils;
import com.ibm.team.jface.labelProviders.ElementRemovedNotifierImpl;
import com.ibm.team.jface.labelProviders.IElementRemovedNotifier;
import com.ibm.team.jface.labelProviders.StandardLabelProvider;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.process.common.ITeamAreaHandle;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IAuditable;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.scm.common.dto.IReadScope;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;

public class BuildSubsetOwnerPicker
extends ElementTreeSelectionDialog {
    private final ITeamRepository fRepo;
    private final IBuildDefinition fBuildDef;
    private final String fDescription;
    private boolean fUseProcessAreaAsOwner;
    private Object fExistingOwner;
    private Visibility fExistingVisibility;

    public BuildSubsetOwnerPicker(Shell shell, ITeamRepository repo, IBuildDefinition buildDef, String description, Object existingOwner, Visibility existingVisibility) {
        super(shell, (ILabelProvider)new StandardLabelProvider((IElementRemovedNotifier)new ElementRemovedNotifierImpl()), (ITreeContentProvider)new OwnerTreeContentProvider(buildDef, existingOwner));
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.fRepo = repo;
        this.fBuildDef = buildDef;
        this.fDescription = description;
        this.fExistingOwner = existingOwner;
        this.fExistingVisibility = existingVisibility;
        this.setInput(this.fRepo);
        this.setMessage(Messages.BuildSubsetOwnerPicker_MESSAGE2);
        this.setAllowMultiple(false);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.BuildSubsetOwnerPicker_TITLE);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        final Button useOwnedProcessArea = new Button(composite, 32);
        useOwnedProcessArea.setText(Messages.BuildSubsetOwnerPicker_BUTTON_DEFAULT);
        useOwnedProcessArea.setLayoutData((Object)new GridData(16384, 1024, true, true, 1, 1));
        useOwnedProcessArea.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                BuildSubsetOwnerPicker.this.fUseProcessAreaAsOwner = useOwnedProcessArea.getSelection();
                BuildSubsetOwnerPicker.this.getTreeViewer().getControl().setEnabled(!BuildSubsetOwnerPicker.this.fUseProcessAreaAsOwner);
                BuildSubsetOwnerPicker.this.updateOKStatus();
            }
        });
        if (this.fExistingOwner == null) {
            useOwnedProcessArea.setSelection(true);
            this.getTreeViewer().getControl().setEnabled(false);
        } else {
            this.getTreeViewer().setSelection((ISelection)new StructuredSelection(this.fExistingOwner));
        }
        this.setEmptyListMessage(NLS.bind((String)Messages.BuildSubsetOwnerPicker_ERROR_NO_PROJECTAREA, (Object)RepositoryUtils.getLabel((ITeamRepository)this.fRepo)));
        this.setAllowMultiple(false);
        this.setValidator(new ISelectionStatusValidator(){

            public IStatus validate(Object[] selection) {
                if (BuildSubsetOwnerPicker.this.fUseProcessAreaAsOwner) {
                    if (BuildSubsetOwnerPicker.this.fExistingVisibility == Visibility.PRIVATE_LITERAL) {
                        return new Status(2, "com.ibm.team.enterprise.build.ui", Messages.BuildSubsetOwnerPicker_ERROR_INVALID_VISIBILITY);
                    }
                } else {
                    if (selection.length < 1) {
                        return new Status(4, "com.ibm.team.enterprise.build.ui", "");
                    }
                    if (selection.length > 1) {
                        return new Status(4, "com.ibm.team.enterprise.build.ui", Messages.BuildSubsetOwnerPicker_ERROR_MULTIPLE_OWNER);
                    }
                    if (selection.length == 1 && !(selection[0] instanceof IContributorHandle)) {
                        return new Status(4, "com.ibm.team.enterprise.build.ui", Messages.BuildSubsetOwnerPicker_ERROR_NONUSER_SELECTED);
                    }
                    if (selection.length == 1 && selection[0] instanceof IContributorHandle && ((IContributorHandle)selection[0]).getItemId().getUuidValue().equals(BuildSubsetOwnerPicker.this.fExistingOwner)) {
                        return new Status(1, "com.ibm.team.enterprise.build.ui", Messages.BuildSubsetOwnerPicker_ERROR_SAMEUSER_SELECTED);
                    }
                }
                return new Status(0, "com.ibm.team.enterprise.build.ui", "");
            }
        });
        this.setTitle(Messages.BuildSubsetOwnerPicker_TITLE2);
        if (this.fDescription != null) {
            this.setMessage(this.fDescription);
        } else {
            this.setMessage(Messages.BuildSubsetOwnerPicker_MESSAGE);
        }
        this.setHelpAvailable(false);
        return composite;
    }

    public boolean useProcessAreaAsOwner() {
        return this.fUseProcessAreaAsOwner;
    }

    public IAuditable getOwner() {
        if (this.useProcessAreaAsOwner()) {
            return null;
        }
        Object obj = this.getFirstResult();
        if (obj != null && obj instanceof IAuditable) {
            return (IAuditable)obj;
        }
        return null;
    }

    public IReadScope getReadScope() {
        Object scope = null;
        IAuditable newOwner = this.getOwner();
        if (newOwner != null) {
            if (newOwner instanceof ITeamAreaHandle) {
                scope = this.fUseProcessAreaAsOwner ? IReadScope.FACTORY.createTeamAreaPrivateScope() : IReadScope.FACTORY.createProcessAreaScope();
            }
            if (newOwner instanceof IProjectAreaHandle) {
                scope = IReadScope.FACTORY.createProcessAreaScope();
            }
            if (newOwner instanceof IContributorHandle) {
                scope = IReadScope.FACTORY.createPrivateScope();
            }
        }
        return scope;
    }
}

