/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.build.ui.subset.dnd;

import com.ibm.team.build.common.model.IBuildDefinition;
import com.ibm.team.build.common.model.IBuildDefinitionHandle;
import com.ibm.team.build.common.model.IBuildResult;
import com.ibm.team.enterprise.build.client.buildablesubset.ClientFactory;
import com.ibm.team.enterprise.build.client.buildablesubset.IBuildableSubsetClient;
import com.ibm.team.enterprise.build.common.DependencyBuildPropertyFactory;
import com.ibm.team.enterprise.build.ui.Activator;
import com.ibm.team.enterprise.build.ui.actions.AddToSubsetFromBuildResultAction;
import com.ibm.team.enterprise.build.ui.subset.BuildSubsetNode;
import com.ibm.team.enterprise.build.ui.subset.dnd.BuildSubsetDNDWorkItemDialog;
import com.ibm.team.enterprise.build.ui.subset.dnd.BuildSubsetFilesDragSourceAdapter;
import com.ibm.team.enterprise.build.ui.subset.editors.BuildableSubsetCriteriaPage;
import com.ibm.team.enterprise.buildablesubset.common.IBuildSubsetRule;
import com.ibm.team.enterprise.buildablesubset.common.impl.DefaultBuildSubsetRule;
import com.ibm.team.enterprise.buildablesubset.common.impl.SubsetBuildSubsetRule2;
import com.ibm.team.enterprise.buildablesubset.common.impl.WorkItemBuildSubsetRule;
import com.ibm.team.enterprise.buildablesubset.common.internal.model.ModelFactory;
import com.ibm.team.enterprise.buildablesubset.common.model.ICriteriaSubset;
import com.ibm.team.enterprise.buildablesubset.common.model.ICriteriaWorkItem;
import com.ibm.team.enterprise.buildablesubset.common.model.ISubset;
import com.ibm.team.enterprise.buildablesubset.common.model.ISubsetFileDesc;
import com.ibm.team.enterprise.buildablesubset.common.model.ISubsetHandle;
import com.ibm.team.enterprise.buildablesubset.common.util.BuildableSubsetUtil;
import com.ibm.team.enterprise.internal.build.ui.nls.Messages;
import com.ibm.team.enterprise.internal.build.ui.utils.BuildUtils;
import com.ibm.team.enterprise.internal.buildmap.common.IBuildFile;
import com.ibm.team.enterprise.rdf.query.common.select.result.Binding;
import com.ibm.team.enterprise.rdf.query.common.select.result.SelectResult;
import com.ibm.team.enterprise.systemdefinition.client.ISystemDefinitionModelClient;
import com.ibm.team.enterprise.systemdefinition.common.model.ILanguageDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.ISystemDefinition;
import com.ibm.team.enterprise.systemdefinition.ui.node.AbstractEnterpriseExtensionsSystemDefinitionNode;
import com.ibm.team.enterprise.zos.internal.systemdefinition.ui.domain.langdef.LanguageDefinitionNodeEE;
import com.ibm.team.filesystem.client.ILocalChange;
import com.ibm.team.filesystem.client.IMetadataProperties;
import com.ibm.team.filesystem.client.IShare;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.internal.era.EraSyncReportFragment;
import com.ibm.team.filesystem.client.internal.namespace.ItemNamespace;
import com.ibm.team.filesystem.client.internal.snapshot.ComponentSyncReportFragment;
import com.ibm.team.filesystem.client.internal.snapshot.FlowType;
import com.ibm.team.filesystem.client.internal.snapshot.SnapshotId;
import com.ibm.team.filesystem.common.IFileItem;
import com.ibm.team.filesystem.common.IFileItemHandle;
import com.ibm.team.filesystem.common.changemodel.FileChange;
import com.ibm.team.filesystem.common.changemodel.VersionablePath;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.ComponentBaselineUtil;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IAbstractConflictItem;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IActivityFolder;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IActivitySource;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IBaselineGroup;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IComponentSyncContext;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IIncomingActivitySource;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IRemoteActivity;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IRemoteChangeSummary;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IUnresolvedFolder;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IUnresolvedSource;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IWorkspaceSyncContext;
import com.ibm.team.filesystem.rcp.core.patches.Patch;
import com.ibm.team.filesystem.rcp.core.patches.PatchFile;
import com.ibm.team.filesystem.rcp.core.patches.PatchModel;
import com.ibm.team.filesystem.rcp.core.patches.PatchOpHandle;
import com.ibm.team.filesystem.ui.changes.views.PatchedDirectory;
import com.ibm.team.filesystem.ui.wrapper.AbstractFileSystemItemWrapper;
import com.ibm.team.filesystem.ui.wrapper.AbstractWrapper;
import com.ibm.team.internal.filesystem.ui.patches.ChangeFolder;
import com.ibm.team.internal.filesystem.ui.views.history.entries.VersionableHistoryEntry;
import com.ibm.team.internal.filesystem.ui.views.structuralchanges.nodes.StructuralChangesComponentNode;
import com.ibm.team.internal.filesystem.ui.views.structuralchanges.nodes.StructuralChangesViewNode;
import com.ibm.team.links.common.IItemReference;
import com.ibm.team.links.common.IReference;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.client.IBaselineConnection;
import com.ibm.team.scm.client.IConfiguration;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.IFlowNodeConnection;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.common.IChange;
import com.ibm.team.scm.common.IChangeSet;
import com.ibm.team.scm.common.IChangeSetHandle;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IFolderHandle;
import com.ibm.team.scm.common.IVersionable;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.IWorkspaceHandle;
import com.ibm.team.scm.common.internal.util.ItemId;
import com.ibm.team.scm.common.internal.util.SiloedItemId;
import com.ibm.team.workitem.common.internal.util.ItemHandleAwareHashSet;
import com.ibm.team.workitem.common.model.IWorkItemHandle;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeNode;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ResourceTransfer;
import org.eclipse.ui.progress.UIJob;

public class BuildSubsetFilesDropTargetAdapter
extends DropTargetAdapter {
    private final StructuredViewer viewer;
    private final Shell shell;
    private final ITeamRepository repository;
    private final IBuildSubsetDropTargetContext context;
    private IWorkspaceConnection subsetWorkspaceConnection;

    public BuildSubsetFilesDropTargetAdapter(StructuredViewer viewer, ITeamRepository repository, IBuildSubsetDropTargetContext context) {
        this.viewer = viewer;
        this.shell = viewer.getControl().getShell();
        this.repository = repository;
        this.context = context;
    }

    public void dragEnter(DropTargetEvent event) {
        if (this.viewer.getControl() == BuildSubsetFilesDragSourceAdapter.CURRENT_SOURCE) {
            event.detail = 0;
            return;
        }
        int detail = 0;
        int i = 0;
        while (i < event.dataTypes.length) {
            block13: {
                block14: {
                    block12: {
                        if (!LocalSelectionTransfer.getTransfer().isSupportedType(event.dataTypes[i]) || LocalSelectionTransfer.getTransfer().getSelection() == null) break block12;
                        ISelection selection = this.getLocalSelectionTransferData();
                        if (selection.isEmpty() || !(selection instanceof IStructuredSelection)) break block13;
                        boolean valid = true;
                        for (Object next : (IStructuredSelection)selection) {
                            if (!((next = BuildSubsetFilesDropTargetAdapter.resolve(next, false)) instanceof IWorkItemHandle || next instanceof IResource || next instanceof ISubsetFileDesc || next instanceof SelectResult || next instanceof BuildSubsetNode || next instanceof ISubset || next instanceof IBuildFile || next instanceof IBuildResult || next instanceof LanguageDefinitionNodeEE || next instanceof com.ibm.team.enterprise.ibmi.internal.definitions.ui.domain.langdef.LanguageDefinitionNodeEE || next instanceof ILanguageDefinition || next instanceof BuildableSubsetCriteriaPage.Criteria || next instanceof IComponentSyncContext || next instanceof IWorkspaceSyncContext || next instanceof AbstractFileSystemItemWrapper || next instanceof IUnresolvedFolder || next instanceof IUnresolvedSource || next instanceof ILocalChange || next instanceof IActivityFolder || next instanceof IRemoteChangeSummary || next instanceof IRemoteActivity || next instanceof IActivitySource || next instanceof IBaselineGroup || next instanceof VersionableHistoryEntry || next instanceof IAbstractConflictItem || next instanceof IChangeSetHandle || next instanceof IComponentHandle || next instanceof VersionablePath || next instanceof PatchOpHandle || next instanceof PatchedDirectory || next instanceof PatchModel || next instanceof Patch || next instanceof FileChange || next instanceof ChangeFolder || next instanceof StructuralChangesComponentNode)) {
                                valid = false;
                            }
                            if (!valid) break;
                        }
                        if (valid) {
                            detail = 1;
                        }
                        break block14;
                    }
                    if (ResourceTransfer.getInstance().isSupportedType(event.dataTypes[i])) {
                        detail = 1;
                    }
                }
                if (detail != 0) break;
            }
            ++i;
        }
        if (detail != 0 && (detail & event.operations) == 0) {
            if ((4 & event.operations) != 0) {
                detail = 4;
            } else if ((2 & event.operations) != 0) {
                detail = 2;
            } else if ((0x10 & event.operations) != 0) {
                detail = 16;
            }
        }
        event.detail = detail;
    }

    public void drop(final DropTargetEvent event) {
        if (LocalSelectionTransfer.getTransfer().isSupportedType(event.currentDataType)) {
            event.data = this.getLocalSelectionTransferData();
        }
        if (event.data instanceof IStructuredSelection) {
            event.data = ((IStructuredSelection)event.data).toArray();
        }
        if (event.data instanceof Object[] && ((Object[])event.data).length > 0) {
            ProgressMonitorDialog dialog = new ProgressMonitorDialog(this.shell);
            try {
                dialog.run(true, true, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        monitor.beginTask("", ((Object[])event.data).length);
                        BuildSubsetFilesDropTargetAdapter.this.subsetWorkspaceConnection = null;
                        ISystemDefinitionModelClient sysDefClient = (ISystemDefinitionModelClient)BuildSubsetFilesDropTargetAdapter.this.repository.getClientLibrary(ISystemDefinitionModelClient.class);
                        HashSet seenResources = new HashSet();
                        ItemHandleAwareHashSet seenVersionableHandles = new ItemHandleAwareHashSet();
                        HashSet<ISubsetFileDesc> droppedFileDescs = new HashSet<ISubsetFileDesc>();
                        final ItemHandleAwareHashSet droppedWorkItems = new ItemHandleAwareHashSet();
                        HashSet<BuildableSubsetCriteriaPage.Criteria> droppedCriteria = new HashSet<BuildableSubsetCriteriaPage.Criteria>();
                        HashSet<ISubset> droppedSubsets = new HashSet<ISubset>();
                        HashSet<Object> droppedLangDefs = new HashSet<Object>();
                        ItemHandleAwareHashSet droppedComponents = new ItemHandleAwareHashSet();
                        HashMap workspaceConnections = new HashMap();
                        try {
                            SubProgressMonitor subMonitor;
                            Object[] objectArray = (Object[])event.data;
                            int n = objectArray.length;
                            int n2 = 0;
                            while (n2 < n) {
                                Object element = objectArray[n2];
                                if (monitor.isCanceled()) {
                                    return;
                                }
                                if ((element = BuildSubsetFilesDropTargetAdapter.resolve(element, false)) instanceof ISubsetFileDesc) {
                                    droppedFileDescs.add((ISubsetFileDesc)element);
                                } else if (element instanceof IResource) {
                                    BuildSubsetFilesDropTargetAdapter.this.dropResource((IResource)element, seenResources, sysDefClient, droppedFileDescs, monitor);
                                } else if (element instanceof IWorkItemHandle) {
                                    droppedWorkItems.add((Object)((IWorkItemHandle)element));
                                } else if (element instanceof BuildSubsetNode) {
                                    ISubset sourceHandle = ((BuildSubsetNode)((Object)element)).getBuildableSubset();
                                    if (!sourceHandle.equals((Object)BuildSubsetFilesDropTargetAdapter.this.context.getTargetSubset())) {
                                        droppedSubsets.add(sourceHandle);
                                    }
                                } else if (element instanceof BuildableSubsetCriteriaPage.Criteria) {
                                    droppedCriteria.add((BuildableSubsetCriteriaPage.Criteria)element);
                                } else if (element instanceof IBuildFile) {
                                    BuildSubsetFilesDropTargetAdapter.this.dropBuildFile((IBuildFile)element, BuildSubsetFilesDropTargetAdapter.this.getTargetSubsetWorkspaceConnection(monitor), sysDefClient, droppedFileDescs, monitor);
                                } else if (element instanceof IBuildResult) {
                                    AddToSubsetFromBuildResultAction.parseBuildableFilesFromBuildReport((IBuildResult)element, BuildSubsetFilesDropTargetAdapter.this.repository, droppedFileDescs, monitor);
                                } else if (element instanceof SelectResult) {
                                    BuildSubsetFilesDropTargetAdapter.this.dropSelectResult((SelectResult)element, sysDefClient, droppedFileDescs, workspaceConnections, monitor);
                                } else if (element instanceof AbstractEnterpriseExtensionsSystemDefinitionNode) {
                                    droppedLangDefs.add(((AbstractEnterpriseExtensionsSystemDefinitionNode)element).getSystemDefinition());
                                } else if (element instanceof ILanguageDefinition) {
                                    ILanguageDefinition ld = (ILanguageDefinition)element;
                                    droppedLangDefs.add(ld);
                                } else {
                                    BuildSubsetFilesDropTargetAdapter.this.dropSCMObject(element, sysDefClient, droppedFileDescs, (ItemHandleAwareHashSet<IComponentHandle>)droppedComponents, (ItemHandleAwareHashSet<IVersionableHandle>)seenVersionableHandles, monitor);
                                }
                                monitor.worked(1);
                                ++n2;
                            }
                            if (monitor.isCanceled()) {
                                return;
                            }
                            final boolean[] skippedElementsNoBuildDef = new boolean[1];
                            final ISubset[] tempSubset = new ISubset[1];
                            ISubset targetHandle = BuildSubsetFilesDropTargetAdapter.this.context.getTargetSubset();
                            final IBuildDefinitionHandle buildDefHandle = BuildSubsetFilesDropTargetAdapter.this.context.getBuildDefinitionHandle();
                            if (droppedCriteria.size() > 0 || droppedWorkItems.size() > 0) {
                                if (buildDefHandle == null) {
                                    skippedElementsNoBuildDef[0] = true;
                                } else {
                                    subMonitor = new SubProgressMonitor(monitor, 1);
                                    subMonitor.beginTask("", 1);
                                    subMonitor.setTaskName(Messages.BuildSubsetFilesDropTargetAdapter_ProcessingWorkItems);
                                    if (droppedWorkItems.size() > 0) {
                                        BuildSubsetFilesDropTargetAdapter.this.shell.getDisplay().syncExec(new Runnable(){

                                            @Override
                                            public void run() {
                                                ISubset result;
                                                BuildSubsetDNDWorkItemDialog dialog = new BuildSubsetDNDWorkItemDialog(BuildSubsetFilesDropTargetAdapter.this.context.getTargetSubset(), BuildSubsetFilesDropTargetAdapter.this.shell, (ItemHandleAwareHashSet<IWorkItemHandle>)droppedWorkItems, BuildSubsetFilesDropTargetAdapter.this.repository, buildDefHandle, false);
                                                if (dialog.open() == 0 && (result = dialog.getResultSubset()) != null && !result.getFileDescs().isEmpty()) {
                                                    if (tempSubset[0] == null) {
                                                        tempSubset[0] = result;
                                                    } else {
                                                        BuildableSubsetUtil.merge3((List)tempSubset[0].getFileDescs(), (List)tempSubset[0].getCriteria().getReferences(), (ISubset)result);
                                                    }
                                                }
                                            }
                                        });
                                    }
                                    if (droppedCriteria.size() > 0) {
                                        IBuildableSubsetClient iBuildableSubsetClient = ClientFactory.getBuildableSubsetClient((ITeamRepository)BuildSubsetFilesDropTargetAdapter.this.repository);
                                        for (BuildableSubsetCriteriaPage.Criteria criteria : droppedCriteria) {
                                            IWorkItemHandle wiHandle = (IWorkItemHandle)criteria.getAdapter(IWorkItemHandle.class);
                                            ICriteriaWorkItem wiCriterion = (ICriteriaWorkItem)criteria.getAdapter(ICriteriaWorkItem.class);
                                            if (wiCriterion == null || wiHandle == null) continue;
                                            WorkItemBuildSubsetRule subsetRule = new WorkItemBuildSubsetRule();
                                            subsetRule.setDynamic(false);
                                            subsetRule.setIncludeChildren(wiCriterion.isIncludeChildren());
                                            subsetRule.addWorkItem(wiHandle);
                                            ISubset result = iBuildableSubsetClient.processRule((IBuildSubsetRule)subsetRule, buildDefHandle, targetHandle, wiCriterion.isIncludeImpacted());
                                            if (result == null || result.getFileDescs().isEmpty()) continue;
                                            if (tempSubset[0] == null) {
                                                tempSubset[0] = result;
                                                continue;
                                            }
                                            BuildableSubsetUtil.merge3((List)tempSubset[0].getFileDescs(), (List)tempSubset[0].getCriteria().getReferences(), (ISubset)result);
                                        }
                                    }
                                }
                                monitor.worked(1);
                            }
                            if (monitor.isCanceled()) {
                                return;
                            }
                            if (droppedComponents.size() > 0) {
                                if (buildDefHandle == null) {
                                    skippedElementsNoBuildDef[0] = true;
                                } else {
                                    List components = BuildSubsetFilesDropTargetAdapter.this.repository.itemManager().fetchPartialItems(new ArrayList(droppedComponents), 0, Arrays.asList(IComponent.NAME_PROPERTY), monitor);
                                    for (IComponent iComponent : components) {
                                        if (monitor.isCanceled()) {
                                            return;
                                        }
                                        SubProgressMonitor subMonitor2 = new SubProgressMonitor(monitor, 1);
                                        subMonitor2.beginTask("", droppedComponents.size());
                                        subMonitor2.setTaskName(NLS.bind((String)Messages.BuildSubsetFilesDropTargetAdapter_ProcessingComponent, (Object)iComponent.getName()));
                                        DefaultBuildSubsetRule rule = new DefaultBuildSubsetRule();
                                        rule.setComponentHandle((IComponentHandle)iComponent);
                                        ISubset result = ClientFactory.getBuildableSubsetClient((ITeamRepository)BuildSubsetFilesDropTargetAdapter.this.repository).processRule((IBuildSubsetRule)rule, buildDefHandle, targetHandle);
                                        if (result != null && !result.getFileDescs().isEmpty()) {
                                            if (tempSubset[0] == null) {
                                                tempSubset[0] = result;
                                            } else {
                                                BuildableSubsetUtil.merge3((List)tempSubset[0].getFileDescs(), (List)tempSubset[0].getCriteria().getReferences(), (ISubset)result);
                                            }
                                        }
                                        monitor.worked(1);
                                    }
                                }
                            }
                            if (monitor.isCanceled()) {
                                return;
                            }
                            if (droppedLangDefs.size() > 0) {
                                if (buildDefHandle == null) {
                                    skippedElementsNoBuildDef[0] = true;
                                } else {
                                    subMonitor = new SubProgressMonitor(monitor, 1);
                                    subMonitor.beginTask("", droppedLangDefs.size());
                                    for (ISystemDefinition iSystemDefinition : droppedLangDefs) {
                                        if (monitor.isCanceled()) {
                                            return;
                                        }
                                        subMonitor.setTaskName(NLS.bind((String)Messages.BuildSubsetFilesDropTargetAdapter_ProcessingLanguageDefinition, (Object)iSystemDefinition.getName()));
                                        DefaultBuildSubsetRule rule = new DefaultBuildSubsetRule();
                                        rule.setLanguageDefinitionId(iSystemDefinition.getItemId());
                                        ISubset result = ClientFactory.getBuildableSubsetClient((ITeamRepository)BuildSubsetFilesDropTargetAdapter.this.repository).processRule((IBuildSubsetRule)rule, buildDefHandle, targetHandle);
                                        if (result != null && !result.getFileDescs().isEmpty()) {
                                            if (tempSubset[0] == null) {
                                                tempSubset[0] = result;
                                            } else {
                                                BuildableSubsetUtil.merge3((List)tempSubset[0].getFileDescs(), (List)tempSubset[0].getCriteria().getReferences(), (ISubset)result);
                                            }
                                        }
                                        monitor.worked(1);
                                    }
                                }
                            }
                            if (monitor.isCanceled()) {
                                return;
                            }
                            if (droppedSubsets.size() > 0) {
                                if (buildDefHandle == null) {
                                    skippedElementsNoBuildDef[0] = true;
                                } else {
                                    subMonitor = new SubProgressMonitor(monitor, 1);
                                    subMonitor.beginTask("", 1);
                                    subMonitor.setTaskName(Messages.BuildSubsetFilesDropTargetAdapter_ProcessingSubsets);
                                    SubsetBuildSubsetRule2 subsetBuildSubsetRule2 = new SubsetBuildSubsetRule2();
                                    subsetBuildSubsetRule2.setTargetSubset((ISubsetHandle)targetHandle);
                                    for (ISubset iSubset : droppedSubsets) {
                                        if (targetHandle != null && targetHandle.getLabel().equals(iSubset.getLabel()) && targetHandle.getBuildDefinition().getItemId().equals((Object)iSubset.getBuildDefinition().getItemId())) continue;
                                        subsetBuildSubsetRule2.addEntry(iSubset.getLabel(), (ISubsetHandle)iSubset);
                                    }
                                    ISubset iSubset = ClientFactory.getBuildableSubsetClient((ITeamRepository)BuildSubsetFilesDropTargetAdapter.this.repository).processRule((IBuildSubsetRule)subsetBuildSubsetRule2, buildDefHandle, targetHandle);
                                    if (iSubset != null && !iSubset.getFileDescs().isEmpty()) {
                                        if (tempSubset[0] == null) {
                                            tempSubset[0] = iSubset;
                                        } else {
                                            BuildableSubsetUtil.merge3((List)tempSubset[0].getFileDescs(), (List)tempSubset[0].getCriteria().getReferences(), (ISubset)iSubset);
                                        }
                                    }
                                }
                                monitor.worked(1);
                            }
                            if (monitor.isCanceled()) {
                                return;
                            }
                            if (droppedFileDescs.size() > 0) {
                                if (tempSubset[0] == null) {
                                    tempSubset[0] = BuildSubsetFilesDropTargetAdapter.this.context.getTargetSubset() != null ? (ISubset)BuildSubsetFilesDropTargetAdapter.this.context.getTargetSubset().getWorkingCopy() : (ISubset)ModelFactory.eINSTANCE.createSubset().getWorkingCopy();
                                    tempSubset[0].getFileDescs().clear();
                                    tempSubset[0].getFileDescs().addAll(new ArrayList<ISubsetFileDesc>(droppedFileDescs));
                                } else {
                                    BuildableSubsetUtil.merge3((List)tempSubset[0].getFileDescs(), new ArrayList<ISubsetFileDesc>(droppedFileDescs));
                                }
                            }
                            if (monitor.isCanceled()) {
                                return;
                            }
                            if (tempSubset[0] != null || skippedElementsNoBuildDef[0]) {
                                new UIJob(""){

                                    public IStatus runInUIThread(IProgressMonitor monitor) {
                                        if (tempSubset[0] != null) {
                                            BuildSubsetFilesDropTargetAdapter.this.context.drop(tempSubset[0]);
                                        }
                                        if (skippedElementsNoBuildDef[0]) {
                                            MessageDialog.openWarning((Shell)BuildSubsetFilesDropTargetAdapter.this.shell, (String)Messages.BuildSubsetFilesDropTargetAdapter_ErrorTitle, (String)Messages.BuildSubsetFilesDropTargetAdapter_NoBuildDef);
                                        }
                                        return Status.OK_STATUS;
                                    }
                                }.schedule();
                            }
                        }
                        catch (Exception e) {
                            throw new InvocationTargetException(e);
                        }
                    }
                });
            }
            catch (Throwable t) {
                if (t instanceof InvocationTargetException) {
                    t = ((InvocationTargetException)t).getCause();
                }
                IStatus status = Activator.getDefault().createErrorStatus(t);
                ErrorDialog.openError((Shell)this.shell, (String)Messages.BuildSubsetFilesDropTargetAdapter_ErrorTitle, (String)Messages.BuildSubsetFilesDropTargetAdapter_ErrorMessage, (IStatus)status);
                Activator.getDefault().logError(status);
            }
        }
    }

    private ISelection getLocalSelectionTransferData() {
        IWorkbenchPartSite site;
        IWorkbenchPart part;
        IWorkbenchPage page;
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window != null && (page = window.getActivePage()) != null && (part = page.getActivePart()) != null && (site = part.getSite()) != null && site.getSelectionProvider() != null && "com.ibm.team.filesystem.ui.changes.views.ChangeExplorerView".equals(site.getId())) {
            return site.getSelectionProvider().getSelection();
        }
        return LocalSelectionTransfer.getTransfer().getSelection();
    }

    public static Object resolve(Object element, boolean resolveCriteria) {
        Object adapted;
        if (element instanceof IReference && ((IReference)element).isItemReference()) {
            element = ((IItemReference)element).getReferencedItem();
        }
        if (element instanceof StructuralChangesComponentNode) {
            return element;
        }
        if (element instanceof StructuralChangesViewNode) {
            element = ((StructuralChangesViewNode)element).getWrapper();
        }
        if (element instanceof AbstractWrapper) {
            element = ((AbstractWrapper)element).getItem();
        }
        if (element instanceof TreeNode) {
            element = ((TreeNode)element).getValue();
        }
        if (resolveCriteria && element instanceof IAdaptable && (adapted = ((IAdaptable)element).getAdapter(ICriteriaSubset.class)) != null) {
            element = adapted;
        }
        return element;
    }

    private void dropSCMObject(Object element, ISystemDefinitionModelClient sysDefClient, Set<ISubsetFileDesc> droppedFiles, ItemHandleAwareHashSet<IComponentHandle> droppedComponents, ItemHandleAwareHashSet<IVersionableHandle> seenFiles, IProgressMonitor monitor) throws TeamRepositoryException {
        if (element instanceof AbstractFileSystemItemWrapper) {
            this.dropItemWrapper((AbstractFileSystemItemWrapper)element, seenFiles, sysDefClient, droppedFiles, monitor);
        } else if (element instanceof ILocalChange) {
            this.dropLocalChange((ILocalChange)element, seenFiles, sysDefClient, droppedFiles, monitor);
        } else if (element instanceof IUnresolvedFolder) {
            this.dropUnresolvedFolder((IUnresolvedFolder)element, seenFiles, sysDefClient, droppedFiles, droppedComponents, monitor);
        } else if (element instanceof IActivityFolder) {
            this.dropActivityFolder((IActivityFolder)element, seenFiles, sysDefClient, droppedFiles, monitor);
        } else if (element instanceof IRemoteActivity) {
            this.dropRemoteActivity((IRemoteActivity)element, seenFiles, sysDefClient, droppedFiles, droppedComponents, monitor);
        } else if (element instanceof IRemoteChangeSummary) {
            this.dropRemoteChangeSummary((IRemoteChangeSummary)element, seenFiles, sysDefClient, droppedFiles, monitor);
        } else if (element instanceof IUnresolvedSource) {
            this.dropUnresolvedSource((IUnresolvedSource)element, seenFiles, sysDefClient, droppedFiles, droppedComponents, monitor);
        } else if (element instanceof IActivitySource) {
            this.dropActivitySource((IActivitySource)element, seenFiles, sysDefClient, droppedFiles, droppedComponents, monitor);
        } else if (element instanceof IBaselineGroup) {
            this.dropBaselineGroup((IBaselineGroup)element, seenFiles, sysDefClient, droppedFiles, droppedComponents, monitor);
        } else if (element instanceof VersionableHistoryEntry) {
            this.dropHistoryEntry((VersionableHistoryEntry)element, seenFiles, sysDefClient, droppedFiles, droppedComponents, monitor);
        } else if (element instanceof IAbstractConflictItem) {
            this.dropConflictItem((IAbstractConflictItem)element, seenFiles, sysDefClient, droppedFiles, monitor);
        } else if (element instanceof IChangeSetHandle) {
            this.dropChangeSet((IChangeSetHandle)element, this.getTargetSubsetWorkspaceConnection(monitor), seenFiles, sysDefClient, droppedFiles, monitor);
        } else if (element instanceof IComponentHandle) {
            droppedComponents.add((Object)((IComponentHandle)element));
        } else if (element instanceof IComponentSyncContext) {
            this.dropComponentSyncContext((IComponentSyncContext)element, seenFiles, sysDefClient, droppedFiles, droppedComponents, monitor);
        } else if (element instanceof IWorkspaceSyncContext) {
            this.dropWorkspaceSyncContext((IWorkspaceSyncContext)element, seenFiles, sysDefClient, droppedFiles, droppedComponents, monitor);
        } else if (element instanceof VersionablePath) {
            this.dropVersionablePath((VersionablePath)element, seenFiles, sysDefClient, droppedFiles, monitor);
        } else if (element instanceof PatchOpHandle) {
            this.dropPatchOpHandle((PatchOpHandle)element, seenFiles, sysDefClient, droppedFiles, monitor);
        } else if (element instanceof PatchedDirectory) {
            this.dropPatchedDirectory((PatchedDirectory)element, seenFiles, sysDefClient, droppedFiles, monitor);
        } else if (element instanceof PatchModel) {
            this.dropPatchModel((PatchModel)element, seenFiles, sysDefClient, droppedFiles, monitor);
        } else if (element instanceof Patch) {
            this.dropPatch((Patch)element, seenFiles, sysDefClient, droppedFiles, monitor);
        } else if (element instanceof FileChange) {
            this.dropFileChange((FileChange)element, seenFiles, sysDefClient, droppedFiles, monitor);
        } else if (element instanceof ChangeFolder) {
            this.dropChangeFolder((ChangeFolder)element, seenFiles, sysDefClient, droppedFiles, monitor);
        } else if (element instanceof StructuralChangesComponentNode) {
            this.dropStructuralChangesComponentNode((StructuralChangesComponentNode)element, seenFiles, sysDefClient, droppedFiles, monitor);
        }
    }

    private void dropResource(IResource resource, final Set<IResource> seenFiles, final ISystemDefinitionModelClient sysDefClient, final Set<ISubsetFileDesc> droppedFiles, final IProgressMonitor monitor) throws CoreException {
        resource.accept(new IResourceVisitor(){

            public boolean visit(IResource resource) throws CoreException {
                if (monitor.isCanceled()) {
                    return false;
                }
                IResource hfsDir = this.getPotentialHFSDirectory(resource);
                if (hfsDir != null) {
                    this.visitFile(hfsDir);
                    return false;
                }
                if (resource.getType() == 1) {
                    this.visitFile(resource);
                    return false;
                }
                return true;
            }

            private void visitFile(IResource file) {
                if (seenFiles.contains(file)) {
                    return;
                }
                seenFiles.add(file);
                IShareable shareable = (IShareable)file.getAdapter(IShareable.class);
                if (shareable != null) {
                    try {
                        BuildSubsetFilesDropTargetAdapter.this.dropShareable(shareable, (ItemHandleAwareHashSet<IVersionableHandle>)null, shareable.getShare(monitor).getSharingDescriptor().getComponent(), sysDefClient, droppedFiles, monitor);
                    }
                    catch (Exception e) {
                        Activator.getDefault().logError(e);
                    }
                }
            }

            private IResource getPotentialHFSDirectory(IResource resource) {
                IContainer parent;
                if (resource.getType() == 1) {
                    return this.getPotentialHFSDirectory((IResource)resource.getParent());
                }
                if (resource.getType() == 2 && (parent = resource.getParent()) != null) {
                    if (parent.getType() == 2) {
                        return this.getPotentialHFSDirectory((IResource)parent);
                    }
                    if (parent.getType() == 4 && !"zOSsrc".equals(resource.getName())) {
                        return resource;
                    }
                }
                return null;
            }
        });
    }

    private void dropChangeSet(IChangeSetHandle changeSetHandle, IWorkspaceConnection workspaceConnection, ItemHandleAwareHashSet<IVersionableHandle> seenFiles, ISystemDefinitionModelClient sysDefClient, Set<ISubsetFileDesc> droppedFiles, IProgressMonitor monitor) throws TeamRepositoryException {
        if (workspaceConnection != null) {
            IChangeSet changeSet = (IChangeSet)this.repository.itemManager().fetchCompleteItem((IItemHandle)changeSetHandle, 0, monitor);
            IConfiguration configuration = workspaceConnection.configuration(changeSet.getComponent());
            this.dropChangeSet(changeSetHandle, configuration, seenFiles, sysDefClient, droppedFiles, monitor);
        }
    }

    private void dropChangeSet(IChangeSetHandle changeSetHandle, IConfiguration configuration, ItemHandleAwareHashSet<IVersionableHandle> seenFiles, ISystemDefinitionModelClient sysDefClient, Set<ISubsetFileDesc> droppedFiles, IProgressMonitor monitor) throws TeamRepositoryException {
        if (configuration != null) {
            IChangeSet changeSet = (IChangeSet)this.repository.itemManager().fetchCompleteItem((IItemHandle)changeSetHandle, 0, monitor);
            List changes = changeSet.changes();
            for (IChange change : changes) {
                if (monitor.isCanceled()) {
                    return;
                }
                IVersionableHandle item = change.item();
                this.dropVersionable(item, false, item.getItemId().getUuidValue(), configuration, seenFiles, sysDefClient, droppedFiles, monitor);
            }
        }
    }

    private void dropLocalChange(ILocalChange change, ItemHandleAwareHashSet<IVersionableHandle> seenFiles, ISystemDefinitionModelClient sysDefClient, Set<ISubsetFileDesc> droppedFiles, IProgressMonitor monitor) throws TeamRepositoryException {
        this.dropShareable(change.getShareable(), seenFiles, change.getComponent(), sysDefClient, droppedFiles, monitor);
    }

    private void dropConflictItem(IAbstractConflictItem conflict, ItemHandleAwareHashSet<IVersionableHandle> seenFiles, ISystemDefinitionModelClient sysDefClient, Set<ISubsetFileDesc> droppedFiles, IProgressMonitor monitor) throws TeamRepositoryException {
        IComponentSyncContext context = conflict.getComponentSyncContext();
        IIncomingActivitySource activitySource = context.getIncomingActivitySource();
        if (activitySource == null) {
            activitySource = context.getOutgoingActivitySource();
        }
        IConfiguration configuration = context.getTeamPlace((IActivitySource)activitySource).configuration((IComponentHandle)context.getComponent());
        this.dropVersionable(conflict.getItem(), false, conflict.getName(false), configuration, seenFiles, sysDefClient, droppedFiles, monitor);
    }

    private void dropComponentSyncContext(IComponentSyncContext componentContext, ItemHandleAwareHashSet<IVersionableHandle> seenFiles, ISystemDefinitionModelClient sysDefClient, Set<ISubsetFileDesc> droppedFiles, ItemHandleAwareHashSet<IComponentHandle> droppedComponents, IProgressMonitor monitor) throws TeamRepositoryException {
        this.dropUnresolvedSource(componentContext.getUnresolvedSource(), seenFiles, sysDefClient, droppedFiles, droppedComponents, monitor);
        List activitySources = componentContext.getActivitySources();
        for (IActivitySource activitySource : activitySources) {
            this.dropActivitySource(activitySource, seenFiles, sysDefClient, droppedFiles, droppedComponents, monitor);
        }
    }

    private void dropWorkspaceSyncContext(IWorkspaceSyncContext workspaceContext, ItemHandleAwareHashSet<IVersionableHandle> seenFiles, ISystemDefinitionModelClient sysDefClient, Set<ISubsetFileDesc> droppedFiles, ItemHandleAwareHashSet<IComponentHandle> droppedComponents, IProgressMonitor monitor) throws TeamRepositoryException {
        IComponentSyncContext[] iComponentSyncContextArray = workspaceContext.getComponentSyncContexts();
        int n = iComponentSyncContextArray.length;
        int n2 = 0;
        while (n2 < n) {
            IComponentSyncContext componentContext = iComponentSyncContextArray[n2];
            this.dropComponentSyncContext(componentContext, seenFiles, sysDefClient, droppedFiles, droppedComponents, monitor);
            ++n2;
        }
    }

    private void dropUnresolvedFolder(IUnresolvedFolder folder, ItemHandleAwareHashSet<IVersionableHandle> seenFiles, ISystemDefinitionModelClient sysDefClient, Set<ISubsetFileDesc> droppedFiles, ItemHandleAwareHashSet<IComponentHandle> droppedComponents, IProgressMonitor monitor) throws TeamRepositoryException {
        Collection children = folder.getChildren();
        for (Object kid : children) {
            if (monitor.isCanceled()) {
                return;
            }
            this.dropSCMObject(kid, sysDefClient, droppedFiles, droppedComponents, seenFiles, monitor);
        }
    }

    private void dropUnresolvedSource(IUnresolvedSource source, ItemHandleAwareHashSet<IVersionableHandle> seenFiles, ISystemDefinitionModelClient sysDefClient, Set<ISubsetFileDesc> droppedFiles, ItemHandleAwareHashSet<IComponentHandle> droppedComponents, IProgressMonitor monitor) throws TeamRepositoryException {
        Collection children = source.getChildren();
        for (IUnresolvedFolder kid : children) {
            if (monitor.isCanceled()) {
                return;
            }
            this.dropUnresolvedFolder(kid, seenFiles, sysDefClient, droppedFiles, droppedComponents, monitor);
        }
    }

    private void dropActivityFolder(IActivityFolder folder, ItemHandleAwareHashSet<IVersionableHandle> seenFiles, ISystemDefinitionModelClient sysDefClient, Set<ISubsetFileDesc> droppedFiles, IProgressMonitor monitor) throws TeamRepositoryException {
        List children = folder.getChanges();
        for (IRemoteChangeSummary kid : children) {
            if (monitor.isCanceled()) {
                return;
            }
            this.dropRemoteChangeSummary(kid, seenFiles, sysDefClient, droppedFiles, monitor);
        }
    }

    private void dropActivitySource(IActivitySource activitySource, ItemHandleAwareHashSet<IVersionableHandle> seenFiles, ISystemDefinitionModelClient sysDefClient, Set<ISubsetFileDesc> droppedFiles, ItemHandleAwareHashSet<IComponentHandle> droppedComponents, IProgressMonitor monitor) throws TeamRepositoryException {
        List activities = activitySource.getActivities();
        for (IRemoteActivity activity : activities) {
            if (monitor.isCanceled()) {
                return;
            }
            this.dropRemoteActivity(activity, seenFiles, sysDefClient, droppedFiles, droppedComponents, monitor);
        }
        List baselines = activitySource.getBaselines();
        for (IBaselineGroup baseline : baselines) {
            if (monitor.isCanceled()) {
                return;
            }
            this.dropBaselineGroup(baseline, seenFiles, sysDefClient, droppedFiles, droppedComponents, monitor);
        }
    }

    private void dropBaselineGroup(IBaselineGroup baseline, ItemHandleAwareHashSet<IVersionableHandle> seenFiles, ISystemDefinitionModelClient sysDefClient, Set<ISubsetFileDesc> droppedFiles, ItemHandleAwareHashSet<IComponentHandle> droppedComponents, IProgressMonitor monitor) throws TeamRepositoryException {
        if (!baseline.isResolved()) {
            ComponentBaselineUtil.resolve((IBaselineGroup)baseline);
        }
        List activities = baseline.getActivities();
        for (IRemoteActivity activity : activities) {
            if (monitor.isCanceled()) {
                return;
            }
            this.dropRemoteActivity(activity, seenFiles, sysDefClient, droppedFiles, droppedComponents, monitor);
        }
    }

    private void dropHistoryEntry(VersionableHistoryEntry entry, ItemHandleAwareHashSet<IVersionableHandle> seenFiles, ISystemDefinitionModelClient sysDefClient, Set<ISubsetFileDesc> droppedFiles, ItemHandleAwareHashSet<IComponentHandle> droppedComponents, IProgressMonitor monitor) throws TeamRepositoryException {
        IConfiguration configuration;
        if (entry.getTargetItem() != null) {
            this.dropItemWrapper(entry.getTargetItem(), seenFiles, sysDefClient, droppedFiles, monitor);
        } else if (entry.getChangeSet() != null && entry.getChangeSet().getChangeSet() != null && (configuration = this.getConfiguration(entry.getDynamicContext().getNamespace(), monitor)) != null) {
            this.dropChangeSet((IChangeSetHandle)entry.getChangeSet().getChangeSet(), configuration, seenFiles, sysDefClient, droppedFiles, monitor);
        }
    }

    private void dropPatchOpHandle(PatchOpHandle handle, ItemHandleAwareHashSet<IVersionableHandle> seenFiles, ISystemDefinitionModelClient sysDefClient, Set<ISubsetFileDesc> droppedFiles, IProgressMonitor monitor) throws TeamRepositoryException {
        this.dropVersionablePath(handle.getFilePath(), seenFiles, sysDefClient, droppedFiles, monitor);
    }

    private void dropVersionablePath(VersionablePath path, ItemHandleAwareHashSet<IVersionableHandle> seenFiles, ISystemDefinitionModelClient sysDefClient, Set<ISubsetFileDesc> droppedFiles, IProgressMonitor monitor) throws TeamRepositoryException {
        this.dropSiloedItemId((SiloedItemId<IVersionable>)path.getSiloedItemId(), path.getFileName(), seenFiles, sysDefClient, droppedFiles, monitor);
    }

    private void dropSiloedItemId(SiloedItemId<IVersionable> item, String name, ItemHandleAwareHashSet<IVersionableHandle> seenFiles, ISystemDefinitionModelClient sysDefClient, Set<ISubsetFileDesc> droppedFiles, IProgressMonitor monitor) throws TeamRepositoryException {
        IWorkspaceConnection connection = this.getTargetSubsetWorkspaceConnection(monitor);
        if (connection != null) {
            IConfiguration configuration = connection.configuration(item.getComponentHandle());
            this.dropVersionable(item.toHandle(), false, name, configuration, seenFiles, sysDefClient, droppedFiles, monitor);
        }
    }

    private void dropFileChange(FileChange change, ItemHandleAwareHashSet<IVersionableHandle> seenFiles, ISystemDefinitionModelClient sysDefClient, Set<ISubsetFileDesc> droppedFiles, IProgressMonitor monitor) throws TeamRepositoryException {
        String name = null;
        name = change.getFinal() != null ? change.getFinal().getPath().getName() : (change.getInitial() != null ? change.getInitial().getPath().getName() : change.getItemId().getItemUUID().getUuidValue());
        this.dropSiloedItemId((SiloedItemId<IVersionable>)change.getSiloedItemId(), name, seenFiles, sysDefClient, droppedFiles, monitor);
    }

    private void dropChangeFolder(ChangeFolder folder, ItemHandleAwareHashSet<IVersionableHandle> seenFiles, ISystemDefinitionModelClient sysDefClient, Set<ISubsetFileDesc> droppedFiles, IProgressMonitor monitor) throws TeamRepositoryException {
        for (FileChange change : folder.getChanges()) {
            this.dropFileChange(change, seenFiles, sysDefClient, droppedFiles, monitor);
        }
    }

    private void dropStructuralChangesComponentNode(StructuralChangesComponentNode node, ItemHandleAwareHashSet<IVersionableHandle> seenFiles, ISystemDefinitionModelClient sysDefClient, Set<ISubsetFileDesc> droppedFiles, IProgressMonitor monitor) throws TeamRepositoryException {
        ComponentSyncReportFragment incoming = node.getReport(FlowType.Incoming);
        ComponentSyncReportFragment outgoing = node.getReport(FlowType.Outgoing);
        node.getContext().getConnection(monitor);
        if (incoming != null) {
            this.dropComponentSyncReportFragment(incoming, node.getContext(), (IComponentHandle)node.getComponent(), seenFiles, sysDefClient, droppedFiles, monitor);
        }
        if (outgoing != null) {
            this.dropComponentSyncReportFragment(outgoing, node.getContext(), (IComponentHandle)node.getComponent(), seenFiles, sysDefClient, droppedFiles, monitor);
        }
    }

    private void dropComponentSyncReportFragment(ComponentSyncReportFragment fragment, SnapshotId context, IComponentHandle componentHandle, ItemHandleAwareHashSet<IVersionableHandle> seenFiles, ISystemDefinitionModelClient sysDefClient, Set<ISubsetFileDesc> droppedFiles, IProgressMonitor monitor) throws TeamRepositoryException {
        IConfiguration configuration = this.getConfiguration(context.getConnection(monitor), componentHandle, monitor);
        if (configuration == null) {
            return;
        }
        EraSyncReportFragment changeSets = fragment.getChangeSets();
        for (ItemId changeSet : changeSets.getChangeSets()) {
            this.dropChangeSet((IChangeSetHandle)changeSet.toHandle(), configuration, seenFiles, sysDefClient, droppedFiles, monitor);
        }
        for (ItemId changeSet : changeSets.getActiveChangeStates().keySet()) {
            this.dropChangeSet((IChangeSetHandle)changeSet.toHandle(), configuration, seenFiles, sysDefClient, droppedFiles, monitor);
        }
        for (ItemId changeSet : changeSets.getCloses()) {
            this.dropChangeSet((IChangeSetHandle)changeSet.toHandle(), configuration, seenFiles, sysDefClient, droppedFiles, monitor);
        }
    }

    private void dropPatchedDirectory(PatchedDirectory dir, ItemHandleAwareHashSet<IVersionableHandle> seenFiles, ISystemDefinitionModelClient sysDefClient, Set<ISubsetFileDesc> droppedFiles, IProgressMonitor monitor) throws TeamRepositoryException {
        for (PatchFile file : dir.getFiles()) {
            this.dropVersionablePath(file.getVersionablePath(), seenFiles, sysDefClient, droppedFiles, monitor);
        }
    }

    private void dropPatch(Patch patch, ItemHandleAwareHashSet<IVersionableHandle> seenFiles, ISystemDefinitionModelClient sysDefClient, Set<ISubsetFileDesc> droppedFiles, IProgressMonitor monitor) throws TeamRepositoryException {
        for (PatchFile file : patch.getPatchedFiles()) {
            this.dropVersionablePath(file.getVersionablePath(), seenFiles, sysDefClient, droppedFiles, monitor);
        }
    }

    private void dropPatchModel(PatchModel model, ItemHandleAwareHashSet<IVersionableHandle> seenFiles, ISystemDefinitionModelClient sysDefClient, Set<ISubsetFileDesc> droppedFiles, IProgressMonitor monitor) throws TeamRepositoryException {
        for (Patch patch : model.getPatches()) {
            this.dropPatch(patch, seenFiles, sysDefClient, droppedFiles, monitor);
        }
    }

    private void dropRemoteChangeSummary(IRemoteChangeSummary change, ItemHandleAwareHashSet<IVersionableHandle> seenFiles, ISystemDefinitionModelClient sysDefClient, Set<ISubsetFileDesc> droppedFiles, IProgressMonitor monitor) throws TeamRepositoryException {
        IActivitySource activitySource = change.getActivity().getActivitySource();
        IConfiguration configuration = activitySource.getModel().getTeamPlace(activitySource).configuration(change.getChangeSummary().component());
        this.dropVersionable(change.getItem(), false, change.getResourceName(), configuration, seenFiles, sysDefClient, droppedFiles, monitor);
    }

    private void dropRemoteActivity(IRemoteActivity activity, ItemHandleAwareHashSet<IVersionableHandle> seenFiles, ISystemDefinitionModelClient sysDefClient, Set<ISubsetFileDesc> droppedFiles, ItemHandleAwareHashSet<IComponentHandle> droppedComponents, IProgressMonitor monitor) throws TeamRepositoryException {
        List changes = activity.getChanges();
        for (Object item : changes) {
            if (monitor.isCanceled()) {
                return;
            }
            this.dropSCMObject(item, sysDefClient, droppedFiles, droppedComponents, seenFiles, monitor);
        }
    }

    private void dropShareable(IShareable shareable, ItemHandleAwareHashSet<IVersionableHandle> seenFiles, IComponentHandle component, ISystemDefinitionModelClient sysDefClient, Set<ISubsetFileDesc> droppedFiles, IProgressMonitor monitor) throws TeamRepositoryException {
        IVersionableHandle versionable = null;
        if (seenFiles != null) {
            versionable = shareable.getVersionable(monitor);
            if (seenFiles.contains((Object)versionable)) {
                return;
            }
            seenFiles.add((Object)versionable);
        }
        SubProgressMonitor subMonitor = new SubProgressMonitor(monitor, 1);
        subMonitor.beginTask("", 1);
        subMonitor.setTaskName(NLS.bind((String)Messages.BuildSubsetFilesDropTargetAdapter_ProcessingFile, (Object)shareable.getLocalPath().toString()));
        ILanguageDefinition ld = null;
        IMetadataProperties props = shareable.getMetadataProperties((IProgressMonitor)subMonitor);
        String ldUUID = (String)props.getCurrentProperties().get("team.enterprise.language.definition");
        if (ldUUID != null && !ldUUID.isEmpty()) {
            ld = (ILanguageDefinition)sysDefClient.findSystemDefinitionComplete(ldUUID, null, ILanguageDefinition.ITEM_TYPE, (IProgressMonitor)subMonitor);
        } else {
            if (versionable == null) {
                shareable.getVersionable(monitor);
            }
            if (versionable != null && versionable instanceof IFileItemHandle) {
                ld = sysDefClient.getDefaultLanguageDefinition(shareable.getLocalPath().getName(), (IProgressMonitor)subMonitor);
            }
        }
        if (ld != null && ld.getTranslators().size() > 0) {
            IShare share = shareable.getShare((IProgressMonitor)subMonitor);
            String compUUID = share.getSharingDescriptor().getComponent().getItemId().getUuidValue();
            String fileUUID = shareable.getVersionable((IProgressMonitor)subMonitor).getItemId().getUuidValue();
            droppedFiles.add(BuildableSubsetUtil.createFileDesc((String)compUUID, (String)fileUUID));
        }
        subMonitor.worked(1);
    }

    private void dropItemWrapper(AbstractFileSystemItemWrapper wrapper, ItemHandleAwareHashSet<IVersionableHandle> seenFiles, ISystemDefinitionModelClient sysDefClient, Set<ISubsetFileDesc> droppedFiles, IProgressMonitor monitor) throws TeamRepositoryException {
        IConfiguration configuration;
        IItemHandle itemHandle = wrapper.getFileItem().toHandle();
        if (itemHandle instanceof IVersionableHandle && (configuration = this.getConfiguration(wrapper.getWorkspace(), monitor)) != null) {
            this.dropVersionable((IVersionableHandle)itemHandle, true, wrapper.getName(), configuration, seenFiles, sysDefClient, droppedFiles, monitor);
        }
    }

    private IConfiguration getConfiguration(ItemNamespace namespace, IProgressMonitor monitor) throws TeamRepositoryException {
        IConnection connection = namespace.getConnection(monitor);
        return this.getConfiguration(connection, (IComponentHandle)namespace.fetchComponentId(monitor).toHandle(), monitor);
    }

    private IConfiguration getConfiguration(IConnection connection, IComponentHandle componentHandle, IProgressMonitor monitor) throws TeamRepositoryException {
        if (connection instanceof IFlowNodeConnection) {
            return ((IWorkspaceConnection)connection).configuration(componentHandle);
        }
        if (connection instanceof IBaselineConnection) {
            return ((IBaselineConnection)connection).configuration();
        }
        return null;
    }

    private void dropVersionable(IVersionableHandle v, boolean includeChildren, String name, IConfiguration configuration, ItemHandleAwareHashSet<IVersionableHandle> seenFiles, ISystemDefinitionModelClient sysDefClient, Set<ISubsetFileDesc> droppedFiles, IProgressMonitor monitor) throws TeamRepositoryException {
        if (seenFiles.contains((Object)v)) {
            return;
        }
        seenFiles.add((Object)v);
        SubProgressMonitor subMonitor = new SubProgressMonitor(monitor, 1);
        subMonitor.beginTask("", 1);
        subMonitor.setTaskName(NLS.bind((String)Messages.BuildSubsetFilesDropTargetAdapter_ProcessingFile, (Object)name));
        if (v instanceof IFileItemHandle) {
            if (this.isBuildableFile((IFileItemHandle)v, configuration, sysDefClient, (IProgressMonitor)subMonitor)) {
                String compUUID = configuration.component().getItemId().getUuidValue();
                String fileUUID = v.getItemId().getUuidValue();
                droppedFiles.add(BuildableSubsetUtil.createFileDesc((String)compUUID, (String)fileUUID));
            }
        } else if (includeChildren && v instanceof IFolderHandle) {
            Map kids = configuration.childEntries((IFolderHandle)v, (IProgressMonitor)subMonitor);
            for (Map.Entry kid : kids.entrySet()) {
                this.dropVersionable((IVersionableHandle)kid.getValue(), includeChildren, (String)kid.getKey(), configuration, seenFiles, sysDefClient, droppedFiles, (IProgressMonitor)subMonitor);
            }
        }
        subMonitor.worked(1);
    }

    private void dropSelectResult(SelectResult result, ISystemDefinitionModelClient sysDefClient, Set<ISubsetFileDesc> droppedFiles, Map<String, IWorkspaceConnection> workspaceConnections, IProgressMonitor monitor) throws TeamRepositoryException {
        String fileUUID = null;
        String componentUUID = null;
        String streamUUID = null;
        for (Binding binding : result.getBindings()) {
            if ("fileItemId".equals(binding.getName())) {
                fileUUID = binding.getValue();
            } else if ("componentId".equals(binding.getName())) {
                componentUUID = binding.getValue();
            } else if ("streamId".equals(binding.getName())) {
                streamUUID = binding.getValue();
            }
            if (fileUUID != null && componentUUID != null && streamUUID != null) break;
        }
        if (streamUUID != null) {
            IWorkspaceConnection connection = workspaceConnections.get(streamUUID);
            if (connection == null) {
                IWorkspaceHandle streamHandle = (IWorkspaceHandle)IWorkspace.ITEM_TYPE.createItemHandle(UUID.valueOf(streamUUID), null);
                connection = SCMPlatform.getWorkspaceManager((ITeamRepository)this.repository).getWorkspaceConnection(streamHandle, monitor);
                workspaceConnections.put(streamUUID, connection);
            }
            if (this.isBuildableFile(fileUUID, componentUUID, connection, sysDefClient, monitor)) {
                droppedFiles.add(BuildableSubsetUtil.createFileDesc((String)componentUUID, (String)fileUUID));
            }
        }
    }

    private void dropBuildFile(IBuildFile file, IWorkspaceConnection workspaceConnection, ISystemDefinitionModelClient sysDefClient, Set<ISubsetFileDesc> droppedFiles, IProgressMonitor monitor) throws TeamRepositoryException {
        if (workspaceConnection != null && this.isBuildableFile(file.getFileUUID(), file.getComponentUUID(), workspaceConnection, sysDefClient, monitor)) {
            droppedFiles.add(BuildableSubsetUtil.createFileDesc((String)file.getComponentUUID(), (String)file.getFileUUID()));
        }
    }

    private IWorkspaceConnection getTargetSubsetWorkspaceConnection(IProgressMonitor monitor) throws TeamRepositoryException {
        if (this.subsetWorkspaceConnection == null) {
            String workspaceUUIDProperty;
            IBuildDefinitionHandle buildDefinitionHandle = this.context.getBuildDefinitionHandle();
            if (buildDefinitionHandle == null) {
                return null;
            }
            IBuildDefinition buildDefinition = (IBuildDefinition)this.repository.itemManager().fetchPartialItem((IItemHandle)buildDefinitionHandle, 0, Arrays.asList(IBuildDefinition.PROPERTY_PROPERTIES), monitor);
            String workspaceUUID = buildDefinition.getPropertyValue(workspaceUUIDProperty = DependencyBuildPropertyFactory.getInstance().resolvePropertyId("teamz.scm.workspaceUUID", buildDefinition), null);
            if (workspaceUUID == null) {
                return null;
            }
            IWorkspaceHandle workspaceHandle = (IWorkspaceHandle)IWorkspace.ITEM_TYPE.createItemHandle(UUID.valueOf((String)workspaceUUID), null);
            this.subsetWorkspaceConnection = BuildUtils.getWorkspaceConnection(this.repository, workspaceHandle, null);
        }
        return this.subsetWorkspaceConnection;
    }

    private boolean isBuildableFile(String fileUUID, String componentUUID, IWorkspaceConnection connection, ISystemDefinitionModelClient sysDefClient, IProgressMonitor monitor) throws TeamRepositoryException {
        if (fileUUID == null || componentUUID == null) {
            return false;
        }
        IFileItemHandle fileItemHandle = (IFileItemHandle)IFileItem.ITEM_TYPE.createItemHandle(UUID.valueOf((String)fileUUID), null);
        IComponentHandle component = (IComponentHandle)IComponent.ITEM_TYPE.createItemHandle(UUID.valueOf((String)componentUUID), null);
        IConfiguration configuration = connection.configuration(component);
        return this.isBuildableFile(fileItemHandle, configuration, sysDefClient, monitor);
    }

    private boolean isBuildableFile(IFileItemHandle fileItemHandle, IConfiguration configuration, ISystemDefinitionModelClient sysDefClient, IProgressMonitor monitor) throws TeamRepositoryException {
        if (fileItemHandle == null || configuration == null) {
            return false;
        }
        IFileItem fileItem = (IFileItem)configuration.fetchCompleteItem((IVersionableHandle)fileItemHandle, monitor);
        return BuildUtils.isBuildableFile((IVersionable)fileItem, sysDefClient);
    }

    public static void installDropSupport(StructuredViewer viewer, ITeamRepository repository, IBuildSubsetDropTargetContext context) {
        viewer.addDropSupport(23, new Transfer[]{LocalSelectionTransfer.getTransfer(), ResourceTransfer.getInstance()}, (DropTargetListener)new BuildSubsetFilesDropTargetAdapter(viewer, repository, context));
    }

    public static interface IBuildSubsetDropTargetContext {
        public void drop(ISubset var1);

        public ISubset getTargetSubset();

        public IBuildDefinitionHandle getBuildDefinitionHandle();
    }
}

