/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.build.ui.subset.dnd;

import com.ibm.team.build.common.model.IBuildDefinitionHandle;
import com.ibm.team.enterprise.build.client.buildablesubset.ClientFactory;
import com.ibm.team.enterprise.build.client.buildablesubset.IBuildableSubsetClient;
import com.ibm.team.enterprise.build.ui.Activator;
import com.ibm.team.enterprise.buildablesubset.common.IBuildSubsetRule;
import com.ibm.team.enterprise.buildablesubset.common.IWorkItemBuildSubsetRule;
import com.ibm.team.enterprise.buildablesubset.common.impl.WorkItemBuildSubsetRule;
import com.ibm.team.enterprise.buildablesubset.common.model.ISubset;
import com.ibm.team.enterprise.internal.build.ui.nls.Messages;
import com.ibm.team.jface.util.UIUpdaterJob;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.workitem.common.internal.util.ItemHandleAwareHashSet;
import com.ibm.team.workitem.common.model.IWorkItemHandle;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;

public class BuildSubsetDNDWorkItemDialog
extends Dialog {
    private final ItemHandleAwareHashSet<IWorkItemHandle> workItems;
    private final ITeamRepository repository;
    private final IBuildDefinitionHandle buildDefinitionHandle;
    private final boolean isDynamic;
    private Button includeChildrenCheckbox;
    private boolean isIncludeChildren;
    private Button includeImpactedCheckbox;
    private boolean isIncludeImpacted;
    private ISubset resultSubset;
    private UIUpdaterJob job;
    private ISubset subset;

    public BuildSubsetDNDWorkItemDialog(ISubset subset, Shell shell, ItemHandleAwareHashSet<IWorkItemHandle> workItems, ITeamRepository repository, IBuildDefinitionHandle buildDefinitionHandle, boolean isDynamic) {
        super(shell);
        this.workItems = workItems;
        this.repository = repository;
        this.buildDefinitionHandle = buildDefinitionHandle;
        this.isDynamic = isDynamic;
        this.subset = subset;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        Label label = new Label(composite, 64);
        label.setText(Messages.BuildSubsetDNDWorkItemDialog_Message);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)label);
        this.includeImpactedCheckbox = new Button(composite, 32);
        this.includeImpactedCheckbox.setText(Messages.BuildSubsetWIDialog_LABEL_INSTRUCTION);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.includeImpactedCheckbox);
        this.includeImpactedCheckbox.setSelection(Activator.getDefault().getDialogSettings().getBoolean("includeImpacted_AddWorkItem"));
        this.includeChildrenCheckbox = new Button(composite, 32);
        this.includeChildrenCheckbox.setText(Messages.BuildSubsetRuleSelectionDialog_INCLUDE_CHILDREN);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.includeChildrenCheckbox);
        this.includeChildrenCheckbox.setSelection(Activator.getDefault().getDialogSettings().getBoolean("includeChildren_AddWorkItem"));
        return composite;
    }

    protected void okPressed() {
        this.isIncludeChildren = this.includeChildrenCheckbox.getSelection();
        Activator.getDefault().getDialogSettings().put("includeChildren_AddWorkItem", this.isIncludeChildren);
        this.isIncludeImpacted = this.includeImpactedCheckbox.getSelection();
        Activator.getDefault().getDialogSettings().put("includeImpacted_AddWorkItem", this.isIncludeImpacted);
        super.okPressed();
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.BuildSubsetDNDWorkItemDialog_Title);
    }

    protected boolean isResizable() {
        return true;
    }

    public int open() {
        int parentReturnValue = super.open();
        if (parentReturnValue == 0) {
            if (this.job != null) {
                this.job.cancel();
            }
            this.job = new UIUpdaterJob(""){
                IBuildableSubsetClient client;
                IWorkItemBuildSubsetRule subsetRule;
                {
                    this.client = ClientFactory.getBuildableSubsetClient((ITeamRepository)BuildSubsetDNDWorkItemDialog.this.repository);
                    this.subsetRule = new WorkItemBuildSubsetRule();
                }

                public IStatus runInBackground(IProgressMonitor monitor) {
                    this.subsetRule.setDynamic(BuildSubsetDNDWorkItemDialog.this.isDynamic);
                    for (IWorkItemHandle workItem : BuildSubsetDNDWorkItemDialog.this.workItems) {
                        this.subsetRule.addWorkItem(workItem);
                    }
                    this.subsetRule.setIncludeChildren(BuildSubsetDNDWorkItemDialog.this.isIncludeChildren);
                    try {
                        BuildSubsetDNDWorkItemDialog.this.resultSubset = this.client.processRule((IBuildSubsetRule)this.subsetRule, BuildSubsetDNDWorkItemDialog.this.buildDefinitionHandle, BuildSubsetDNDWorkItemDialog.this.subset, BuildSubsetDNDWorkItemDialog.this.isIncludeImpacted);
                    }
                    catch (TeamRepositoryException e) {
                        e.printStackTrace();
                    }
                    return super.runInBackground(monitor);
                }

                public IStatus runInUI(IProgressMonitor monitor) {
                    return super.runInUI(monitor);
                }
            };
            this.job.schedule();
            try {
                this.job.join();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        return parentReturnValue;
    }

    public ISubset getResultSubset() {
        return this.resultSubset;
    }
}

