/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.build.ui.subset.dnd;

import com.ibm.team.build.common.model.IBuildDefinitionHandle;
import com.ibm.team.enterprise.build.ui.Activator;
import com.ibm.team.enterprise.build.ui.subset.dnd.BuildSubsetCriteriaDragSourceAdapter;
import com.ibm.team.enterprise.build.ui.subset.dnd.BuildSubsetDNDWorkItemDialog;
import com.ibm.team.enterprise.build.ui.subset.dnd.BuildSubsetFilesDropTargetAdapter;
import com.ibm.team.enterprise.buildablesubset.common.internal.model.ModelFactory;
import com.ibm.team.enterprise.buildablesubset.common.model.ISubset;
import com.ibm.team.enterprise.buildablesubset.common.model.ISubsetCriteria;
import com.ibm.team.enterprise.buildablesubset.common.util.BuildableSubsetUtil;
import com.ibm.team.enterprise.internal.build.ui.nls.Messages;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.workitem.common.internal.util.ItemHandleAwareHashSet;
import com.ibm.team.workitem.common.model.IWorkItemHandle;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.progress.UIJob;

public class BuildSubsetCriteriaDropTargetAdapter
extends DropTargetAdapter {
    private final StructuredViewer viewer;
    private final Shell shell;
    private final ITeamRepository repository;
    private final BuildSubsetFilesDropTargetAdapter.IBuildSubsetDropTargetContext context;
    private boolean enabled;

    public BuildSubsetCriteriaDropTargetAdapter(StructuredViewer viewer, ITeamRepository repository, BuildSubsetFilesDropTargetAdapter.IBuildSubsetDropTargetContext context) {
        this.viewer = viewer;
        this.shell = viewer.getControl().getShell();
        this.repository = repository;
        this.context = context;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void dragEnter(DropTargetEvent event) {
        if (!this.enabled) {
            event.detail = 0;
            return;
        }
        if (this.viewer.getControl() == BuildSubsetCriteriaDragSourceAdapter.CURRENT_SOURCE) {
            event.detail = 0;
            return;
        }
        int detail = 0;
        int i = 0;
        while (i < event.dataTypes.length) {
            if (LocalSelectionTransfer.getTransfer().isSupportedType(event.dataTypes[i]) && LocalSelectionTransfer.getTransfer().getSelection() != null && !LocalSelectionTransfer.getTransfer().getSelection().isEmpty()) {
                boolean valid = true;
                for (Object next : (IStructuredSelection)LocalSelectionTransfer.getTransfer().getSelection()) {
                    if (!((next = BuildSubsetFilesDropTargetAdapter.resolve(next, true)) instanceof IWorkItemHandle) && !(next instanceof ISubsetCriteria)) {
                        valid = false;
                    }
                    if (!valid) break;
                }
                if (valid) {
                    detail = 1;
                }
            }
            if (detail != 0) break;
            ++i;
        }
        if (detail != 0 && (detail & event.operations) == 0) {
            if ((4 & event.operations) != 0) {
                detail = 4;
            } else if ((2 & event.operations) != 0) {
                detail = 2;
            } else if ((0x10 & event.operations) != 0) {
                detail = 16;
            }
        }
        event.detail = detail;
    }

    public void drop(final DropTargetEvent event) {
        if (!this.enabled) {
            return;
        }
        if (event.data instanceof IStructuredSelection) {
            event.data = ((IStructuredSelection)event.data).toArray();
        }
        if (event.data instanceof Object[] && ((Object[])event.data).length > 0) {
            ProgressMonitorDialog dialog = new ProgressMonitorDialog(this.shell);
            try {
                dialog.run(true, true, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        monitor.beginTask("", ((Object[])event.data).length);
                        final ItemHandleAwareHashSet droppedWorkItems = new ItemHandleAwareHashSet();
                        HashSet<ISubsetCriteria> droppedCriteria = new HashSet<ISubsetCriteria>();
                        try {
                            Object[] objectArray = (Object[])event.data;
                            int n = objectArray.length;
                            int n2 = 0;
                            while (n2 < n) {
                                Object element = objectArray[n2];
                                if (monitor.isCanceled()) {
                                    return;
                                }
                                if ((element = BuildSubsetFilesDropTargetAdapter.resolve(element, true)) instanceof IWorkItemHandle) {
                                    droppedWorkItems.add((Object)((IWorkItemHandle)element));
                                } else if (element instanceof ISubsetCriteria) {
                                    droppedCriteria.add((ISubsetCriteria)element);
                                }
                                monitor.worked(1);
                                ++n2;
                            }
                            if (monitor.isCanceled()) {
                                return;
                            }
                            final boolean[] skippedElementsNoBuildDef = new boolean[1];
                            final ISubset[] tempSubset = new ISubset[1];
                            final IBuildDefinitionHandle buildDefHandle = BuildSubsetCriteriaDropTargetAdapter.this.context.getBuildDefinitionHandle();
                            if (droppedWorkItems.size() > 0) {
                                if (buildDefHandle == null) {
                                    skippedElementsNoBuildDef[0] = true;
                                } else {
                                    SubProgressMonitor subMonitor = new SubProgressMonitor(monitor, 1);
                                    subMonitor.beginTask("", 1);
                                    subMonitor.setTaskName(Messages.BuildSubsetFilesDropTargetAdapter_ProcessingWorkItems);
                                    BuildSubsetCriteriaDropTargetAdapter.this.shell.getDisplay().syncExec(new Runnable(){

                                        @Override
                                        public void run() {
                                            ISubset result;
                                            BuildSubsetDNDWorkItemDialog dialog = new BuildSubsetDNDWorkItemDialog(BuildSubsetCriteriaDropTargetAdapter.this.context.getTargetSubset(), BuildSubsetCriteriaDropTargetAdapter.this.shell, (ItemHandleAwareHashSet<IWorkItemHandle>)droppedWorkItems, BuildSubsetCriteriaDropTargetAdapter.this.repository, buildDefHandle, true);
                                            if (dialog.open() == 0 && (result = dialog.getResultSubset()) != null && !result.getCriteria().getReferences().isEmpty()) {
                                                if (tempSubset[0] == null) {
                                                    tempSubset[0] = result;
                                                } else {
                                                    BuildableSubsetUtil.merge3((List)tempSubset[0].getFileDescs(), (List)tempSubset[0].getCriteria().getReferences(), (ISubset)result);
                                                }
                                            }
                                        }
                                    });
                                }
                                monitor.worked(1);
                            }
                            if (monitor.isCanceled()) {
                                return;
                            }
                            if (droppedCriteria.size() > 0) {
                                if (tempSubset[0] == null) {
                                    tempSubset[0] = BuildSubsetCriteriaDropTargetAdapter.this.context.getTargetSubset() != null ? BuildSubsetCriteriaDropTargetAdapter.this.context.getTargetSubset() : ModelFactory.eINSTANCE.createSubset();
                                    tempSubset[0].getCriteria().getReferences().addAll(droppedCriteria);
                                } else {
                                    BuildableSubsetUtil.merge3((Collection)tempSubset[0].getCriteria().getReferences(), droppedCriteria, (Collection)tempSubset[0].getFileDescs());
                                }
                            }
                            if (monitor.isCanceled()) {
                                return;
                            }
                            if (tempSubset[0] != null || skippedElementsNoBuildDef[0]) {
                                new UIJob(""){

                                    public IStatus runInUIThread(IProgressMonitor monitor) {
                                        if (tempSubset[0] != null) {
                                            BuildSubsetCriteriaDropTargetAdapter.this.context.drop(tempSubset[0]);
                                        }
                                        if (skippedElementsNoBuildDef[0]) {
                                            MessageDialog.openWarning((Shell)BuildSubsetCriteriaDropTargetAdapter.this.shell, (String)Messages.BuildSubsetFilesDropTargetAdapter_ErrorTitle, (String)Messages.BuildSubsetFilesDropTargetAdapter_NoBuildDef);
                                        }
                                        return Status.OK_STATUS;
                                    }
                                }.schedule();
                            }
                        }
                        catch (Exception e) {
                            throw new InvocationTargetException(e);
                        }
                    }
                });
            }
            catch (Throwable t) {
                if (t instanceof InvocationTargetException) {
                    t = ((InvocationTargetException)t).getCause();
                }
                IStatus status = Activator.getDefault().createErrorStatus(t);
                ErrorDialog.openError((Shell)this.shell, (String)Messages.BuildSubsetFilesDropTargetAdapter_ErrorTitle, (String)Messages.BuildSubsetFilesDropTargetAdapter_ErrorMessage, (IStatus)status);
                Activator.getDefault().logError(status);
            }
        }
    }

    public static BuildSubsetCriteriaDropTargetAdapter installDropSupport(StructuredViewer viewer, ITeamRepository repository, BuildSubsetFilesDropTargetAdapter.IBuildSubsetDropTargetContext context) {
        BuildSubsetCriteriaDropTargetAdapter adapter = new BuildSubsetCriteriaDropTargetAdapter(viewer, repository, context);
        viewer.addDropSupport(23, new Transfer[]{LocalSelectionTransfer.getTransfer()}, (DropTargetListener)adapter);
        return adapter;
    }
}

