/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.build.ui.subset;

import com.ibm.team.build.common.model.IBuildDefinition;
import com.ibm.team.build.common.model.IBuildDefinitionHandle;
import com.ibm.team.build.internal.ui.jobs.TeamBuildJob;
import com.ibm.team.enterprise.build.client.buildablesubset.ClientFactory;
import com.ibm.team.enterprise.build.client.buildablesubset.IBuildableSubsetClient;
import com.ibm.team.enterprise.build.common.IBuildUtility;
import com.ibm.team.enterprise.build.ui.subset.BuildableSubsetUtils;
import com.ibm.team.enterprise.build.ui.subset.ContributorSelectionDialog;
import com.ibm.team.enterprise.build.ui.subset.views.BuildSubsetView;
import com.ibm.team.enterprise.buildablesubset.common.model.ISubset;
import com.ibm.team.enterprise.common.ui.domain.AbstractEnterpriseExtensionsNode;
import com.ibm.team.enterprise.internal.build.ui.nls.Messages;
import com.ibm.team.jface.util.UIUpdaterJob;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.workitem.common.internal.util.ItemHandleAwareHashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Widget;

public class SubsetSearchDialog
extends TitleAreaDialog
implements SelectionListener {
    private TableViewer searchTargetsViewer;
    private Table componentTable;
    private Button addTargetButton;
    private Button delTargetButton;
    private ITeamRepository fTeamRepository;
    private IProjectArea fProjectArea;
    private IProjectAreaHandle fPAHandle;
    private List selectedTargets;
    private List<IBuildDefinitionHandle> buildDefinitionHandles;
    private List<ISubset> fSelectedSubsets;
    private IBuildableSubsetClient buildableSubsetClient;
    private AbstractEnterpriseExtensionsNode fSelectedNode;

    private void filterBuildDefinitions() {
        try {
            List definitions = this.fTeamRepository.itemManager().fetchPartialItems(this.buildDefinitionHandles, 0, Collections.singletonList(IBuildDefinition.PROPERTY_PROPERTIES), null);
            ItemHandleAwareHashSet dependencyDefinitions = new ItemHandleAwareHashSet();
            ItemHandleAwareHashSet removedDefinitions = new ItemHandleAwareHashSet();
            for (IBuildDefinition bd : definitions) {
                if (IBuildUtility.isDependencyBuild((IBuildDefinition)bd) || IBuildUtility.isOldDependencyBuild((IBuildDefinition)bd)) {
                    dependencyDefinitions.add((Object)bd);
                    continue;
                }
                removedDefinitions.add((Object)bd);
            }
            if (removedDefinitions.size() > 0) {
                this.buildDefinitionHandles.removeAll((Collection<?>)removedDefinitions);
            }
        }
        catch (TeamRepositoryException e) {
            e.printStackTrace();
        }
    }

    public SubsetSearchDialog(Shell parentShell, ITeamRepository teamRepository, IProjectAreaHandle projectAreaHandle, AbstractEnterpriseExtensionsNode subsetNode) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10 | 0x400);
        this.fTeamRepository = teamRepository;
        this.fPAHandle = projectAreaHandle;
        this.fSelectedNode = subsetNode;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.BuildSubsetNode_ACTION_SEARCH);
    }

    private void loadConfigurations() {
        new TeamBuildJob(Messages.BuildSubsetFileSelectionDialog_LOAD_CONFIG_JOB, true, this.fTeamRepository){

            protected IStatus runProtected(IProgressMonitor monitor) throws Exception {
                SubsetSearchDialog.this.buildDefinitionHandles = BuildableSubsetUtils.getBuildDefinitions(SubsetSearchDialog.this.fPAHandle);
                SubsetSearchDialog.this.filterBuildDefinitions();
                SubsetSearchDialog.this.fProjectArea = (IProjectArea)SubsetSearchDialog.this.fTeamRepository.itemManager().fetchCompleteItem((IItemHandle)SubsetSearchDialog.this.fPAHandle, 0, monitor);
                return null;
            }
        }.schedule();
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogAreaComposite = (Composite)super.createDialogArea(parent);
        Composite mainComposite = new Composite(dialogAreaComposite, 0);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)mainComposite);
        GridLayoutFactory.swtDefaults().numColumns(2).equalWidth(false).applyTo(mainComposite);
        GridData gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.heightHint = 10;
        this.createTargetSelectionPart(mainComposite);
        this.loadConfigurations();
        this.setTitle(Messages.SubsetSearchDialog_TITLE);
        this.setMessage(Messages.SubsetSearchDialog_SEARCH_RULE_3, 0);
        return dialogAreaComposite;
    }

    protected Control createContents(Composite parent) {
        Control main = super.createContents(parent);
        Button okButton = this.getButton(0);
        okButton.setEnabled(false);
        return main;
    }

    private TableColumn createTableColumn(String name, String tooltip, int flags, int id, int weight, TableColumnLayout layout) {
        TableColumn column = new TableColumn(this.searchTargetsViewer.getTable(), 16384, id);
        column.setText(name);
        column.setToolTipText(tooltip);
        layout.setColumnData((Widget)column, (ColumnLayoutData)new ColumnWeightData(weight));
        return column;
    }

    private void createTargetSelectionPart(Composite parent) {
        Composite searchTargetComposite = new Composite(parent, 0);
        GridDataFactory.fillDefaults().grab(true, true).span(2, 1).hint(-1, 200).applyTo((Control)searchTargetComposite);
        GridLayoutFactory.swtDefaults().numColumns(4).equalWidth(false).applyTo(searchTargetComposite);
        Composite tableComposite = new Composite(searchTargetComposite, 0);
        GridDataFactory.fillDefaults().grab(true, true).span(3, 1).applyTo((Control)tableComposite);
        this.componentTable = new Table(tableComposite, 68354);
        GridDataFactory.fillDefaults().span(3, 1).grab(true, true).indent(10, -1).hint(-1, 400).applyTo((Control)this.componentTable);
        this.searchTargetsViewer = new TableViewer(this.componentTable);
        TableColumnLayout columnLayout = new TableColumnLayout();
        tableComposite.setLayout((Layout)columnLayout);
        this.createTableColumn(Messages.SubsetSearchDialog_TABLE_COLUMN_NAME, null, 16384, 0, 15, columnLayout);
        this.searchTargetsViewer.getTable().setHeaderVisible(true);
        this.searchTargetsViewer.getTable().setLinesVisible(true);
        this.searchTargetsViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public Object[] getElements(Object inputElement) {
                return SubsetSearchDialog.this.selectedTargets.toArray();
            }
        });
        this.searchTargetsViewer.setLabelProvider((IBaseLabelProvider)new ITableLabelProvider(){

            public void addListener(ILabelProviderListener listener) {
            }

            public void dispose() {
            }

            public boolean isLabelProperty(Object element, String property) {
                return false;
            }

            public void removeListener(ILabelProviderListener listener) {
            }

            public Image getColumnImage(Object element, int columnIndex) {
                return null;
            }

            public String getColumnText(Object element, int columnIndex) {
                IContributor contributor = (IContributor)element;
                if (columnIndex == 0) {
                    return contributor.getName();
                }
                return null;
            }
        });
        this.componentTable.pack();
        this.componentTable.layout();
        Composite buttonComposite = new Composite(searchTargetComposite, 0);
        GridDataFactory.fillDefaults().applyTo((Control)buttonComposite);
        GridLayoutFactory.fillDefaults().equalWidth(false).applyTo(buttonComposite);
        this.addTargetButton = new Button(buttonComposite, 8);
        this.addTargetButton.setText(Messages.SubsetSearchDialog_BUTTON_ADD);
        GridDataFactory.fillDefaults().applyTo((Control)this.addTargetButton);
        this.addTargetButton.addSelectionListener((SelectionListener)this);
        this.delTargetButton = new Button(buttonComposite, 8);
        this.delTargetButton.setText(Messages.SubsetSearchDialog_BUTTON_DEL);
        GridDataFactory.fillDefaults().applyTo((Control)this.delTargetButton);
        this.delTargetButton.addSelectionListener((SelectionListener)this);
        this.delTargetButton.setEnabled(false);
        this.searchTargetsViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                SubsetSearchDialog.this.delTargetButton.setEnabled(!event.getSelection().isEmpty());
            }
        });
    }

    private IBuildableSubsetClient getBuildableSubsetClient() {
        if (this.buildableSubsetClient == null) {
            this.buildableSubsetClient = ClientFactory.getBuildableSubsetClient((ITeamRepository)this.fTeamRepository);
        }
        return this.buildableSubsetClient;
    }

    private List<ISubset> fetchUserSubsets(IContributorHandle[] contributors) {
        IBuildableSubsetClient client = this.getBuildableSubsetClient();
        List<Object> subsets = new ArrayList<ISubset>();
        try {
            if (this.fProjectArea != null && contributors != null && contributors.length > 0) {
                subsets = client.searchBuildableSubsetsByOwner((IProjectAreaHandle)this.fProjectArea, contributors, null);
            }
        }
        catch (TeamRepositoryException e) {
            e.printStackTrace();
        }
        return subsets;
    }

    private void selectUsers() {
        final ContributorSelectionDialog dialog = new ContributorSelectionDialog(this.getShell(), this.fTeamRepository, new ArrayList(), true);
        if (dialog.open() == 0) {
            new TeamBuildJob(Messages.BuildSubsetFileSelectionDialog_LOAD_CONFIG_JOB, true, this.fTeamRepository){

                protected IStatus runProtected(IProgressMonitor monitor) throws Exception {
                    List contributors = SubsetSearchDialog.this.fTeamRepository.itemManager().fetchCompleteItems(Arrays.asList(dialog.getContributorResult()), 1, null);
                    SubsetSearchDialog.this.selectedTargets = contributors;
                    return null;
                }

                protected void jobFinished(IStatus status) {
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            SubsetSearchDialog.this.searchTargetsViewer.setInput((Object)SubsetSearchDialog.this.selectedTargets);
                            SubsetSearchDialog.this.searchTargetsViewer.refresh();
                            SubsetSearchDialog.this.updateButtonsEnablement();
                        }
                    });
                }
            }.schedule();
        }
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.widget == this.addTargetButton) {
            this.selectUsers();
        } else if (e.widget == this.delTargetButton) {
            IStructuredSelection deletes = (IStructuredSelection)this.searchTargetsViewer.getSelection();
            this.selectedTargets.removeAll(deletes.toList());
            this.searchTargetsViewer.setInput((Object)this.selectedTargets);
            this.searchTargetsViewer.refresh();
            this.updateButtonsEnablement();
        }
    }

    private void updateButtonsEnablement() {
        Button okButton = this.getButton(0);
        if (this.selectedTargets != null) {
            okButton.setEnabled(!this.selectedTargets.isEmpty());
        } else {
            okButton.setEnabled(false);
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    protected void okPressed() {
        new UIUpdaterJob(Messages.SubsetSearchDialog_SEARCH_SUBSETS_JOB){

            public IStatus runInBackground(IProgressMonitor monitor) {
                IContributorHandle[] handleArray = new IContributorHandle[SubsetSearchDialog.this.selectedTargets.size()];
                SubsetSearchDialog.this.fSelectedSubsets = SubsetSearchDialog.this.fetchUserSubsets(SubsetSearchDialog.this.selectedTargets.toArray(handleArray));
                return super.runInBackground(monitor);
            }

            public IStatus runInUI(IProgressMonitor monitor) {
                BuildSubsetView.displayBuildSubsetView(SubsetSearchDialog.this.fSelectedSubsets, SubsetSearchDialog.this.fTeamRepository, SubsetSearchDialog.this.fProjectArea, SubsetSearchDialog.this.fSelectedNode);
                return super.runInUI(monitor);
            }
        }.schedule();
        super.okPressed();
    }
}

