/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.build.ui.subset;

import com.ibm.team.enterprise.build.ui.subset.BuildSubsetNode;
import com.ibm.team.enterprise.build.ui.subset.DeleteSubsetActionDelegate;
import com.ibm.team.enterprise.build.ui.subset.EditSubsetActionDelegate;
import com.ibm.team.enterprise.buildablesubset.common.model.ISubset;
import com.ibm.team.enterprise.common.ui.IEnterpriseExtensionsNode;
import com.ibm.team.enterprise.common.ui.domain.AbstractEnterpriseExtensionsNode;
import com.ibm.team.enterprise.internal.common.ui.EnterpriseExtensionsDomainContentProvider;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.process.rcp.ui.teamnavigator.IMenuOperationTarget;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.internal.TeamRepository;
import java.util.ArrayList;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.ui.IWorkbenchSite;

public class SubsetMenuOperationTarget
implements IMenuOperationTarget {
    public boolean canDoOperation(String actionId, IStructuredSelection selection) {
        if (this.isSelectionOfSubset(selection)) {
            if (actionId.equals(IMenuOperationTarget.DELETE)) {
                return true;
            }
            if (actionId.equals("jazz.open")) {
                return true;
            }
        }
        return false;
    }

    private boolean isSelectionOfSubset(IStructuredSelection selection) {
        if (selection.size() > 0) {
            for (Object object : selection) {
                if (object instanceof AbstractEnterpriseExtensionsNode) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public void doOperation(String actionId, IWorkbenchSite site, IStructuredSelection selection) {
        if (this.isSelectionOfSubset(selection)) {
            if (actionId.equals(IMenuOperationTarget.DELETE)) {
                this.deleteSubset(selection);
            } else if (actionId.equals("jazz.open")) {
                this.openSubset(selection, site);
            }
        }
    }

    private void deleteSubset(IStructuredSelection selection) {
        ArrayList<ISubset> subsetsToDelete = new ArrayList<ISubset>();
        ArrayList<IEnterpriseExtensionsNode> nodesToDelete = new ArrayList<IEnterpriseExtensionsNode>();
        AbstractTreeViewer treeViewer = null;
        ITeamRepository repository = this.resolveOwningRepository((TreeSelection)selection);
        for (AbstractEnterpriseExtensionsNode node : selection) {
            if (!(node instanceof BuildSubsetNode)) continue;
            subsetsToDelete.add(((BuildSubsetNode)node).getBuildableSubset());
            nodesToDelete.add((IEnterpriseExtensionsNode)node);
            if (treeViewer != null) continue;
            treeViewer = ((EnterpriseExtensionsDomainContentProvider)node.getDomain().getContentProvider()).getTreeViewer();
        }
        DeleteSubsetActionDelegate delegate = new DeleteSubsetActionDelegate(repository, treeViewer, nodesToDelete);
        delegate.selectionChanged(null, (ISelection)new StructuredSelection(subsetsToDelete));
        delegate.run(null);
    }

    private void openSubset(IStructuredSelection selection, IWorkbenchSite site) {
        for (BuildSubsetNode node : selection) {
            if (!(node instanceof BuildSubsetNode)) continue;
            EditSubsetActionDelegate.run(node, node.getProjectAreaHandle(), site.getPage());
        }
    }

    public String getLabel(String actionId) {
        return null;
    }

    private ITeamRepository resolveOwningRepository(TreeSelection selection) {
        TeamRepository repo = null;
        TreePath[] path = selection.getPaths();
        int numSegments = path[0].getSegmentCount();
        int i = 0;
        while (i < numSegments) {
            Object segmentObject = path[0].getSegment(i);
            if (segmentObject instanceof IProjectAreaHandle) {
                repo = (TeamRepository)((IProjectAreaHandle)segmentObject).getOrigin();
                break;
            }
            ++i;
        }
        return repo;
    }
}

