/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.build.ui.subset;

import com.ibm.team.build.common.model.IBuildDefinition;
import com.ibm.team.build.common.model.IBuildDefinitionHandle;
import com.ibm.team.enterprise.build.ui.Activator;
import com.ibm.team.enterprise.build.ui.subset.BuildSubsetEditorInput;
import com.ibm.team.enterprise.build.ui.subset.BuildSubsetFiltersDialog;
import com.ibm.team.enterprise.build.ui.subset.BuildSubsetNode;
import com.ibm.team.enterprise.build.ui.subset.EditSubsetActionDelegate;
import com.ibm.team.enterprise.build.ui.subset.SubsetSearchDialog;
import com.ibm.team.enterprise.build.ui.subset.views.BuildSubsetFilesView;
import com.ibm.team.enterprise.buildablesubset.common.model.ISubset;
import com.ibm.team.enterprise.common.ui.domain.AbstractEnterpriseExtensionsNode;
import com.ibm.team.enterprise.internal.build.ui.nls.Messages;
import com.ibm.team.enterprise.internal.common.ui.EnterpriseExtensionsDomainActionHelper;
import com.ibm.team.enterprise.internal.common.ui.EnterpriseExtensionsDomainContentProvider;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PlatformUI;

public class SubsetDomainActionHelper
extends EnterpriseExtensionsDomainActionHelper {
    private IMenuManager fMenuManager;
    private IStructuredSelection fSelection;
    private IWorkbenchPartSite fPartSite;

    public SubsetDomainActionHelper(IMenuManager manager, IStructuredSelection selection, IWorkbenchPartSite site) {
        super(manager, selection, site);
        this.fMenuManager = manager;
        this.fSelection = selection;
        this.fPartSite = site;
    }

    public void contributeActions() {
        super.contributeActions();
        if (this.fSelection.isEmpty()) {
            return;
        }
        Object element = this.fSelection.getFirstElement();
        if (this.fSelection.size() == 1 && element instanceof AbstractEnterpriseExtensionsNode) {
            this.contributeSubsetNodeActions((AbstractEnterpriseExtensionsNode)element);
        }
    }

    private void contributeSubsetNodeActions(AbstractEnterpriseExtensionsNode node) {
        if (node.hasChildren()) {
            this.fMenuManager.appendToGroup("jazz.open.group", (IAction)this.getNewSubsetAction(node));
            this.fMenuManager.appendToGroup("jazz.open.group", (IAction)this.getSearchSubsetAction(node));
            if (node.getParent() == null) {
                this.fMenuManager.appendToGroup("jazz.refactoring.group", (IAction)this.getFilterSubsetsAction(node));
            }
        } else if (node instanceof BuildSubsetNode) {
            this.fMenuManager.appendToGroup("jazz.open.group", (IAction)this.getPreviewSubsetAction((BuildSubsetNode)node));
            this.fMenuManager.appendToGroup("jazz.refactoring.group", (IAction)this.getDuplicateSubsetAction((BuildSubsetNode)node));
        }
    }

    private Action getNewSubsetAction(final AbstractEnterpriseExtensionsNode selectedNode) {
        String actionLabel = Messages.BuildSubsetNode_ACTION_NEW;
        return new Action(actionLabel){

            public void run() {
                IWorkbenchPage page = SubsetDomainActionHelper.this.fPartSite.getPage();
                try {
                    BuildSubsetEditorInput newEditorInput = new BuildSubsetEditorInput(selectedNode);
                    page.openEditor((IEditorInput)newEditorInput, "com.ibm.team.enterprise.build.ui.subset.editors.BuildableSubsetEditor");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        };
    }

    private Action getSearchSubsetAction(final AbstractEnterpriseExtensionsNode selectedNode) {
        String actionLabel = Messages.BuildSubsetNode_ACTION_SEARCH;
        return new Action(actionLabel){

            public void run() {
                try {
                    ITeamRepository teamRepository = selectedNode.getTeamRepository();
                    IProjectAreaHandle paHandle = selectedNode.getProjectAreaHandle();
                    SubsetSearchDialog searchDialog = new SubsetSearchDialog(SubsetDomainActionHelper.this.fPartSite.getShell(), teamRepository, paHandle, selectedNode);
                    searchDialog.open();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        };
    }

    private Action getFilterSubsetsAction(final AbstractEnterpriseExtensionsNode selectedNode) {
        return new Action(Messages.BuildSubsetNode_ACTION_FILTER){

            public void run() {
                try {
                    IProjectAreaHandle projectArea = selectedNode.getProjectAreaHandle();
                    BuildSubsetFiltersDialog dialog = new BuildSubsetFiltersDialog(SubsetDomainActionHelper.this.fPartSite.getShell(), projectArea);
                    if (dialog.open() == 0) {
                        Object[] result;
                        String origFilterList = Activator.getDefault().getPreferenceStore().getString("team.enterprise.build.subsets.filtered.list." + projectArea.getItemId().getUuidValue());
                        boolean origFilterEnabled = Activator.getDefault().getPreferenceStore().getBoolean("team.enterprise.build.subsets.filtered.enabled." + projectArea.getItemId().getUuidValue());
                        boolean refresh = false;
                        if (dialog.isFilterEnabled() != origFilterEnabled) {
                            refresh = true;
                            Activator.getDefault().getPreferenceStore().setValue("team.enterprise.build.subsets.filtered.enabled." + projectArea.getItemId().getUuidValue(), dialog.isFilterEnabled());
                        }
                        if ((result = dialog.getResult()) != null) {
                            String filterString;
                            StringBuilder filterBuf = new StringBuilder(result.length * 24);
                            Object[] objectArray = result;
                            int n = result.length;
                            int n2 = 0;
                            while (n2 < n) {
                                Object next = objectArray[n2];
                                if (next instanceof IBuildDefinition) {
                                    filterBuf.append(((IBuildDefinition)next).getItemId().getUuidValue());
                                    filterBuf.append(',');
                                }
                                ++n2;
                            }
                            if (filterBuf.length() == 0) {
                                filterBuf.append(',');
                            }
                            if (!(filterString = filterBuf.toString()).equals(origFilterList)) {
                                Activator.getDefault().getPreferenceStore().setValue("team.enterprise.build.subsets.filtered.list." + projectArea.getItemId().getUuidValue(), filterString);
                                if (dialog.isFilterEnabled()) {
                                    refresh = true;
                                }
                            }
                        }
                        if (refresh) {
                            ((EnterpriseExtensionsDomainContentProvider)selectedNode.getDomain().getContentProvider()).getTreeViewer().refresh((Object)selectedNode, true);
                        }
                    }
                }
                catch (Exception e) {
                    Activator.getDefault().logError(e);
                }
            }

            public ImageDescriptor getImageDescriptor() {
                return Activator.getImageDescriptor("icons/elcl16/filter.gif");
            }
        };
    }

    private Action getPreviewSubsetAction(final BuildSubsetNode node) {
        return new Action(Messages.BuildableSubsetEditor_ACTION_PREVIEW){

            public void run() {
                try {
                    BuildSubsetFilesView.displayBuildSubsetFilesView((ISubset)node.getBuildableSubset().getWorkingCopy(), node.getTeamRepository(), true, false, null);
                }
                catch (Exception e) {
                    Activator.getDefault().logError(e);
                }
            }

            public ImageDescriptor getImageDescriptor() {
                return Activator.getImageDescriptor("icons/elcl16/preview.gif");
            }
        };
    }

    private Action getDuplicateSubsetAction(final BuildSubsetNode node) {
        return new Action(Messages.BuildSubsetNode_ACTION_DUPLICATE){

            public void run() {
                try {
                    new Job(NLS.bind((String)Messages.BuildSubsetNode_ACTION_DUPLICATE_JOB, (Object)node.getLabel())){

                        protected IStatus run(IProgressMonitor monitor) {
                            try {
                                ISubset subset = node.getBuildableSubset();
                                if (subset == null) {
                                    throw new TeamRepositoryException(NLS.bind((String)Messages.BuildableSubsetEditor_NOT_EXIST, (Object)subset.getLabel()));
                                }
                                IBuildDefinitionHandle buildDefHandle = subset.getBuildDefinition();
                                final BuildSubsetEditorInput editorInput = new BuildSubsetEditorInput(null, buildDefHandle, subset.getFileDescs(), subset.getCriteria().getReferences(), node.getTeamRepository(), node.getProjectAreaHandle());
                                editorInput.setSubsetNode((AbstractEnterpriseExtensionsNode)node.getParent());
                                Display.getDefault().asyncExec(new Runnable(){

                                    @Override
                                    public void run() {
                                        EditSubsetActionDelegate.run(editorInput, PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage());
                                    }
                                });
                                return Status.OK_STATUS;
                            }
                            catch (Exception e) {
                                return new Status(4, "com.ibm.team.enterprise.build.ui", e.getMessage(), (Throwable)e);
                            }
                        }
                    }.schedule();
                }
                catch (Exception e) {
                    Activator.getDefault().logError(e);
                }
            }
        };
    }
}

