/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.build.ui.subset;

import com.ibm.team.build.common.model.IBuildDefinition;
import com.ibm.team.enterprise.build.client.buildablesubset.ClientFactory;
import com.ibm.team.enterprise.build.client.buildablesubset.IBuildableSubsetClient;
import com.ibm.team.enterprise.build.ui.subset.BuildSubsetEditorInput;
import com.ibm.team.enterprise.build.ui.subset.BuildSubsetNode;
import com.ibm.team.enterprise.buildablesubset.common.model.ISubset;
import com.ibm.team.enterprise.buildablesubset.common.model.ISubsetHandle;
import com.ibm.team.process.common.IProcessArea;
import com.ibm.team.process.common.IProcessAreaHandle;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.ActionDelegate;

public class EditSubsetActionDelegate
extends ActionDelegate
implements IObjectActionDelegate {
    private IStructuredSelection fSelection;
    private IWorkbenchPart fTargetPart;
    private static ISubset subset;
    private static IProjectAreaHandle projectAreaHandle;

    public void selectionChanged(IAction action, ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            this.fSelection = (IStructuredSelection)selection;
        }
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.fTargetPart = targetPart;
    }

    public void run(IAction action) {
        if (this.fSelection.getFirstElement() instanceof BuildSubsetNode) {
            BuildSubsetNode buildSubset = (BuildSubsetNode)((Object)this.fSelection.getFirstElement());
            EditSubsetActionDelegate.run(buildSubset, this.fTargetPart.getSite().getPage());
        }
    }

    public static void run(BuildSubsetNode buildSubset, IWorkbenchPage workbenchPage) {
        EditSubsetActionDelegate.run(buildSubset, null, workbenchPage);
    }

    public static void runWithSubsetItem(final ISubsetHandle subsetHandle, final IWorkbenchPage workbenchPage, final ITeamRepository teamRepository) {
        Job getSubsetItem = new Job("Get Subset"){

            protected IStatus run(IProgressMonitor monitor) {
                if (teamRepository != null) {
                    try {
                        IBuildableSubsetClient client = ClientFactory.getBuildableSubsetClient((ITeamRepository)teamRepository);
                        subset = client.getSubsetItem(subsetHandle, teamRepository);
                        IItem buildFetched = teamRepository.itemManager().fetchCompleteItem((IItemHandle)subset.getBuildDefinition(), 0, monitor);
                        if (buildFetched instanceof IBuildDefinition) {
                            IProcessAreaHandle processAreaHandle = ((IBuildDefinition)buildFetched).getProcessArea();
                            IProcessArea processArea = (IProcessArea)teamRepository.itemManager().fetchCompleteItem((IItemHandle)processAreaHandle, 0, monitor);
                            projectAreaHandle = processArea.getProjectArea();
                        }
                    }
                    catch (TeamRepositoryException e) {
                        return new Status(4, "SUBSET_ID", null);
                    }
                }
                return new Status(0, "SUBSET_ID", 0, null, null);
            }
        };
        getSubsetItem.schedule();
        getSubsetItem.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                EditSubsetActionDelegate.run(subset, workbenchPage, teamRepository, projectAreaHandle);
            }
        });
    }

    public static void run(ISubset subset, final IWorkbenchPage workbenchPage, ITeamRepository teamRepository, IProjectAreaHandle pa) {
        try {
            final BuildSubsetEditorInput editorInput = new BuildSubsetEditorInput(subset, teamRepository, pa);
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    try {
                        workbenchPage.openEditor((IEditorInput)editorInput, "com.ibm.team.enterprise.build.ui.subset.editors.BuildableSubsetEditor");
                    }
                    catch (PartInitException e) {
                        e.printStackTrace();
                    }
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void run(BuildSubsetNode buildSubset, ITeamRepository teamRepository, IProjectAreaHandle projectAreaHandle, IWorkbenchPage workbenchPage) {
        try {
            EditSubsetActionDelegate.runWithSubsetItem((ISubsetHandle)buildSubset.getBuildableSubset(), workbenchPage, teamRepository);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void run(BuildSubsetNode buildSubset, IProjectAreaHandle projectAreaHandle, IWorkbenchPage workbenchPage) {
        try {
            BuildSubsetEditorInput editorInput = new BuildSubsetEditorInput(buildSubset);
            workbenchPage.openEditor((IEditorInput)editorInput, "com.ibm.team.enterprise.build.ui.subset.editors.BuildableSubsetEditor");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void run(ISubset buildSubset, ITeamRepository repository, IProjectAreaHandle projectAreaHandle, IWorkbenchPage workbenchPage) {
        try {
            BuildSubsetEditorInput editorInput = new BuildSubsetEditorInput(buildSubset, repository, projectAreaHandle);
            workbenchPage.openEditor((IEditorInput)editorInput, "com.ibm.team.enterprise.build.ui.subset.editors.BuildableSubsetEditor");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static IEditorPart run(BuildSubsetEditorInput editorInput, IWorkbenchPage workbenchPage) {
        try {
            IEditorPart editor = workbenchPage.findEditor((IEditorInput)editorInput);
            if (editor != null) {
                return editor;
            }
            return workbenchPage.openEditor((IEditorInput)editorInput, "com.ibm.team.enterprise.build.ui.subset.editors.BuildableSubsetEditor");
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

