/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.build.ui.subset;

import com.ibm.team.enterprise.build.client.buildablesubset.ClientFactory;
import com.ibm.team.enterprise.build.client.buildablesubset.IBuildableSubsetClient;
import com.ibm.team.enterprise.build.ui.subset.BuildSubsetNode;
import com.ibm.team.enterprise.build.ui.subset.views.BuildSubsetView;
import com.ibm.team.enterprise.buildablesubset.common.model.ISubset;
import com.ibm.team.enterprise.common.ui.IEnterpriseExtensionsNode;
import com.ibm.team.enterprise.internal.build.ui.nls.Messages;
import com.ibm.team.enterprise.systemdefinition.ui.editors.actions.AbstractRepositoryActionDelegate;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.ItemNotFoundException;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;

public class DeleteSubsetActionDelegate
extends AbstractRepositoryActionDelegate
implements IObjectActionDelegate {
    private ISelection fSelection;
    private ITeamRepository fTeamRepository;
    private AbstractTreeViewer treeViewer;
    private List<IEnterpriseExtensionsNode> nodesToDelete;
    private List<IEnterpriseExtensionsNode> fDeletedNodes;

    public DeleteSubsetActionDelegate(ITeamRepository repository, AbstractTreeViewer fViewer, List<IEnterpriseExtensionsNode> targetNodes) {
        this.fTeamRepository = repository;
        this.treeViewer = fViewer;
        this.nodesToDelete = new ArrayList<IEnterpriseExtensionsNode>();
        this.nodesToDelete.addAll(targetNodes);
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    protected String getConfirmationMessage() {
        return Messages.BuildSubsetNode_LABEL_DELETEDIALOG_MESSAGE;
    }

    protected String getJobLabel() {
        return Messages.BuildSubsetNode_LABEL_DELETEDIALOG;
    }

    protected void performAction(IProgressMonitor progressMonitor) throws TeamRepositoryException {
        ArrayList<ISubset> selectedSubsets = new ArrayList<ISubset>();
        IStructuredSelection selection = (IStructuredSelection)this.fSelection;
        for (Object element : selection) {
            if (!(element instanceof ISubset)) continue;
            selectedSubsets.add((ISubset)element);
        }
        this.removeSubsets(selectedSubsets, progressMonitor);
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.fSelection = selection;
    }

    private void removeSubsets(List<ISubset> buildSubsets, IProgressMonitor progressMonitor) {
        progressMonitor.beginTask(Messages.BuildSubsetNode_JOB_DELETE, buildSubsets.size());
        this.fDeletedNodes = new ArrayList<IEnterpriseExtensionsNode>();
        for (IEnterpriseExtensionsNode node : this.nodesToDelete) {
            if (!(node instanceof BuildSubsetNode)) continue;
            BuildSubsetNode subsetNode = (BuildSubsetNode)node;
            boolean deleted = true;
            try {
                IBuildableSubsetClient client = ClientFactory.getBuildableSubsetClient((ITeamRepository)this.fTeamRepository);
                ISubset buildSubset = subsetNode.getBuildableSubset();
                if (buildSubset != null) {
                    client.deleteBuildableSubset(buildSubset);
                }
            }
            catch (ItemNotFoundException infException) {
                deleted = true;
            }
            catch (TeamRepositoryException tException) {
                deleted = false;
            }
            if (!deleted) continue;
            this.fDeletedNodes.add((IEnterpriseExtensionsNode)subsetNode);
        }
        progressMonitor.done();
    }

    protected void performUpdateUI() {
        if (this.getActionConfirmed() && this.treeViewer != null && !this.fDeletedNodes.isEmpty()) {
            HashSet<IEnterpriseExtensionsNode> nodesToRefresh = new HashSet<IEnterpriseExtensionsNode>();
            for (IEnterpriseExtensionsNode deletedNode : this.fDeletedNodes) {
                nodesToRefresh.add(deletedNode.getParent());
                this.treeViewer.remove((Object)deletedNode);
            }
            BuildSubsetView.deleteNodesFromBuildSubsetView(this.fDeletedNodes);
            if (!nodesToRefresh.isEmpty()) {
                for (IEnterpriseExtensionsNode toRefresh : nodesToRefresh) {
                    toRefresh.refresh();
                }
            }
            this.fDeletedNodes.clear();
        }
    }
}

