/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.build.ui.subset;

import com.ibm.team.enterprise.internal.build.ui.nls.Messages;
import com.ibm.team.process.internal.rcp.ui.ContributorQueryRunnable;
import com.ibm.team.process.internal.rcp.ui.ContributorSelectionBlock;
import com.ibm.team.process.internal.rcp.ui.HelpContextIds;
import com.ibm.team.process.internal.rcp.ui.IBlockContainer;
import com.ibm.team.process.internal.rcp.ui.ProcessRCPUIPlugin;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IContributorHandle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class ContributorSelectionDialog
extends TitleAreaDialog
implements IBlockContainer {
    private static final String DIALOG_SETTINGS = "com.ibm.team.process.rcp.ui.TeamContributorSelectionDialog";
    private ITeamRepository fRepository;
    private boolean fMultiselection;
    private ContributorSelectionBlock fSelectionBlock;
    private List fFilteredContributors;
    private ResourceManager fResourceManager;
    private String fSeparatorLabel;
    private List<ViewerFilter> fFilters;
    private boolean fIncludeHistory = true;
    private boolean fIncludeArchivedFilter = true;
    private Object[] fResult;
    private boolean fOpenEditorOnFinish;
    private String fTitle;
    private String fMessage;
    private String fHeaderLabel;
    private String fShellTitle;
    private String fHelpContextId;
    private ImageDescriptor fTitleImageDescriptor;
    private boolean fAllowOpenEditorsOnFinish = false;
    private ContributorQueryRunnable fQueryRunnable;
    private boolean fPageIsComplete;

    public ContributorSelectionDialog(Shell shell, ITeamRepository repository) {
        this(shell, repository, Collections.EMPTY_LIST, true);
    }

    public ContributorSelectionDialog(Shell shell, ITeamRepository repository, List filteredContributors, boolean multi) {
        super(shell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        Assert.isTrue((repository.getId() != null ? 1 : 0) != 0);
        this.fRepository = repository;
        this.fMultiselection = multi;
        this.fFilteredContributors = filteredContributors;
        this.fResourceManager = new LocalResourceManager(JFaceResources.getResources());
        this.fMessage = Messages.ContributorSelectionDialog_MESSAGE;
        this.fShellTitle = Messages.ContributorSelectionDialog_TITLE;
        this.fHelpContextId = "com.ibm.team.process.rcp.ui.csh_select_user";
        this.fTitleImageDescriptor = AbstractUIPlugin.imageDescriptorFromPlugin((String)"com.ibm.team.process.rcp.ui", (String)"icons/wizban/contributor_wizban.gif");
        this.fTitle = Messages.ContributorSelectionDialog_TITLE;
    }

    public IContributorHandle[] getContributorResult() {
        Object[] handles = this.fSelectionBlock.getResult();
        IContributorHandle[] result = new IContributorHandle[handles.length];
        System.arraycopy(handles, 0, result, 0, handles.length);
        return result;
    }

    protected Control createContents(Composite parent) {
        HelpContextIds.hookHelpListener((Control)parent, (String)this.fHelpContextId);
        return super.createContents(parent);
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        Composite blockContainer = new Composite(dialogArea, 0);
        GridLayout layout = new GridLayout(1, true);
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        blockContainer.setLayout((Layout)layout);
        blockContainer.setLayoutData((Object)new GridData(1808));
        this.fSelectionBlock = new ContributorSelectionBlock(this.fMultiselection, this.fIncludeHistory, this.fIncludeArchivedFilter, (IBlockContainer)this, this.fRepository, this.fFilteredContributors);
        if (this.fQueryRunnable != null) {
            this.fSelectionBlock.setQueryRunnable(this.fQueryRunnable);
        }
        if (this.fSeparatorLabel != null) {
            this.fSelectionBlock.setSeparatorLabel(this.fSeparatorLabel);
        }
        if (this.fFilters != null) {
            Iterator<ViewerFilter> iterator = this.fFilters.iterator();
            while (iterator.hasNext()) {
                this.fSelectionBlock.addListFilter(iterator.next());
            }
        }
        if (this.fHeaderLabel != null) {
            this.fSelectionBlock.setHeaderLabelText(this.fHeaderLabel);
        }
        Control block = this.fSelectionBlock.create(blockContainer);
        this.fSelectionBlock.restoreBlockSettings(this.getDialogSettings());
        this.fSelectionBlock.applyFilter();
        return block;
    }

    public void create() {
        super.create();
        this.getDefaultButton().setEnabled(false);
        this.fSelectionBlock.getPatternControl().setFocus();
        this.setTitle(this.fTitle);
        this.setMessage(this.fMessage);
        this.getShell().setText(this.fShellTitle);
        this.setTitleImage(this.fResourceManager.createImage(this.fTitleImageDescriptor));
    }

    protected IDialogSettings getDialogSettings() {
        IDialogSettings settings = ProcessRCPUIPlugin.getDefault().getDialogSettings().getSection(DIALOG_SETTINGS);
        if (settings == null) {
            settings = ProcessRCPUIPlugin.getDefault().getDialogSettings().addNewSection(DIALOG_SETTINGS);
        }
        return settings;
    }

    public boolean close() {
        try {
            this.fSelectionBlock.storeBlockSettings(this.getDialogSettings());
            this.fResourceManager.dispose();
            this.fSelectionBlock.dispose();
        }
        catch (Throwable e) {
            ProcessRCPUIPlugin.getDefault().log(e);
        }
        return super.close();
    }

    public GridData setLayoutData(Button button) {
        this.setButtonLayoutData(button);
        return (GridData)button.getLayoutData();
    }

    public void setStatus(IStatus status) {
        int type = 0;
        if (status != null) {
            switch (status.getSeverity()) {
                case 4: {
                    type = 3;
                    break;
                }
                case 2: {
                    type = 2;
                    break;
                }
                case 1: {
                    type = 1;
                }
            }
        }
        if (status == null || status.isOK() && status.getCode() != 55) {
            this.setMessage(this.fMessage);
        } else if (status.getMessage().length() != 0) {
            this.setMessage(status.getMessage(), type);
        }
    }

    protected void computeResult() {
        this.fSelectionBlock.computeResult(true);
        this.fOpenEditorOnFinish = this.fSelectionBlock.openEditorsOnFinish();
        this.setResult(this.fSelectionBlock.getResult());
    }

    private void setResult(Object[] result) {
        this.fResult = result;
    }

    public Object[] getResult() {
        return this.fResult;
    }

    public Object getFirstResult() {
        if (this.fResult == null || this.fResult.length == 0) {
            return null;
        }
        return this.fResult[0];
    }

    public Button getDefaultButton() {
        return this.getButton(0);
    }

    public boolean isPageComplete() {
        return this.fPageIsComplete;
    }

    public void finish() {
        this.okPressed();
    }

    protected void okPressed() {
        this.computeResult();
        super.okPressed();
    }

    public void addListFilter(ViewerFilter filter) {
        if (this.fFilters == null) {
            this.fFilters = new ArrayList<ViewerFilter>();
        }
        this.fFilters.add(filter);
    }

    public void setSeparatorLabel(String separatorLabel) {
        this.fSeparatorLabel = separatorLabel;
    }

    public boolean allowOpenEditorsOnFinish() {
        return this.fAllowOpenEditorsOnFinish;
    }

    public void setAllowOpenEditorsOnFinish(boolean allowOpenEditors) {
        this.fAllowOpenEditorsOnFinish = allowOpenEditors;
    }

    public boolean openEditorsOnFinish() {
        return this.fOpenEditorOnFinish;
    }

    protected void cancelPressed() {
        if (this.fSelectionBlock.isSearching()) {
            this.fSelectionBlock.cancelSearch();
        }
        super.cancelPressed();
    }

    public void setTitle(String title) {
        this.fTitle = title;
        super.setTitle(title);
    }

    public void setShellTitle(String shellTitle) {
        this.fShellTitle = shellTitle;
    }

    public void setMessage(String message) {
        this.fMessage = message;
        if (this.fSelectionBlock != null) {
            super.setMessage(message);
        }
    }

    public void setHelpContextId(String helpContextId) {
        this.fHelpContextId = helpContextId;
    }

    public void setTitleImageDescriptor(ImageDescriptor imageDescriptor) {
        this.fTitleImageDescriptor = imageDescriptor;
    }

    public void setIncludeHistory(boolean includeHistory) {
        this.fIncludeHistory = includeHistory;
    }

    public void setIncludeArchivedFilter(boolean includeArchivedFilter) {
        this.fIncludeArchivedFilter = includeArchivedFilter;
    }

    public void setQueryRunnable(ContributorQueryRunnable runnable) {
        this.fQueryRunnable = runnable;
    }

    public void setHeaderLabel(String headerLabel) {
        this.fHeaderLabel = headerLabel;
    }

    public void setPageComplete(boolean complete) {
        this.fPageIsComplete = complete;
        Button defaultButton = this.getDefaultButton();
        if (defaultButton != null) {
            this.getDefaultButton().setEnabled(complete);
        }
    }
}

