/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.build.ui.subset;

import com.ibm.team.build.common.model.IBuildDefinitionHandle;
import com.ibm.team.build.common.model.query.IBaseBuildDefinitionQueryModel;
import com.ibm.team.build.internal.common.model.query.BaseBuildDefinitionQueryModel;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.process.rcp.ui.teamnavigator.ConnectedProjectAreaRegistry;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.internal.TeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.query.IItemQuery;
import com.ibm.team.repository.common.query.IItemQueryPage;
import com.ibm.team.repository.common.query.ast.IItemHandleInputArg;
import com.ibm.team.repository.common.query.ast.IPredicate;
import com.ibm.team.repository.common.query.ast.IQueryModel;
import com.ibm.team.repository.common.service.IQueryService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

public class BuildableSubsetUtils {
    public static List<IBuildDefinitionHandle> getBuildDefinitions(IProjectAreaHandle projectAreaHandle) throws TeamRepositoryException {
        return BuildableSubsetUtils.getBuildDefinitions(Arrays.asList(projectAreaHandle));
    }

    public static List<IBuildDefinitionHandle> getBuildDefinitions(Collection<IProjectAreaHandle> projectAreaHandles) throws TeamRepositoryException {
        ArrayList<IBuildDefinitionHandle> buildDefinitionHandles = new ArrayList<IBuildDefinitionHandle>();
        for (IProjectAreaHandle projectAreaHandle : projectAreaHandles) {
            ITeamRepository repository = (ITeamRepository)projectAreaHandle.getOrigin();
            IQueryService queryService = ((TeamRepository)repository).getQueryService();
            IBaseBuildDefinitionQueryModel.IBuildDefinitionQueryModel buildDefinitionQueryModel = IBaseBuildDefinitionQueryModel.IBuildDefinitionQueryModel.ROOT;
            IItemQuery query = (IItemQuery)IItemQuery.FACTORY.newInstance((IQueryModel)buildDefinitionQueryModel);
            ConnectedProjectAreaRegistry registry = ConnectedProjectAreaRegistry.getDefault();
            List selectedProcessAreas = registry.getSelectedProcessAreas(projectAreaHandle);
            if (selectedProcessAreas.size() <= 0) continue;
            IItemHandleInputArg[] itemHandleArgs = new IItemHandleInputArg[selectedProcessAreas.size()];
            int i = 0;
            while (i < selectedProcessAreas.size()) {
                itemHandleArgs[i] = query.newItemHandleArg();
                ++i;
            }
            IPredicate filter = ((BaseBuildDefinitionQueryModel.BuildDefinitionQueryModel)buildDefinitionQueryModel).processArea()._in(itemHandleArgs);
            query.filter(filter);
            IItemQueryPage queryPage = queryService.queryItems(query, selectedProcessAreas.toArray(), Integer.MAX_VALUE);
            if (queryPage == null) continue;
            do {
                IItemHandle[] itemHandles;
                if ((itemHandles = queryPage.handlesAsArray()) == null) continue;
                IItemHandle[] iItemHandleArray = itemHandles;
                int n = itemHandles.length;
                int n2 = 0;
                while (n2 < n) {
                    IItemHandle itemHandle = iItemHandleArray[n2];
                    buildDefinitionHandles.add((IBuildDefinitionHandle)itemHandle);
                    ++n2;
                }
            } while (queryPage.hasNext() && (queryPage = (IItemQueryPage)queryService.fetchPage(queryPage.getToken(), queryPage.getNextStartPosition(), 512)) != null);
        }
        return buildDefinitionHandles;
    }
}

