/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.build.ui.subset;

import com.ibm.team.build.common.model.IBuildDefinitionHandle;
import com.ibm.team.enterprise.build.client.buildablesubset.ClientFactory;
import com.ibm.team.enterprise.build.ui.subset.BuildSubsetNode;
import com.ibm.team.enterprise.buildablesubset.common.model.ICriteriaWorkItem;
import com.ibm.team.enterprise.buildablesubset.common.model.ISubset;
import com.ibm.team.enterprise.buildablesubset.common.util.BuildableSubsetUtil;
import com.ibm.team.enterprise.common.ui.Activator;
import com.ibm.team.enterprise.internal.build.ui.nls.Messages;
import com.ibm.team.jface.itemview.MarkupUtil;
import com.ibm.team.jface.preview.DomainAdapter;
import com.ibm.team.jface.preview.HTMLGenerator;
import com.ibm.team.jface.preview.IDomainAdapter;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.osgi.util.NLS;

public class BuildableSubsetDomainAdapter
extends DomainAdapter
implements IDomainAdapter {
    private static final String BS_CSS = "bscss";

    public void generateContentAsHTML(HashMap head, StringBuffer body, Object input, IDomainAdapter.Info info) {
        HTMLGenerator htmlGenerator = null;
        try {
            if (input instanceof BuildSubsetNode) {
                BuildSubsetNode subsetNode = (BuildSubsetNode)((Object)input);
                ISubset subsetHandle = subsetNode.getBuildableSubset();
                ITeamRepository repository = subsetNode.getTeamRepository();
                htmlGenerator = this.generateHtml(subsetHandle, repository);
            } else if (input instanceof ISubset) {
                ISubset subset = (ISubset)input;
                ITeamRepository repository = (ITeamRepository)subset.getOrigin();
                htmlGenerator = this.generateHtml(subset, repository);
            }
        }
        catch (Exception e) {
            Activator.log((Throwable)e);
        }
        if (htmlGenerator != null) {
            htmlGenerator.generate(head, body, info);
        }
    }

    public String generateJobInfo(Object input, IDomainAdapter.Info info) {
        ISubset subset = null;
        if (input instanceof BuildSubsetNode) {
            BuildSubsetNode subsetNode = (BuildSubsetNode)((Object)input);
            subset = subsetNode.getBuildableSubset();
        } else if (input instanceof ISubset) {
            subset = (ISubset)input;
        }
        if (subset == null || subset.getBuildDefinition() == null || subset.getOrigin() == null || subset.getLabel() == null || subset.getLabel().trim().length() <= 0) {
            return "__do--not__show//";
        }
        return Messages.BuildableSubsetDomainAdapter_JOB_INFO;
    }

    public String generateTitle(Object input) {
        return Messages.BuildableSubsetDomainAdapter_TITLE;
    }

    protected Object convertToDomainObject(Object object) {
        if (object instanceof ISubset) {
            return object;
        }
        return null;
    }

    private HTMLGenerator generateHtml(ISubset subset, ITeamRepository repository) throws TeamRepositoryException {
        return this.generateHtml(subset.getLabel(), subset.getBuildDefinition(), repository);
    }

    private HTMLGenerator generateHtml(String subsetLabel, IBuildDefinitionHandle buildDefinitionHandle, ITeamRepository repository) throws TeamRepositoryException {
        String slug = BuildableSubsetUtil.getSlug((String)subsetLabel, (String)buildDefinitionHandle.getItemId().getUuidValue());
        ISubset subset = ClientFactory.getBuildableSubsetClient((ITeamRepository)repository).getSubsetItem(slug);
        return this.generateHtml(subsetLabel, subset, repository);
    }

    private HTMLGenerator generateHtml(final String subsetLabel, final ISubset subset, final ITeamRepository repository) {
        return new HTMLGenerator(){

            protected void createControl(HTMLGenerator.Composite composite) {
                String label;
                String string = label = subset != null ? subset.getLabel() : subsetLabel;
                if (label != null && label.trim().length() > 0) {
                    HTMLGenerator.Label scanResultLabel = new HTMLGenerator.Label((HTMLGenerator)this, label);
                    HTMLGenerator.Section section = new HTMLGenerator.Section((HTMLGenerator)this, composite, (HTMLGenerator.Control)scanResultLabel);
                    HTMLGenerator.Table table = new HTMLGenerator.Table((HTMLGenerator)this, (HTMLGenerator.Composite)section, 2);
                    table.setCSSClass("layout");
                    if (subset != null) {
                        new HTMLGenerator.Label((HTMLGenerator)this, (HTMLGenerator.Composite)table, Messages.BuildableSubsetDomainAdapter_WI_LABLE);
                        ArrayList wiHandles = new ArrayList();
                        subset.getCriteria().getReferences().stream().filter(ICriteriaWorkItem.class::isInstance).map(ICriteriaWorkItem.class::cast).forEach(wiCriterion -> {
                            wiHandles.addAll(wiCriterion.getWorkItems());
                            wiHandles.addAll(wiCriterion.getAdditionalWorkItems());
                        });
                        Collection<Object> wis = Collections.EMPTY_SET;
                        try {
                            wis = ClientFactory.getBuildableSubsetClient((ITeamRepository)repository).getWorkItemNumbers(wiHandles, repository).values();
                        }
                        catch (IllegalArgumentException e) {
                            e.printStackTrace();
                        }
                        catch (TeamRepositoryException e) {
                            e.printStackTrace();
                        }
                        new HTMLGenerator.Label((HTMLGenerator)this, (HTMLGenerator.Composite)table, BuildableSubsetDomainAdapter.this.convertToString(new HashSet(wis)));
                        new HTMLGenerator.Label((HTMLGenerator)this, (HTMLGenerator.Composite)table, Messages.BuildableSubsetDomainAdapter_NUMBER_OF_FILES_LABEL);
                        new HTMLGenerator.Label((HTMLGenerator)this, (HTMLGenerator.Composite)table, NLS.bind((String)Messages.BuildableSubsetDomainAdapter_NUMBER_OF_FILES, (Object)subset.getFileDescs().size()));
                        new HTMLGenerator.Label((HTMLGenerator)this, (HTMLGenerator.Composite)table, Messages.BuildableSubsetDomainAdapter_DESCRIPTION);
                        new HTMLGenerator.Label((HTMLGenerator)this, (HTMLGenerator.Composite)table, subset.getDescription() == null ? "" : subset.getDescription());
                    } else {
                        String msg = subsetLabel != null ? NLS.bind((String)Messages.BuildableSubsetDomainAdapter_SUBSET_NOT_FOUND, (Object[])new Object[]{subsetLabel}) : null;
                        new HTMLGenerator.Label((HTMLGenerator)this, (HTMLGenerator.Composite)table, msg);
                    }
                }
            }

            protected void generateHead(HashMap headDefinitions) {
                if (headDefinitions.containsKey(BuildableSubsetDomainAdapter.BS_CSS)) {
                    return;
                }
                StringBuilder css = new StringBuilder();
                css.append("<style type=\"text/css\">");
                css.append("table.layout");
                css.append(" { empty-cells:hide; margin-left: -1px; ").append(MarkupUtil.getDefaultFont()).append(" }\n");
                css.append("</style>");
                headDefinitions.put(BuildableSubsetDomainAdapter.BS_CSS, css.toString());
            }
        };
    }

    private String convertToString(Set<Integer> workItemIds) {
        StringBuilder buffer = new StringBuilder();
        if (workItemIds.size() == 0) {
            buffer.append(Messages.BuildableSubsetDomainAdapter_NONE);
        } else {
            Iterator<Integer> iterator = workItemIds.iterator();
            while (iterator.hasNext()) {
                buffer.append(iterator.next());
                if (!iterator.hasNext()) continue;
                buffer.append(", ");
            }
        }
        return buffer.toString();
    }
}

