/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.build.ui.subset;

import com.ibm.team.enterprise.build.ui.Activator;
import com.ibm.team.enterprise.internal.build.ui.nls.Messages;
import com.ibm.team.enterprise.systemdefinition.client.ISystemDefinitionModelClient;
import com.ibm.team.enterprise.systemdefinition.common.model.ILanguageDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.ILanguageDefinitionHandle;
import com.ibm.team.enterprise.systemdefinition.common.model.ISystemDefinitionHandle;
import com.ibm.team.filesystem.common.IFileItem;
import com.ibm.team.jface.util.UIUpdaterJob;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.client.IConfiguration;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IFolder;
import com.ibm.team.scm.common.IFolderHandle;
import com.ibm.team.scm.common.IVersionable;
import com.ibm.team.scm.common.IWorkspaceHandle;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.internal.progress.ProgressMessages;
import org.eclipse.ui.progress.DeferredTreeContentManager;
import org.eclipse.ui.progress.IDeferredWorkbenchAdapter;
import org.eclipse.ui.progress.IElementCollector;
import org.eclipse.ui.progress.PendingUpdateAdapter;
import org.eclipse.ui.progress.WorkbenchJob;

public class BuildableSubsetContentProvider2
implements ITreeContentProvider,
IDeferredWorkbenchAdapter {
    private ConcurrentMap<Object, AtomicBoolean> fObjectFetchMap = new ConcurrentHashMap<Object, AtomicBoolean>();
    private AtomicInteger fFetchTotal = new AtomicInteger(0);
    private AtomicInteger fAddTotal = new AtomicInteger(0);
    private DeferredTreeContentManager fDeferredTreeManager;
    private ITeamRepository repository;
    private IWorkspaceConnection workspaceConnection;
    private Map<UUID, IComponent> componentMap;
    private Map<UUID, IComponent> buildableFileComponentMap;
    private Map<UUID, ILanguageDefinition> languageDefinitionMap;
    private Map<String, ILanguageDefinition> defaultLanguageDefinitionMap;
    private ISystemDefinitionModelClient systemDefinitionClient;
    private Button fOKButton = null;
    private CheckboxTreeViewer fTreeViewer = null;

    public BuildableSubsetContentProvider2(ITeamRepository repository) {
        this.repository = repository;
        this.systemDefinitionClient = (ISystemDefinitionModelClient)repository.getClientLibrary(ISystemDefinitionModelClient.class);
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof PendingUpdateAdapter) {
            return new Object[0];
        }
        if (this.fDeferredTreeManager != null) {
            return this.fDeferredTreeManager.getChildren(parentElement);
        }
        return new String[]{Messages.BuildableSubsetSelectionDialog_PENDING};
    }

    public Object getParent(Object element) {
        return null;
    }

    public boolean hasChildren(Object element) {
        return !(element instanceof IFileItem);
    }

    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }

    public void dispose() {
        this.fDeferredTreeManager = null;
        this.languageDefinitionMap.clear();
        this.defaultLanguageDefinitionMap.clear();
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.workspaceConnection = null;
        this.languageDefinitionMap = new HashMap<UUID, ILanguageDefinition>();
        this.defaultLanguageDefinitionMap = new HashMap<String, ILanguageDefinition>();
        if (this.fDeferredTreeManager == null) {
            this.fDeferredTreeManager = new DeferredTreeContentManager((AbstractTreeViewer)viewer){

                protected IDeferredWorkbenchAdapter getAdapter(Object element) {
                    if (BuildableSubsetContentProvider2.this.hasChildren(element)) {
                        return BuildableSubsetContentProvider2.this;
                    }
                    return super.getAdapter(element);
                }

                protected void addChildren(final Object parent, final Object[] children, IProgressMonitor monitor) {
                    WorkbenchJob updateJob = new WorkbenchJob(ProgressMessages.DeferredTreeContentManager_AddingChildren){

                        public IStatus runInUIThread(IProgressMonitor updateMonitor) {
                            if (BuildableSubsetContentProvider2.this.fTreeViewer == null || BuildableSubsetContentProvider2.this.fTreeViewer.getTree() == null || BuildableSubsetContentProvider2.this.fTreeViewer.getControl().isDisposed() || updateMonitor.isCanceled()) {
                                return Status.CANCEL_STATUS;
                            }
                            if (children != null && children.length > 0) {
                                BuildableSubsetContentProvider2.this.fTreeViewer.add(parent, children);
                                Object[] objectArray = children;
                                int n = children.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    Object child = objectArray[n2];
                                    if (BuildableSubsetContentProvider2.this.fTreeViewer.getChecked(parent) && !BuildableSubsetContentProvider2.this.fTreeViewer.getGrayed(parent)) {
                                        BuildableSubsetContentProvider2.this.fTreeViewer.setChecked(child, true);
                                    }
                                    ++n2;
                                }
                                BuildableSubsetContentProvider2.this.fAddTotal.addAndGet(children.length);
                                if (BuildableSubsetContentProvider2.this.fOKButton != null && !BuildableSubsetContentProvider2.this.fOKButton.isDisposed()) {
                                    if (BuildableSubsetContentProvider2.this.fFetchTotal.get() == BuildableSubsetContentProvider2.this.fAddTotal.get()) {
                                        BuildableSubsetContentProvider2.this.fOKButton.setEnabled(true);
                                    } else {
                                        BuildableSubsetContentProvider2.this.fOKButton.setEnabled(false);
                                    }
                                }
                            }
                            return Status.OK_STATUS;
                        }
                    };
                    updateJob.setSystem(true);
                    updateJob.schedule();
                }
            };
        }
    }

    public void fetchDeferredChildren(Object object, IElementCollector collector, IProgressMonitor monitor) {
        AtomicBoolean fFetchInProgress = this.getObjectFetched(object);
        if (fFetchInProgress.compareAndSet(false, true)) {
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    if (BuildableSubsetContentProvider2.this.fOKButton != null && !BuildableSubsetContentProvider2.this.fOKButton.isDisposed()) {
                        BuildableSubsetContentProvider2.this.fOKButton.setEnabled(false);
                    }
                }
            });
            try {
                try {
                    if (object instanceof IWorkspaceHandle) {
                        this.fetchComponents((IWorkspaceHandle)object, collector, monitor);
                    } else if (object instanceof IComponent) {
                        this.fetchProjects((IComponent)object, collector, monitor);
                    } else if (object instanceof IFolder) {
                        this.fetchFolders((IFolder)object, collector, monitor);
                    }
                }
                catch (TeamRepositoryException e) {
                    Activator.getDefault().logError(e);
                    fFetchInProgress.set(false);
                    collector.done();
                    monitor.done();
                }
            }
            finally {
                fFetchInProgress.set(false);
                collector.done();
                monitor.done();
            }
        }
    }

    private AtomicBoolean getObjectFetched(Object obj) {
        AtomicBoolean result = new AtomicBoolean(false);
        AtomicBoolean tempResult = this.fObjectFetchMap.putIfAbsent(obj, result);
        if (tempResult != null) {
            result = tempResult;
        }
        return result;
    }

    public void fetchComponents(IWorkspaceHandle workspace, IElementCollector collector, IProgressMonitor monitor) throws TeamRepositoryException {
        if (monitor != null && monitor.isCanceled()) {
            return;
        }
        this.workspaceConnection = SCMPlatform.getWorkspaceManager((ITeamRepository)this.repository).getWorkspaceConnection(workspace, monitor);
        List componentHandles = this.workspaceConnection.getComponents();
        List components = this.repository.itemManager().fetchCompleteItems(componentHandles, 0, monitor);
        this.addCollectorByArray(collector, components.toArray(), monitor);
        this.componentMap = new HashMap<UUID, IComponent>();
        this.buildableFileComponentMap = new HashMap<UUID, IComponent>();
    }

    public void fetchProjects(final IComponent component, final IElementCollector collector, IProgressMonitor monitor) throws TeamRepositoryException {
        if (monitor != null && monitor.isCanceled() || this.workspaceConnection == null) {
            return;
        }
        final IConfiguration configuration = this.workspaceConnection.configuration((IComponentHandle)component);
        try {
            UIUpdaterJob uiJob = new UIUpdaterJob(""){
                private List<IVersionable> versionables;

                public IStatus runInBackground(IProgressMonitor monitor) {
                    try {
                        Map projectHandleMap = configuration.childEntriesForRoot(monitor);
                        this.versionables = configuration.fetchCompleteItems(new ArrayList(projectHandleMap.values()), monitor);
                    }
                    catch (TeamRepositoryException e) {
                        e.printStackTrace();
                    }
                    return super.runInBackground(monitor);
                }

                public IStatus runInUI(IProgressMonitor monitor) {
                    for (IVersionable versionable : this.versionables) {
                        if (!(versionable instanceof IFolder)) continue;
                        BuildableSubsetContentProvider2.this.addCollectorByItem(collector, versionable, monitor);
                        BuildableSubsetContentProvider2.this.componentMap.put(versionable.getItemId(), component);
                    }
                    return super.runInUI(monitor);
                }
            };
            uiJob.schedule();
            uiJob.join();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public void fetchFolders(IFolder folder, IElementCollector collector, IProgressMonitor monitor) throws TeamRepositoryException {
        if (monitor != null && monitor.isCanceled() || this.workspaceConnection == null || folder == null) {
            return;
        }
        String folderName = folder.getName().toLowerCase();
        if (folderName.startsWith(".") || folderName.equals("zosbin")) {
            return;
        }
        IComponent component = this.componentMap.get(folder.getItemId());
        if (component == null) {
            return;
        }
        IConfiguration configuration = this.workspaceConnection.configuration((IComponentHandle)component);
        Map versionableMap = configuration.childEntries((IFolderHandle)folder, monitor);
        List versionables = configuration.fetchCompleteItems(new ArrayList(versionableMap.values()), monitor);
        for (IVersionable versionable : versionables) {
            if (versionable.getName().startsWith(".")) continue;
            if (versionable instanceof IFolder) {
                this.addCollectorByItem(collector, versionable, monitor);
                this.componentMap.put(versionable.getItemId(), component);
                continue;
            }
            if (!(versionable instanceof IFileItem) || !this.isBuildableFile((IFileItem)versionable, monitor)) continue;
            this.addCollectorByItem(collector, versionable, monitor);
            this.buildableFileComponentMap.put(versionable.getItemId(), component);
        }
    }

    private void addCollectorByArray(IElementCollector collector, Object[] objArray, IProgressMonitor monitor) {
        if (objArray != null) {
            collector.add(objArray, monitor);
            this.fFetchTotal.addAndGet(objArray.length);
        }
    }

    private void addCollectorByItem(IElementCollector collector, Object obj, IProgressMonitor monitor) {
        collector.add(obj, monitor);
        this.fFetchTotal.incrementAndGet();
    }

    public boolean isBuildableFile(IFileItem fileItem, IProgressMonitor monitor) {
        ILanguageDefinition ld;
        block4: {
            if (monitor != null && monitor.isCanceled()) {
                return false;
            }
            try {
                ld = this.getLanguageDefinition(fileItem, monitor);
                if (ld != null) break block4;
                return false;
            }
            catch (TeamRepositoryException e) {
                return false;
            }
        }
        return ld.getTranslators().size() > 0;
    }

    private ILanguageDefinition getLanguageDefinition(IFileItem fileItem, IProgressMonitor monitor) throws TeamRepositoryException {
        ILanguageDefinition ld = null;
        String langdefValue = (String)fileItem.getUserProperties().get("team.enterprise.language.definition");
        if (langdefValue != null && !langdefValue.equals("")) {
            UUID uuid = this.convert2UUID(langdefValue);
            ld = this.languageDefinitionMap.get(uuid);
            if (ld == null) {
                ILanguageDefinitionHandle handle = (ILanguageDefinitionHandle)ILanguageDefinition.ITEM_TYPE.createItemHandle(uuid, null);
                ld = (ILanguageDefinition)this.systemDefinitionClient.fetchSystemDefinition((ISystemDefinitionHandle)handle, null, monitor);
            }
            if (ld != null) {
                this.languageDefinitionMap.put(uuid, ld);
            }
        } else {
            String fileName = fileItem.getName();
            int extensionIndex = fileName != null ? fileName.lastIndexOf(46) : -1;
            String fileExtension = extensionIndex != -1 && fileName.length() > extensionIndex + 1 ? fileName.substring(extensionIndex + 1).toLowerCase() : "";
            ld = this.defaultLanguageDefinitionMap.get(fileExtension);
            if (ld == null) {
                ld = this.systemDefinitionClient.getDefaultLanguageDefinition(fileItem.getName(), monitor);
            }
            if (ld != null) {
                this.defaultLanguageDefinitionMap.put(fileExtension, ld);
            }
        }
        return ld;
    }

    private UUID convert2UUID(String uuidValue) {
        try {
            return UUID.valueOf((String)uuidValue);
        }
        catch (Exception e) {
            return null;
        }
    }

    public ISchedulingRule getRule(Object arg0) {
        return null;
    }

    public boolean isContainer() {
        return true;
    }

    public ImageDescriptor getImageDescriptor(Object object) {
        return null;
    }

    public String getLabel(Object element) {
        return element.toString();
    }

    public Map<UUID, IComponent> getComponentMap() {
        return this.componentMap;
    }

    public Map<UUID, IComponent> getBuildableFileComponentMap() {
        return this.buildableFileComponentMap;
    }

    public IWorkspaceConnection getWorkspaceConnection() {
        return this.workspaceConnection;
    }

    public void setOKButton(Button okButton) {
        this.fOKButton = okButton;
    }

    public void setTreeViewer(CheckboxTreeViewer fTreeViewer) {
        this.fTreeViewer = fTreeViewer;
    }

    public AtomicInteger getFetchTotal() {
        return this.fFetchTotal;
    }

    public AtomicInteger getAddTotal() {
        return this.fAddTotal;
    }
}

