/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.build.ui.subset;

import com.ibm.team.build.common.model.IBuildDefinitionHandle;
import com.ibm.team.enterprise.build.client.buildablesubset.IBuildableSubsetClient;
import com.ibm.team.enterprise.build.ui.subset.BuildSubsetNode;
import com.ibm.team.enterprise.build.ui.subset.BuildSubsetsNode;
import com.ibm.team.enterprise.buildablesubset.common.model.ISubset;
import com.ibm.team.enterprise.internal.build.ui.nls.Messages;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.process.common.ITeamArea;
import com.ibm.team.process.rcp.ui.teamnavigator.DomainSubtreeRoot;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ui.progress.IElementCollector;

public class BuildSubsetsNodeMySubsets
extends BuildSubsetsNode {
    public static final String NODE_PATH_ID = "BuildSubsets/MySubsets";
    public static final String NODE_ID = "com.ibm.team.enterprise.build.ui.subset.mysubsets";
    private boolean isFetching;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fetchDeferredChildren(IElementCollector collector, IProgressMonitor monitor) {
        BuildSubsetsNodeMySubsets buildSubsetsNodeMySubsets = this;
        synchronized (buildSubsetsNodeMySubsets) {
            if (this.isFetching) {
                return;
            }
            this.isFetching = true;
        }
        try {
            monitor.beginTask("", -1);
            this.collectMySubsetNodes(this.getDomainSubtreeRoot(), collector, monitor, null);
        }
        catch (Throwable throwable) {
            BuildSubsetsNodeMySubsets buildSubsetsNodeMySubsets2 = this;
            synchronized (buildSubsetsNodeMySubsets2) {
                this.isFetching = false;
            }
            throw throwable;
        }
        BuildSubsetsNodeMySubsets buildSubsetsNodeMySubsets3 = this;
        synchronized (buildSubsetsNodeMySubsets3) {
            this.isFetching = false;
        }
    }

    private void collectMySubsetNodes(DomainSubtreeRoot parent, IElementCollector collector, IProgressMonitor monitor, String timestamp) {
        Object category = parent.getCategoryElement();
        if (category instanceof ITeamArea) {
            category = ((ITeamArea)category).getProjectArea();
        }
        IProjectAreaHandle projectAreaHandle = (IProjectAreaHandle)category;
        ArrayList<BuildSubsetNode> nodes = new ArrayList<BuildSubsetNode>();
        if (this.fRepository == null) {
            this.fRepository = (ITeamRepository)projectAreaHandle.getOrigin();
        }
        List<ISubset> subsetList = this.getBuildableSubsets(projectAreaHandle, timestamp);
        for (ISubset subset : subsetList) {
            BuildSubsetNode newNode = new BuildSubsetNode(subset, this.getDomainSubtreeRoot(), this);
            newNode.setProjectAreaHandle(projectAreaHandle);
            nodes.add(newNode);
        }
        collector.add(nodes.toArray(), null);
    }

    @Override
    protected List<ISubset> getBuildableSubsetsForNode(IBuildDefinitionHandle buildDefinitionHandle, String timestamp) throws TeamRepositoryException {
        IBuildableSubsetClient client = (IBuildableSubsetClient)this.fRepository.getClientLibrary(IBuildableSubsetClient.class);
        return client.getMyBuildableSubsets(buildDefinitionHandle, timestamp);
    }

    @Override
    public boolean hasChildren() {
        return true;
    }

    @Override
    public String getLabel() {
        return Messages.BuildSubsetsNode_BuildSubsetsMySubsets;
    }
}

