/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.build.ui.subset;

import com.ibm.team.build.common.model.IBuildDefinitionHandle;
import com.ibm.team.enterprise.build.ui.Activator;
import com.ibm.team.enterprise.build.ui.subset.BuildSubsetNode;
import com.ibm.team.enterprise.build.ui.subset.BuildSubsetsNodeMySubsets;
import com.ibm.team.enterprise.build.ui.subset.BuildSubsetsNodeSharedSubsets;
import com.ibm.team.enterprise.build.ui.subset.BuildableSubsetUtils;
import com.ibm.team.enterprise.build.ui.subset.SubsetDomainActionHelper;
import com.ibm.team.enterprise.buildablesubset.common.model.ISubset;
import com.ibm.team.enterprise.common.ui.domain.AbstractEnterpriseExtensionsNode;
import com.ibm.team.enterprise.internal.build.ui.nls.Messages;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.progress.PendingUpdateAdapter;

public class BuildSubsetsNode
extends AbstractEnterpriseExtensionsNode {
    private ViewerSorter fViewerSorter;
    protected ITeamRepository fRepository;

    public ViewerSorter getSorter() {
        if (this.fViewerSorter == null) {
            this.fViewerSorter = new BuildSubsetViewerSorter();
        }
        return this.fViewerSorter;
    }

    public Image getIcon() {
        return Activator.getImage("icons/obj16/bldsubset_fldr.gif");
    }

    public String getLabel() {
        if (Activator.getDefault().getPreferenceStore().getBoolean("team.enterprise.build.subsets.filtered.enabled." + this.getProjectAreaHandle().getItemId().getUuidValue())) {
            return Messages.BuildsubsetNode_LABEL_FILTERED;
        }
        return Messages.BuildsubsetNode_LABEL;
    }

    public boolean hasChildren() {
        return true;
    }

    public void contributeContextMenuActions(IMenuManager manager, IStructuredSelection selection) {
        if (selection.isEmpty()) {
            return;
        }
        SubsetDomainActionHelper actionHelper = new SubsetDomainActionHelper(manager, selection, this.getDomainSubtreeRoot().getDomain().getWorkbenchPart().getSite());
        actionHelper.contributeActions();
        super.contributeContextMenuActions(manager, selection);
    }

    protected String[] getOperationIds() {
        return new String[]{"com.ibm.teamz.build.rbe.buildableSubset"};
    }

    protected List<ISubset> getBuildableSubsets(IProjectAreaHandle projectAreaHandle, String timestamp) {
        ArrayList<ISubset> handles = new ArrayList<ISubset>();
        try {
            List<IBuildDefinitionHandle> buildDefinitionHandles = BuildableSubsetUtils.getBuildDefinitions(projectAreaHandle);
            boolean filterEnabled = Activator.getDefault().getPreferenceStore().getBoolean("team.enterprise.build.subsets.filtered.enabled." + this.getProjectAreaHandle().getItemId().getUuidValue());
            if (filterEnabled) {
                List<String> buildsToShow = Arrays.asList(Activator.getDefault().getPreferenceStore().getString("team.enterprise.build.subsets.filtered.list." + this.getProjectAreaHandle().getItemId().getUuidValue()).split(","));
                if (buildsToShow.isEmpty()) {
                    buildDefinitionHandles.clear();
                } else {
                    Iterator<IBuildDefinitionHandle> it = buildDefinitionHandles.iterator();
                    while (it.hasNext()) {
                        if (buildsToShow.contains(it.next().getItemId().getUuidValue())) continue;
                        it.remove();
                    }
                }
            }
            for (IBuildDefinitionHandle buildDefinitionHandle : buildDefinitionHandles) {
                handles.addAll(this.getBuildableSubsetsForNode(buildDefinitionHandle, timestamp));
            }
        }
        catch (TeamRepositoryException e) {
            e.printStackTrace();
        }
        return handles;
    }

    protected List<ISubset> getBuildableSubsetsForNode(IBuildDefinitionHandle buildDefinitionHandle, String timestamp) throws TeamRepositoryException {
        return new ArrayList<ISubset>();
    }

    public static class BuildSubsetViewerSorter
    extends ViewerSorter {
        public int compare(Viewer viewer, Object element1, Object element2) {
            if (element1 instanceof PendingUpdateAdapter && element2 instanceof PendingUpdateAdapter) {
                return 0;
            }
            if (element1 instanceof PendingUpdateAdapter) {
                return -1;
            }
            if (element2 instanceof PendingUpdateAdapter) {
                return 1;
            }
            if (element1 instanceof BuildSubsetNode && element2 instanceof BuildSubsetsNodeMySubsets) {
                return 1;
            }
            if (element1 instanceof BuildSubsetNode && element2 instanceof BuildSubsetsNodeSharedSubsets) {
                return 1;
            }
            if (element1 instanceof BuildSubsetsNodeMySubsets && element2 instanceof BuildSubsetsNodeSharedSubsets) {
                return -1;
            }
            if (element1 instanceof BuildSubsetsNodeMySubsets && element2 instanceof BuildSubsetNode) {
                return -1;
            }
            if (element1 instanceof BuildSubsetsNodeSharedSubsets && element2 instanceof BuildSubsetsNodeMySubsets) {
                return 1;
            }
            if (element1 instanceof BuildSubsetsNodeSharedSubsets && element2 instanceof BuildSubsetNode) {
                return -1;
            }
            if (element1 instanceof BuildSubsetNode && element2 instanceof BuildSubsetNode) {
                BuildSubsetNode node1 = (BuildSubsetNode)((Object)element1);
                BuildSubsetNode node2 = (BuildSubsetNode)((Object)element2);
                return node1.getLabel().compareTo(node2.getLabel());
            }
            return 0;
        }
    }
}

