/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.build.ui.subset;

import com.ibm.team.build.common.model.IBuildDefinitionHandle;
import com.ibm.team.enterprise.build.client.buildablesubset.ClientFactory;
import com.ibm.team.enterprise.build.client.buildablesubset.IBuildableSubsetClient;
import com.ibm.team.enterprise.build.ui.Activator;
import com.ibm.team.enterprise.buildablesubset.common.IBuildSubsetRule;
import com.ibm.team.enterprise.buildablesubset.common.IWorkItemBuildSubsetRule;
import com.ibm.team.enterprise.buildablesubset.common.impl.WorkItemBuildSubsetRule;
import com.ibm.team.enterprise.buildablesubset.common.model.ISubset;
import com.ibm.team.enterprise.internal.build.ui.nls.Messages;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.workitem.common.IWorkItemCommon;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.model.IWorkItemHandle;
import com.ibm.team.workitem.rcp.ui.workitempicker.WorkItemSelectionDialog;
import com.ibm.team.workitem.rcp.ui.workitempicker.WorkItemSelector;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class BuildSubsetWorkItemSelectionDialog
extends WorkItemSelectionDialog {
    private ITeamRepository repo;
    private IBuildDefinitionHandle fBuildDefHandle = null;
    private ISubset fResultSubset = null;
    private IWorkItemHandle[] fHandles = null;
    private List<IWorkItemHandle> selectedWorkItems;
    private IWorkItemBuildSubsetRule subsetRule;
    private Button showSummaryCheckbox;
    private boolean showSummary = true;
    public static final String DO_NOT_SHOW_SUMMARY_SETTING = "doNotShowSummarySetting_AddWorkItem";
    public static final String INCLUDE_CHLDREN = "includeChildren_AddWorkItem";
    public static final String INCLUDE_IMPACTED = "includeImpacted_AddWorkItem";
    private Button includeChildrenCheckbox;
    private boolean isIncludeChildren = false;
    private Button includeImpactedCheckbox;
    private boolean isIncludeImpacted = false;
    private boolean isDynamic = false;

    public BuildSubsetWorkItemSelectionDialog(Shell parent, IBuildDefinitionHandle buildDefHandle, boolean multi) {
        super(parent, multi);
        this.repo = (ITeamRepository)buildDefHandle.getOrigin();
        this.fBuildDefHandle = buildDefHandle;
    }

    public BuildSubsetWorkItemSelectionDialog(Shell parent, ITeamRepository repository, IBuildDefinitionHandle buildDefHandle, boolean multi) {
        super(parent, repository, multi);
        this.repo = repository;
        this.fBuildDefHandle = buildDefHandle;
    }

    public BuildSubsetWorkItemSelectionDialog(Shell parent, IProjectAreaHandle projectArea, IBuildDefinitionHandle buildDefHandle, boolean multi) {
        super(parent, projectArea, multi);
        this.repo = (ITeamRepository)projectArea.getOrigin();
        this.fBuildDefHandle = buildDefHandle;
    }

    public List<IWorkItemHandle> getChosenWorkItems() {
        return this.selectedWorkItems;
    }

    public int open() {
        this.setTitle(Messages.BuildSubsetWIDialog_TITLE);
        int parentReturnValue = super.open();
        if (parentReturnValue == 0) {
            this.fHandles = (IWorkItemHandle[])super.getResult();
        }
        return parentReturnValue;
    }

    public Object[] getResult() {
        this.getResultSubset(null);
        if (this.fResultSubset != null) {
            return this.fResultSubset.getFileDescs().toArray();
        }
        return new Object[0];
    }

    public ISubset getResultSubset(ISubset currentSubset) {
        if (this.fResultSubset != null) {
            return this.fResultSubset;
        }
        if (this.fHandles != null && this.fHandles.length > 0) {
            WorkItemSelector.addToHistory((IWorkItemHandle[])this.fHandles);
            if (this.selectedWorkItems == null) {
                this.selectedWorkItems = new ArrayList<IWorkItemHandle>();
            }
            this.selectedWorkItems.addAll(Arrays.asList(this.fHandles));
            IBuildableSubsetClient client = ClientFactory.getBuildableSubsetClient((ITeamRepository)this.repo);
            this.subsetRule = new WorkItemBuildSubsetRule();
            this.subsetRule.setDynamic(this.isDynamic);
            for (IWorkItemHandle workItemHandle : this.selectedWorkItems) {
                this.subsetRule.addWorkItem(workItemHandle);
            }
            this.subsetRule.setIncludeChildren(this.isIncludeChildren);
            try {
                this.fResultSubset = client.processRule((IBuildSubsetRule)this.subsetRule, this.fBuildDefHandle, currentSubset, this.isIncludeImpacted);
                if (this.showSummary) {
                    IWorkItemCommon workItemClient = (IWorkItemCommon)this.repo.getClientLibrary(IWorkItemCommon.class);
                    List workItems = workItemClient.getAuditableCommon().resolveAuditables(this.subsetRule.getWorkItemHandles(), IWorkItem.SMALL_PROFILE, null);
                    for (IWorkItem workItem : workItems) {
                        this.subsetRule.addWorkItemSummary(String.valueOf(workItem.getId()) + ": " + workItem.getHTMLSummary().getPlainText());
                    }
                    String additionalText = (String)this.fResultSubset.getProperties().get("additionalSummaryText");
                    if (additionalText != null && !additionalText.isEmpty()) {
                        this.subsetRule.addAdditionalSummaryText(additionalText);
                    }
                }
            }
            catch (TeamRepositoryException e) {
                e.printStackTrace();
            }
        }
        return this.fResultSubset;
    }

    protected Control createDialogArea(Composite parent) {
        Composite parentComposite = (Composite)super.createDialogArea(parent);
        this.includeImpactedCheckbox = new Button(parentComposite, 32);
        this.includeImpactedCheckbox.setText(Messages.BuildSubsetWIDialog_LABEL_INSTRUCTION);
        GridDataFactory.fillDefaults().span(2, 1).indent(-1, 4).applyTo((Control)this.includeImpactedCheckbox);
        this.includeImpactedCheckbox.setSelection(Activator.getDefault().getDialogSettings().getBoolean(INCLUDE_IMPACTED));
        this.showSummaryCheckbox = new Button(parentComposite, 32);
        this.showSummaryCheckbox.setText(Messages.BuildSubsetRuleSelectionDialog_SHOW_SUMMARY);
        GridDataFactory.fillDefaults().span(2, 1).indent(-1, 4).applyTo((Control)this.showSummaryCheckbox);
        this.showSummaryCheckbox.setSelection(!Activator.getDefault().getDialogSettings().getBoolean(DO_NOT_SHOW_SUMMARY_SETTING));
        this.includeChildrenCheckbox = new Button(parentComposite, 32);
        this.includeChildrenCheckbox.setText(Messages.BuildSubsetRuleSelectionDialog_INCLUDE_CHILDREN);
        GridDataFactory.fillDefaults().span(2, 1).indent(-1, 4).applyTo((Control)this.includeChildrenCheckbox);
        this.includeChildrenCheckbox.setSelection(Activator.getDefault().getDialogSettings().getBoolean(INCLUDE_CHLDREN));
        return parentComposite;
    }

    public boolean getIsIncludeImpacted() {
        return this.isIncludeImpacted;
    }

    public IBuildSubsetRule getSubsetRule() {
        return this.subsetRule;
    }

    public void setDynamic(boolean dynamic) {
        this.isDynamic = dynamic;
    }

    public boolean isDynamic() {
        return this.isDynamic;
    }

    protected void computeResult() {
        this.showSummary = this.showSummaryCheckbox.getSelection();
        Activator.getDefault().getDialogSettings().put(DO_NOT_SHOW_SUMMARY_SETTING, !this.showSummary);
        this.isIncludeChildren = this.includeChildrenCheckbox.getSelection();
        Activator.getDefault().getDialogSettings().put(INCLUDE_CHLDREN, this.isIncludeChildren);
        this.isIncludeImpacted = this.includeImpactedCheckbox.getSelection();
        Activator.getDefault().getDialogSettings().put(INCLUDE_IMPACTED, this.isIncludeImpacted);
        super.computeResult();
    }

    public boolean isShowingSummary() {
        return this.showSummary;
    }
}

