/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.build.ui.subset;

import com.ibm.team.build.common.model.IBuildDefinition;
import com.ibm.team.build.internal.ui.BuildDefinitionLabelProvider;
import com.ibm.team.enterprise.build.client.buildablesubset.IBuildableSubsetClient;
import com.ibm.team.enterprise.build.ui.Activator;
import com.ibm.team.enterprise.build.ui.subset.BuildSubsetDeferredContentProvider;
import com.ibm.team.enterprise.build.ui.subset.FilteredBuildSubsetTree;
import com.ibm.team.enterprise.buildablesubset.common.model.ISubset;
import com.ibm.team.enterprise.buildablesubset.common.model.ISubsetHandle;
import com.ibm.team.enterprise.common.ui.util.BuildSubsetTreeItemTooltipSupport;
import com.ibm.team.enterprise.internal.build.ui.nls.Messages;
import com.ibm.team.foundation.common.text.XMLString;
import com.ibm.team.jface.tooltip.TooltipSupport;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.process.internal.common.ItemHandleAwareHashMap;
import com.ibm.team.process.internal.common.NLS;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.progress.PendingUpdateAdapter;
import org.eclipse.ui.progress.UIJob;

public class BuildSubsetSelectionDialog
extends ElementTreeSelectionDialog {
    private IStatus ERROR_STATUS;
    private IStatus OK_STATUS;
    private final ItemHandleAwareHashMap descriptionMap;
    protected final ITeamRepository repository;
    protected Text descriptionText;
    protected Button displayOnlyForBuildCheckbox;
    private final IBuildDefinition buildDefinition;
    private final boolean allowShowAllSubsets;
    private final ViewerFilter filter;
    protected FilteredBuildSubsetTree tree;
    protected Combo combo;

    public BuildSubsetSelectionDialog(Shell parent, ITeamRepository repository, IBuildDefinition buildDefinition, boolean allowShowAllSubsets, boolean allowMultiple) {
        this(parent, repository, buildDefinition, allowShowAllSubsets, allowMultiple, null);
    }

    public BuildSubsetSelectionDialog(Shell parent, ITeamRepository repository, IBuildDefinition buildDefinition, boolean allowShowAllSubsets, boolean allowMultiple, ViewerFilter filter) {
        super(parent, (ILabelProvider)new BuildSubsetLabelProvider(), (ITreeContentProvider)new BuildSubsetDeferredContentProvider(repository, buildDefinition));
        if (buildDefinition == null && !allowShowAllSubsets) {
            throw new IllegalArgumentException();
        }
        this.setTitle(Messages.BuildsubsetSelectionDialog_TITLE);
        this.setMessage(Messages.BuildsubsetSelectionDialog_DESCRIPTION);
        this.setAllowMultiple(allowMultiple);
        this.setValidator(this.getSelectionValidator());
        if (filter != null) {
            this.addFilter(filter);
        }
        this.descriptionMap = new ItemHandleAwareHashMap();
        this.repository = repository;
        this.buildDefinition = buildDefinition;
        this.allowShowAllSubsets = allowShowAllSubsets;
        this.filter = filter;
        if (buildDefinition == null) {
            this.setInput(repository);
        } else {
            this.setInput(new BuildDefinitionEntry(buildDefinition, null));
        }
    }

    protected ISelectionStatusValidator getSelectionValidator() {
        return new ISelectionStatusValidator(){

            public IStatus validate(Object[] selection) {
                boolean isAnySubsetSelected = false;
                if (selection != null) {
                    Object[] objectArray = selection;
                    int n = selection.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object o = objectArray[n2];
                        if (o instanceof ISubset) {
                            isAnySubsetSelected = true;
                            break;
                        }
                        ++n2;
                    }
                }
                IStatus status = null;
                if (!isAnySubsetSelected) {
                    if (BuildSubsetSelectionDialog.this.ERROR_STATUS == null) {
                        BuildSubsetSelectionDialog.this.ERROR_STATUS = (IStatus)new Status(4, "com.ibm.team.enterprise.build.ui", "");
                    }
                    status = BuildSubsetSelectionDialog.this.ERROR_STATUS;
                } else {
                    if (BuildSubsetSelectionDialog.this.OK_STATUS == null) {
                        BuildSubsetSelectionDialog.this.OK_STATUS = (IStatus)new Status(0, "com.ibm.team.enterprise.build.ui", "");
                    }
                    status = BuildSubsetSelectionDialog.this.OK_STATUS;
                }
                BuildSubsetSelectionDialog.this.updateDescription(selection, status);
                return status;
            }
        };
    }

    protected void computeResult() {
        ArrayList subsetHandles = new ArrayList();
        for (Object next : (IStructuredSelection)this.getTreeViewer().getSelection()) {
            if (!(next instanceof ISubset)) continue;
            subsetHandles.add(next);
        }
        this.setResult(subsetHandles);
    }

    public boolean close() {
        this.descriptionText.dispose();
        return super.close();
    }

    public String getResultSlug() {
        return this.getSelectedSubset().getLabel();
    }

    public ISubset getSelectedSubset() {
        Object[] result = this.getResult();
        return (ISubset)result[0];
    }

    public ISubset[] getSelectedSubsets() {
        Object[] result = this.getResult();
        ISubset[] subsets = new ISubset[result.length];
        System.arraycopy(result, 0, subsets, 0, result.length);
        return subsets;
    }

    protected void updateDescription(Object[] selection, IStatus status) {
        if (this.descriptionText == null || this.descriptionText.isDisposed()) {
            return;
        }
        if (selection == null || selection.length == 0) {
            this.descriptionText.setText("");
            return;
        }
        if (selection.length > 1) {
            this.descriptionText.setText(Messages.BuildsubsetSelectionDialog_MULTIPLE_SELECTED);
            return;
        }
        if (selection[0] instanceof Exception) {
            String desc = (String)this.descriptionMap.get(selection[0]);
            if (desc == null) {
                StringWriter writer = new StringWriter();
                ((Exception)selection[0]).printStackTrace(new PrintWriter(writer));
                desc = writer.toString();
                this.descriptionMap.put(selection[0], (Object)desc);
            }
            this.descriptionText.setText(desc);
            return;
        }
        if (!status.isOK() || !(selection[0] instanceof ISubset)) {
            this.descriptionText.setText("");
            return;
        }
        final ISubset handle = (ISubset)selection[0];
        String desc = (String)this.descriptionMap.get((Object)handle);
        if (desc != null) {
            this.descriptionText.setText(desc);
            return;
        }
        Job job = new Job(""){

            protected IStatus run(IProgressMonitor monitor) {
                IBuildableSubsetClient client = (IBuildableSubsetClient)BuildSubsetSelectionDialog.this.repository.getClientLibrary(IBuildableSubsetClient.class);
                try {
                    ISubset subset = client.getSubsetItem((ISubsetHandle)handle, BuildSubsetSelectionDialog.this.repository);
                    final String description = subset != null && subset.getDescription() != null && !subset.getDescription().trim().isEmpty() ? subset.getDescription() : Messages.BuildSubsetDialog_NO_DESCRIPTION;
                    BuildSubsetSelectionDialog.this.descriptionMap.put((Object)handle, (Object)description);
                    UIJob uiJob = new UIJob(""){

                        public IStatus runInUIThread(IProgressMonitor monitor) {
                            if (!(this).BuildSubsetSelectionDialog.this.descriptionText.isDisposed()) {
                                (this).BuildSubsetSelectionDialog.this.descriptionText.setText(description);
                            }
                            return Status.OK_STATUS;
                        }
                    };
                    uiJob.schedule();
                }
                catch (TeamRepositoryException e) {
                    Activator.log(e);
                }
                return Status.OK_STATUS;
            }
        };
        job.schedule();
    }

    protected Label createMessageArea(Composite composite) {
        Label label = new Label(composite, 64);
        if (this.getMessage() != null) {
            label.setText(this.getMessage());
        }
        label.setFont(composite.getFont());
        GridData data = new GridData(4, 0x1000000, true, false);
        label.setLayoutData((Object)data);
        if (this.allowShowAllSubsets) {
            int filteredIndex;
            int buildDefIndex;
            int nextIndex = 0;
            ArrayList<String> items = new ArrayList<String>();
            if (this.buildDefinition != null) {
                buildDefIndex = nextIndex++;
                items.add(NLS.bind((String)Messages.BuildsubsetSelectionDialog_SHOW_FOR_SINGLE_BUILD, (Object)this.buildDefinition.getId()));
            } else {
                buildDefIndex = -1;
            }
            boolean displayFilteredOption = false;
            List rawProjectAreas = this.repository.itemManager().getKnownSharedItems(IProjectArea.ITEM_TYPE);
            for (Object pa : rawProjectAreas) {
                if (!(pa instanceof IProjectAreaHandle) || !Activator.getDefault().getPreferenceStore().getBoolean("team.enterprise.build.subsets.filtered.enabled." + ((IProjectAreaHandle)pa).getItemId().getUuidValue())) continue;
                displayFilteredOption = true;
                break;
            }
            if (displayFilteredOption) {
                filteredIndex = nextIndex++;
                items.add(Messages.BuildsubsetSelectionDialog_SHOW_FOR_FILTERED_BUILDS);
            } else {
                filteredIndex = -2;
            }
            items.add(Messages.BuildsubsetSelectionDialog_SHOW_FOR_ALL_BUILDS);
            if (items.size() > 1) {
                this.combo = new Combo(composite, 12);
                this.combo.setItems(items.toArray(new String[items.size()]));
                this.combo.select(0);
                this.combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        int index = BuildSubsetSelectionDialog.this.combo.getSelectionIndex();
                        if (index == buildDefIndex) {
                            ((BuildSubsetDeferredContentProvider)BuildSubsetSelectionDialog.this.getTreeViewer().getContentProvider()).setDisplayType(0);
                            BuildSubsetSelectionDialog.this.getTreeViewer().setInput((Object)new BuildDefinitionEntry(BuildSubsetSelectionDialog.this.buildDefinition, null));
                        } else if (index == filteredIndex) {
                            ((BuildSubsetDeferredContentProvider)BuildSubsetSelectionDialog.this.getTreeViewer().getContentProvider()).setDisplayType(1);
                            BuildSubsetSelectionDialog.this.getTreeViewer().setInput((Object)BuildSubsetSelectionDialog.this.repository);
                        } else {
                            ((BuildSubsetDeferredContentProvider)BuildSubsetSelectionDialog.this.getTreeViewer().getContentProvider()).setDisplayType(2);
                            BuildSubsetSelectionDialog.this.getTreeViewer().setInput((Object)BuildSubsetSelectionDialog.this.repository);
                        }
                    }
                });
                this.combo.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            }
        }
        return label;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        this.createAdditionalDialogContents(composite);
        if (this.buildDefinition == null) {
            if (this.combo == null || this.combo.getItemCount() == 1) {
                ((BuildSubsetDeferredContentProvider)this.getTreeViewer().getContentProvider()).setDisplayType(2);
            } else {
                ((BuildSubsetDeferredContentProvider)this.getTreeViewer().getContentProvider()).setDisplayType(1);
            }
        }
        this.tree.getFilterControl().setFocus();
        return composite;
    }

    protected void createAdditionalDialogContents(Composite composite) {
        Label label = new Label(composite, 0);
        label.setText(Messages.BuildableSubsetSelectionDialog_DESCRIPTION);
        this.descriptionText = new Text(composite, 2634);
        GridData data = new GridData(768);
        data.heightHint = this.descriptionText.getLineHeight() * 2;
        this.descriptionText.setLayoutData((Object)data);
        new TooltipSupport((Control)this.descriptionText, false, false){

            protected String getMarkup(Object element, boolean isFocus) {
                return XMLString.createFromPlainText((String)BuildSubsetSelectionDialog.this.descriptionText.getText()).getXMLText();
            }

            public Object getElement(Control control, int x, int y) {
                return BuildSubsetSelectionDialog.this.descriptionText;
            }
        };
    }

    protected TreeViewer doCreateTreeViewer(Composite parent, int style) {
        this.tree = new FilteredBuildSubsetTree(parent, style, true, this.filter);
        this.tree.setLayoutData(new GridData(1808));
        BuildSubsetSelectionDialog.applyDialogFont((Control)this.tree);
        new BuildSubsetTreeItemTooltipSupport(this.tree.getViewer());
        return this.tree.getViewer();
    }

    public static class BuildDefinitionEntry {
        IBuildDefinition buildDefinition;
        IProjectArea projectArea;

        public BuildDefinitionEntry(IBuildDefinition buildDefinition, IProjectArea projectArea) {
            this.buildDefinition = buildDefinition;
            this.projectArea = projectArea;
        }
    }

    private static class BuildSubsetLabelProvider
    extends LabelProvider {
        private final BuildDefinitionLabelProvider buildDefProvider = new BuildDefinitionLabelProvider(false);

        private BuildSubsetLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof ISubset) {
                ISubset handle = (ISubset)element;
                return handle.getLabel();
            }
            if (element instanceof BuildDefinitionEntry) {
                BuildDefinitionEntry entry = (BuildDefinitionEntry)element;
                String label = this.buildDefProvider.getText((Object)entry.buildDefinition);
                if (entry.projectArea != null) {
                    label = String.valueOf(label) + " [" + entry.projectArea.getName() + "]";
                }
                return label;
            }
            if (element instanceof PendingUpdateAdapter) {
                return ((PendingUpdateAdapter)element).getLabel(element);
            }
            if (element instanceof Exception) {
                return NLS.bind((String)Messages.BuildSubsetFiltersDialog_ERROR_OCCURRED, (Object)((Exception)element).toString());
            }
            return element == null ? "" : element.toString();
        }

        public Image getImage(Object element) {
            if (element instanceof ISubset) {
                return Activator.getImage("icons/obj16/buildsubset.gif");
            }
            if (element instanceof BuildDefinitionEntry) {
                return this.buildDefProvider.getImage((Object)((BuildDefinitionEntry)element).buildDefinition);
            }
            return null;
        }
    }
}

