/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.build.ui.subset;

import com.ibm.team.build.common.model.IBuildDefinition;
import com.ibm.team.build.common.model.IBuildDefinitionHandle;
import com.ibm.team.build.internal.ui.jobs.TeamBuildJob;
import com.ibm.team.enterprise.build.client.buildablesubset.IBuildableSubsetClient;
import com.ibm.team.enterprise.build.common.IBuildUtility;
import com.ibm.team.enterprise.build.ui.Activator;
import com.ibm.team.enterprise.buildablesubset.common.IBuildSubsetRule;
import com.ibm.team.enterprise.buildablesubset.common.IDefaultBuildSubsetRule;
import com.ibm.team.enterprise.buildablesubset.common.impl.DefaultBuildSubsetRule;
import com.ibm.team.enterprise.buildablesubset.common.model.ISubset;
import com.ibm.team.enterprise.internal.build.ui.nls.Messages;
import com.ibm.team.enterprise.systemdefinition.client.ClientFactory;
import com.ibm.team.enterprise.systemdefinition.client.ISystemDefinitionModelClient;
import com.ibm.team.enterprise.systemdefinition.common.model.IIBMiLanguageDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.IIBMiPlatformObject;
import com.ibm.team.enterprise.systemdefinition.common.model.ILanguageDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.ISystemDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.IZosLanguageDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.IZosPlatformObject;
import com.ibm.team.jface.util.UIUpdaterJob;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.client.IItemManager;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.IWorkspaceManager;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IWorkspaceHandle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.SelectionStatusDialog;

public class BuildSubsetRuleSelectionDialog
extends SelectionStatusDialog {
    private ITeamRepository fTeamRepository;
    private IWorkspaceHandle fWorkspaceHandle;
    private Button componentButton;
    private Button langDefButton;
    private Button nameButton;
    private Combo componentCombo;
    private Combo langDefCombo;
    private Text nameText;
    private Button showSummaryCheckbox;
    private boolean showSummary = true;
    private static final String DO_NOT_SHOW_SUMMARY_SETTING = "doNotShowSummarySetting_AddRule";
    private SelectionListener buttonSelectionListener = null;
    private SelectionListener comboSelectionListener = null;
    private IComponentHandle[] componentData = null;
    private String[] langDefData = null;
    private IBuildDefinitionHandle fBuildDefHandle = null;
    private IDefaultBuildSubsetRule subsetRule;
    private ISubset fResultSubset;

    public BuildSubsetRuleSelectionDialog(Shell parent, ITeamRepository repo, IWorkspaceHandle wsHandle, IBuildDefinitionHandle buildDefHandle) {
        super(parent);
        this.fTeamRepository = repo;
        this.fWorkspaceHandle = wsHandle;
        this.fBuildDefHandle = buildDefHandle;
        this.setTitle(Messages.BuildSubsetRuleDialog_TITLE);
    }

    protected Control createDialogArea(Composite parent) {
        Composite mainComposite = (Composite)super.createDialogArea(parent);
        GridLayoutFactory.fillDefaults().numColumns(2).margins(5, 5).applyTo(mainComposite);
        this.createSelectionWidgets(mainComposite);
        this.validate();
        return mainComposite;
    }

    private void createSelectionWidgets(Composite composite) {
        Label instructionLabel = new Label(composite, 0);
        instructionLabel.setText(Messages.BuildSubsetRuleDialog_LABEL_INSTRUCTION);
        GridDataFactory.fillDefaults().span(2, 1).applyTo((Control)instructionLabel);
        this.componentButton = new Button(composite, 32);
        this.componentButton.setText(Messages.BuildSubsetRuleDialog_BUTTON_COMPONENT);
        this.componentButton.addSelectionListener(this.getButtonSelectionListener());
        this.componentCombo = new Combo(composite, 0x800808);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.componentCombo);
        this.componentCombo.setEnabled(this.componentButton.getSelection());
        this.componentCombo.addSelectionListener(this.getComboSelectionListener());
        this.initializeComponentCombo();
        this.langDefButton = new Button(composite, 32);
        this.langDefButton.setText(Messages.BuildSubsetRuleDialog_BUTTON_LANGDEF);
        this.langDefButton.addSelectionListener(this.getButtonSelectionListener());
        this.langDefCombo = new Combo(composite, 0x800808);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.langDefCombo);
        this.langDefCombo.setEnabled(this.langDefButton.getSelection());
        this.langDefCombo.addSelectionListener(this.getComboSelectionListener());
        this.initializeLanguageDefinitionCombo();
        this.nameButton = new Button(composite, 32);
        this.nameButton.setText(Messages.BuildSubsetRuleDialog_BUTTON_NAME);
        this.nameButton.addSelectionListener(this.getButtonSelectionListener());
        this.nameText = new Text(composite, 2048);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.nameText);
        this.nameText.setEnabled(this.nameButton.getSelection());
        this.nameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                BuildSubsetRuleSelectionDialog.this.validate();
            }
        });
        Label label = new Label(composite, 16384);
        label = new Label(composite, 16384);
        label.setText(Messages.BuildSubsetRuleSelectionDialog_PATTERN_LABEL);
        this.showSummaryCheckbox = new Button(composite, 32);
        this.showSummaryCheckbox.setText(Messages.BuildSubsetRuleSelectionDialog_SHOW_SUMMARY);
        GridDataFactory.fillDefaults().span(2, 1).grab(true, false).applyTo((Control)this.showSummaryCheckbox);
        this.showSummaryCheckbox.setSelection(!Activator.getDefault().getDialogSettings().getBoolean(DO_NOT_SHOW_SUMMARY_SETTING));
    }

    private void initializeComponentCombo() {
        new UIUpdaterJob(""){
            List componentList;
            IItemManager itemManager;

            public IStatus runInBackground(IProgressMonitor monitor) {
                this.itemManager = BuildSubsetRuleSelectionDialog.this.fTeamRepository.itemManager();
                IWorkspaceManager wsManager = SCMPlatform.getWorkspaceManager((ITeamRepository)BuildSubsetRuleSelectionDialog.this.fTeamRepository);
                try {
                    IWorkspaceConnection wsConnection = wsManager.getWorkspaceConnection(BuildSubsetRuleSelectionDialog.this.fWorkspaceHandle, null);
                    this.componentList = wsConnection.getComponents();
                    BuildSubsetRuleSelectionDialog.this.componentData = this.componentList.toArray(new IComponentHandle[this.componentList.size()]);
                }
                catch (TeamRepositoryException e) {
                    e.printStackTrace();
                }
                return Status.OK_STATUS;
            }

            public IStatus runInUI(IProgressMonitor monitor) {
                try {
                    List components = this.itemManager.fetchPartialItems(this.componentList, 0, Arrays.asList(IComponent.NAME_PROPERTY), monitor);
                    Collections.sort(components, new Comparator(){

                        public int compare(Object o1, Object o2) {
                            IComponent component1 = (IComponent)o1;
                            IComponent component2 = (IComponent)o2;
                            return component1.getName().compareTo(component2.getName());
                        }
                    });
                    int i = 0;
                    for (Object component : components) {
                        BuildSubsetRuleSelectionDialog.this.componentCombo.add(((IComponent)component).getName());
                        ((BuildSubsetRuleSelectionDialog)BuildSubsetRuleSelectionDialog.this).componentData[i++] = (IComponentHandle)IComponent.ITEM_TYPE.createItemHandle(((IComponent)component).getItemId(), null);
                    }
                }
                catch (TeamRepositoryException e) {
                    e.printStackTrace();
                }
                return Status.OK_STATUS;
            }
        }.schedule();
    }

    private void initializeLanguageDefinitionCombo() {
        final ISystemDefinitionModelClient client = ClientFactory.getSystemDefinitionModelClient((ITeamRepository)this.fTeamRepository);
        final ArrayList comboContents = new ArrayList();
        this.langDefCombo.setEnabled(false);
        TeamBuildJob initializeLangDefJob = new TeamBuildJob("", false, this.fTeamRepository){

            protected IStatus runProtected(IProgressMonitor monitor) throws Exception {
                try {
                    try {
                        Class<IZosPlatformObject> platform = IZosPlatformObject.class;
                        if (IBuildUtility.isIBMiDependencyBuild((IBuildDefinition)((IBuildDefinition)BuildSubsetRuleSelectionDialog.this.fBuildDefHandle))) {
                            platform = IIBMiPlatformObject.class;
                        }
                        ArrayList<String> langDefUUIDs = new ArrayList<String>();
                        List fProjectAreas = BuildSubsetRuleSelectionDialog.this.getProjectAreas(BuildSubsetRuleSelectionDialog.this.fTeamRepository);
                        for (IProjectArea p : fProjectAreas) {
                            String projectAreaName = p.getName();
                            List languageDefinitionHandles = IBuildUtility.isIBMiDependencyBuild((IBuildDefinition)((IBuildDefinition)BuildSubsetRuleSelectionDialog.this.fBuildDefHandle)) ? client.findSystemDefinitions(IIBMiLanguageDefinition.ITEM_TYPE, (IProjectAreaHandle)p, -1, false, Arrays.asList(ILanguageDefinition.SMALL_PROFILE), monitor) : client.findSystemDefinitions(IZosLanguageDefinition.ITEM_TYPE, (IProjectAreaHandle)p, -1, false, Arrays.asList(ILanguageDefinition.SMALL_PROFILE), monitor);
                            for (ISystemDefinition handle : languageDefinitionHandles) {
                                String langDefName = handle.getName();
                                langDefUUIDs.add(handle.getItemId().getUuidValue());
                                comboContents.add(String.valueOf(langDefName) + " (" + projectAreaName + ")");
                            }
                        }
                        BuildSubsetRuleSelectionDialog.this.langDefData = langDefUUIDs.toArray(new String[langDefUUIDs.size()]);
                    }
                    catch (TeamRepositoryException e) {
                        e.printStackTrace();
                        monitor.done();
                    }
                }
                finally {
                    monitor.done();
                }
                return Status.OK_STATUS;
            }

            protected void jobFinished(IStatus status) {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        for (String s : comboContents) {
                            BuildSubsetRuleSelectionDialog.this.langDefCombo.add(s);
                        }
                        BuildSubsetRuleSelectionDialog.this.langDefCombo.setEnabled(BuildSubsetRuleSelectionDialog.this.langDefButton.getSelection());
                    }
                });
            }
        };
        initializeLangDefJob.schedule();
    }

    private List<IProjectArea> getProjectAreas(ITeamRepository repo) {
        ArrayList<IProjectArea> projectAreas = new ArrayList<IProjectArea>();
        List rawProjectAreas = new ArrayList();
        try {
            rawProjectAreas = repo.itemManager().fetchCompleteItems(this.fTeamRepository.itemManager().getKnownSharedItems(IProjectArea.ITEM_TYPE), 2, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (TeamRepositoryException e) {
            e.printStackTrace();
        }
        for (IProjectArea p : rawProjectAreas) {
            if (p == null) continue;
            projectAreas.add(p);
        }
        return projectAreas;
    }

    private SelectionListener getButtonSelectionListener() {
        if (this.buttonSelectionListener == null) {
            this.buttonSelectionListener = new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                }

                public void widgetSelected(SelectionEvent e) {
                    Object sourceObject = e.getSource();
                    if (sourceObject == BuildSubsetRuleSelectionDialog.this.componentButton) {
                        BuildSubsetRuleSelectionDialog.this.componentCombo.setEnabled(BuildSubsetRuleSelectionDialog.this.componentButton.getSelection());
                    } else if (sourceObject == BuildSubsetRuleSelectionDialog.this.langDefButton) {
                        BuildSubsetRuleSelectionDialog.this.langDefCombo.setEnabled(BuildSubsetRuleSelectionDialog.this.langDefButton.getSelection());
                    } else if (sourceObject == BuildSubsetRuleSelectionDialog.this.nameButton) {
                        BuildSubsetRuleSelectionDialog.this.nameText.setEnabled(BuildSubsetRuleSelectionDialog.this.nameButton.getSelection());
                    }
                    BuildSubsetRuleSelectionDialog.this.validate();
                }
            };
        }
        return this.buttonSelectionListener;
    }

    private SelectionListener getComboSelectionListener() {
        if (this.comboSelectionListener == null) {
            this.comboSelectionListener = new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                }

                public void widgetSelected(SelectionEvent e) {
                    BuildSubsetRuleSelectionDialog.this.validate();
                }
            };
        }
        return this.comboSelectionListener;
    }

    protected void computeResult() {
        this.showSummary = this.showSummaryCheckbox.getSelection();
        Activator.getDefault().getDialogSettings().put(DO_NOT_SHOW_SUMMARY_SETTING, !this.showSummary);
        this.subsetRule = new DefaultBuildSubsetRule();
        if (this.componentButton.getSelection()) {
            int componentIndex = this.componentCombo.getSelectionIndex();
            IComponentHandle selectedComponentHandle = this.componentData[componentIndex];
            this.subsetRule.setComponentHandle(selectedComponentHandle);
            this.subsetRule.setComponentName(this.componentCombo.getText());
        }
        if (this.langDefButton.getSelection()) {
            int languageDefinitionIndex = this.langDefCombo.getSelectionIndex();
            this.subsetRule.setLanguageDefinitionId(UUID.valueOf((String)this.langDefData[languageDefinitionIndex]));
            this.subsetRule.setLanguageDefinitionName(this.langDefCombo.getText());
        }
        if (this.nameButton.getSelection()) {
            String specifiedName = this.nameText.getText();
            this.subsetRule.setNamePattern(specifiedName);
        }
    }

    public IBuildSubsetRule getSubsetRule() {
        return this.subsetRule;
    }

    private void validate() {
        String errorString = null;
        String EMPTY_STRING = "";
        Status status = new Status(0, "com.ibm.team.enterprise.build.ui", "");
        boolean isComponentSelected = this.componentButton.getSelection();
        boolean isNameSelected = this.nameButton.getSelection();
        boolean isLangDefSelected = this.langDefButton.getSelection();
        if (!(isComponentSelected || isLangDefSelected || isNameSelected)) {
            errorString = Messages.BuildSubsetRuleDialog_ERROR_NORULE;
        } else if (isComponentSelected && this.componentCombo.getText().equalsIgnoreCase(EMPTY_STRING)) {
            errorString = Messages.BuildSubsetRuleDialog_ERROR_NOCOMPONENT;
        } else if (isNameSelected && this.nameText.getText().equalsIgnoreCase(EMPTY_STRING)) {
            errorString = Messages.BuildSubsetRuleDialog_ERROR_NONAME;
        } else if (isLangDefSelected && this.langDefCombo.getText().equalsIgnoreCase(EMPTY_STRING)) {
            errorString = Messages.BuildSubsetRuleDialog_ERROR_NOLANGDEF;
        }
        if (errorString != null) {
            status = new Status(4, "com.ibm.team.enterprise.build.ui", errorString);
        }
        this.updateStatus((IStatus)status);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setMinimumSize(450, -1);
    }

    public boolean isShowingSummary() {
        return this.showSummary;
    }

    public Object[] getResult() {
        Object[] results = super.getResult();
        if (results == null) {
            return new Object[0];
        }
        return results;
    }

    public ISubset getResultSubset(ISubset currentSubset) {
        if (this.fResultSubset != null) {
            return this.fResultSubset;
        }
        if (this.subsetRule != null && this.fBuildDefHandle != null) {
            try {
                IBuildableSubsetClient client = com.ibm.team.enterprise.build.client.buildablesubset.ClientFactory.getBuildableSubsetClient((ITeamRepository)this.fTeamRepository);
                this.fResultSubset = client.processRule((IBuildSubsetRule)this.subsetRule, this.fBuildDefHandle, currentSubset);
            }
            catch (TeamRepositoryException e) {
                e.printStackTrace();
            }
        }
        return this.fResultSubset;
    }
}

