/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.build.ui.subset;

import com.ibm.team.enterprise.build.client.buildablesubset.IBuildableSubsetClient;
import com.ibm.team.enterprise.build.ui.Activator;
import com.ibm.team.enterprise.build.ui.subset.BuildSubsetsNode;
import com.ibm.team.enterprise.build.ui.subset.EditSubsetActionDelegate;
import com.ibm.team.enterprise.build.ui.subset.SubsetDomainActionHelper;
import com.ibm.team.enterprise.buildablesubset.common.model.ISubset;
import com.ibm.team.enterprise.common.ui.IEnterpriseExtensionsNode;
import com.ibm.team.enterprise.common.ui.IEnterpriseFavoritesItem;
import com.ibm.team.enterprise.common.ui.domain.AbstractEnterpriseExtensionsNode;
import com.ibm.team.process.rcp.ui.teamnavigator.DomainSubtreeRoot;
import com.ibm.team.repository.common.IItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IWorkbenchPartSite;

public class BuildSubsetNode
extends AbstractEnterpriseExtensionsNode
implements IEnterpriseFavoritesItem {
    IBuildableSubsetClient client = null;
    private ISubset fSubset = null;

    public BuildSubsetNode(ISubset subset, DomainSubtreeRoot domainSubtreeRoot, BuildSubsetsNode buildSubsetsNode) {
        this.fSubset = subset;
        this.setDomainSubtreeRoot(domainSubtreeRoot);
        this.setParent((IEnterpriseExtensionsNode)buildSubsetsNode);
    }

    public void contributeContextMenuActions(IMenuManager manager, IStructuredSelection selection) {
        if (selection.isEmpty()) {
            return;
        }
        SubsetDomainActionHelper actionHelper = new SubsetDomainActionHelper(manager, selection, this.getDomainSubtreeRoot().getDomain().getWorkbenchPart().getSite());
        actionHelper.contributeActions();
        super.contributeContextMenuActions(manager, selection);
    }

    public boolean hasChildren() {
        return false;
    }

    public Image getIcon() {
        return Activator.getImage("icons/obj16/buildsubset.gif");
    }

    public String getLabel() {
        if (this.fSubset != null) {
            return this.fSubset.getLabel();
        }
        return null;
    }

    public ISubset getBuildableSubset() {
        return this.fSubset;
    }

    public void setBuildableSubset(ISubset subset) {
        this.fSubset = subset;
    }

    public boolean open(IWorkbenchPartSite site, IStructuredSelection selection) {
        if (selection.size() != 1) {
            return false;
        }
        Object element = selection.getFirstElement();
        if (element instanceof BuildSubsetNode) {
            BuildSubsetNode node = (BuildSubsetNode)((Object)element);
            EditSubsetActionDelegate.run(node, this.getTeamRepository(), node.getProjectAreaHandle(), site.getPage());
            return true;
        }
        return false;
    }

    public IItem getItem() {
        return this.fSubset;
    }

    public void setLabel(String label) {
        this.fSubset.setLabel(label);
    }

    public String getItemDescription() {
        return this.fSubset.getLabel();
    }

    public String getItemName() {
        return this.fSubset.getLabel();
    }

    public String getItemReferenceType() {
        return ISubset.class.getName();
    }
}

