/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.build.ui.subset;

import com.ibm.team.build.common.model.IBuildDefinition;
import com.ibm.team.build.common.model.IBuildDefinitionHandle;
import com.ibm.team.build.internal.ui.BuildDefinitionLabelProvider;
import com.ibm.team.build.internal.ui.dialogs.definitions.BuildDefinitionDialogMessages;
import com.ibm.team.enterprise.build.common.IBuildUtility;
import com.ibm.team.enterprise.build.ui.Activator;
import com.ibm.team.enterprise.build.ui.subset.BuildableSubsetUtils;
import com.ibm.team.enterprise.internal.build.ui.nls.Messages;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.process.internal.common.NLS;
import com.ibm.team.repository.client.ITeamRepository;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ListSelectionDialog;
import org.eclipse.ui.progress.PendingUpdateAdapter;
import org.eclipse.ui.progress.UIJob;

public class BuildSubsetFiltersDialog
extends ListSelectionDialog {
    private Button filterEnabledCheckbox;
    private boolean filterEnabled;
    private IProjectAreaHandle projectArea;
    private Job fetchJob;

    public BuildSubsetFiltersDialog(Shell parentShell, IProjectAreaHandle projectArea) {
        super(parentShell, (Object)projectArea, (IStructuredContentProvider)new SubsetFiltersContentProvider(), (ILabelProvider)new SubsetFiltersLabelProvider(), "");
        this.setTitle(Messages.BuildSubsetFiltersDialog_TITLE);
        this.filterEnabled = Activator.getDefault().getPreferenceStore().getBoolean("team.enterprise.build.subsets.filtered.enabled." + projectArea.getItemId().getUuidValue());
        this.projectArea = projectArea;
        this.fetchJob = this.createFetchBuildDefinitionsJob();
    }

    public Object[] getResult() {
        Object[] result = super.getResult();
        if (result != null && result.length > 0 && !(result[0] instanceof IBuildDefinition)) {
            return null;
        }
        return result;
    }

    protected void okPressed() {
        Object[] children = ((IStructuredContentProvider)this.getViewer().getContentProvider()).getElements(this.getViewer().getInput());
        ArrayList<Object> checked = null;
        if (children != null && children.length > 0 && children[0] instanceof IBuildDefinition) {
            checked = new ArrayList<Object>(children.length);
            int i = 0;
            while (i < children.length) {
                Object element = children[i];
                if (this.getViewer().getChecked(element)) {
                    checked.add(element);
                }
                ++i;
            }
        }
        super.okPressed();
        this.setResult(checked);
    }

    protected Job createFetchBuildDefinitionsJob() {
        return new Job(BuildDefinitionDialogMessages.FetchBuildDefinitionStatusRecordsJob_0){
            private boolean canceled;

            protected IStatus run(IProgressMonitor monitor) {
                Object[] newInput = null;
                try {
                    ArrayList<IBuildDefinition> buildDefs = new ArrayList<IBuildDefinition>();
                    ArrayList<IBuildDefinition> initialSelections = new ArrayList<IBuildDefinition>();
                    String savedFilterList = Activator.getDefault().getPreferenceStore().getString("team.enterprise.build.subsets.filtered.list." + BuildSubsetFiltersDialog.this.projectArea.getItemId().getUuidValue());
                    List<String> defsToSelect = savedFilterList.isEmpty() ? null : Arrays.asList(savedFilterList.split(","));
                    ITeamRepository repository = (ITeamRepository)BuildSubsetFiltersDialog.this.projectArea.getOrigin();
                    List<IBuildDefinitionHandle> handles = BuildableSubsetUtils.getBuildDefinitions(BuildSubsetFiltersDialog.this.projectArea);
                    if (this.canceled) {
                        throw new OperationCanceledException();
                    }
                    List defs = repository.itemManager().fetchPartialItems(handles, 0, Arrays.asList(IBuildDefinition.PROPERTY_CONFIGURATION_ELEMENTS, IBuildDefinition.PROPERTY_ID), monitor);
                    if (this.canceled) {
                        throw new OperationCanceledException();
                    }
                    for (Object def : defs) {
                        IBuildDefinition bd = (IBuildDefinition)def;
                        if (!IBuildUtility.isDependencyBuild((IBuildDefinition)bd) && !IBuildUtility.isOldDependencyBuild((IBuildDefinition)bd)) continue;
                        buildDefs.add(bd);
                        if (defsToSelect != null && !defsToSelect.contains(bd.getItemId().getUuidValue())) continue;
                        initialSelections.add(bd);
                    }
                    if (this.canceled) {
                        throw new OperationCanceledException();
                    }
                    newInput = buildDefs.toArray();
                    BuildSubsetFiltersDialog.this.setInitialElementSelections(initialSelections);
                }
                catch (OperationCanceledException e) {
                    throw e;
                }
                catch (Exception e) {
                    Activator.getDefault().logError((Throwable)e);
                    newInput = e;
                }
                if (newInput != null) {
                    final Object[] finalInput = newInput;
                    new UIJob(BuildDefinitionDialogMessages.FetchBuildDefinitionStatusRecordsJob_0){

                        public IStatus runInUIThread(IProgressMonitor monitor) {
                            if (!BuildSubsetFiltersDialog.this.getShell().isDisposed() && !canceled) {
                                BuildSubsetFiltersDialog.this.getViewer().setInput(finalInput);
                                if (!BuildSubsetFiltersDialog.this.getInitialElementSelections().isEmpty()) {
                                    BuildSubsetFiltersDialog.this.getViewer().setCheckedElements(BuildSubsetFiltersDialog.this.getInitialElementSelections().toArray());
                                }
                                if (!(finalInput instanceof Exception)) {
                                    BuildSubsetFiltersDialog.this.updateTableEnablement(BuildSubsetFiltersDialog.this.filterEnabled);
                                }
                            }
                            return Status.OK_STATUS;
                        }
                    }.schedule();
                }
                return Status.OK_STATUS;
            }

            protected void canceling() {
                this.canceled = true;
            }
        };
    }

    public int open() {
        this.fetchJob.schedule();
        return super.open();
    }

    public boolean close() {
        this.fetchJob.cancel();
        this.filterEnabledCheckbox.dispose();
        return super.close();
    }

    protected Control createDialogArea(Composite parent) {
        if (this.getContextHelpId() != null) {
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, this.getContextHelpId());
        }
        Control control = super.createDialogArea(parent);
        this.updateTableEnablement(false);
        this.getViewer().setComparator(new ViewerComparator());
        return control;
    }

    protected String getContextHelpId() {
        return "com.ibm.team.build.ui.dialog_subset_filters";
    }

    protected Label createMessageArea(Composite composite) {
        this.filterEnabledCheckbox = new Button(composite, 32);
        this.filterEnabledCheckbox.setText(Messages.BuildSubsetFiltersDialog_BUILDDEF_CHECKBOX);
        this.filterEnabledCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BuildSubsetFiltersDialog.this.filterEnabled = BuildSubsetFiltersDialog.this.filterEnabledCheckbox.getSelection();
                BuildSubsetFiltersDialog.this.updateTableEnablement(BuildSubsetFiltersDialog.this.filterEnabled);
            }
        });
        this.filterEnabledCheckbox.setSelection(this.filterEnabled);
        return null;
    }

    protected void updateTableEnablement(boolean enabled) {
        this.getViewer().getTable().setEnabled(enabled);
        this.getButton(18).setEnabled(enabled);
        this.getButton(19).setEnabled(enabled);
    }

    public boolean isFilterEnabled() {
        return this.filterEnabled;
    }

    private static class SubsetFiltersContentProvider
    implements IStructuredContentProvider {
        private SubsetFiltersContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof IProjectAreaHandle) {
                return new Object[]{new PendingUpdateAdapter()};
            }
            if (inputElement instanceof Object[]) {
                return (Object[])inputElement;
            }
            if (inputElement instanceof Exception) {
                return new Object[]{inputElement};
            }
            return new Object[0];
        }
    }

    private static class SubsetFiltersLabelProvider
    extends LabelProvider {
        private BuildDefinitionLabelProvider buildDefProvider = new BuildDefinitionLabelProvider(false);

        private SubsetFiltersLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof PendingUpdateAdapter) {
                return ((PendingUpdateAdapter)element).getLabel(element);
            }
            if (element instanceof Exception) {
                return NLS.bind((String)Messages.BuildSubsetFiltersDialog_ERROR_OCCURRED, (Object)((Exception)element).toString());
            }
            return this.buildDefProvider.getText(element);
        }

        public Image getImage(Object element) {
            return this.buildDefProvider.getImage(element);
        }
    }
}

