/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.build.ui.subset;

import com.ibm.team.build.common.model.IBuildDefinition;
import com.ibm.team.build.common.model.IBuildDefinitionHandle;
import com.ibm.team.build.common.model.IBuildProperty;
import com.ibm.team.enterprise.build.common.DependencyBuildPropertyFactory;
import com.ibm.team.enterprise.build.ui.subset.BuildableSubsetContentProvider2;
import com.ibm.team.enterprise.build.ui.subset.BuildableSubsetLabelProvider2;
import com.ibm.team.enterprise.buildablesubset.common.internal.model.ModelFactory;
import com.ibm.team.enterprise.buildablesubset.common.internal.model.SubsetFileDesc;
import com.ibm.team.enterprise.buildablesubset.common.util.BuildableSubsetUtil;
import com.ibm.team.enterprise.common.ui.util.BuildSubsetTreeItemTooltipSupport;
import com.ibm.team.enterprise.internal.build.ui.nls.Messages;
import com.ibm.team.enterprise.internal.build.ui.utils.BuildUtils;
import com.ibm.team.filesystem.common.IFileItem;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.client.IConfiguration;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IFolder;
import com.ibm.team.scm.common.IFolderHandle;
import com.ibm.team.scm.common.IVersionable;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.IWorkspaceHandle;
import com.ibm.team.scm.common.dto.IAncestorReport;
import com.ibm.team.scm.common.dto.INameItemPair;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ITreeViewerListener;
import org.eclipse.jface.viewers.TreeExpansionEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.CheckedTreeSelectionDialog;
import org.eclipse.ui.progress.IElementCollector;

public class BuildSubsetFileSelectionDialog
extends CheckedTreeSelectionDialog {
    private ITeamRepository repository;
    private IBuildDefinitionHandle buildDefinitionHandle;
    private IWorkspace streamAssociatedWithBuildDefinition;
    private Set<String> expandedFolders;
    private Set<String> expandedComponents;
    private BuildableSubsetContentProvider2 fContentProvider = null;
    List<IAncestorReport> ancestorReports;

    public BuildSubsetFileSelectionDialog(Shell parent, ITeamRepository repository, IBuildDefinitionHandle buildDefinitionHandle) {
        super(parent, (ILabelProvider)new BuildableSubsetLabelProvider2(), (ITreeContentProvider)new BuildableSubsetContentProvider2(repository));
        this.setTitle(Messages.BuildableSubsetSelectionDialog_DIALOG_TITLE);
        this.setMessage(Messages.BuildableSubsetSelectionDialog_DIALOG_DESCRIPTION);
        this.expandedFolders = new HashSet<String>();
        this.expandedComponents = new HashSet<String>();
        this.setContainerMode(true);
        this.repository = repository;
        this.buildDefinitionHandle = buildDefinitionHandle;
        this.setInput(new String[]{Messages.BuildableSubsetSelectionDialog_PENDING});
    }

    private void getStreamFromBuildDefinition(final IProgressMonitor monitor) {
        try {
            Thread thread = new Thread(){

                @Override
                public void run() {
                    try {
                        IBuildDefinition buildDef = (IBuildDefinition)BuildSubsetFileSelectionDialog.this.repository.itemManager().fetchCompleteItem((IItemHandle)BuildSubsetFileSelectionDialog.this.buildDefinitionHandle, 0, monitor);
                        String wsPropertyId = DependencyBuildPropertyFactory.getInstance().resolvePropertyId("teamz.scm.workspaceUUID", buildDef);
                        IBuildProperty buildProperty = buildDef.getProperty(wsPropertyId);
                        if (buildProperty != null) {
                            IWorkspaceHandle wsHandle = (IWorkspaceHandle)IWorkspace.ITEM_TYPE.createItemHandle(UUID.valueOf((String)buildProperty.getValue()), null);
                            BuildSubsetFileSelectionDialog.this.streamAssociatedWithBuildDefinition = new BuildUtils().getWorkspaceStream(wsHandle, BuildSubsetFileSelectionDialog.this.repository);
                        }
                    }
                    catch (Exception e) {
                        BuildSubsetFileSelectionDialog.this.streamAssociatedWithBuildDefinition = null;
                    }
                }
            };
            thread.start();
            thread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    protected void updateButtonsEnableState(IStatus status) {
        Button okButton = this.getOkButton();
        if (okButton != null && !okButton.isDisposed()) {
            boolean enable;
            boolean bl = enable = !status.matches(4);
            if (this.fContentProvider != null) {
                AtomicInteger fetchCount = this.fContentProvider.getFetchTotal();
                AtomicInteger addCount = this.fContentProvider.getAddTotal();
                if (fetchCount != null && addCount != null && fetchCount.get() != addCount.get()) {
                    enable = false;
                }
            }
            okButton.setEnabled(enable);
        }
    }

    protected Control createDialogArea(Composite parent) {
        Composite mainComposite = new Composite(parent, 0);
        mainComposite.setLayoutData((Object)new GridData(1808));
        mainComposite.setLayout((Layout)new GridLayout());
        super.createDialogArea(mainComposite);
        this.getStreamFromBuildDefinition(null);
        this.getTreeViewer().setInput((Object)this.streamAssociatedWithBuildDefinition);
        this.getTreeViewer().addTreeListener((ITreeViewerListener)new BuildSubsetTreeListener());
        this.setInput(this.streamAssociatedWithBuildDefinition);
        new BuildSubsetTreeItemTooltipSupport((TreeViewer)this.getTreeViewer());
        return mainComposite;
    }

    protected Control createContents(Composite parent) {
        Control result = super.createContents(parent);
        this.fContentProvider = (BuildableSubsetContentProvider2)this.getTreeViewer().getContentProvider();
        this.fContentProvider.setOKButton(this.getOkButton());
        this.fContentProvider.setTreeViewer(this.getTreeViewer());
        return result;
    }

    protected Composite createSelectionButtons(Composite composite) {
        return composite;
    }

    protected void computeResult() {
        ArrayList<SubsetFileDesc> buildableFileDescs = new ArrayList<SubsetFileDesc>();
        ComponentVersionableInfoList infoList = this.buildComponentVersionableInfoList();
        for (ComponentVersionableInfo info : infoList.getInfos()) {
            IComponent component = info.component;
            int index = 0;
            while (index < info.versionables.size()) {
                SubsetFileDesc desc = ModelFactory.eINSTANCE.createSubsetFileDesc();
                desc.setComponent(BuildableSubsetUtil.createComponentHandle((String)component.getItemId().getUuidValue()));
                desc.setFileItem((IVersionableHandle)BuildableSubsetUtil.createFileItemHandle((String)info.versionables.get(index).getItemId().getUuidValue()));
                buildableFileDescs.add(desc);
                ++index;
            }
        }
        this.setResult(buildableFileDescs);
    }

    private ComponentVersionableInfoList buildComponentVersionableInfoList() {
        Object[] selectedElements = this.getTreeViewer().getCheckedElements();
        return this.buildComponentVersionableInfoList(new ComponentVersionableInfoList(), selectedElements);
    }

    private ComponentVersionableInfoList buildComponentVersionableInfoList(ComponentVersionableInfoList existingList, Object[] selections) {
        ComponentVersionableInfoList infoList = existingList;
        BuildableSubsetContentProvider2 contentProvider = (BuildableSubsetContentProvider2)this.getTreeViewer().getContentProvider();
        Map<UUID, IComponent> componentMap = contentProvider.getComponentMap();
        Map<UUID, IComponent> buildableFileComponentMap = contentProvider.getBuildableFileComponentMap();
        Object[] objectArray = selections;
        int n = selections.length;
        int n2 = 0;
        while (n2 < n) {
            IComponent component;
            Object element = objectArray[n2];
            if (element instanceof IFolder) {
                IFolder folder = (IFolder)element;
                if (!this.expandedFolders.contains(folder.getItemId().getUuidValue())) {
                    try {
                        List<IVersionable> filesToAdd = this.updateFolders(folder, contentProvider.getWorkspaceConnection(), componentMap, buildableFileComponentMap, null);
                        infoList = this.buildComponentVersionableInfoList(infoList, filesToAdd.toArray());
                    }
                    catch (TeamRepositoryException e) {
                        e.printStackTrace();
                    }
                }
            } else if (element instanceof IFileItem) {
                IFileItem file = (IFileItem)element;
                component = buildableFileComponentMap.get(file.getItemId());
                if (component != null) {
                    ComponentVersionableInfo info = infoList.getInfo(component);
                    if (info == null) {
                        info = new ComponentVersionableInfo(component);
                        infoList.addInfo(info);
                    }
                    info.addVersionable((IVersionable)file);
                }
            } else if (element instanceof IComponent && !this.expandedComponents.contains((component = (IComponent)element).getItemId().getUuidValue())) {
                try {
                    List<IVersionable> filesToAdd = this.updateComponents(component, contentProvider.getWorkspaceConnection(), componentMap, buildableFileComponentMap, null);
                    infoList = this.buildComponentVersionableInfoList(infoList, filesToAdd.toArray());
                }
                catch (TeamRepositoryException e) {
                    e.printStackTrace();
                }
            }
            ++n2;
        }
        return infoList;
    }

    private List<IVersionable> updateFolders(IFolder folder, IWorkspaceConnection workspaceConnection, Map<UUID, IComponent> componentMap, Map<UUID, IComponent> buildableFileComponentMap, IProgressMonitor monitor) throws TeamRepositoryException {
        ArrayList<IVersionable> folderChildren = new ArrayList<IVersionable>();
        if (monitor != null && monitor.isCanceled() || workspaceConnection == null || folder == null) {
            return null;
        }
        String folderName = folder.getName().toLowerCase();
        if (folderName.startsWith(".") || folderName.equals("zosbin")) {
            return null;
        }
        IComponent component = componentMap.get(folder.getItemId());
        if (component == null) {
            return null;
        }
        IConfiguration configuration = workspaceConnection.configuration((IComponentHandle)component);
        this.fetchVersionable(configuration, folder, folderChildren, component, componentMap, buildableFileComponentMap, monitor);
        return folderChildren;
    }

    private void fetchVersionable(final IConfiguration configuration, final IFolder folder, final ArrayList<IVersionable> folderChildren, final IComponent component, final Map<UUID, IComponent> componentMap, final Map<UUID, IComponent> buildableFileComponentMap, final IProgressMonitor monitor) {
        Thread thread = new Thread(){

            @Override
            public void run() {
                try {
                    Map versionableMap = configuration.childEntries((IFolderHandle)folder, monitor);
                    List versionables = configuration.fetchCompleteItems(new ArrayList(versionableMap.values()), monitor);
                    BuildableSubsetContentProvider2 contentProvider = (BuildableSubsetContentProvider2)BuildSubsetFileSelectionDialog.this.getTreeViewer().getContentProvider();
                    for (IVersionable versionable : versionables) {
                        if (versionable.getName().startsWith(".")) continue;
                        if (versionable instanceof IFolder) {
                            folderChildren.add(versionable);
                            componentMap.put(versionable.getItemId(), component);
                            continue;
                        }
                        if (!(versionable instanceof IFileItem) || !contentProvider.isBuildableFile((IFileItem)versionable, monitor)) continue;
                        folderChildren.add(versionable);
                        buildableFileComponentMap.put(versionable.getItemId(), component);
                    }
                }
                catch (TeamRepositoryException e) {
                    e.printStackTrace();
                }
            }
        };
        thread.start();
        try {
            thread.join();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private List<IVersionable> updateComponents(IComponent component, IWorkspaceConnection workspaceConnection, Map<UUID, IComponent> componentMap, Map<UUID, IComponent> buildableFileComponentMap, IProgressMonitor monitor) throws TeamRepositoryException {
        ArrayList<IVersionable> componentChildren = new ArrayList<IVersionable>();
        if (monitor != null && monitor.isCanceled() || workspaceConnection == null || component == null) {
            return null;
        }
        final ArrayList folders = new ArrayList();
        IElementCollector collector = new IElementCollector(){

            public void done() {
            }

            public void add(Object[] elements, IProgressMonitor monitor) {
                Object[] objectArray = elements;
                int n = elements.length;
                int n2 = 0;
                while (n2 < n) {
                    Object element = objectArray[n2];
                    if (element instanceof IFolder) {
                        folders.add((IFolder)element);
                    }
                    ++n2;
                }
            }

            public void add(Object element, IProgressMonitor monitor) {
                if (element instanceof IFolder) {
                    folders.add((IFolder)element);
                }
            }
        };
        BuildableSubsetContentProvider2 contentProvider = (BuildableSubsetContentProvider2)this.getTreeViewer().getContentProvider();
        contentProvider.fetchProjects(component, collector, monitor);
        for (IFolder folder : folders) {
            try {
                List<IVersionable> filesToAdd = this.updateFolders(folder, workspaceConnection, componentMap, buildableFileComponentMap, monitor);
                componentChildren.addAll(filesToAdd);
            }
            catch (TeamRepositoryException e) {
                e.printStackTrace();
            }
        }
        return componentChildren;
    }

    private List<String> buildScmPaths(final ComponentVersionableInfo info) {
        final BuildableSubsetContentProvider2 contentProvider = (BuildableSubsetContentProvider2)this.getTreeViewer().getContentProvider();
        final IComponent component = info.component;
        try {
            Thread thread = new Thread(){

                @Override
                public void run() {
                    try {
                        IConfiguration configuration = contentProvider.getWorkspaceConnection().configuration((IComponentHandle)component);
                        BuildSubsetFileSelectionDialog.this.ancestorReports = configuration.locateAncestors(info.versionables, null);
                    }
                    catch (Exception e) {
                        BuildSubsetFileSelectionDialog.this.ancestorReports = null;
                    }
                }
            };
            thread.start();
            thread.join();
        }
        catch (InterruptedException e) {
            return null;
        }
        ArrayList<String> paths = new ArrayList<String>();
        Path filePath = null;
        for (IAncestorReport report : this.ancestorReports) {
            List itemPairs = report.getNameItemPairs();
            if (!itemPairs.isEmpty()) {
                for (INameItemPair pairItem : itemPairs) {
                    if (pairItem.getName() == null) {
                        filePath = new Path("\\");
                        continue;
                    }
                    if (filePath == null) continue;
                    filePath = filePath.append(pairItem.getName());
                }
            }
            paths.add(this.convert2ScmPath((IPath)filePath));
        }
        return paths;
    }

    private String convert2ScmPath(IPath path) {
        String temp = path.toString();
        while (temp.startsWith("\\") || temp.startsWith("/")) {
            temp = temp.substring(1);
        }
        return temp;
    }

    class BuildSubsetTreeListener
    implements ITreeViewerListener {
        BuildSubsetTreeListener() {
        }

        public void treeCollapsed(TreeExpansionEvent event) {
        }

        public void treeExpanded(TreeExpansionEvent event) {
            Object eventElement = event.getElement();
            if (eventElement instanceof IFolder) {
                BuildSubsetFileSelectionDialog.this.expandedFolders.add(((IFolder)eventElement).getItemId().getUuidValue());
            } else if (eventElement instanceof IComponent) {
                BuildSubsetFileSelectionDialog.this.expandedComponents.add(((IComponent)eventElement).getItemId().getUuidValue());
            }
        }
    }

    class ComponentVersionableInfo {
        protected IComponent component;
        protected List<IVersionable> versionables;

        public ComponentVersionableInfo(IComponent component) {
            this.component = component;
            this.versionables = new ArrayList<IVersionable>();
        }

        public void addVersionable(IVersionable versionable) {
            this.versionables.add(versionable);
        }
    }

    class ComponentVersionableInfoList {
        List<ComponentVersionableInfo> infos = new ArrayList<ComponentVersionableInfo>();

        ComponentVersionableInfoList() {
        }

        void addInfo(ComponentVersionableInfo info) {
            this.infos.add(info);
        }

        ComponentVersionableInfo getInfo(IComponent component) {
            for (ComponentVersionableInfo info : this.infos) {
                if (!info.component.sameItemId((IItemHandle)component)) continue;
                return info;
            }
            return null;
        }

        List<ComponentVersionableInfo> getInfos() {
            return this.infos;
        }
    }
}

