/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.build.ui.subset;

import com.ibm.team.build.common.model.IBuildDefinition;
import com.ibm.team.build.common.model.IBuildDefinitionHandle;
import com.ibm.team.enterprise.build.ui.subset.BuildSubsetNode;
import com.ibm.team.enterprise.buildablesubset.common.model.ISubset;
import com.ibm.team.enterprise.buildablesubset.common.model.ISubsetCriteria;
import com.ibm.team.enterprise.buildablesubset.common.model.ISubsetFileDesc;
import com.ibm.team.enterprise.common.ui.domain.AbstractEnterpriseExtensionsNode;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.client.ITeamRepository;
import java.util.Collection;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IPersistableElement;

public class BuildSubsetEditorInput
implements IEditorInput {
    private String initialPageId;
    private ITeamRepository fRepository = null;
    private IProjectAreaHandle fProjectAreaHandle = null;
    private ISubset fSubset = null;
    private ISubset fPreviousSubset = null;
    private IBuildDefinition fBuildDefinition = null;
    private IBuildDefinitionHandle fBuildDefinitionHandle = null;
    private AbstractEnterpriseExtensionsNode fSubsetNode = null;
    private Collection<ISubsetFileDesc> fAdditionalFileDescs;
    private Collection<ISubsetCriteria> fAdditionalCriteria;

    public BuildSubsetEditorInput(AbstractEnterpriseExtensionsNode node) {
        this.fProjectAreaHandle = node.getProjectAreaHandle();
        if (this.fProjectAreaHandle != null) {
            this.fRepository = (ITeamRepository)this.fProjectAreaHandle.getOrigin();
        }
        this.fSubsetNode = node;
        if (node instanceof BuildSubsetNode) {
            this.fSubset = ((BuildSubsetNode)node).getBuildableSubset();
        }
        this.fBuildDefinitionHandle = this.fSubset != null ? this.fSubset.getBuildDefinition() : null;
    }

    public BuildSubsetEditorInput(ISubset subset, ITeamRepository repo, IProjectAreaHandle projectArea) {
        this.fProjectAreaHandle = projectArea;
        this.fSubset = subset;
        this.fRepository = repo;
        this.fBuildDefinitionHandle = this.fSubset.getBuildDefinition();
    }

    public BuildSubsetEditorInput(ISubset subset, IBuildDefinitionHandle buildDefinitionHandle, Collection<ISubsetFileDesc> additionalFileDescs, Collection<ISubsetCriteria> additionalCriteria, ITeamRepository repo, IProjectAreaHandle projectArea) {
        this.fSubset = subset;
        this.fProjectAreaHandle = projectArea;
        this.fRepository = repo;
        this.fBuildDefinitionHandle = buildDefinitionHandle;
        this.fAdditionalFileDescs = additionalFileDescs;
        this.fAdditionalCriteria = additionalCriteria;
    }

    public String getInitialPageId() {
        return this.initialPageId;
    }

    public void setInitialPageId(String pageId) {
        this.initialPageId = pageId;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof BuildSubsetEditorInput)) {
            return false;
        }
        BuildSubsetEditorInput newInput = (BuildSubsetEditorInput)obj;
        if (newInput.getSubset() == null) {
            return false;
        }
        ISubset subset = newInput.getSubset();
        try {
            String currLabel = "";
            String currBuildDef = "";
            if (this.getSubset() != null) {
                currLabel = this.getSubset().getLabel();
                currBuildDef = this.getSubset().getBuildDefinition().getItemId().getUuidValue();
            }
            boolean isLabelEqual = currLabel.equals(subset.getLabel());
            boolean isBuildDefEqual = currBuildDef.equals(subset.getBuildDefinition().getItemId().getUuidValue());
            return isLabelEqual && isBuildDefEqual;
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean exists() {
        return true;
    }

    public ImageDescriptor getImageDescriptor() {
        return null;
    }

    public String getName() {
        return "";
    }

    public IPersistableElement getPersistable() {
        return null;
    }

    public String getToolTipText() {
        return "";
    }

    public Object getAdapter(Class adapter) {
        return null;
    }

    public ITeamRepository getTeamRepository() {
        return this.fRepository;
    }

    public ISubset getSubset() {
        return this.fSubset;
    }

    public void setSubset(ISubset newSubset) {
        if (this.fSubset != null && this.fSubset.getOwner() != null) {
            this.fPreviousSubset = this.fSubset;
        }
        this.fSubset = newSubset;
        if (this.fSubset != null && newSubset != null) {
            this.fSubset.setLabel(newSubset.getLabel());
        }
    }

    public IBuildDefinition getBuildDefinition() {
        return this.fBuildDefinition;
    }

    public void setBuildDefinition(IBuildDefinition newDefinition) {
        this.fBuildDefinition = newDefinition;
    }

    public IBuildDefinitionHandle getBuildDefinitionHandle() {
        return this.fBuildDefinitionHandle;
    }

    public void setBuildDefinitionHandle(IBuildDefinitionHandle newDefHandle) {
        this.fBuildDefinitionHandle = newDefHandle;
    }

    public AbstractEnterpriseExtensionsNode getSubsetNode() {
        return this.fSubsetNode;
    }

    public void setSubsetNode(AbstractEnterpriseExtensionsNode subsetNode) {
        this.fSubsetNode = subsetNode;
    }

    public IProjectAreaHandle getProjectAreaHandle() {
        return this.fProjectAreaHandle;
    }

    public Collection<ISubsetFileDesc> getAdditionalFileDescs() {
        return this.fAdditionalFileDescs;
    }

    public Collection<ISubsetCriteria> getAdditionalCriteria() {
        return this.fAdditionalCriteria;
    }

    public ISubset getPreviousSubset() {
        return this.fPreviousSubset;
    }
}

