/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.build.ui.subset;

import com.ibm.team.build.common.model.IBuildDefinition;
import com.ibm.team.build.common.model.IBuildDefinitionHandle;
import com.ibm.team.build.internal.ui.dialogs.definitions.BuildDefinitionSelectionDialog;
import com.ibm.team.build.internal.ui.dialogs.definitions.FetchBuildDefinitionsInConnectedProjectAreasJob;
import com.ibm.team.enterprise.build.common.IBuildUtility;
import com.ibm.team.enterprise.build.ui.subset.BuildableSubsetUtils;
import com.ibm.team.enterprise.internal.build.ui.nls.Messages;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.process.internal.common.ItemHandleAwareHashSet;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;

public class BuildSubsetDefinitionSelectionDialog
extends BuildDefinitionSelectionDialog {
    private Collection<IProjectAreaHandle> fProjectAreas;

    public BuildSubsetDefinitionSelectionDialog(IProjectAreaHandle projectArea, Shell parent) {
        this(Arrays.asList(projectArea), parent);
    }

    public BuildSubsetDefinitionSelectionDialog(Collection<IProjectAreaHandle> projectArea, Shell parent) {
        this(projectArea, parent, Messages.BuildSubsetDialog_DESCRIPTION_SELECTDEF, false);
    }

    public BuildSubsetDefinitionSelectionDialog(Collection<IProjectAreaHandle> projectArea, Shell parent, String descriptionText, boolean showRepository) {
        super(parent, Messages.BuildSubsetDialog_TITLE_SELECTDEF, descriptionText, false, showRepository);
        this.fProjectAreas = projectArea;
    }

    protected Label createMessageArea(Composite composite) {
        Label superLabel = super.createMessageArea(composite);
        GridData data = new GridData();
        data.exclude = true;
        superLabel.setLayoutData((Object)data);
        Label label = new Label(composite, 64);
        if (this.getMessage() != null) {
            label.setText(this.getMessage());
        }
        label.setFont(composite.getFont());
        data = new GridData(4, 0x1000000, true, false);
        label.setLayoutData((Object)data);
        return label;
    }

    public void setListElements(Object[] elements) {
        ArrayList<IBuildDefinition> buildDefs = null;
        boolean isAtLeastOneBuildDefinition = false;
        Object[] objectArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            Object currObject = objectArray[n2];
            if (currObject instanceof IBuildDefinition) {
                if (!isAtLeastOneBuildDefinition) {
                    isAtLeastOneBuildDefinition = true;
                }
                if (buildDefs == null) {
                    buildDefs = new ArrayList<IBuildDefinition>();
                }
                if (IBuildUtility.isDependencyBuild((IBuildDefinition)((IBuildDefinition)currObject)) || IBuildUtility.isOldDependencyBuild((IBuildDefinition)((IBuildDefinition)currObject))) {
                    buildDefs.add((IBuildDefinition)currObject);
                }
            }
            ++n2;
        }
        if (buildDefs != null && !buildDefs.isEmpty()) {
            super.setListElements(buildDefs.toArray());
        } else if (isAtLeastOneBuildDefinition) {
            super.setListElements(buildDefs.toArray());
        } else {
            super.setListElements(elements);
        }
    }

    protected Job createFetchJob() {
        return new FetchBuildDefinitionsInConnectedProjectAreasJob(this){

            protected IBuildDefinition[] fetchBuildDefinitions(ITeamRepository repository, IProgressMonitor monitor) throws TeamRepositoryException {
                if (BuildSubsetDefinitionSelectionDialog.this.fProjectAreas != null && !BuildSubsetDefinitionSelectionDialog.this.fProjectAreas.isEmpty()) {
                    List<IBuildDefinitionHandle> handles = BuildableSubsetUtils.getBuildDefinitions(BuildSubsetDefinitionSelectionDialog.this.fProjectAreas);
                    ArrayList defs = new ArrayList(handles.size());
                    defs.addAll(repository.itemManager().fetchCompleteItems(handles, 0, monitor));
                    return defs.toArray(new IBuildDefinition[defs.size()]);
                }
                return super.fetchBuildDefinitions(repository, monitor);
            }

            protected ITeamRepository[] getConnectedRepositories() {
                if (BuildSubsetDefinitionSelectionDialog.this.fProjectAreas != null && !BuildSubsetDefinitionSelectionDialog.this.fProjectAreas.isEmpty()) {
                    ItemHandleAwareHashSet repositories = new ItemHandleAwareHashSet();
                    for (IProjectAreaHandle handle : BuildSubsetDefinitionSelectionDialog.this.fProjectAreas) {
                        Object origin;
                        if (handle == null || !((origin = handle.getOrigin()) instanceof ITeamRepository)) continue;
                        repositories.add(origin);
                    }
                    return (ITeamRepository[])repositories.toArray((Object[])new ITeamRepository[repositories.size()]);
                }
                return super.getConnectedRepositories();
            }
        };
    }
}

