/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.build.ui.subset;

import com.ibm.team.build.common.model.IBuildDefinition;
import com.ibm.team.build.common.model.IBuildDefinitionHandle;
import com.ibm.team.enterprise.build.client.buildablesubset.ClientFactory;
import com.ibm.team.enterprise.build.client.buildablesubset.IBuildableSubsetClient;
import com.ibm.team.enterprise.build.common.IBuildUtility;
import com.ibm.team.enterprise.build.ui.Activator;
import com.ibm.team.enterprise.build.ui.subset.BuildSubsetSelectionDialog;
import com.ibm.team.enterprise.build.ui.subset.BuildableSubsetUtils;
import com.ibm.team.enterprise.build.ui.subset.FilteredBuildSubsetTree;
import com.ibm.team.enterprise.buildablesubset.common.model.ISubset;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.progress.DeferredTreeContentManager;
import org.eclipse.ui.progress.IDeferredWorkbenchAdapter;
import org.eclipse.ui.progress.IElementCollector;

public class BuildSubsetDeferredContentProvider
implements ITreeContentProvider,
IDeferredWorkbenchAdapter {
    public static final int DISPLAY_BUILDDEF_SUBSETS = 0;
    public static final int DISPLAY_FILTERED_SUBSETS = 1;
    public static final int DISPLAY_ALL_SUBSETS = 2;
    protected DeferredTreeContentManager deferredTreeManager;
    protected TreeViewer treeViewer;
    private ITeamRepository repository;
    private IBuildDefinition buildDefinition;
    private int displayType;
    protected Map<Object, Object[]> fetched;
    protected Map<Object, Object[]> fetchedfiltered;
    protected Map<Object, Object[]> fetchedAll;
    private static final Object[] EMPTY_ARRAY = new Object[0];

    public BuildSubsetDeferredContentProvider(ITeamRepository repository, IBuildDefinition buildDefinition) {
        this.repository = repository;
        this.buildDefinition = buildDefinition;
        this.fetched = new HashMap<Object, Object[]>();
        this.fetchedfiltered = new HashMap<Object, Object[]>();
        this.fetchedAll = new HashMap<Object, Object[]>();
    }

    public void setDisplayType(int type) {
        switch (type) {
            case 0: 
            case 1: 
            case 2: {
                this.displayType = type;
            }
        }
    }

    public void dispose() {
        this.deferredTreeManager = null;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        if (viewer instanceof TreeViewer) {
            this.treeViewer = (TreeViewer)viewer;
        }
    }

    public ImageDescriptor getImageDescriptor(Object object) {
        return null;
    }

    public String getLabel(Object o) {
        if (o instanceof ITeamRepository) {
            return ((ITeamRepository)o).getName();
        }
        if (o instanceof IProjectArea) {
            return ((IProjectArea)o).getName();
        }
        if (o instanceof BuildSubsetSelectionDialog.BuildDefinitionEntry) {
            return ((BuildSubsetSelectionDialog.BuildDefinitionEntry)o).buildDefinition.getId();
        }
        if (o != null) {
            return o.toString();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fetchDeferredChildren(Object object, IElementCollector collector, IProgressMonitor monitor) {
        Object object2 = object;
        synchronized (object2) {
            block14: {
                Map<Object, Object[]> cacheToCheck = object instanceof ITeamRepository || object instanceof IProjectArea ? (this.displayType == 1 ? this.fetchedfiltered : (this.displayType == 2 ? this.fetchedAll : this.fetched)) : this.fetched;
                if (cacheToCheck.containsKey(object)) {
                    return;
                }
                try {
                    try {
                        if (object instanceof ITeamRepository) {
                            this.fetchRepositoryChildren((ITeamRepository)object, collector, monitor);
                        } else if (object instanceof IProjectArea) {
                            this.fetchProjectAreaChildren((IProjectArea)object, collector, monitor);
                        } else if (object instanceof BuildSubsetSelectionDialog.BuildDefinitionEntry) {
                            this.fetchBuildDefinitionChildren((BuildSubsetSelectionDialog.BuildDefinitionEntry)object, collector, monitor);
                        }
                    }
                    catch (Exception e) {
                        Activator.getDefault().logError(e);
                        Object[] error = new Object[]{e};
                        collector.add(error, monitor);
                        this.fetched.put(object, error);
                        monitor.done();
                        break block14;
                    }
                }
                catch (Throwable throwable) {
                    monitor.done();
                    throw throwable;
                }
                monitor.done();
            }
        }
    }

    protected void fetchRepositoryChildren(ITeamRepository repository, IElementCollector collector, IProgressMonitor monitor) throws TeamRepositoryException {
        List rawProjectAreas = repository.itemManager().fetchCompleteItems(repository.itemManager().getKnownSharedItems(IProjectArea.ITEM_TYPE), 2, null);
        ArrayList<BuildSubsetSelectionDialog.BuildDefinitionEntry> buildDefinitions = new ArrayList<BuildSubsetSelectionDialog.BuildDefinitionEntry>(rawProjectAreas.size());
        for (IProjectArea projectArea : rawProjectAreas) {
            boolean filterEnabled;
            if (projectArea == null || projectArea.isArchived()) continue;
            List<IBuildDefinitionHandle> handles = BuildableSubsetUtils.getBuildDefinitions((IProjectAreaHandle)projectArea);
            if (this.displayType == 1 && (filterEnabled = Activator.getDefault().getPreferenceStore().getBoolean("team.enterprise.build.subsets.filtered.enabled." + projectArea.getItemId().getUuidValue()))) {
                String filterList = Activator.getDefault().getPreferenceStore().getString("team.enterprise.build.subsets.filtered.list." + projectArea.getItemId().getUuidValue());
                List<String> uuidsToKeep = Arrays.asList(filterList.split(","));
                Iterator<IBuildDefinitionHandle> it = handles.iterator();
                while (it.hasNext()) {
                    UUID nextUUID = it.next().getItemId();
                    if (this.buildDefinition != null && this.buildDefinition.getItemId().equals((Object)nextUUID) || uuidsToKeep.contains(nextUUID.getUuidValue())) continue;
                    it.remove();
                }
            }
            List defs = repository.itemManager().fetchPartialItems(handles, 0, Arrays.asList(IBuildDefinition.PROPERTY_CONFIGURATION_ELEMENTS, IBuildDefinition.PROPERTY_ID), (IProgressMonitor)new NullProgressMonitor());
            for (Object def : defs) {
                IBuildDefinition bd = (IBuildDefinition)def;
                if (!IBuildUtility.isDependencyBuild((IBuildDefinition)bd) && !IBuildUtility.isOldDependencyBuild((IBuildDefinition)bd)) continue;
                buildDefinitions.add(new BuildSubsetSelectionDialog.BuildDefinitionEntry(bd, projectArea));
            }
        }
        Collections.sort(buildDefinitions, new Comparator<BuildSubsetSelectionDialog.BuildDefinitionEntry>(){

            @Override
            public int compare(BuildSubsetSelectionDialog.BuildDefinitionEntry o1, BuildSubsetSelectionDialog.BuildDefinitionEntry o2) {
                String label1 = o1.buildDefinition.getId();
                String label2 = o2.buildDefinition.getId();
                return label1.compareTo(label2);
            }
        });
        Object[] added = buildDefinitions.toArray();
        collector.add(added, monitor);
        if (this.displayType == 1) {
            this.fetchedfiltered.put(repository, added);
        } else if (this.displayType == 2) {
            this.fetchedAll.put(repository, added);
        } else {
            this.fetched.put(repository, added);
        }
    }

    protected void fetchProjectAreaChildren(IProjectArea projectArea, IElementCollector collector, IProgressMonitor monitor) throws TeamRepositoryException {
        List rawProjectAreas = this.repository.itemManager().fetchCompleteItems(this.repository.itemManager().getKnownSharedItems(IProjectArea.ITEM_TYPE), 2, null);
        ArrayList<BuildSubsetSelectionDialog.BuildDefinitionEntry> buildDefinitions = new ArrayList<BuildSubsetSelectionDialog.BuildDefinitionEntry>(rawProjectAreas.size());
        if (projectArea != null && !projectArea.isArchived()) {
            boolean filterEnabled;
            List<IBuildDefinitionHandle> handles = BuildableSubsetUtils.getBuildDefinitions((IProjectAreaHandle)projectArea);
            if (this.displayType == 1 && (filterEnabled = Activator.getDefault().getPreferenceStore().getBoolean("team.enterprise.build.subsets.filtered.enabled." + projectArea.getItemId().getUuidValue()))) {
                String filterList = Activator.getDefault().getPreferenceStore().getString("team.enterprise.build.subsets.filtered.list." + projectArea.getItemId().getUuidValue());
                List<String> uuidsToKeep = Arrays.asList(filterList.split(","));
                Iterator<IBuildDefinitionHandle> it = handles.iterator();
                while (it.hasNext()) {
                    UUID nextUUID = it.next().getItemId();
                    if (this.buildDefinition != null && this.buildDefinition.getItemId().equals((Object)nextUUID) || uuidsToKeep.contains(nextUUID.getUuidValue())) continue;
                    it.remove();
                }
            }
            List defs = this.repository.itemManager().fetchPartialItems(handles, 0, Arrays.asList(IBuildDefinition.PROPERTY_CONFIGURATION_ELEMENTS, IBuildDefinition.PROPERTY_ID), (IProgressMonitor)new NullProgressMonitor());
            for (Object def : defs) {
                IBuildDefinition bd = (IBuildDefinition)def;
                if (!IBuildUtility.isDependencyBuild((IBuildDefinition)bd) && !IBuildUtility.isOldDependencyBuild((IBuildDefinition)bd)) continue;
                buildDefinitions.add(new BuildSubsetSelectionDialog.BuildDefinitionEntry(bd, projectArea));
            }
        }
        Collections.sort(buildDefinitions, new Comparator<BuildSubsetSelectionDialog.BuildDefinitionEntry>(){

            @Override
            public int compare(BuildSubsetSelectionDialog.BuildDefinitionEntry o1, BuildSubsetSelectionDialog.BuildDefinitionEntry o2) {
                String label1 = o1.buildDefinition.getId();
                String label2 = o2.buildDefinition.getId();
                return label1.compareTo(label2);
            }
        });
        Object[] added = buildDefinitions.toArray();
        collector.add(added, monitor);
        if (this.displayType == 1) {
            this.fetchedfiltered.put(projectArea, added);
        } else if (this.displayType == 2) {
            this.fetchedAll.put(projectArea, added);
        } else {
            this.fetched.put(projectArea, added);
        }
    }

    protected void fetchBuildDefinitionChildren(BuildSubsetSelectionDialog.BuildDefinitionEntry buildDefinitionEntry, IElementCollector collector, IProgressMonitor monitor) throws TeamRepositoryException {
        IBuildableSubsetClient client = ClientFactory.getBuildableSubsetClient((ITeamRepository)this.repository);
        String ownerId = this.repository.loggedInContributor().getItemId().getUuidValue();
        List handles = client.getAllBuildableSubsets((IBuildDefinitionHandle)buildDefinitionEntry.buildDefinition, ownerId);
        Collections.sort(handles, new Comparator<ISubset>(){

            @Override
            public int compare(ISubset o1, ISubset o2) {
                String label1 = o1.getLabel();
                String label2 = o2.getLabel();
                return label1.compareTo(label2);
            }
        });
        Object[] added = handles.toArray();
        collector.add(added, monitor);
        this.fetched.put(buildDefinitionEntry, added);
    }

    public boolean isContainer() {
        return true;
    }

    public ISchedulingRule getRule(Object object) {
        return null;
    }

    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof ITeamRepository || parentElement instanceof IProjectArea || parentElement instanceof BuildSubsetSelectionDialog.BuildDefinitionEntry) {
            Map<Object, Object[]> cacheToCheck = parentElement instanceof ITeamRepository || parentElement instanceof IProjectArea ? (this.displayType == 1 ? this.fetchedfiltered : (this.displayType == 2 ? this.fetchedAll : this.fetched)) : this.fetched;
            if (cacheToCheck.containsKey(parentElement)) {
                return cacheToCheck.get(parentElement);
            }
            if (this.getContentManager() != null) {
                return this.getContentManager().getChildren(parentElement);
            }
            return new Object[]{""};
        }
        return EMPTY_ARRAY;
    }

    public Object getParent(Object element) {
        return null;
    }

    public boolean hasChildren(Object element) {
        if (this.displayType == 0) {
            return false;
        }
        return element instanceof ITeamRepository || element instanceof IProjectArea || element instanceof BuildSubsetSelectionDialog.BuildDefinitionEntry;
    }

    private DeferredTreeContentManager getContentManager() {
        if (this.deferredTreeManager == null && this.treeViewer != null) {
            this.deferredTreeManager = new DeferredTreeContentManager((AbstractTreeViewer)this.treeViewer){

                protected IDeferredWorkbenchAdapter getAdapter(Object element) {
                    return BuildSubsetDeferredContentProvider.this;
                }
            };
            this.deferredTreeManager.addUpdateCompleteListener((IJobChangeListener)new JobChangeAdapter(){

                public void done(IJobChangeEvent event) {
                    if (event.getResult().isOK() && !BuildSubsetDeferredContentProvider.this.treeViewer.getTree().isDisposed()) {
                        Composite filteredTree = BuildSubsetDeferredContentProvider.this.treeViewer.getTree().getParent().getParent();
                        if (filteredTree instanceof FilteredBuildSubsetTree) {
                            ((FilteredBuildSubsetTree)filteredTree).refresh();
                        } else {
                            BuildSubsetDeferredContentProvider.this.treeViewer.refresh();
                        }
                    }
                }
            });
        }
        return this.deferredTreeManager;
    }
}

