/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.build.ui.property.pages;

import com.ibm.icu.text.Collator;
import com.ibm.team.build.internal.ui.jobs.TeamBuildJob;
import com.ibm.team.enterprise.build.ui.metadata.api.IMetadata;
import com.ibm.team.enterprise.build.ui.metadata.core.api.Metadata;
import com.ibm.team.enterprise.build.ui.property.pages.EnterpriseMetadataPropertiesComposite;
import com.ibm.team.enterprise.build.ui.property.pages.EnterpriseVariableComparator;
import com.ibm.team.enterprise.build.ui.property.pages.Utils;
import com.ibm.team.enterprise.ibmi.internal.definitions.ui.actions.EditSystemDefinitionActionDelegate;
import com.ibm.team.enterprise.internal.build.ui.nls.Messages;
import com.ibm.team.enterprise.langdef.ui.dialogs.LanguageDefinitionLabelHelper;
import com.ibm.team.enterprise.systemdefinition.client.ISystemDefinitionModelClient;
import com.ibm.team.enterprise.systemdefinition.common.internal.model.Variable;
import com.ibm.team.enterprise.systemdefinition.common.model.IIBMiLanguageDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.ILanguageDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.IPlatformObject;
import com.ibm.team.enterprise.systemdefinition.common.model.ISystemDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.ITranslator;
import com.ibm.team.enterprise.systemdefinition.common.model.ITranslatorEntry;
import com.ibm.team.enterprise.systemdefinition.common.model.IVariable;
import com.ibm.team.enterprise.systemdefinition.common.model.IZosLanguageDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.ModelFactory;
import com.ibm.team.enterprise.systemdefinition.common.util.Constants;
import com.ibm.team.enterprise.systemdefinition.ui.ISystemDefinitionContext;
import com.ibm.team.enterprise.systemdefinition.ui.dialogs.CreateVariableDialog;
import com.ibm.team.enterprise.systemdefinition.ui.dialogs.SystemDefinitionDeferredContentProvider;
import com.ibm.team.enterprise.systemdefinition.ui.dialogs.SystemDefinitionSelectionDialog;
import com.ibm.team.enterprise.systemdefinition.ui.dialogs.VariableContentProvider;
import com.ibm.team.enterprise.systemdefinition.ui.dialogs.VariableLabelProvider;
import com.ibm.team.filesystem.client.IMetadataProperties;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.client.IItemManager;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class EnterpriseShareableMetadataPropertiesComposite
extends EnterpriseMetadataPropertiesComposite {
    private boolean isUsingDefault = false;
    private boolean isLoadAlways = false;
    private boolean hasLoadChanged = false;
    protected Link LDTitleLink;
    private Button clearButton;
    private Button browseButton;
    protected Button loadButton;
    private Label defaultLangDefLabel;
    protected Text fLanguageDefField;
    protected String fLanguageDefUUID;
    private final IShareable fShareable;
    protected ITeamRepository fTeamRepository;
    private IStatus errorStatus;
    private IItemType fDefinitionType;
    private ViewerFilter fDialogFilter;
    private String[] fDialogFetchProperties;
    private ResolveLangDefExtensionsJob resolveExtensions = null;
    private Button fAddVariableButton;
    private Button fRemoveVariableButton;
    private Button fEditVariableButton;
    private Button fRestoreDefaultButton;
    private TableViewer fVariableTableViewer;
    private List<IVariable> fNewOrChangedVariables = new ArrayList<IVariable>();
    private List<IVariable> fMergedVariables = new ArrayList<IVariable>();
    private List<IVariable> fRemovedVariables = new ArrayList<IVariable>();
    private List<IVariable> fDefaultTranslatorVariables;
    private List<String> fRemovedProperties = new ArrayList<String>();
    private SelectionListener sortListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent event) {
            EnterpriseShareableMetadataPropertiesComposite.this.handleSorting(event);
        }
    };
    private ILanguageDefinition languageDefinition;

    public EnterpriseShareableMetadataPropertiesComposite(Composite parent, IShareable shareable, Class<? extends IPlatformObject> platform) {
        super(parent);
        this.fShareable = shareable;
        this.errorStatus = null;
        this.fDefinitionType = ILanguageDefinition.ITEM_TYPE;
        this.fDialogFetchProperties = SystemDefinitionDeferredContentProvider.MINIMUM_PROPERTIES;
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, this.getContextHelpId());
        this.createContents(platform);
    }

    protected void createContents(Class<? extends IPlatformObject> platform) {
        GridLayout layout = new GridLayout(4, false);
        this.setLayout((Layout)layout);
        GridData gridData1 = new GridData();
        gridData1.horizontalAlignment = 4;
        this.LDTitleLink = new Link((Composite)this, 0);
        this.LDTitleLink.setText(Messages.EnterpriseMetadataPropertiesPage_LANGUAGE_DEFN);
        this.LDTitleLink.addSelectionListener(this.getLDLinkListener());
        this.LDTitleLink.setLayoutData((Object)gridData1);
        this.setLDTitleLinkEnablement(false);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.fLanguageDefField = new Text((Composite)this, 2052);
        this.fLanguageDefField.setLayoutData((Object)gridData);
        this.fLanguageDefField.setEditable(false);
        this.browseButton = new Button((Composite)this, 0);
        this.browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ISystemDefinition langDef;
                SystemDefinitionSelectionDialog dialog;
                if (EnterpriseShareableMetadataPropertiesComposite.this.fTeamRepository != null && (dialog = new SystemDefinitionSelectionDialog(EnterpriseShareableMetadataPropertiesComposite.this.getShell(), EnterpriseShareableMetadataPropertiesComposite.this.fTeamRepository, EnterpriseShareableMetadataPropertiesComposite.this.fDefinitionType, EnterpriseShareableMetadataPropertiesComposite.this.fDialogFilter, EnterpriseShareableMetadataPropertiesComposite.this.fDialogFetchProperties)).open() == 0 && (langDef = (ISystemDefinition)dialog.getFirstResult()) != null) {
                    EnterpriseShareableMetadataPropertiesComposite.this.fLanguageDefUUID = langDef.getItemId().getUuidValue();
                    EnterpriseShareableMetadataPropertiesComposite.this.fLanguageDefField.setText(EnterpriseShareableMetadataPropertiesComposite.this.getLanguageDefFldText(langDef.getName(), langDef.getProjectArea().getItemId()));
                    EnterpriseShareableMetadataPropertiesComposite.this.setLDTitleLinkEnablement(true);
                    EnterpriseShareableMetadataPropertiesComposite.this.defaultLangDefLabel.setVisible(false);
                    EnterpriseShareableMetadataPropertiesComposite.this.clearButton.setEnabled(true);
                    EnterpriseShareableMetadataPropertiesComposite.this.loadButton.setEnabled(true);
                    EnterpriseShareableMetadataPropertiesComposite.this.updateVariablesTable(null, EnterpriseShareableMetadataPropertiesComposite.this.fLanguageDefUUID);
                }
            }
        });
        this.browseButton.setText(Messages.BUILD_SELECTION_BUTTON_LABEL);
        this.errorStatus = new Status(1, "com.ibm.team.enterprise.build.ui", Messages.BUILD_MEMBER_WIZARD_FILE_NOT_SHARED_WARNING);
        this.browseButton.setEnabled(false);
        this.clearButton = new Button((Composite)this, 0);
        this.clearButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EnterpriseShareableMetadataPropertiesComposite.this.fLanguageDefUUID = null;
                EnterpriseShareableMetadataPropertiesComposite.this.fLanguageDefField.setText("");
                EnterpriseShareableMetadataPropertiesComposite.this.updateDefaultLangDef(false, new String());
                EnterpriseShareableMetadataPropertiesComposite.this.updateVariablesTable(null, EnterpriseShareableMetadataPropertiesComposite.this.fLanguageDefUUID);
            }
        });
        this.clearButton.setText(Messages.BUILD_CLEAR_BUTTON_LABEL);
        this.defaultLangDefLabel = new Label((Composite)this, 0);
        GridData gridData2 = new GridData();
        gridData2.horizontalAlignment = 4;
        gridData2.horizontalSpan = 4;
        this.defaultLangDefLabel.setLayoutData((Object)gridData2);
        this.defaultLangDefLabel.setText(Messages.EnterpriseFileMetadataPropertiesPage_DEFAULT_LANGDEF);
        this.defaultLangDefLabel.setForeground(Display.getDefault().getSystemColor(16));
        this.defaultLangDefLabel.setVisible(false);
        this.createSpacer(this, 0, 4);
        this.loadButton = new Button((Composite)this, 32);
        GridData gridData3 = new GridData();
        gridData3.horizontalAlignment = 4;
        gridData3.horizontalSpan = 4;
        this.loadButton.setLayoutData((Object)gridData3);
        this.loadButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean rc;
                if (EnterpriseShareableMetadataPropertiesComposite.this.loadButton.getSelection() && !(rc = MessageDialog.openQuestion((Shell)EnterpriseShareableMetadataPropertiesComposite.this.loadButton.getShell(), (String)Messages.WarningDialogTitle, (String)Messages.AlwaysLoadDeprecatedWarning))) {
                    EnterpriseShareableMetadataPropertiesComposite.this.loadButton.setSelection(false);
                }
                EnterpriseShareableMetadataPropertiesComposite.this.isLoadAlways = EnterpriseShareableMetadataPropertiesComposite.this.loadButton.getSelection();
                EnterpriseShareableMetadataPropertiesComposite.this.hasLoadChanged = true;
            }
        });
        this.loadButton.setText(Messages.BUILD_LOAD_BUTTON_LABEL);
        this.createVariablesGroup(this);
    }

    protected String getLanguageDefFldText(String languageDefName, UUID projectAreaUUID) {
        IItemManager itemManager = this.fTeamRepository.itemManager();
        String returnString = languageDefName;
        try {
            IProjectAreaHandle projectAreaHandle = (IProjectAreaHandle)IProjectArea.ITEM_TYPE.createItemHandle(projectAreaUUID, null);
            IProjectArea parentPA = (IProjectArea)itemManager.fetchCompleteItem((IItemHandle)projectAreaHandle, 0, (IProgressMonitor)new NullProgressMonitor());
            String projectAreaName = parentPA.getName();
            returnString = languageDefName.concat(" (" + projectAreaName + ")");
        }
        catch (TeamRepositoryException e) {
            e.printStackTrace();
        }
        return returnString;
    }

    @Override
    public void initialize(IMetadata metadata) {
        this.fTeamRepository = Utils.getTeamRepository(this.fShareable);
        if (this.fTeamRepository != null) {
            this.errorStatus = null;
            this.browseButton.setEnabled(true);
        }
        String languagedefUUID = metadata == null ? "" : metadata.getProperty("team.enterprise.language.definition");
        boolean hasUUID = languagedefUUID != null && languagedefUUID.length() > 0;
        this.updateDefaultLangDef(hasUUID, languagedefUUID);
        this.updateVariablesTable(metadata, this.fLanguageDefUUID);
        boolean loadAlways = metadata == null ? false : Boolean.parseBoolean(metadata.getProperty("team.enterprise.build.alwaysload"));
        this.loadButton.setSelection(loadAlways);
    }

    private void getVariablesFromTranslators(final String languageDefUUID) {
        Thread thread = new Thread(){

            @Override
            public void run() {
                try {
                    ArrayList<IVariable> variables = new ArrayList<IVariable>();
                    if (languageDefUUID != null && EnterpriseShareableMetadataPropertiesComposite.this.fTeamRepository != null) {
                        ISystemDefinitionModelClient client = (ISystemDefinitionModelClient)EnterpriseShareableMetadataPropertiesComposite.this.fTeamRepository.getClientLibrary(ISystemDefinitionModelClient.class);
                        ILanguageDefinition langDef = (ILanguageDefinition)client.findSystemDefinitionComplete(languageDefUUID, null, ILanguageDefinition.ITEM_TYPE, (IProgressMonitor)new NullProgressMonitor());
                        if (langDef != null) {
                            List translatorList = langDef.getTranslators();
                            for (ITranslatorEntry entry : translatorList) {
                                ITranslator translator;
                                if (!entry.getKind().equals("com.ibm.team.enterprise.systemdefinition.entry.translator") || (translator = (ITranslator)client.findSystemDefinitionComplete(entry.getValue(), null, ITranslator.ITEM_TYPE, (IProgressMonitor)new NullProgressMonitor())) == null) continue;
                                List translatorVars = translator.getVariables();
                                for (IVariable v : translatorVars) {
                                    if (EnterpriseShareableMetadataPropertiesComposite.this.isReservedVariable(v)) continue;
                                    variables.add(v);
                                }
                            }
                        }
                        EnterpriseShareableMetadataPropertiesComposite.this.fDefaultTranslatorVariables = variables;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        };
        thread.start();
        try {
            thread.join();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private boolean isReservedVariable(IVariable variable) {
        String[] stringArray = Constants.reservedVariableNames;
        int n = Constants.reservedVariableNames.length;
        int n2 = 0;
        while (n2 < n) {
            String reservedVar = stringArray[n2];
            if (variable.getName().equalsIgnoreCase(reservedVar)) {
                return true;
            }
            ++n2;
        }
        stringArray = Constants.reservedVariableSuffixes;
        n = Constants.reservedVariableSuffixes.length;
        n2 = 0;
        while (n2 < n) {
            String reservedSuffix = stringArray[n2];
            if (variable.getName().toUpperCase().endsWith(reservedSuffix.toUpperCase())) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private List<IVariable> mergeVariableLists(List<IVariable> defaultList, List<IVariable> newOrChangedList) {
        if (defaultList != null && newOrChangedList != null) {
            ArrayList<IVariable> merged = new ArrayList<IVariable>();
            ArrayList<IVariable> defaultListCopy = new ArrayList<IVariable>();
            defaultListCopy.addAll(defaultList);
            block0: for (IVariable defaultVar : defaultList) {
                for (IVariable changedVar : newOrChangedList) {
                    if (!changedVar.getName().equals(defaultVar.getName())) continue;
                    defaultListCopy.remove(defaultVar);
                    continue block0;
                }
            }
            merged.addAll(newOrChangedList);
            merged.addAll(defaultListCopy);
            return merged;
        }
        return newOrChangedList;
    }

    private void updateDefaultLangDef(boolean hasUUID, String currentUUID) {
        if (this.fTeamRepository == null) {
            this.errorStatus = new Status(1, "com.ibm.team.enterprise.build.ui", Messages.BUILD_MEMBER_WIZARD_FILE_NOT_SHARED_WARNING);
        } else {
            if (!hasUUID) {
                this.resolveExtensions = new ResolveLangDefExtensionsJob(hasUUID, currentUUID);
                this.resolveExtensions.schedule();
                this.clearButton.setEnabled(false);
                this.loadButton.setEnabled(false);
                this.browseButton.setEnabled(false);
                return;
            }
            this.isUsingDefault = false;
            this.defaultLangDefLabel.setVisible(this.isUsingDefault);
            this.clearButton.setEnabled(!this.isUsingDefault);
            if (hasUUID) {
                this.fLanguageDefField.setText(Messages.EnterpriseMetadataPropertiesPage_PENDING);
                this.fLanguageDefUUID = this.isUsingDefault ? null : currentUUID;
                LanguageDefinitionLabelHelper labelHelper = this.getLabelHelper();
                ISystemDefinitionContext context = this.getLanguageDefinitionContext(currentUUID);
                labelHelper.getLanguageDefinitionLabelInBackground(context);
            }
        }
    }

    private void setLangDef(ILanguageDefinition languageDefinition) {
        this.languageDefinition = languageDefinition;
    }

    private ILanguageDefinition getLangDef() {
        return this.languageDefinition;
    }

    protected LanguageDefinitionLabelHelper getLabelHelper() {
        return new LanguageDefinitionLabelHelper(){

            @Override
            public void labelAvailable(String label, String langdefUUID) {
                if (!EnterpriseShareableMetadataPropertiesComposite.this.fLanguageDefField.isDisposed()) {
                    if (langdefUUID != null) {
                        EnterpriseShareableMetadataPropertiesComposite.this.fetchLangdefInBackground(langdefUUID);
                        if (EnterpriseShareableMetadataPropertiesComposite.this.getLangDef() != null) {
                            label = EnterpriseShareableMetadataPropertiesComposite.this.getLanguageDefFldText(label, EnterpriseShareableMetadataPropertiesComposite.this.getLangDef().getProjectArea().getItemId());
                        }
                    }
                    if (label.length() > 0) {
                        EnterpriseShareableMetadataPropertiesComposite.this.setLDTitleLinkEnablement(true);
                    }
                    EnterpriseShareableMetadataPropertiesComposite.this.fLanguageDefField.setText(label);
                }
            }
        };
    }

    protected ISystemDefinitionContext getLanguageDefinitionContext(final String langdefUUID) {
        return new ISystemDefinitionContext(){

            public String getSystemDefinitionUUID() {
                return langdefUUID;
            }

            public ITeamRepository getTeamRepository() {
                return EnterpriseShareableMetadataPropertiesComposite.this.fTeamRepository;
            }

            public IProjectAreaHandle getProjectArea() {
                return null;
            }
        };
    }

    @Override
    public Properties getProperties() {
        Properties props = new Properties();
        if (this.fLanguageDefUUID != null) {
            props.put("team.enterprise.language.definition", this.fLanguageDefUUID);
        } else {
            this.fRemovedProperties.add("team.enterprise.language.definition");
        }
        if (this.hasLoadChanged) {
            props.put("team.enterprise.build.alwaysload", Boolean.toString(this.isLoadAlways));
        }
        for (IVariable var : this.fNewOrChangedVariables) {
            props.put("team.enterprise.build.var." + var.getName(), var.getValue());
        }
        return props;
    }

    public Properties getRemovedProperties() {
        Properties props = new Properties();
        for (IVariable var : this.fRemovedVariables) {
            props.put("team.enterprise.build.var." + var.getName(), var.getValue());
        }
        for (String prop : this.fRemovedProperties) {
            props.put(prop, "");
        }
        return props;
    }

    public IStatus getErrorStatus() {
        return this.errorStatus;
    }

    private final void createVariablesGroup(Composite subGroup) {
        this.createSpacer(this, 5, 4);
        Group variableGroup = new Group(subGroup, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 4;
        GridData grid = new GridData(768);
        grid.horizontalSpan = 4;
        variableGroup.setLayout((Layout)layout);
        variableGroup.setText(Messages.EnterpriseFileMetadataPropertiesComposite_VariablesGroupLabel);
        variableGroup.setLayoutData((Object)grid);
        Label desc = new Label((Composite)variableGroup, 0);
        desc.setText(Messages.EnterpriseFileMetadataPropertiesComposite_VariablesGroupDesc);
        desc.setLayoutData((Object)grid);
        this.createVariableTable((Composite)variableGroup);
    }

    private void createVariableTable(Composite parent) {
        Composite tableComposite = new Composite(parent, 0);
        GridDataFactory.fillDefaults().grab(true, true).span(3, 1).applyTo((Control)tableComposite);
        GridLayoutFactory.fillDefaults().numColumns(1).applyTo(tableComposite);
        Table table = new Table(tableComposite, 68352);
        GridDataFactory.fillDefaults().hint(200, table.getItemHeight() * 20).grab(true, true).applyTo((Control)table);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        String[] columnHeaders = new String[]{Messages.EnterpriseFileMetadataPropertiesComposite_NameColumn, Messages.EnterpriseFileMetadataPropertiesComposite_ValueColumn};
        int[] columnWeights = new int[]{50, 50};
        TableColumnLayout tcl = new TableColumnLayout();
        this.fVariableTableViewer = new TableViewer(table);
        this.fVariableTableViewer.setContentProvider((IContentProvider)new VariableContentProvider());
        this.fVariableTableViewer.setLabelProvider((IBaseLabelProvider)new VariableLabelProvider());
        this.fVariableTableViewer.getTable().setSortDirection(128);
        int i = 0;
        while (i < columnHeaders.length) {
            TableColumn column = new TableColumn(table, 0);
            column.setText(columnHeaders[i]);
            tcl.setColumnData((Widget)column, (ColumnLayoutData)new ColumnWeightData(columnWeights[i]));
            if (i == 0) {
                this.fVariableTableViewer.getTable().setSortColumn(column);
            }
            column.addSelectionListener(this.sortListener);
            ++i;
        }
        tableComposite.setLayout((Layout)tcl);
        this.fVariableTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                EnterpriseShareableMetadataPropertiesComposite.this.updateVariableButtonEnablement();
            }
        });
        this.fVariableTableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                ISelection selection = event.getSelection();
                if (!(selection instanceof IStructuredSelection)) {
                    return;
                }
                Object element = ((IStructuredSelection)selection).getFirstElement();
                if (element instanceof IVariable) {
                    IVariable variable = (IVariable)element;
                    EnterpriseShareableMetadataPropertiesComposite.this.editVariable(variable);
                }
            }
        });
        Composite buttonComposite = new Composite(parent, 0);
        GridDataFactory.swtDefaults().grab(false, false).applyTo((Control)buttonComposite);
        GridLayoutFactory.swtDefaults().numColumns(1).applyTo(buttonComposite);
        this.fAddVariableButton = new Button(buttonComposite, 8);
        this.fAddVariableButton.setText(Messages.EnterpriseFileMetadataPropertiesComposite_AddButton);
        this.fAddVariableButton.setEnabled(true);
        this.fAddVariableButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent event) {
            }

            public void widgetSelected(SelectionEvent event) {
                try {
                    CreateVariableDialog dialog = new CreateVariableDialog(EnterpriseShareableMetadataPropertiesComposite.this.getShell(), null, EnterpriseShareableMetadataPropertiesComposite.this.fMergedVariables, Messages.EnterpriseFileMetadataPropertiesComposite_CreateVariableTitle, Messages.EnterpriseFileMetadataPropertiesComposite_CreateVariableDescription);
                    if (dialog.open() == 0) {
                        IVariable newVariable = dialog.getVariable();
                        List currentList = ((VariableContentProvider)EnterpriseShareableMetadataPropertiesComposite.this.fVariableTableViewer.getContentProvider()).getVariableList();
                        if (currentList != null) {
                            currentList.add(newVariable);
                            EnterpriseShareableMetadataPropertiesComposite.this.fNewOrChangedVariables.add(newVariable);
                        }
                        EnterpriseShareableMetadataPropertiesComposite.this.fVariableTableViewer.refresh();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        this.fEditVariableButton = new Button(buttonComposite, 8);
        this.fEditVariableButton.setText(Messages.EnterpriseFileMetadataPropertiesComposite_EditButton);
        this.fEditVariableButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent event) {
            }

            public void widgetSelected(SelectionEvent event) {
                IVariable initialVariable = null;
                Object tableSelection = ((StructuredSelection)EnterpriseShareableMetadataPropertiesComposite.this.fVariableTableViewer.getSelection()).getFirstElement();
                if (tableSelection instanceof IVariable) {
                    initialVariable = (IVariable)tableSelection;
                }
                if (initialVariable != null) {
                    EnterpriseShareableMetadataPropertiesComposite.this.editVariable(initialVariable);
                }
            }
        });
        this.fRemoveVariableButton = new Button(buttonComposite, 8);
        this.fRemoveVariableButton.setText(Messages.EnterpriseFileMetadataPropertiesComposite_RemoveButton);
        this.fRemoveVariableButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent event) {
            }

            public void widgetSelected(SelectionEvent event) {
                ISelection selection = EnterpriseShareableMetadataPropertiesComposite.this.fVariableTableViewer.getSelection();
                Object selectionObject = ((StructuredSelection)selection).getFirstElement();
                if (selectionObject instanceof IVariable) {
                    IVariable variableObject = (IVariable)selectionObject;
                    List variableList = ((VariableContentProvider)EnterpriseShareableMetadataPropertiesComposite.this.fVariableTableViewer.getContentProvider()).getVariableList();
                    if (variableList.contains(variableObject) && EnterpriseShareableMetadataPropertiesComposite.this.fNewOrChangedVariables != null && EnterpriseShareableMetadataPropertiesComposite.this.fNewOrChangedVariables.contains(variableObject)) {
                        variableList.remove(variableObject);
                        EnterpriseShareableMetadataPropertiesComposite.this.fNewOrChangedVariables.remove(variableObject);
                        EnterpriseShareableMetadataPropertiesComposite.this.fRemovedVariables.add(variableObject);
                        EnterpriseShareableMetadataPropertiesComposite.this.fVariableTableViewer.refresh();
                    }
                }
            }
        });
        this.fRestoreDefaultButton = new Button(buttonComposite, 8);
        this.fRestoreDefaultButton.setText(Messages.EnterpriseFileMetadataPropertiesComposite_RestoreDefaultButton);
        this.fRestoreDefaultButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent event) {
            }

            public void widgetSelected(SelectionEvent event) {
                ISelection selection = EnterpriseShareableMetadataPropertiesComposite.this.fVariableTableViewer.getSelection();
                Object selectionObject = ((StructuredSelection)selection).getFirstElement();
                if (selectionObject instanceof IVariable) {
                    IVariable variableObject = (IVariable)selectionObject;
                    List variableList = ((VariableContentProvider)EnterpriseShareableMetadataPropertiesComposite.this.fVariableTableViewer.getContentProvider()).getVariableList();
                    if (variableList.contains(variableObject) && EnterpriseShareableMetadataPropertiesComposite.this.overridesTranslatorVariable(variableObject)) {
                        EnterpriseShareableMetadataPropertiesComposite.this.fNewOrChangedVariables.remove(variableObject);
                        EnterpriseShareableMetadataPropertiesComposite.this.fRemovedVariables.add(variableObject);
                        variableObject.setValue(EnterpriseShareableMetadataPropertiesComposite.this.getOriginalValue(variableObject));
                        EnterpriseShareableMetadataPropertiesComposite.this.updateVariablesTable(null, EnterpriseShareableMetadataPropertiesComposite.this.fLanguageDefUUID);
                        EnterpriseShareableMetadataPropertiesComposite.this.updateVariableButtonEnablement();
                        EnterpriseShareableMetadataPropertiesComposite.this.fVariableTableViewer.refresh();
                    }
                }
            }
        });
        this.updateVariableButtonEnablement();
        GC gc = new GC((Drawable)this.fAddVariableButton);
        gc.setFont(this.fAddVariableButton.getFont());
        FontMetrics fontMetrics = gc.getFontMetrics();
        gc.dispose();
        int maxWidth = Dialog.convertHorizontalDLUsToPixels((FontMetrics)fontMetrics, (int)61);
        Point minSize = this.fAddVariableButton.computeSize(-1, -1, true);
        maxWidth = Math.max(maxWidth, minSize.x);
        minSize = this.fRemoveVariableButton.computeSize(-1, -1, true);
        maxWidth = Math.max(maxWidth, minSize.x);
        minSize = this.fEditVariableButton.computeSize(-1, -1, true);
        maxWidth = Math.max(maxWidth, minSize.x);
        minSize = this.fRestoreDefaultButton.computeSize(-1, -1, true);
        maxWidth = Math.max(maxWidth, minSize.x);
        GridData gridData = new GridData(128);
        gridData.widthHint = maxWidth;
        this.fAddVariableButton.setLayoutData((Object)gridData);
        gridData = new GridData(128);
        gridData.widthHint = maxWidth;
        this.fRemoveVariableButton.setLayoutData((Object)gridData);
        gridData = new GridData(128);
        gridData.widthHint = maxWidth;
        this.fEditVariableButton.setLayoutData((Object)gridData);
        gridData = new GridData(128);
        gridData.widthHint = maxWidth;
        this.fRestoreDefaultButton.setLayoutData((Object)gridData);
        this.fVariableTableViewer.setComparator((ViewerComparator)new EnterpriseVariableComparator(this.createComparator(true), true));
    }

    private void updateVariableButtonEnablement() {
        IStructuredSelection selection = (IStructuredSelection)this.fVariableTableViewer.getSelection();
        this.fEditVariableButton.setEnabled(selection.size() == 1);
        this.fRemoveVariableButton.setEnabled(!selection.isEmpty());
        this.fRestoreDefaultButton.setEnabled(selection.size() == 1);
        if (selection.getFirstElement() instanceof IVariable) {
            IVariable selectedVar = (IVariable)selection.getFirstElement();
            this.fRemoveVariableButton.setEnabled(this.fRemoveVariableButton.isEnabled() && this.fNewOrChangedVariables.contains(selectedVar) && !this.overridesTranslatorVariable(selectedVar));
            this.fRestoreDefaultButton.setEnabled(this.fRestoreDefaultButton.isEnabled() && this.overridesTranslatorVariable(selectedVar));
        }
    }

    private void editVariable(IVariable variable) {
        CreateVariableDialog dialog = new CreateVariableDialog(this.getShell(), variable, this.fMergedVariables, this.isTranslatorVariable(variable) || this.overridesTranslatorVariable(variable), Messages.EnterpriseFileMetadataPropertiesComposite_EditVariableTitle, Messages.EnterpriseFileMetadataPropertiesComposite_EditVariableDescription);
        if (dialog.open() == 0) {
            IVariable var = dialog.getVariable();
            if (!this.fNewOrChangedVariables.contains(var)) {
                this.fNewOrChangedVariables.add(var);
            }
            this.fRemovedVariables.remove(var);
            if (!dialog.getOriginalName().equalsIgnoreCase(var.getName())) {
                Variable oldVar = ModelFactory.eINSTANCE.createVariable();
                oldVar.setName(dialog.getOriginalName());
                this.fRemovedVariables.add((IVariable)oldVar);
            }
            this.updateVariablesTable(null, this.fLanguageDefUUID);
            this.updateVariableButtonEnablement();
            this.fVariableTableViewer.refresh();
        }
    }

    private boolean isTranslatorVariable(IVariable variable) {
        String varName = variable.getName();
        boolean overrides = false;
        if (this.fDefaultTranslatorVariables != null) {
            for (IVariable var : this.fDefaultTranslatorVariables) {
                if (!var.getName().equals(varName)) continue;
                overrides = true;
                break;
            }
        }
        return overrides;
    }

    private boolean overridesTranslatorVariable(IVariable variable) {
        String varName = variable.getName();
        String varValue = variable.getValue();
        boolean overrides = true;
        if (this.fDefaultTranslatorVariables != null) {
            for (IVariable var : this.fDefaultTranslatorVariables) {
                if (!var.getName().equals(varName) || !var.getValue().equals(varValue)) continue;
                overrides = false;
            }
        }
        return overrides;
    }

    private String getOriginalValue(IVariable variable) {
        if (this.overridesTranslatorVariable(variable)) {
            String varName = variable.getName();
            if (this.fDefaultTranslatorVariables != null) {
                for (IVariable var : this.fDefaultTranslatorVariables) {
                    if (!var.getName().equals(varName)) continue;
                    return var.getValue();
                }
            }
        }
        return variable.getValue();
    }

    private List<IVariable> getPropertyVariables(IMetadata metadata) {
        IMetadataProperties props;
        ArrayList<IVariable> variables = new ArrayList<IVariable>();
        if (metadata instanceof Metadata && (props = ((Metadata)metadata).getVersionableProperties()) != null) {
            Set keys = props.getCurrentProperties().keySet();
            for (String key : keys) {
                if (!key.startsWith("team.enterprise.build.var.")) continue;
                Variable variable = ModelFactory.eINSTANCE.createVariable();
                variable.setName(key.substring("team.enterprise.build.var.".length()));
                variable.setValue(metadata.getProperty(key));
                variables.add((IVariable)variable);
            }
        }
        return variables;
    }

    protected void createSpacer(Composite parent, int height, int horizontalSpan) {
        Label label = new Label(parent, 0);
        GridData tableWrapData = new GridData(1, horizontalSpan);
        tableWrapData.heightHint = height;
        label.setLayoutData((Object)tableWrapData);
    }

    private void updateVariablesTable(IMetadata metadata, String langDefUUID) {
        if (metadata != null) {
            this.fNewOrChangedVariables = this.getPropertyVariables(metadata);
        }
        if (langDefUUID == null) {
            langDefUUID = this.fLanguageDefUUID;
        }
        this.getVariablesFromTranslators(langDefUUID);
        this.fMergedVariables = this.mergeVariableLists(this.duplicateVariableList(this.fDefaultTranslatorVariables), this.fNewOrChangedVariables);
        this.fVariableTableViewer.setInput(this.fMergedVariables);
    }

    private List<IVariable> duplicateVariableList(List<IVariable> varList) {
        ArrayList<IVariable> listCopy = new ArrayList<IVariable>();
        if (varList != null) {
            for (IVariable v : varList) {
                listCopy.add(this.newCopy(v));
            }
        }
        return listCopy;
    }

    public String getContextHelpId() {
        return "com.ibm.team.build.ui.properties_enterpriseextensionsfile";
    }

    protected SelectionListener getLDLinkListener() {
        return new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                EnterpriseShareableMetadataPropertiesComposite.this.openLDEditor();
            }
        };
    }

    protected void openLDEditor() {
        if (this.fLanguageDefUUID != null) {
            this.openLDEditor(this.fLanguageDefUUID);
        } else {
            OpenDefaultLangDefJob job = new OpenDefaultLangDefJob();
            job.schedule();
        }
    }

    private void openLDEditor(String uuid) {
        if (uuid == null || uuid.isEmpty()) {
            return;
        }
        try {
            ISystemDefinitionModelClient client = (ISystemDefinitionModelClient)this.fTeamRepository.getClientLibrary(ISystemDefinitionModelClient.class);
            ILanguageDefinition langDef = (ILanguageDefinition)client.findSystemDefinitionComplete(uuid, null, ILanguageDefinition.ITEM_TYPE, null);
            IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            if (window != null) {
                IWorkbenchPage page = window.getActivePage();
                String projectAreaUUID = langDef.getProjectArea().getItemId().getUuidValue();
                IProjectAreaHandle itemHandle = (IProjectAreaHandle)IProjectArea.ITEM_TYPE.createItemHandle((Object)this.fTeamRepository, UUID.valueOf((String)projectAreaUUID), null);
                if (langDef instanceof IZosLanguageDefinition) {
                    com.ibm.team.enterprise.zos.internal.systemdefinition.ui.domain.actions.EditSystemDefinitionActionDelegate.run((ISystemDefinition)langDef, (IProjectAreaHandle)itemHandle, (IWorkbenchPage)page, (boolean)true, (boolean)true);
                } else if (langDef instanceof IIBMiLanguageDefinition) {
                    EditSystemDefinitionActionDelegate.run((ISystemDefinition)langDef, (IProjectAreaHandle)itemHandle, (IWorkbenchPage)page, (boolean)true, (boolean)true);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void setLDTitleLinkEnablement(boolean enabled) {
        this.LDTitleLink.setEnabled(enabled);
    }

    private IVariable newCopy(IVariable v) {
        Variable variable = ModelFactory.eINSTANCE.createVariable();
        variable.setName(v.getName());
        variable.setValue(v.getValue());
        return variable;
    }

    private void fetchLangdefInBackground(final String langdefUUID) {
        Thread thread = new Thread(){

            @Override
            public void run() {
                try {
                    ISystemDefinitionModelClient sysDefClient = (ISystemDefinitionModelClient)EnterpriseShareableMetadataPropertiesComposite.this.fTeamRepository.getClientLibrary(ISystemDefinitionModelClient.class);
                    ILanguageDefinition ld = (ILanguageDefinition)sysDefClient.findSystemDefinitionComplete(langdefUUID, null, ILanguageDefinition.ITEM_TYPE, null);
                    EnterpriseShareableMetadataPropertiesComposite.this.setLangDef(ld);
                }
                catch (TeamRepositoryException e) {
                    e.printStackTrace();
                    EnterpriseShareableMetadataPropertiesComposite.this.setLDTitleLinkEnablement(false);
                }
            }
        };
        thread.start();
        try {
            thread.join();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public void setDefinitionsItemType(IItemType itemType) {
        this.fDefinitionType = itemType;
    }

    public void setDefinitionsFilter(ViewerFilter filter) {
        this.fDialogFilter = filter;
    }

    public void setDefinitionsFetchingProperties(String[] properties) {
        this.fDialogFetchProperties = properties;
    }

    public void clearSorting() {
        if (this.fVariableTableViewer != null) {
            this.fVariableTableViewer.setComparator(null);
        }
    }

    private void handleSorting(SelectionEvent event) {
        TableColumn sortColumn = (TableColumn)event.widget;
        boolean ascending = this.updateSortOrderIndication(sortColumn);
        Comparator<Object> comparator = this.createComparator(ascending);
        this.fVariableTableViewer.setComparator((ViewerComparator)new EnterpriseVariableComparator(comparator, sortColumn.getText().compareTo(Messages.EnterpriseFileMetadataPropertiesComposite_NameColumn) == 0));
    }

    private boolean updateSortOrderIndication(Object sortColumn) {
        Table table = this.fVariableTableViewer.getTable();
        TableColumn previous = table.getSortColumn() != null ? table.getSortColumn() : null;
        int i = 0;
        while (i < table.getColumnCount()) {
            TableColumn tableColumn = table.getColumn(i);
            if (sortColumn != null && tableColumn != null && sortColumn.equals(tableColumn)) {
                table.setSortColumn(tableColumn);
                if (previous != null && previous.equals(sortColumn)) {
                    int direction = table.getSortDirection();
                    table.setSortDirection(direction == 1024 || direction == 0 ? 128 : 1024);
                } else {
                    table.setSortDirection(128);
                }
                return table.getSortDirection() == 128;
            }
            ++i;
        }
        return true;
    }

    private Comparator<Object> createComparator(final boolean ascending) {
        Comparator<Object> comparator = new Comparator<Object>(){

            @Override
            public int compare(Object o1, Object o2) {
                Collator collator = Collator.getInstance((Locale)Locale.getDefault());
                return ascending ? collator.compare(o1, o2) : collator.compare(o2, o1);
            }
        };
        return comparator;
    }

    class OpenDefaultLangDefJob
    extends TeamBuildJob {
        private String fResolvedUUID;

        OpenDefaultLangDefJob() {
            super(Messages.LanguageDefinitionLabelHelper_JOB_LABEL, false);
        }

        protected IStatus runProtected(IProgressMonitor monitor) throws Exception {
            ISystemDefinitionModelClient systemDefClient = (ISystemDefinitionModelClient)EnterpriseShareableMetadataPropertiesComposite.this.fTeamRepository.getClientLibrary(ISystemDefinitionModelClient.class);
            try {
                ILanguageDefinition defaultLD = systemDefClient.getDefaultLanguageDefinition(EnterpriseShareableMetadataPropertiesComposite.this.fShareable.getLocalPath().toString(), monitor);
                if (defaultLD != null) {
                    this.fResolvedUUID = defaultLD.getItemId().getUuidValue();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return Status.OK_STATUS;
        }

        protected void jobFinished(IStatus status) {
            if (this.fResolvedUUID != null) {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        EnterpriseShareableMetadataPropertiesComposite.this.openLDEditor(OpenDefaultLangDefJob.this.fResolvedUUID);
                    }
                });
            }
        }
    }

    class ResolveLangDefExtensionsJob
    extends TeamBuildJob {
        private boolean hasUUID;
        private String currentUUID;

        ResolveLangDefExtensionsJob(boolean hasUUID, String currentUUID) {
            super(Messages.ResolveLanguageDefinitionJob_JOB_LABEL, false);
            this.hasUUID = hasUUID;
            this.currentUUID = currentUUID;
        }

        protected IStatus runProtected(IProgressMonitor monitor) throws Exception {
            ISystemDefinitionModelClient systemDefClient = (ISystemDefinitionModelClient)EnterpriseShareableMetadataPropertiesComposite.this.fTeamRepository.getClientLibrary(ISystemDefinitionModelClient.class);
            try {
                ILanguageDefinition defaultLD = systemDefClient.getDefaultLanguageDefinition(EnterpriseShareableMetadataPropertiesComposite.this.fShareable.getLocalPath().toString(), monitor);
                if (defaultLD != null) {
                    String langDefValueText = defaultLD.getItemId().getUuidValue();
                    boolean bl = this.hasUUID = langDefValueText != null && langDefValueText.length() > 0;
                    if (this.hasUUID) {
                        EnterpriseShareableMetadataPropertiesComposite.this.isUsingDefault = true;
                        this.currentUUID = langDefValueText;
                        EnterpriseShareableMetadataPropertiesComposite.this.getDisplay().syncExec(new Runnable(){

                            @Override
                            public void run() {
                                EnterpriseShareableMetadataPropertiesComposite.this.updateVariablesTable(null, ResolveLangDefExtensionsJob.this.currentUUID);
                            }
                        });
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return Status.OK_STATUS;
        }

        protected void jobFinished(IStatus status) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    ((ResolveLangDefExtensionsJob)ResolveLangDefExtensionsJob.this).EnterpriseShareableMetadataPropertiesComposite.this.loadButton.setEnabled(true);
                    EnterpriseShareableMetadataPropertiesComposite.this.browseButton.setEnabled(true);
                    EnterpriseShareableMetadataPropertiesComposite.this.defaultLangDefLabel.setVisible(EnterpriseShareableMetadataPropertiesComposite.this.isUsingDefault);
                    EnterpriseShareableMetadataPropertiesComposite.this.clearButton.setEnabled(!EnterpriseShareableMetadataPropertiesComposite.this.isUsingDefault);
                    if (ResolveLangDefExtensionsJob.this.hasUUID) {
                        ((ResolveLangDefExtensionsJob)ResolveLangDefExtensionsJob.this).EnterpriseShareableMetadataPropertiesComposite.this.fLanguageDefField.setText(Messages.EnterpriseMetadataPropertiesPage_PENDING);
                        EnterpriseShareableMetadataPropertiesComposite.this.setLDTitleLinkEnablement(false);
                        ((ResolveLangDefExtensionsJob)ResolveLangDefExtensionsJob.this).EnterpriseShareableMetadataPropertiesComposite.this.fLanguageDefUUID = EnterpriseShareableMetadataPropertiesComposite.this.isUsingDefault ? null : ResolveLangDefExtensionsJob.this.currentUUID;
                        LanguageDefinitionLabelHelper labelHelper = EnterpriseShareableMetadataPropertiesComposite.this.getLabelHelper();
                        ISystemDefinitionContext context = EnterpriseShareableMetadataPropertiesComposite.this.getLanguageDefinitionContext(ResolveLangDefExtensionsJob.this.currentUUID);
                        labelHelper.getLanguageDefinitionLabelInBackground(context);
                    }
                }
            });
        }
    }
}

