/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.build.ui.properties;

import com.ibm.team.build.common.model.IBuildDefinition;
import com.ibm.team.build.internal.ui.editors.builddefinition.BuildDefinitionEditorInput;
import com.ibm.team.build.ui.properties.AbstractBuildPropertyEditor;
import com.ibm.team.build.ui.properties.IBuildPropertyEditorContext;
import com.ibm.team.enterprise.build.common.IBuildUtility;
import com.ibm.team.enterprise.systemdefinition.client.ISystemDefinitionModelClient;
import com.ibm.team.enterprise.systemdefinition.common.model.IIBMiPlatformObject;
import com.ibm.team.enterprise.systemdefinition.common.model.IPlatformObject;
import com.ibm.team.enterprise.systemdefinition.common.model.ISearchPath;
import com.ibm.team.enterprise.systemdefinition.common.model.ISystemDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.ISystemDefinitionHandle;
import com.ibm.team.enterprise.systemdefinition.common.model.IZosPlatformObject;
import com.ibm.team.enterprise.systemdefinition.ui.dialogs.SearchPathSelectionDialog;
import com.ibm.team.enterprise.systemdefinition.ui.dialogs.SystemDefinitionSelectionDialog;
import com.ibm.team.process.common.IProcessAreaHandle;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.TeamRepositoryException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;

public abstract class AbstractPlatformBuildPropertyEditor
extends AbstractBuildPropertyEditor {
    private IProcessAreaHandle processAreaHandle;
    protected Class<? extends IPlatformObject> platform;

    protected abstract IItemType getType();

    public boolean editProperty(IBuildPropertyEditorContext context) {
        try {
            ISystemDefinitionHandle systemDefinitionHandle;
            Object dlg = this.getType().equals(ISearchPath.ITEM_TYPE) ? new SearchPathSelectionDialog(context.getShell(), context.getTeamRepository(), null) : new SystemDefinitionSelectionDialog(context.getShell(), context.getTeamRepository(), this.getType());
            if (dlg.open() == 0 && (systemDefinitionHandle = (ISystemDefinitionHandle)dlg.getFirstResult()) != null) {
                context.getProperty().setValue(systemDefinitionHandle.getItemId().getUuidValue());
                return true;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
        return false;
    }

    public String getPropertyValueLabel(IBuildPropertyEditorContext context, IProgressMonitor monitor) throws TeamRepositoryException {
        String uuid = context.getProperty().getValue();
        if (uuid.length() > 0) {
            ISystemDefinitionModelClient sysDefClient = (ISystemDefinitionModelClient)context.getTeamRepository().getClientLibrary(ISystemDefinitionModelClient.class);
            ISystemDefinition sysdef = sysDefClient.findSystemDefinition(uuid, null, this.getType(), null);
            if (sysdef != null) {
                return sysdef.getName();
            }
            return uuid;
        }
        return uuid;
    }

    public Class<? extends IPlatformObject> getPlatform() {
        if (this.platform == null) {
            this.platform = this.resolvePlatform();
        }
        return this.platform;
    }

    public IProcessAreaHandle getProcessArea() {
        if (this.processAreaHandle == null) {
            this.processAreaHandle = this.resolveProjectAreaFromBuildDefinitionEditor();
        }
        return this.processAreaHandle;
    }

    protected Class<? extends IPlatformObject> resolvePlatform() {
        Class<? extends IPlatformObject> platform = this.resolvePlatformFromBuildDefinitionEditor();
        return platform;
    }

    protected Class<? extends IPlatformObject> resolvePlatformFromBuildDefinitionEditor() {
        try {
            IEditorPart part = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
            if (part.getEditorInput() instanceof BuildDefinitionEditorInput) {
                IBuildDefinition buildDefinition = ((BuildDefinitionEditorInput)part.getEditorInput()).getBuildDefinition();
                if (IBuildUtility.isIBMiDependencyBuild((IBuildDefinition)buildDefinition)) {
                    return IIBMiPlatformObject.class;
                }
                return IZosPlatformObject.class;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    protected IProcessAreaHandle resolveProjectAreaFromBuildDefinitionEditor() {
        try {
            IEditorPart part;
            System.out.println("one: " + (PlatformUI.getWorkbench() == null));
            if (PlatformUI.getWorkbench() != null) {
                System.out.println("two: ");
                if (PlatformUI.getWorkbench().getActiveWorkbenchWindow() != null) {
                    System.out.println("three: ");
                    if (PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage() != null) {
                        System.out.println("four");
                    }
                }
            }
            if ((part = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor()).getEditorInput() instanceof BuildDefinitionEditorInput) {
                IBuildDefinition buildDefinition = ((BuildDefinitionEditorInput)part.getEditorInput()).getBuildDefinition();
                return buildDefinition.getProcessArea();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }
}

