/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.build.ui.pickers;

import com.ibm.team.enterprise.build.ui.Activator;
import com.ibm.team.enterprise.internal.build.ui.nls.Messages;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.IShare;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.ISharingDescriptor;
import com.ibm.team.filesystem.rcp.core.internal.resources.ResourceUtil;
import com.ibm.team.foundation.common.util.Adapters;
import com.ibm.team.internal.filesystem.ui.labelproviders.ResourceLabelProvider;
import com.ibm.team.internal.filesystem.ui.queries.ResourceQuery;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.core.utils.CategoryComparator;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.repository.rcp.ui.internal.utils.SWTUtil;
import com.ibm.team.repository.rcp.ui.internal.viewers.ComparatorSorter;
import com.ibm.team.repository.rcp.ui.internal.viewers.ConcurrentTreeContentProvider;
import com.ibm.team.repository.rcp.ui.internal.viewers.ISetWithListeners;
import com.ibm.team.repository.rcp.ui.internal.viewers.ITreeProvider;
import com.ibm.team.repository.rcp.ui.operations.IOperationRunner;
import com.ibm.team.repository.rcp.ui.operations.IStatusCollector;
import com.ibm.team.repository.rcp.ui.operations.JobRunner;
import com.ibm.team.repository.rcp.ui.operations.Operation;
import com.ibm.team.repository.rcp.ui.operations.OperationFailedException;
import com.ibm.team.repository.rcp.ui.operations.RepositoryOperation;
import com.ibm.team.repository.rcp.ui.parts.WidgetToolkit;
import com.ibm.team.repository.rcp.ui.utils.MnemonicGenerator;
import com.ibm.team.repository.rcp.ui.utils.UIContext;
import com.ibm.team.repository.rcp.ui.utils.WidgetFactoryContext;
import java.util.Comparator;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerLabel;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;

public class NameByFilePicker {
    private IOperationRunner background;
    private Text textContent;
    private WritableValue validationStatus = new WritableValue();
    private Composite buttonBar;
    private Button clearButton;
    private Button browseButton;
    private IShareable selectedResource;

    public NameByFilePicker(Composite parent, WidgetFactoryContext context, Text destination) {
        this.validationStatus.setValue((Object)Status.OK_STATUS);
        WidgetToolkit toolkit = context.getToolkit();
        this.background = context.getBackgroundOperationRunner();
        MnemonicGenerator mg = context.getMnemonics();
        this.textContent = destination;
        this.buttonBar = toolkit.createComposite(parent);
        this.browseButton = toolkit.createButton(this.buttonBar, mg.generate(Messages.NameByFilePicker_BROWSE), 8);
        this.browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NameByFilePicker.this.doBrowse((IProgressMonitor)new NullProgressMonitor());
            }
        });
        this.clearButton = toolkit.createButton(this.buttonBar, mg.generate(Messages.NameByFilePicker_CLEAR), 8);
        this.clearButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NameByFilePicker.this.doClear();
            }
        });
        Dialog.applyDialogFont((Control)this.buttonBar);
        GridLayoutFactory.fillDefaults().numColumns(this.buttonBar.getChildren().length).generateLayout(this.buttonBar);
        GridData gridData = new GridData(1, 0x1000000, false, false, 1, 1);
        this.buttonBar.setLayoutData((Object)gridData);
        this.textContent.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                NameByFilePicker.this.onDispose();
            }
        });
        this.updatePath((IProgressMonitor)new NullProgressMonitor());
    }

    protected void doClear() {
        this.setItem("");
    }

    private void setItem(String string) {
        this.textContent.setText(string);
    }

    private void updatePath(IProgressMonitor monitor) {
        monitor.beginTask(Messages.NameByFilePicker_UPDATEMONITOR, 2);
        this.clearButton.setEnabled(this.textContent != null && !this.textContent.getText().equals(""));
        if (this.selectedResource == null) {
            this.doClear();
            monitor.done();
            return;
        }
        monitor.worked(1);
        final Display d = Display.getCurrent();
        this.background.enqueue(Messages.NameByFilePicker_COMPUTINGMONITOR, (Operation)new RepositoryOperation(){

            public void repositoryRun(final IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException, FileSystemException, OperationFailedException {
                SWTUtil.greedyExec((Display)d, (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (NameByFilePicker.this.textContent.isDisposed()) {
                            monitor.done();
                            return;
                        }
                        NameByFilePicker.this.textContent.setText(NameByFilePicker.this.selectedResource.getLocalPath().getName());
                    }
                });
            }
        });
        monitor.done();
    }

    protected void onDispose() {
    }

    protected void doBrowse(IProgressMonitor monitor) {
        monitor.beginTask(Messages.NameByFilePicker_BROWSINGMONITOR, 3);
        UIContext context = UIContext.createShellContext((Shell)this.browseButton.getShell());
        String finalPath = NameByFilePicker.browseWorkspaceMustExist(context, new ISelectionStatusValidator(){

            public IStatus validate(Object[] selection) {
                int i = 0;
                while (i < selection.length) {
                    Object next = selection[i];
                    if (next instanceof IResource) {
                        ISharingDescriptor descriptor;
                        IResource resource = (IResource)next;
                        IShareable shareable = (IShareable)Adapters.getAdapter((Object)resource, IShareable.class);
                        IShare share = null;
                        try {
                            share = shareable.getShare((IProgressMonitor)new NullProgressMonitor());
                        }
                        catch (FileSystemException e) {
                            Activator.getDefault().logError(e);
                        }
                        if (share != null && (descriptor = share.getSharingDescriptor()) != null && descriptor.getComponent() == null) {
                            return StatusUtil.newStatus((Object)this, (int)4, (String)"The selected item is not shared");
                        }
                    }
                    ++i;
                }
                return Status.OK_STATUS;
            }
        }, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        monitor.worked(1);
        if (finalPath != null) {
            IResource f = ResourceUtil.getResource((IPath)new Path(finalPath));
            this.selectedResource = (IShareable)Adapters.getAdapter((Object)f, IShareable.class);
            this.updatePath((IProgressMonitor)new SubProgressMonitor(monitor, 1));
        }
        monitor.done();
    }

    public IObservableValue getValidationStatus() {
        return this.validationStatus;
    }

    public void setEnabled(boolean enableChanges) {
        this.browseButton.setEnabled(enableChanges);
        this.clearButton.setEnabled(enableChanges);
    }

    public void setBrowseable(boolean enableChanges) {
        this.browseButton.setEnabled(enableChanges);
    }

    public void setClearable(boolean enableChanges) {
        this.clearButton.setEnabled(enableChanges);
    }

    public Control getButtonControl() {
        return this.buttonBar;
    }

    public static String browseWorkspaceMustExist(UIContext context, final ISelectionStatusValidator additionalValidator, IProgressMonitor monitor) {
        monitor.beginTask(Messages.NameByFilePicker_BROWSEMONITOR, 3);
        final JobRunner backgroundRunner = new JobRunner(false);
        String newFilename = null;
        ConcurrentTreeContentProvider tcp = new ConcurrentTreeContentProvider(new ITreeProvider(){

            public ISetWithListeners<?> getChildren(Object element) {
                if (element instanceof IFile) {
                    return null;
                }
                if (element instanceof IResource) {
                    return new ResourceQuery((IOperationRunner)backgroundRunner, (IResource)element);
                }
                return null;
            }
        });
        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(context.getShell(), (ILabelProvider)new ResourceLabelProvider(){

            public void updateLabel(ViewerLabel label, Object element) {
                if (element instanceof String) {
                    label.setText((String)element);
                    return;
                }
                super.updateLabel(label, element);
            }
        }, (ITreeContentProvider)tcp);
        dialog.setAllowMultiple(false);
        final String message = Messages.NameByFilePicker_MESSAGE;
        dialog.setMessage(message);
        dialog.setComparator((ViewerComparator)new ComparatorSorter((Comparator)new CategoryComparator<Object>(){

            protected int category(Object toTest) {
                if (toTest instanceof IContainer) {
                    return 1;
                }
                if (toTest instanceof IFile) {
                    return 2;
                }
                return 0;
            }

            protected int compareSameCategory(int category, Object e1, Object e2) {
                if (e1 instanceof IResource) {
                    return ((IResource)e1).getName().compareToIgnoreCase(((IResource)e2).getName());
                }
                return 0;
            }
        }));
        dialog.setTitle(Messages.NameByFilePicker_TITLE);
        dialog.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                return true;
            }
        });
        dialog.setValidator(new ISelectionStatusValidator(){

            public IStatus validate(Object[] selection) {
                if (selection.length == 0) {
                    return StatusUtil.newStatus((Object)this, (int)4, (String)message);
                }
                Object sel = selection[0];
                if (!(sel instanceof IFile)) {
                    return StatusUtil.newStatus((Object)this, (int)4, (String)message);
                }
                IStatus result = null;
                if (additionalValidator != null && (result = additionalValidator.validate(selection)) != null && !result.isOK()) {
                    return result;
                }
                return StatusUtil.newStatus((Object)this, (int)0, (String)"");
            }
        });
        monitor.worked(1);
        dialog.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
        dialog.open();
        IResource resource = (IResource)dialog.getFirstResult();
        if (resource != null) {
            newFilename = resource.getFullPath().toString();
        }
        monitor.done();
        return newFilename;
    }
}

