/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.build.ui.metadata.core.api;

import com.ibm.team.enterprise.build.ui.metadata.api.IMetadata;
import com.ibm.team.enterprise.build.ui.metadata.api.IMetadataFactory;
import com.ibm.team.enterprise.build.ui.metadata.api.IValidator;
import com.ibm.team.enterprise.build.ui.metadata.core.api.Metadata;
import com.ibm.team.enterprise.build.ui.metadata.core.validators.DefaultValidator;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.IShareable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;

public class MetadataFactory
implements IMetadataFactory {
    private static MetadataFactory instance = null;
    private IValidator defaultMetadataValidator = null;
    private HashMap<String, IConfigurationElement> metadataElementMap = null;

    protected MetadataFactory() {
    }

    public static MetadataFactory getInstance() {
        if (instance == null) {
            instance = new MetadataFactory();
        }
        return instance;
    }

    @Override
    public IMetadata getMetadata(File file) {
        return this.getMetadata(file, false);
    }

    public IMetadata getMetadata(IShareable shareable) {
        try {
            return new Metadata(shareable);
        }
        catch (FileSystemException e) {
            return null;
        }
    }

    @Override
    public IMetadata getContainerMetadata(File folder) {
        return this.getMetadata(folder, true);
    }

    private IMetadata getMetadata(File file, boolean isFolder) {
        try {
            return new Metadata(file, isFolder);
        }
        catch (FileNotFoundException e) {
            return null;
        }
        catch (IOException e) {
            return null;
        }
        catch (FileSystemException e) {
            return null;
        }
    }

    public IMetadata getMetadata(URI sourceFileURI) {
        return this.getMetadata(sourceFileURI, false);
    }

    public IMetadata getContainerMetadata(URI sourceFileURI) {
        return this.getMetadata(sourceFileURI, true);
    }

    public IMetadata getProjectMetadata(IProject project) {
        try {
            return new Metadata(project);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return null;
        }
        catch (FileSystemException e) {
            e.printStackTrace();
            return null;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private IMetadata getMetadata(URI sourceFileURI, boolean isFolder) {
        try {
            return new Metadata(sourceFileURI, isFolder);
        }
        catch (FileNotFoundException e) {
            return null;
        }
        catch (IOException e) {
            return null;
        }
        catch (FileSystemException e) {
            return null;
        }
    }

    public IValidator getDefaultMetadataValidator() {
        if (this.defaultMetadataValidator == null) {
            this.defaultMetadataValidator = new DefaultValidator();
        }
        return this.defaultMetadataValidator;
    }

    public IConfigurationElement getExtensionElement(String metadataKey) {
        if (this.metadataElementMap == null) {
            this.metadataElementMap = new HashMap();
        }
        if (this.metadataElementMap.isEmpty()) {
            this.loadExtensions();
        }
        if (!this.metadataElementMap.isEmpty()) {
            return this.metadataElementMap.get(metadataKey);
        }
        return null;
    }

    private void loadExtensions() {
        ArrayList<IConfigurationElement> metadataElementArray = new ArrayList<IConfigurationElement>();
        IExtensionPoint metadataExtensionPoint = Platform.getExtensionRegistry().getExtensionPoint("com.ibm.teamz.metadata.core.extension");
        IConfigurationElement[] points = metadataExtensionPoint.getConfigurationElements();
        int i = 0;
        while (i < points.length) {
            if (points[i].getName().equalsIgnoreCase("metadataElement")) {
                metadataElementArray.add(points[i]);
            }
            ++i;
        }
        for (IConfigurationElement element : metadataElementArray) {
            String elementKey = element.getAttribute("key");
            this.metadataElementMap.put(elementKey, element);
        }
    }
}

