/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.build.ui.metadata.api;

import com.ibm.team.enterprise.build.ui.metadata.api.IMetadata;
import com.ibm.team.enterprise.build.ui.metadata.api.IValidator;
import com.ibm.team.enterprise.build.ui.metadata.nls.Messages;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public abstract class AbstractMetadata
implements IMetadata {
    protected boolean allowBlank = false;

    @Override
    public IStatus setProperties(String metadataKey, List<String> metadataValues) {
        String compositeMetadataValue = new String();
        Iterator<String> valueIterator = metadataValues.iterator();
        while (valueIterator.hasNext()) {
            compositeMetadataValue = String.valueOf(compositeMetadataValue) + valueIterator.next();
            if (!valueIterator.hasNext()) continue;
            compositeMetadataValue = String.valueOf(compositeMetadataValue) + ", ";
        }
        return this.setProperty(metadataKey, compositeMetadataValue);
    }

    @Override
    public IStatus setProperties(Properties propertyMap) {
        return this.setClientProperties(propertyMap);
    }

    public IStatus setProperties(Properties propertyMap, boolean allowBlank) {
        this.allowBlank = allowBlank;
        return this.setProperties(propertyMap);
    }

    @Override
    public IStatus setProperty(String metadataKey, String metadataValue) {
        IValidator metadataValidator = this.getValidator(metadataKey);
        if (metadataValidator != null) {
            IStatus setStatus = metadataValidator.validate(metadataValue);
            if (setStatus.getCode() != 4) {
                this.setClientProperty(metadataKey, metadataValue);
            }
            return setStatus;
        }
        return new Status(4, "com.ibm.team.enterprise.build.ui", 0, Messages.AbstractMetadata_NO_VALIDATOR, null);
    }

    public IStatus setProperty(String metadataKey, String metadataValue, boolean allowBlank) {
        this.allowBlank = allowBlank;
        return this.setProperty(metadataKey, metadataValue);
    }

    protected abstract void setClientProperty(String var1, String var2);

    protected abstract IStatus setClientProperties(Properties var1);

    public abstract void removeVersionableClientProperties(Properties var1);
}

