/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.build.ui.editors.result.internal;

import com.ibm.team.build.internal.ui.jobs.TeamBuildJob;
import com.ibm.team.enterprise.internal.build.ui.utils.BuildReportUtil;
import com.ibm.team.enterprise.systemdefinition.client.ISystemDefinitionModelClient;
import com.ibm.team.enterprise.systemdefinition.common.model.ISystemDefinition;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.UUID;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.IWorkbenchPage;

public class OpenSystemDefinitionEditorJob
extends TeamBuildJob {
    private String fSysDefUUID = null;
    private String fSysDefStatusUUID = null;
    private String fSysDefType = null;
    private IWorkbenchPage fWorkbenchPage = null;
    private Map<String, ISystemDefinition> fSysDefCache;

    public OpenSystemDefinitionEditorJob(String name, boolean isUserInitiated, ITeamRepository teamRepository, String fSysDefUUID, String fSysDefStatusUUID, String fSysDefType, IWorkbenchPage fWorkbenchPage, Map<String, ISystemDefinition> fSysDefCache) {
        super(name, isUserInitiated, teamRepository);
        this.fSysDefUUID = fSysDefUUID;
        this.fSysDefStatusUUID = fSysDefStatusUUID;
        this.fSysDefType = fSysDefType;
        this.fWorkbenchPage = fWorkbenchPage;
        this.fSysDefCache = fSysDefCache;
    }

    protected IStatus runProtected(IProgressMonitor monitor) throws Exception {
        ISystemDefinition sysDef = BuildReportUtil.getSystemDefinition(this.fSysDefUUID, this.fSysDefStatusUUID, this.fSysDefType, this.fSysDefCache, this.getJobTeamRepository(), monitor);
        if (sysDef != null) {
            ISystemDefinitionModelClient client = (ISystemDefinitionModelClient)this.getJobTeamRepository().getClientLibrary(ISystemDefinitionModelClient.class);
            ISystemDefinition latestSysDef = client.findSystemDefinition(sysDef.getItemId().getUuidValue(), null, null, monitor);
            boolean isLatestSysDef = true;
            if (latestSysDef != null && !latestSysDef.getStateId().equals((Object)UUID.valueOf((String)this.fSysDefStatusUUID))) {
                isLatestSysDef = false;
            }
            IProjectAreaHandle itemHandle = (IProjectAreaHandle)IProjectArea.ITEM_TYPE.createItemHandle(sysDef.getProjectArea().getItemId(), null);
            IProjectArea projectArea = (IProjectArea)this.getJobTeamRepository().itemManager().fetchCompleteItem((IItemHandle)itemHandle, 0, monitor);
            BuildReportUtil.openSystemDefinitionEditor((IProjectAreaHandle)projectArea, sysDef, isLatestSysDef, this.fWorkbenchPage);
        }
        return Status.OK_STATUS;
    }
}

