/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.build.ui.editors.result.internal;

import com.ibm.team.enterprise.build.common.buildreport.BuildReportConstants;
import com.ibm.team.enterprise.build.ui.editors.result.internal.IBuildReportNode;
import com.ibm.team.enterprise.internal.build.ui.utils.BuildReportUtil;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.swt.graphics.Image;

public class BuildReportTreeNode
implements IBuildReportNode {
    private String fProjectName = null;
    private String fComponentName = null;
    private IBuildReportNode fParentNode = null;
    private List<IBuildReportNode> fChildren = null;
    private String fName = null;

    public BuildReportTreeNode(IBuildReportNode parentNode, String projectName, String componentName, List<IBuildReportNode> children) {
        this.fParentNode = parentNode;
        this.fProjectName = projectName;
        this.fComponentName = componentName;
        this.fName = String.valueOf(this.fProjectName) + "(" + this.fComponentName + ")";
        this.fChildren = children;
    }

    @Override
    public IBuildReportNode getParentNode() {
        return this.fParentNode;
    }

    @Override
    public void setParentNode(IBuildReportNode fParentNode) {
        this.fParentNode = fParentNode;
    }

    @Override
    public Image getColumnImage(int columnIndex) {
        return null;
    }

    @Override
    public String getColumnText(int columnIndex, boolean removePrefix, String prefix, boolean isFailed) {
        String result = null;
        if (columnIndex == 0) {
            result = this.fName;
        }
        return result;
    }

    public String getProjectName() {
        return this.fProjectName;
    }

    public String getComponentName() {
        return this.fComponentName;
    }

    @Override
    public List<IBuildReportNode> getChildren() {
        return this.fChildren;
    }

    @Override
    public void setChildren(List<IBuildReportNode> children) {
        this.fChildren = children;
    }

    public int hashCode() {
        int result = BuildReportConstants.HASHCODE_INITIAL;
        result = BuildReportUtil.hashCode((int)result, (Object)this.fProjectName);
        result = BuildReportUtil.hashCode((int)result, (Object)this.fParentNode);
        result = BuildReportUtil.hashCode((int)result, this.fChildren);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        boolean result = false;
        if (obj instanceof BuildReportTreeNode) {
            BuildReportTreeNode leafNode = (BuildReportTreeNode)obj;
            if ((this.fProjectName == null && leafNode.getProjectName() == null || this.fProjectName != null && this.fProjectName.equals(leafNode.getProjectName())) && (this.fProjectName == null && leafNode.getProjectName() == null || this.fProjectName != null && this.fProjectName.equals(leafNode.getProjectName())) && (this.fParentNode == null && leafNode.getParentNode() == null || this.fParentNode != null && this.fParentNode.equals(leafNode.getParentNode())) && (this.fChildren == null && leafNode.getChildren() == null || this.fChildren != null && this.fChildren.equals(leafNode.getChildren()))) {
                result = true;
            }
        }
        return result;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        if (this.fProjectName != null && this.fProjectName.length() > 0) {
            builder.append("Name: ").append(this.fProjectName);
        }
        if (this.fParentNode != null) {
            builder.append(" | Parent Node: ").append(this.fParentNode.getColumnText(0, false, null, false));
        }
        if (this.fChildren != null && this.fChildren.size() > 0) {
            builder.append(" | Children Nodes [");
            for (IBuildReportNode child : this.fChildren) {
                builder.append("\n{");
                builder.append(child);
                builder.append("}");
            }
            builder.deleteCharAt(builder.length() - 1);
            builder.append("\n]");
        }
        return builder.toString();
    }

    @Override
    public IBuildReportNode clone() throws CloneNotSupportedException {
        List<IBuildReportNode> children = this.getChildren();
        LinkedList<IBuildReportNode> outputChildren = new LinkedList<IBuildReportNode>();
        for (IBuildReportNode node : children) {
            outputChildren.add(node.clone());
        }
        BuildReportTreeNode clonedNode = new BuildReportTreeNode(null, this.getProjectName(), this.getComponentName(), outputChildren);
        for (IBuildReportNode node : outputChildren) {
            node.setParentNode(clonedNode);
        }
        return clonedNode;
    }
}

