/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.build.ui.editors.result.internal;

import com.ibm.team.build.internal.common.helper.TimeFormatHelper;
import com.ibm.team.enterprise.build.common.buildreport.BuildReportConstants;
import com.ibm.team.enterprise.build.common.buildreport.IReportBuildFile;
import com.ibm.team.enterprise.build.ui.editors.result.internal.IBuildReportNode;
import com.ibm.team.enterprise.internal.build.ui.utils.BuildReportUtil;
import java.util.List;
import org.eclipse.swt.graphics.Image;

public class BuildReportTreeLeafNode
implements IBuildReportNode {
    private IReportBuildFile fReportBuildFile = null;
    private IBuildReportNode fParentNode = null;

    public BuildReportTreeLeafNode(IBuildReportNode parentNode, IReportBuildFile reportBuildFile) {
        this.fParentNode = parentNode;
        this.fReportBuildFile = reportBuildFile;
    }

    @Override
    public List<IBuildReportNode> getChildren() {
        return null;
    }

    @Override
    public void setChildren(List<IBuildReportNode> children) {
    }

    @Override
    public IBuildReportNode getParentNode() {
        return this.fParentNode;
    }

    @Override
    public void setParentNode(IBuildReportNode parent) {
        this.fParentNode = parent;
    }

    @Override
    public Image getColumnImage(int columnIndex) {
        return null;
    }

    public IReportBuildFile getReportBuildFile() {
        return this.fReportBuildFile;
    }

    @Override
    public String getColumnText(int columnIndex, boolean removePrefix, String prefix, boolean isFailed) {
        String result = null;
        switch (columnIndex) {
            case 0: {
                result = this.fReportBuildFile.getBuildFileFullPath();
                if (!removePrefix || prefix == null || result == null || !result.startsWith(prefix) || result.length() <= prefix.length() + 1) break;
                result = result.substring(prefix.length() + 1);
                break;
            }
            case 1: {
                int reason = this.fReportBuildFile.getReasonCode();
                if (reason == -2) {
                    result = "N/A";
                    break;
                }
                result = String.valueOf(reason);
                break;
            }
            case 2: {
                result = this.fReportBuildFile.getLangDefName();
                break;
            }
            case 3: {
                result = this.fReportBuildFile.getOutputFullPath();
                break;
            }
            case 4: {
                if (!isFailed) break;
                int maxRC = this.fReportBuildFile.getMaxRC();
                if (maxRC == -1) {
                    result = "N/A";
                    break;
                }
                result = String.valueOf(maxRC);
                break;
            }
            case 5: {
                long timeStamp = this.fReportBuildFile.getOutputTimestamp();
                if (timeStamp <= 0L) {
                    result = "";
                    break;
                }
                result = TimeFormatHelper.getDateString((long)timeStamp);
                break;
            }
            case 6: {
                int maxRC = this.fReportBuildFile.getMaxRC();
                result = maxRC == -1 ? "N/A" : String.valueOf(maxRC);
            }
        }
        return result;
    }

    public int hashCode() {
        int result = BuildReportConstants.HASHCODE_INITIAL;
        result = BuildReportUtil.hashCode((int)result, (Object)this.fReportBuildFile);
        result = BuildReportUtil.hashCode((int)result, (Object)this.fParentNode);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        boolean result = false;
        if (obj instanceof BuildReportTreeLeafNode) {
            BuildReportTreeLeafNode leafNode = (BuildReportTreeLeafNode)obj;
            if (this.fReportBuildFile == null && leafNode.getReportBuildFile() == null || this.fReportBuildFile != null && this.fReportBuildFile.equals(leafNode.getReportBuildFile())) {
                result = true;
            }
        }
        return result;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        if (this.fParentNode != null) {
            builder.append("Parent Node: ").append(this.fParentNode.getColumnText(0, false, null, false));
        }
        if (this.fReportBuildFile != null) {
            builder.append(" | Build File \n\t[ ").append(this.fReportBuildFile).append("]");
        }
        return builder.toString();
    }

    @Override
    public IBuildReportNode clone() throws CloneNotSupportedException {
        return new BuildReportTreeLeafNode(null, this.getReportBuildFile());
    }
}

