/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.build.ui.editors.result;

import com.ibm.team.build.common.model.BuildStatus;
import com.ibm.team.build.common.model.IBuildResultContribution;
import com.ibm.team.build.ui.editors.result.AbstractBuildResultContributionProvider;
import com.ibm.team.build.ui.editors.result.AbstractBuildResultPage;
import com.ibm.team.build.ui.editors.result.IBuildResultContext;
import com.ibm.team.enterprise.build.client.buildablesubset.IBuildableSubsetClient;
import com.ibm.team.enterprise.build.ui.Activator;
import com.ibm.team.enterprise.build.ui.subset.EditSubsetActionDelegate;
import com.ibm.team.enterprise.buildablesubset.common.model.ISubset;
import com.ibm.team.enterprise.internal.build.ui.nls.Messages;
import com.ibm.team.process.internal.common.NLS;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.progress.UIJob;

public class MandatorySubsetContributionProvider
extends AbstractBuildResultContributionProvider {
    private static final String ZERO_LENGTH_STRING = "";
    private IBuildResultContribution[] fContributions;
    private String subsetLabel = "";
    private String url = "";
    private boolean isTransitory;

    public MandatorySubsetContributionProvider(FormEditor buildEditor, String extensionId, IBuildResultContext context) {
        super(buildEditor, extensionId, context);
    }

    public String[] getExtendedContributionIds() {
        return new String[]{"com.ibm.team.enterprise.build.mandatorySubset"};
    }

    public AbstractBuildResultPage getBuildResultPage() {
        return null;
    }

    public void initializeContributionProvider(IProgressMonitor monitor) throws Exception {
        this.fContributions = this.getContributions();
        if (this.fContributions != null && this.fContributions.length > 0) {
            IBuildResultContribution contribution = this.fContributions[0];
            this.subsetLabel = contribution.getLabel();
            this.url = contribution.getExtendedContributionProperty(IBuildResultContribution.PROPERTY_NAME_URL);
            this.isTransitory = Boolean.parseBoolean(contribution.getExtendedContributionProperty("team.enterprise.build.ant.mandatorySubsetIsTransitory"));
            if (this.isTransitory) {
                this.subsetLabel = NLS.bind((String)Messages.MandatorySubsetBuildResultColumn_TRANSITORY_LABEL, (Object)this.subsetLabel);
            }
        }
    }

    public String getSummaryText() {
        return this.subsetLabel;
    }

    public String getSummaryTitle() {
        return Messages.MandatorySubsetContributionProvider_SUMMARY_TITLE;
    }

    public BuildStatus getStatus() {
        return BuildStatus.INFO;
    }

    public boolean isSummaryLink() {
        return this.url != null && this.url.length() > 0 && !this.isTransitory;
    }

    public void summaryLinkActivated() {
        if (this.url != null && this.url.length() > 0 && !this.isTransitory) {
            new Job(ZERO_LENGTH_STRING){

                protected IStatus run(IProgressMonitor monitor) {
                    try {
                        IBuildableSubsetClient client = (IBuildableSubsetClient)MandatorySubsetContributionProvider.this.getBuildResultContext().getTeamRepository().getClientLibrary(IBuildableSubsetClient.class);
                        final ISubset subset = client.getSubsetItem(MandatorySubsetContributionProvider.this.url);
                        new UIJob(MandatorySubsetContributionProvider.ZERO_LENGTH_STRING){

                            public IStatus runInUIThread(IProgressMonitor monitor) {
                                EditSubsetActionDelegate.run(subset, MandatorySubsetContributionProvider.this.getBuildResultContext().getTeamRepository(), MandatorySubsetContributionProvider.this.getBuildResultContext().getBuildResultRecord().getProjectArea(), MandatorySubsetContributionProvider.this.getBuildResultEditor().getSite().getPage());
                                return Status.OK_STATUS;
                            }
                        }.schedule();
                    }
                    catch (Exception e) {
                        Activator.getDefault().logError(e);
                        new UIJob(MandatorySubsetContributionProvider.ZERO_LENGTH_STRING){

                            public IStatus runInUIThread(IProgressMonitor monitor) {
                                Status status = new Status(4, "com.ibm.team.enterprise.build.ui", Messages.BuildSubsetContributionProvider_ERROR_OPENING_SUBSET_MSG_REASON, (Throwable)e);
                                ErrorDialog.openError((Shell)MandatorySubsetContributionProvider.this.getBuildResultEditor().getSite().getShell(), (String)Messages.BuildSubsetContributionProvider_ERROR_OPENING_SUBSET_TITLE, (String)NLS.bind((String)Messages.BuildSubsetContributionProvider_ERROR_OPENING_SUBSET_MSG, (Object)MandatorySubsetContributionProvider.this.subsetLabel), (IStatus)status);
                                return Status.OK_STATUS;
                            }
                        }.schedule();
                    }
                    return Status.OK_STATUS;
                }
            }.schedule();
        }
    }
}

