/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.build.ui.editors.result;

import com.ibm.team.build.common.model.IBuildResultContribution;
import com.ibm.team.build.internal.ui.editors.result.BuildResultEditor;
import com.ibm.team.build.internal.ui.jobs.TeamBuildJob;
import com.ibm.team.enterprise.build.common.BuildableFileBuildResult;
import com.ibm.team.enterprise.build.common.buildreport.BuildReportCache;
import com.ibm.team.enterprise.build.ui.editors.result.BuildReportContentFilter;
import com.ibm.team.enterprise.build.ui.editors.result.BuildReportPage;
import com.ibm.team.enterprise.build.ui.editors.result.BuildReportStyledLabelProvider;
import com.ibm.team.enterprise.build.ui.editors.result.internal.BuildReportParser;
import com.ibm.team.enterprise.build.ui.editors.result.internal.BuildReportTreeNode;
import com.ibm.team.enterprise.common.ui.util.Utils;
import com.ibm.team.enterprise.internal.build.ui.nls.Messages;
import com.ibm.team.enterprise.internal.build.ui.utils.BuildReportUtil;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IContent;
import java.io.InputStream;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;

public class FetchBuildReportRootNodesJob
extends TeamBuildJob {
    private BuildResultEditor fEditor = null;
    private CTabFolder fTabFolder = null;
    private TreeViewer fViewer = null;
    private TreeViewer fFailedViewer = null;
    private TreeViewer fUnbuiltViewer = null;
    private BuildReportCache fCache = null;
    private ITeamRepository fTeamRepository = null;
    private IContent fBuildReportContent = null;
    private IContent fFailedBuildReportContent = null;
    private Button fPageNextBtn = null;
    private Button fPageTailBtn = null;
    private Label fBookMarkLabel = null;
    private BuildReportTreeNode[] fRootNodes = null;
    private boolean fNeedInputs = false;
    private String fResourcePrefix = null;
    private Map<BuildableFileBuildResult, Map<Integer, Integer>> fPageBookMap = null;
    private Map<BuildableFileBuildResult, AtomicInteger> fCurrentPageMap = null;
    private Composite fNavigatorComposite = null;
    private boolean fIsPersonal = false;
    private boolean fIsZos = false;
    private BuildReportStyledLabelProvider fLabelProvider = null;
    private BuildReportStyledLabelProvider fFailedLabelProvider = null;
    private BuildReportStyledLabelProvider fUnbuiltLabelProvider = null;
    private BuildReportParser fParser = null;
    private BuildReportContentFilter fFilter = null;
    private BuildableFileBuildResult fBuildResult = null;
    private BuildReportPage fBuildReportPage = null;

    public FetchBuildReportRootNodesJob(String name, boolean isUserInitiated, BuildResultEditor fEditor, CTabFolder fTabFolder, TreeViewer fViewer, TreeViewer fFailedViewer, TreeViewer fUnbuiltViewer, BuildReportCache fCache, ITeamRepository fTeamRepository, IContent fBuildReportContent, IContent fFailedBuildReportContent, Label fBookMarkLabel, Button fPageNextBtn, Button fPageTailBtn, boolean fNeedVersionID, String fResourcePrefix, Map<BuildableFileBuildResult, Map<Integer, Integer>> fPageBookMap, Map<BuildableFileBuildResult, AtomicInteger> fCurrentPageMap, Composite navigatorComp, boolean fIsPersonal, boolean fIsZos, BuildReportStyledLabelProvider fLabelProvider, BuildReportStyledLabelProvider fFailedLabelProvider, BuildReportStyledLabelProvider fUnbuiltLabelProvider, BuildReportContentFilter fFilter, BuildableFileBuildResult fBuildResult, BuildReportPage fBuildReportPage) {
        super(name, isUserInitiated);
        this.fEditor = fEditor;
        this.fTabFolder = fTabFolder;
        this.fViewer = fViewer;
        this.fFailedViewer = fFailedViewer;
        this.fUnbuiltViewer = fUnbuiltViewer;
        this.fCache = fCache;
        this.fTeamRepository = fTeamRepository;
        this.fBuildReportContent = fBuildReportContent;
        this.fFailedBuildReportContent = fFailedBuildReportContent;
        this.fPageNextBtn = fPageNextBtn;
        this.fPageTailBtn = fPageTailBtn;
        this.fBookMarkLabel = fBookMarkLabel;
        this.fNeedInputs = fNeedVersionID;
        this.fResourcePrefix = fResourcePrefix;
        this.fPageBookMap = fPageBookMap;
        this.fCurrentPageMap = fCurrentPageMap;
        this.fNavigatorComposite = navigatorComp;
        this.fIsPersonal = fIsPersonal;
        this.fIsZos = fIsZos;
        this.fLabelProvider = fLabelProvider;
        this.fFailedLabelProvider = fFailedLabelProvider;
        this.fUnbuiltLabelProvider = fUnbuiltLabelProvider;
        this.fBuildResult = fBuildResult;
        this.fBuildReportPage = fBuildReportPage;
    }

    protected IStatus runProtected(IProgressMonitor monitor) throws Exception {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                FetchBuildReportRootNodesJob.this.fEditor.setBusy(true);
            }
        });
        TeamBuildJob job = new TeamBuildJob("Fetch the build report data", true){

            protected IStatus runProtected(IProgressMonitor monitor) throws Exception {
                InputStream in;
                IBuildResultContribution[] contributions;
                if (FetchBuildReportRootNodesJob.this.fBuildReportContent == null && (contributions = FetchBuildReportRootNodesJob.this.fEditor.getBuildResultContributions(new String[]{IBuildResultContribution.ARTIFACT_EXTENDED_CONTRIBUTION_ID})).length > 0) {
                    IBuildResultContribution[] iBuildResultContributionArray = contributions;
                    int n = contributions.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IBuildResultContribution tempContribution = iBuildResultContributionArray[n2];
                        String fileName = tempContribution.getExtendedContributionProperty(IBuildResultContribution.PROPERTY_NAME_FILE_NAME);
                        if ("buildReport.xml".equals(fileName)) {
                            FetchBuildReportRootNodesJob.this.fBuildReportContent = tempContribution.getExtendedContributionData();
                        } else if ("failedBuildReport.xml".equals(fileName)) {
                            FetchBuildReportRootNodesJob.this.fFailedBuildReportContent = tempContribution.getExtendedContributionData();
                        }
                        ++n2;
                    }
                }
                if (FetchBuildReportRootNodesJob.this.fBuildReportContent == null) {
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            FetchBuildReportRootNodesJob.this.fEditor.setBusy(false);
                        }
                    });
                    monitor.setCanceled(true);
                    return Status.CANCEL_STATUS;
                }
                InputStream failedIn = null;
                if (FetchBuildReportRootNodesJob.this.fFailedBuildReportContent != null) {
                    failedIn = FetchBuildReportRootNodesJob.this.fTeamRepository.contentManager().retrieveContentStream(FetchBuildReportRootNodesJob.this.fFailedBuildReportContent, (IProgressMonitor)new NullProgressMonitor());
                }
                if ((in = FetchBuildReportRootNodesJob.this.fTeamRepository.contentManager().retrieveContentStream(FetchBuildReportRootNodesJob.this.fBuildReportContent, (IProgressMonitor)new NullProgressMonitor())) != null) {
                    FetchBuildReportRootNodesJob.this.fParser = new BuildReportParser(FetchBuildReportRootNodesJob.this.fTeamRepository, FetchBuildReportRootNodesJob.this.fNeedInputs, FetchBuildReportRootNodesJob.this.fResourcePrefix, FetchBuildReportRootNodesJob.this.fIsPersonal, FetchBuildReportRootNodesJob.this.fIsZos);
                    FetchBuildReportRootNodesJob.this.fParser.parseXMLFromInputStream(in, FetchBuildReportRootNodesJob.this.fCache, true, failedIn);
                }
                return Status.OK_STATUS;
            }

            protected void jobFinished(IStatus status) {
                if (Status.OK_STATUS.equals(status)) {
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            FetchBuildReportRootNodesJob.this.setNeedPrefix();
                            int pageSize = Utils.getCurrentBuildReportPageSize();
                            BuildReportUtil.calculatePageCapacity(FetchBuildReportRootNodesJob.this.fCache, pageSize, FetchBuildReportRootNodesJob.this.fPageBookMap, FetchBuildReportRootNodesJob.this.fCurrentPageMap);
                            Map pageBook = null;
                            FetchBuildReportRootNodesJob.this.fBuildResult = BuildReportUtil.getBuildResult(FetchBuildReportRootNodesJob.this.fCache.getSuccessBuildFileSize(), FetchBuildReportRootNodesJob.this.fCache.getFailedBuildFileSize(), FetchBuildReportRootNodesJob.this.fCache.getUnBuiltBuildFileSize());
                            if (FetchBuildReportRootNodesJob.this.fBuildReportPage != null) {
                                FetchBuildReportRootNodesJob.this.fBuildReportPage.setBuidResult(FetchBuildReportRootNodesJob.this.fBuildResult);
                                FetchBuildReportRootNodesJob.this.fBuildReportPage.setCurrentPage((AtomicInteger)FetchBuildReportRootNodesJob.this.fCurrentPageMap.get(FetchBuildReportRootNodesJob.this.fBuildResult));
                            }
                            if (FetchBuildReportRootNodesJob.this.fCache.getUnBuiltBuildFileSize() == 0) {
                                BuildReportUtil.disposeTab(FetchBuildReportRootNodesJob.this.fTabFolder, BuildableFileBuildResult.UNBUILD);
                            } else if (FetchBuildReportRootNodesJob.this.fCache.getUnBuiltBuildFileSize() > 0) {
                                BuildReportUtil.setTabTooltipText(FetchBuildReportRootNodesJob.this.fTabFolder, BuildableFileBuildResult.UNBUILD, NLS.bind((String)Messages.BuildReportPage_TAB_TOTAL_TOOLTIP, (Object)FetchBuildReportRootNodesJob.this.fCache.getUnBuiltBuildFileSize()));
                            }
                            if (FetchBuildReportRootNodesJob.this.fCache.getSuccessBuildFileSize() == 0) {
                                BuildReportUtil.disposeTab(FetchBuildReportRootNodesJob.this.fTabFolder, BuildableFileBuildResult.SUCCESS);
                            } else if (FetchBuildReportRootNodesJob.this.fCache.getSuccessBuildFileSize() > 0) {
                                BuildReportUtil.setTabTooltipText(FetchBuildReportRootNodesJob.this.fTabFolder, BuildableFileBuildResult.SUCCESS, NLS.bind((String)Messages.BuildReportPage_TAB_TOTAL_TOOLTIP, (Object)FetchBuildReportRootNodesJob.this.fCache.getSuccessBuildFileSize()));
                            }
                            if (FetchBuildReportRootNodesJob.this.fCache.getFailedBuildFileSize() == 0) {
                                BuildReportUtil.disposeTab(FetchBuildReportRootNodesJob.this.fTabFolder, BuildableFileBuildResult.FAILED);
                            } else if (FetchBuildReportRootNodesJob.this.fCache.getFailedBuildFileSize() > 0) {
                                BuildReportUtil.setTabTooltipText(FetchBuildReportRootNodesJob.this.fTabFolder, BuildableFileBuildResult.FAILED, NLS.bind((String)Messages.BuildReportPage_TAB_TOTAL_TOOLTIP, (Object)FetchBuildReportRootNodesJob.this.fCache.getFailedBuildFileSize()));
                            }
                            if (FetchBuildReportRootNodesJob.this.fBuildResult != null) {
                                BuildReportUtil.setTabSelection(FetchBuildReportRootNodesJob.this.fTabFolder, FetchBuildReportRootNodesJob.this.fBuildResult);
                                pageBook = (Map)FetchBuildReportRootNodesJob.this.fPageBookMap.get(FetchBuildReportRootNodesJob.this.fBuildResult);
                            }
                            if (pageBook != null && pageBook.size() > 1) {
                                FetchBuildReportRootNodesJob.this.fRootNodes = BuildReportUtil.getCurrentRootNodes(FetchBuildReportRootNodesJob.this.fCache, null, 1, pageBook, FetchBuildReportRootNodesJob.this.fBuildResult);
                                FetchBuildReportRootNodesJob.this.fEditor.setBusy(false);
                                BuildReportUtil.setTreeViewInput(FetchBuildReportRootNodesJob.this.fRootNodes, FetchBuildReportRootNodesJob.this.fViewer, FetchBuildReportRootNodesJob.this.fFailedViewer, FetchBuildReportRootNodesJob.this.fUnbuiltViewer, FetchBuildReportRootNodesJob.this.fBuildResult);
                                FetchBuildReportRootNodesJob.this.fNavigatorComposite.setVisible(true);
                                int pages = pageBook.size();
                                if (FetchBuildReportRootNodesJob.this.fBuildReportPage != null) {
                                    FetchBuildReportRootNodesJob.this.fBuildReportPage.setPageCapacity(pages);
                                }
                                FetchBuildReportRootNodesJob.this.fBookMarkLabel.setText(NLS.bind((String)Messages.BuildReportPage_Navigator_Label, (Object)1, (Object)pages));
                                if (pageBook.size() > 1) {
                                    FetchBuildReportRootNodesJob.this.fPageNextBtn.setEnabled(true);
                                    FetchBuildReportRootNodesJob.this.fPageTailBtn.setEnabled(true);
                                }
                            } else {
                                FetchBuildReportRootNodesJob.this.fNavigatorComposite.setVisible(false);
                            }
                            FetchBuildReportRootNodesJob.this.fBookMarkLabel.getParent().layout();
                            FetchBuildReportRootNodesJob.this.fBookMarkLabel.getParent().getParent().layout();
                        }
                    });
                } else {
                    FetchBuildReportRootNodesJob.this.fCache.markEnd();
                }
            }
        };
        job.schedule();
        this.fRootNodes = BuildReportUtil.getCurrentRootNodes(this.fCache, null, 1, null, this.fBuildResult);
        return Status.OK_STATUS;
    }

    private void setNeedPrefix() {
        if (this.fLabelProvider != null) {
            this.fLabelProvider.setNeedPrefix(this.fParser.isNeedPrefix());
        }
        if (this.fFailedLabelProvider != null) {
            this.fFailedLabelProvider.setNeedPrefix(this.fParser.isNeedPrefix());
        }
        if (this.fUnbuiltLabelProvider != null) {
            this.fUnbuiltLabelProvider.setNeedPrefix(this.fParser.isNeedPrefix());
        }
        if (this.fFilter != null) {
            this.fFilter.setRemovePrefix(this.fIsZos && this.fIsPersonal && !this.fParser.isNeedPrefix());
        }
    }

    protected void jobFinished(IStatus status) {
        if (this.fRootNodes != null) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    FetchBuildReportRootNodesJob.this.fEditor.setBusy(false);
                    FetchBuildReportRootNodesJob.this.setNeedPrefix();
                    BuildReportUtil.setTreeViewInput(FetchBuildReportRootNodesJob.this.fRootNodes, FetchBuildReportRootNodesJob.this.fViewer, FetchBuildReportRootNodesJob.this.fFailedViewer, FetchBuildReportRootNodesJob.this.fUnbuiltViewer, FetchBuildReportRootNodesJob.this.fBuildResult);
                }
            });
        }
        if (this.fBuildReportContent == null && this.fFailedBuildReportContent == null) {
            throw new IllegalArgumentException(Messages.BuildReportPage_FETCH_BUILDREPORT_NOCONTENT_ERROR);
        }
    }
}

