/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.build.ui.editors.result;

import com.ibm.team.enterprise.build.common.buildreport.IReportBuildFile;
import com.ibm.team.enterprise.build.ui.Activator;
import com.ibm.team.enterprise.build.ui.editors.buildmap.BuildMapEditorInput;
import com.ibm.team.enterprise.build.ui.editors.result.internal.BuildReportTreeLeafNode;
import com.ibm.team.enterprise.build.ui.editors.result.internal.OpenSystemDefinitionEditorJob;
import com.ibm.team.enterprise.build.ui.views.DependencySetView;
import com.ibm.team.enterprise.internal.build.ui.nls.Messages;
import com.ibm.team.enterprise.internal.buildmap.common.IBuildMap;
import com.ibm.team.enterprise.systemdefinition.common.model.ISystemDefinition;
import com.ibm.team.jface.util.UIUpdaterJob;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.io.IOException;
import java.net.URI;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.TreeViewerFocusCellManager;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.xml.sax.SAXException;

public abstract class BuildReportTreeEventListener {
    protected TreeViewerFocusCellManager fCellManager = null;
    protected ITeamRepository fTeamRepository = null;
    protected String fBuildDefUUID = null;
    protected Map<URI, IBuildMap> fBuildmapMap = null;
    protected Map<String, String> fUuidStateIDVersionIDMap = null;
    protected Map<String, String> fComponentUUIDNameMap = null;
    protected Map<String, ISystemDefinition> fSysDefCache = null;
    protected boolean fNeedInputs = false;
    protected String fResourcePrefix = null;
    protected boolean fIsZos = true;
    protected boolean fPersonal = false;
    protected boolean fIsFailed = false;
    private UIUpdaterJob fUIJob = null;

    public BuildReportTreeEventListener(TreeViewerFocusCellManager cellManager, ITeamRepository fTeamRepository, String fBuildDefUUID, Map<URI, IBuildMap> fBuildmapMap, Map<String, String> fUuidStateIDVersionIDMap, Map<String, String> fComponentUUIDNameMap, Map<String, ISystemDefinition> fSysDefCache, boolean fNeedInputs, String fResourcePrefix, boolean fPersonal, boolean fIsZos, boolean fIsFailed) {
        this.fCellManager = cellManager;
        this.fTeamRepository = fTeamRepository;
        this.fBuildDefUUID = fBuildDefUUID;
        this.fBuildmapMap = fBuildmapMap;
        this.fUuidStateIDVersionIDMap = fUuidStateIDVersionIDMap;
        this.fComponentUUIDNameMap = fComponentUUIDNameMap;
        this.fSysDefCache = fSysDefCache;
        this.fNeedInputs = fNeedInputs;
        this.fResourcePrefix = fResourcePrefix;
        this.fPersonal = fPersonal;
        this.fIsZos = fIsZos;
        this.fIsFailed = fIsFailed;
    }

    protected void doEvent() {
        Object element;
        ViewerCell viewerCell;
        if (this.fCellManager != null && (viewerCell = this.fCellManager.getFocusCell()) != null && (element = viewerCell.getElement()) instanceof BuildReportTreeLeafNode) {
            BuildReportTreeLeafNode leafNode = (BuildReportTreeLeafNode)element;
            IReportBuildFile buildFile = leafNode.getReportBuildFile();
            int columnIndex = viewerCell.getColumnIndex();
            if (2 == columnIndex) {
                IWorkbenchPage workbenchPage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                OpenSystemDefinitionEditorJob job = new OpenSystemDefinitionEditorJob(Messages.BuildReportPage_OPEN_LANGDEF_JOB_TITLE, true, this.fTeamRepository, buildFile.getLangDefUUID(), buildFile.getLangDefStateID(), "languagedefinition", workbenchPage, this.fSysDefCache);
                job.schedule();
            } else if (columnIndex == 0) {
                DependencySetView.displayDependencySetView(buildFile, this.fBuildmapMap, this.fUuidStateIDVersionIDMap, this.fComponentUUIDNameMap, this.fTeamRepository, this.fNeedInputs, this.fResourcePrefix, this.fIsZos, this.fPersonal);
            } else if (4 == columnIndex && !this.fIsFailed) {
                String text = viewerCell.getText();
                URI buildMapURI = buildFile.getBuildMapURL();
                if (text != null && text.length() > 0 && buildMapURI != null) {
                    final BuildMapEditorInput editorInput = new BuildMapEditorInput(buildMapURI, this.fBuildmapMap, this.fUuidStateIDVersionIDMap, this.fComponentUUIDNameMap, this.fSysDefCache, this.fTeamRepository);
                    if (this.fUIJob != null) {
                        this.fUIJob.cancel();
                    }
                    this.fUIJob = new UIUpdaterJob(""){
                        IBuildMap buildMap;
                        {
                            super($anonymous0);
                            this.buildMap = null;
                        }

                        public IStatus runInBackground(IProgressMonitor monitor) {
                            try {
                                this.buildMap = editorInput.fetchBuildMap(null);
                            }
                            catch (TeamRepositoryException e) {
                                Activator.getDefault().logError(e);
                            }
                            catch (SAXException e) {
                                Activator.getDefault().logError(e);
                            }
                            catch (IOException e) {
                                Activator.getDefault().logError(e);
                            }
                            catch (ParserConfigurationException e) {
                                Activator.getDefault().logError(e);
                            }
                            return super.runInBackground(monitor);
                        }

                        public IStatus runInUI(IProgressMonitor monitor) {
                            if (this.buildMap != null) {
                                try {
                                    PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().openEditor((IEditorInput)editorInput, "com.ibm.team.enterprise.build.ui.editors.buildMapEditor");
                                }
                                catch (PartInitException ex) {
                                    Activator.getDefault().logError(ex);
                                }
                            } else {
                                MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)Messages.ViewBuildMapDialog_TITLE, (String)Messages.ViewBuildMapAction_ERROR_INVALID_SELECTION);
                            }
                            return super.runInUI(monitor);
                        }
                    };
                    this.fUIJob.schedule();
                }
            }
        }
    }
}

