/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.build.ui.editors.result;

import com.ibm.team.enterprise.build.common.GatewayErrorMessages;
import com.ibm.team.enterprise.build.common.buildreport.IReportBuildFile;
import com.ibm.team.enterprise.build.ui.Activator;
import com.ibm.team.enterprise.build.ui.editors.result.AbstractBuildStyledLabelProvider;
import com.ibm.team.enterprise.build.ui.editors.result.internal.BuildReportTreeLeafNode;
import com.ibm.team.enterprise.build.ui.editors.result.internal.BuildReportTreeNode;
import com.ibm.team.enterprise.build.ui.editors.result.internal.IBuildReportNode;
import com.ibm.team.enterprise.internal.build.ui.nls.Messages;
import com.ibm.team.enterprise.internal.build.ui.utils.BuildReportUtil;
import com.ibm.team.enterprise.systemdefinition.common.model.ISystemDefinition;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.graphics.Image;

public class BuildReportStyledLabelProvider
extends AbstractBuildStyledLabelProvider {
    private boolean fPersonal = false;
    private boolean fIsPreview = false;
    private boolean fNeedPrefix = false;
    private boolean fIsZos = true;
    private boolean fIsFailed = false;
    private Map<String, ISystemDefinition> fSystemDefMap;
    private ITeamRepository fTeamRepository;
    private String fResourcePrefix = null;

    public BuildReportStyledLabelProvider(Set<Integer> underLineSet, Set<Integer> qualifierSet, boolean fPersonal, boolean fIsPreview, boolean fIsZos, boolean fIsFailed, ITeamRepository fTeamRepository, Map<String, ISystemDefinition> fSystemDefMap, String fResourcePrefix) {
        super(underLineSet, qualifierSet);
        this.fPersonal = fPersonal;
        this.fIsPreview = fIsPreview;
        this.fIsZos = fIsZos;
        this.fIsFailed = fIsFailed;
        this.fSystemDefMap = fSystemDefMap;
        this.fTeamRepository = fTeamRepository;
        this.fResourcePrefix = fResourcePrefix;
    }

    @Override
    public Image getColumnImage(Object element, int columnIndex) {
        IReportBuildFile reportFile;
        Image result = null;
        if (element != null && element instanceof BuildReportTreeLeafNode && 4 == columnIndex && !this.fPersonal && !this.fIsPreview & !this.fIsFailed && (reportFile = ((BuildReportTreeLeafNode)element).getReportBuildFile()).getBuildMapURL() != null) {
            result = Activator.getImage("icons/misc/externalLink.gif");
        }
        return result;
    }

    @Override
    public boolean isLinkStyledElement(Object element) {
        boolean result = false;
        result = element != null && element instanceof BuildReportTreeLeafNode;
        return result;
    }

    @Override
    public String getColumnText(Object element, int columnIndex) {
        String result = null;
        if (element instanceof IBuildReportNode) {
            IBuildReportNode node = (IBuildReportNode)element;
            result = element instanceof BuildReportTreeLeafNode && 4 == columnIndex && !this.fPersonal && !this.fIsPreview && !this.fIsFailed ? " " : node.getColumnText(columnIndex, this.fIsZos && this.fPersonal && !this.fNeedPrefix, this.fResourcePrefix, this.fIsFailed);
        }
        return result;
    }

    @Override
    protected boolean isQualifierStyledElement(Object element, int columnIndex) {
        return element != null && element instanceof BuildReportTreeNode && super.isQualifierStyledElement(element, columnIndex);
    }

    @Override
    protected StyledString getQualifierStyledText(Object element, int columnIndex) {
        StyledString st = null;
        if (element != null && element instanceof BuildReportTreeNode) {
            BuildReportTreeNode node = (BuildReportTreeNode)element;
            st = BuildReportUtil.getQualifierSourceString(node.getProjectName(), node.getComponentName());
        }
        return st;
    }

    @Override
    public String getToolTipText(Object element, int columnIndex) {
        String result = null;
        if (element instanceof BuildReportTreeLeafNode) {
            BuildReportTreeLeafNode node = (BuildReportTreeLeafNode)element;
            IReportBuildFile buildFile = node.getReportBuildFile();
            if (1 == columnIndex) {
                int reason = buildFile.getReasonCode();
                switch (reason) {
                    case -1: {
                        result = Messages.BuildReportPage_REASON_TO_BUILD_TOOLTIP_MINUS_1;
                        break;
                    }
                    case 0: {
                        result = Messages.BuildReportPage_REASON_TO_BUILD_TOOLTIP_0;
                        break;
                    }
                    case 1: {
                        result = Messages.BuildReportPage_REASON_TO_BUILD_TOOLTIP_1;
                        break;
                    }
                    case 2: {
                        result = Messages.BuildReportPage_REASON_TO_BUILD_TOOLTIP_2;
                        break;
                    }
                    case 3: {
                        result = Messages.BuildReportPage_REASON_TO_BUILD_TOOLTIP_3;
                        break;
                    }
                    case 4: {
                        result = Messages.BuildReportPage_REASON_TO_BUILD_TOOLTIP_4;
                        break;
                    }
                    case 5: {
                        result = Messages.BuildReportPage_REASON_TO_BUILD_TOOLTIP_5;
                        break;
                    }
                    case 6: {
                        result = Messages.BuildReportPage_REASON_TO_BUILD_TOOLTIP_6;
                        break;
                    }
                    case 7: {
                        result = Messages.BuildReportPage_REASON_TO_BUILD_TOOLTIP_7;
                        break;
                    }
                    default: {
                        result = "N/A";
                        break;
                    }
                }
            } else if (columnIndex == 0) {
                result = BuildReportUtil.getTooltipForSource(buildFile.getProject(), buildFile.getComponent());
            } else if (2 == columnIndex) {
                ISystemDefinition sysDef = null;
                try {
                    sysDef = BuildReportUtil.getSystemDefinition(buildFile.getLangDefUUID(), buildFile.getLangDefStateID(), "languagedefinition", this.fSystemDefMap, this.fTeamRepository, null);
                }
                catch (TeamRepositoryException e) {
                    Activator.getDefault().logError(e);
                }
                if (sysDef != null) {
                    result = sysDef.getDescription();
                }
                if (result != null && result.length() < 1) {
                    result = null;
                }
            } else if (4 == columnIndex) {
                result = this.getColumnText(element, columnIndex);
                result = GatewayErrorMessages.msg((String)result);
            }
        }
        return result;
    }

    public void setNeedPrefix(boolean fNeedPrefix) {
        this.fNeedPrefix = fNeedPrefix;
    }

    @Override
    public Image getToolTipImage(Object element, int columnIndex) {
        return null;
    }
}

