/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.build.ui.editors.result;

import com.ibm.team.build.internal.ui.editors.result.BuildResultEditor;
import com.ibm.team.build.internal.ui.editors.result.BuildResultPage;
import com.ibm.team.build.internal.ui.helper.BuildUIHelper;
import com.ibm.team.build.ui.editors.result.AbstractBuildResultPage;
import com.ibm.team.build.ui.editors.result.IBuildResultContext;
import com.ibm.team.enterprise.build.common.BuildableFileBuildResult;
import com.ibm.team.enterprise.build.common.buildreport.BuildReportCache;
import com.ibm.team.enterprise.build.ui.actions.SubsetFromBuildReportAction;
import com.ibm.team.enterprise.build.ui.editors.result.BuildReportContentFilter;
import com.ibm.team.enterprise.build.ui.editors.result.BuildReportStyledLabelProvider;
import com.ibm.team.enterprise.build.ui.editors.result.BuildReportTreeContentProvider;
import com.ibm.team.enterprise.build.ui.editors.result.BuildReportTreeKeyListener;
import com.ibm.team.enterprise.build.ui.editors.result.BuildReportTreeMouseListener;
import com.ibm.team.enterprise.build.ui.editors.result.BuildReportTreeMouseTrackListener;
import com.ibm.team.enterprise.build.ui.editors.result.BuildReportViewerToolTipSupport;
import com.ibm.team.enterprise.build.ui.editors.result.FetchBuildReportRootNodesJob;
import com.ibm.team.enterprise.build.ui.editors.result.internal.BuildReportTreeNode;
import com.ibm.team.enterprise.internal.build.ui.nls.Messages;
import com.ibm.team.enterprise.internal.build.ui.utils.BuildReportUtil;
import com.ibm.team.enterprise.internal.buildmap.common.IBuildMap;
import com.ibm.team.enterprise.systemdefinition.common.model.ISystemDefinition;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IContent;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.TreeColumnLayout;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.FocusCellHighlighter;
import org.eclipse.jface.viewers.FocusCellOwnerDrawHighlighter;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerFocusCellManager;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MenuDetectEvent;
import org.eclipse.swt.events.MenuDetectListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TypedEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class BuildReportPage
extends BuildResultPage {
    public static final String PAGE_ID = "com.ibm.team.enterprise.build.ui.editors.result.BuildReportPage";
    private static final String PAGE_HEAD_LABEL = "|<";
    private static final String PAGE_TAIL_LABEL = ">|";
    private static final String PAGE_NEXT_LABEL = ">>";
    private static final String PAGE_PREVIOUS_LABEL = "<<";
    private CTabFolder fTabFolder = null;
    private TreeViewer fSuccessViewer;
    private TreeViewer fFailedViewer;
    private TreeViewer fUnbuiltViewer;
    private IContent fBuildReportContent = null;
    private IContent fFailedBuildReportContent = null;
    private int fSuccessBuildFiles = -1;
    private int fFailedBuildFiles = -1;
    private String fBuildDefUUID = null;
    private BuildReportCache fCache = null;
    private BuildResultEditor fEditor = null;
    private ITeamRepository fTeamRepository = null;
    private Map<BuildableFileBuildResult, AtomicInteger> fCurrentPageMap = null;
    private AtomicInteger fCurrentPageNum = new AtomicInteger(0);
    private final AtomicInteger fPageCapacity = new AtomicInteger(0);
    private Label fBookMarkLabel;
    private Button fPageNextBtn;
    private Button fPagePreviousBtn;
    private Button fPageHeadBtn;
    private Button fPageTailBtn;
    private Composite navigatorComp;
    private Text fResourcePrefixText;
    private Text fFilterText;
    private BuildReportContentFilter fFilter;
    private final boolean fNeedInputs;
    private boolean fPersonal = false;
    private boolean fIsPreview = false;
    private boolean fIsZos = false;
    private String fResourcePrefix = null;
    private Map<String, String> fUuidStateIDVersionIDMap = null;
    private Map<String, String> fComponentUUIDNameMap = null;
    private Map<BuildableFileBuildResult, Map<Integer, Integer>> fPageBookMap = null;
    private FormToolkit fToolkit = null;
    private Map<URI, IBuildMap> fBuildmapMap = null;
    private Map<String, ISystemDefinition> fSystemDefMap = null;
    private BuildReportStyledLabelProvider fLabelProvider;
    private BuildReportStyledLabelProvider fFailedLabelProvider;
    private BuildReportStyledLabelProvider fUnbuiltLabelProvider;
    private BuildableFileBuildResult fBuildResult = null;
    private Composite subsetComp;
    private boolean selectionisChanging = false;

    public BuildReportPage(FormEditor editor, String title, String[] contributionIds, IBuildResultContext buildResultContext, IContent buildReportContent, IContent failedBuildReportContent, int totalBuildFiles, int failedBuildFiles, String fBuildDefUUID, ITeamRepository teamRepository, boolean fPersonal, boolean fPreview, boolean fIsZos, String fResourcePrefix) {
        super(editor, PAGE_ID, title, contributionIds, buildResultContext);
        this.fEditor = (BuildResultEditor)editor;
        this.fBuildReportContent = buildReportContent;
        this.fFailedBuildReportContent = failedBuildReportContent;
        this.fSuccessBuildFiles = totalBuildFiles;
        this.fFailedBuildFiles = failedBuildFiles;
        this.fBuildDefUUID = fBuildDefUUID;
        this.fTeamRepository = teamRepository;
        this.fCache = new BuildReportCache();
        this.fNeedInputs = fPersonal || fPreview;
        this.fPersonal = fPersonal;
        this.fIsPreview = fPreview;
        this.fIsZos = fIsZos;
        this.fResourcePrefix = fResourcePrefix;
        this.fBuildmapMap = new HashMap<URI, IBuildMap>();
        this.fSystemDefMap = new HashMap<String, ISystemDefinition>();
        this.fUuidStateIDVersionIDMap = new HashMap<String, String>();
        this.fComponentUUIDNameMap = new HashMap<String, String>();
        this.fPageBookMap = new HashMap<BuildableFileBuildResult, Map<Integer, Integer>>();
        this.fCurrentPageMap = new HashMap<BuildableFileBuildResult, AtomicInteger>();
        this.fBuildResult = BuildReportUtil.getBuildResult(this.fSuccessBuildFiles, this.fFailedBuildFiles, -1);
    }

    protected void doCreatePageContent(Composite parent) {
        if (this.fCache != null) {
            this.fCache.reset();
            this.fPageCapacity.set(0);
        }
        if (this.fBuildmapMap != null) {
            this.fBuildmapMap.clear();
        }
        if (this.fUuidStateIDVersionIDMap != null) {
            this.fUuidStateIDVersionIDMap.clear();
        }
        this.fToolkit = this.getManagedForm().getToolkit();
        new LocalResourceManager(JFaceResources.getResources(), (Control)parent);
        GridLayoutFactory.fillDefaults().applyTo(parent);
        Section section = this.fToolkit.createSection(parent, 384);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)section);
        section.setText(Messages.BuildReportContributionProvider_PAGE_TITLE);
        String description = null;
        int displayInt = 0;
        displayInt = this.fFailedBuildFiles < 0 ? this.fSuccessBuildFiles : this.fSuccessBuildFiles + this.fFailedBuildFiles;
        description = this.fIsPreview ? NLS.bind((String)Messages.BuildReportPage_DESCRIPTION_PREVIEW, (Object)displayInt) : (this.fPersonal ? NLS.bind((String)Messages.BuildReportPage_DESCRIPTION_PERSONAL, (Object)displayInt) : NLS.bind((String)Messages.BuildReportPage_DESCRIPTION, (Object)displayInt));
        section.setDescription(description != null ? description : "");
        section.setExpanded(true);
        Composite outerComposite = this.fToolkit.createComposite((Composite)section);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)outerComposite);
        GridLayoutFactory.fillDefaults().numColumns(1).applyTo(outerComposite);
        section.setClient((Control)outerComposite);
        this.createControlSection(outerComposite);
        this.createBuildReportTabs(outerComposite);
        section.layout();
        outerComposite.layout(true);
        parent.layout();
        this.getManagedForm().reflow(true);
    }

    private void createControlSection(Composite parent) {
        Composite upperComp = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().numColumns(1).applyTo(upperComp);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)upperComp);
        Composite searchNaviComp = this.fToolkit.createComposite(upperComp);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(searchNaviComp);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)searchNaviComp);
        Composite searchComp = new Composite(searchNaviComp, 0);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(searchComp);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)searchComp);
        this.fToolkit.createLabel(searchComp, Messages.BuildMapEditor_GENERAL_RESOURCE_PREFIX_LABEL);
        this.fResourcePrefixText = BuildUIHelper.createNonEditableText((FormToolkit)this.fToolkit, (Composite)searchComp, (String)(this.fResourcePrefix == null ? "" : this.fResourcePrefix), (int)0);
        this.fResourcePrefixText.setBackground(searchComp.getBackground());
        this.fToolkit.createLabel(searchComp, Messages.BuildReportPage_Filter_Label);
        this.fFilterText = new Text(searchComp, 2048);
        this.addNewLines(searchComp, 1, 2);
        Label fileCount = new Label(searchComp, 0);
        int displayInt = 0;
        displayInt = this.fFailedBuildFiles < 0 ? this.fSuccessBuildFiles : this.fSuccessBuildFiles + this.fFailedBuildFiles;
        fileCount.setText(Messages.bind((String)Messages.BuildReportPage_FILE_COUNT, (Object)this.fSuccessBuildFiles, (Object)displayInt));
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.fFilterText);
        ArrayList<Integer> filterColumn = new ArrayList<Integer>();
        filterColumn.add(0);
        filterColumn.add(2);
        filterColumn.add(3);
        this.fFilter = new BuildReportContentFilter(new String("*"), filterColumn, this.fResourcePrefix);
        this.fFilterText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String pattern = ((Text)e.widget).getText();
                if (pattern != null && pattern.trim().length() > 0) {
                    BuildReportPage.this.fFilter.setPattern(pattern);
                } else {
                    BuildReportPage.this.fFilter.setPattern("*");
                }
                BuildReportPage.this.toggleButtonStatus();
                BuildReportPage.this.updateTreeNodes(BuildReportPage.this.fCurrentPageNum.get());
            }
        });
        this.subsetComp = new Composite(searchNaviComp, 0);
        this.subsetComp.setVisible(true);
        GridLayoutFactory.fillDefaults().numColumns(5).applyTo(this.subsetComp);
        GridDataFactory.fillDefaults().align(0x1000008, 0x1000000).grab(true, false).applyTo((Control)this.subsetComp);
        this.navigatorComp = new Composite(searchNaviComp, 0);
        GridLayoutFactory.fillDefaults().numColumns(5).applyTo(this.navigatorComp);
        GridDataFactory.fillDefaults().align(0x1000008, 0x1000000).grab(true, false).applyTo((Control)this.navigatorComp);
        this.fBookMarkLabel = new Label(this.navigatorComp, 8);
        this.fPageHeadBtn = new Button(this.navigatorComp, 8);
        this.fPageHeadBtn.setText(PAGE_HEAD_LABEL);
        this.fPageHeadBtn.setSize(100, 50);
        this.fPageHeadBtn.setEnabled(false);
        this.fPageHeadBtn.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                BuildReportPage.this.fCurrentPageNum.set(1);
                BuildReportPage.this.toggleButtonStatus();
                BuildReportPage.this.updateTreeNodes(BuildReportPage.this.fCurrentPageNum.get());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.fPagePreviousBtn = new Button(this.navigatorComp, 8);
        this.fPagePreviousBtn.setText(PAGE_PREVIOUS_LABEL);
        this.fPagePreviousBtn.setSize(100, 50);
        this.fPagePreviousBtn.setEnabled(false);
        this.fPagePreviousBtn.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (BuildReportPage.this.fCurrentPageNum.get() - 1 >= 1) {
                    BuildReportPage.this.fCurrentPageNum.decrementAndGet();
                    BuildReportPage.this.toggleButtonStatus();
                    BuildReportPage.this.updateTreeNodes(BuildReportPage.this.fCurrentPageNum.get());
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.fPageNextBtn = new Button(this.navigatorComp, 8);
        this.fPageNextBtn.setText(PAGE_NEXT_LABEL);
        this.fPageNextBtn.setSize(100, 50);
        this.fPageNextBtn.setEnabled(false);
        this.fPageNextBtn.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (BuildReportPage.this.fCurrentPageNum.get() + 1 <= BuildReportPage.this.fPageCapacity.get()) {
                    BuildReportPage.this.fCurrentPageNum.incrementAndGet();
                    BuildReportPage.this.toggleButtonStatus();
                    BuildReportPage.this.updateTreeNodes(BuildReportPage.this.fCurrentPageNum.get());
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.fPageTailBtn = new Button(this.navigatorComp, 8);
        this.fPageTailBtn.setText(PAGE_TAIL_LABEL);
        this.fPageTailBtn.setSize(100, 50);
        this.fPageTailBtn.setEnabled(false);
        this.fPageTailBtn.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                BuildReportPage.this.fCurrentPageNum.set(BuildReportPage.this.fPageCapacity.get());
                BuildReportPage.this.toggleButtonStatus();
                BuildReportPage.this.updateTreeNodes(BuildReportPage.this.fCurrentPageNum.get());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    private void addNewLines(Composite searchComp, int newLines, int cols) {
        int j = 0;
        while (j < newLines * cols) {
            new Label(searchComp, 0);
            ++j;
        }
    }

    private void toggleButtonStatus() {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (1 == BuildReportPage.this.fPageCapacity.get()) {
                    BuildReportPage.this.fPageHeadBtn.setEnabled(false);
                    BuildReportPage.this.fPagePreviousBtn.setEnabled(false);
                    BuildReportPage.this.fPageNextBtn.setEnabled(false);
                    BuildReportPage.this.fPageTailBtn.setEnabled(false);
                } else if (1 == BuildReportPage.this.fCurrentPageNum.get()) {
                    BuildReportPage.this.fPageHeadBtn.setEnabled(false);
                    BuildReportPage.this.fPagePreviousBtn.setEnabled(false);
                    BuildReportPage.this.fPageNextBtn.setEnabled(true);
                    BuildReportPage.this.fPageTailBtn.setEnabled(true);
                } else if (BuildReportPage.this.fPageCapacity.get() == BuildReportPage.this.fCurrentPageNum.get()) {
                    BuildReportPage.this.fPageHeadBtn.setEnabled(true);
                    BuildReportPage.this.fPagePreviousBtn.setEnabled(true);
                    BuildReportPage.this.fPageNextBtn.setEnabled(false);
                    BuildReportPage.this.fPageTailBtn.setEnabled(false);
                } else {
                    BuildReportPage.this.fPageHeadBtn.setEnabled(true);
                    BuildReportPage.this.fPagePreviousBtn.setEnabled(true);
                    BuildReportPage.this.fPageNextBtn.setEnabled(true);
                    BuildReportPage.this.fPageTailBtn.setEnabled(true);
                }
            }
        });
    }

    private void createBuildReportTabs(Composite parent) {
        this.fTabFolder = new CTabFolder(parent, 0x800080);
        this.fToolkit.adapt((Control)this.fTabFolder, true, true);
        Color selectedColor = this.fToolkit.getColors().getColor("org.eclipse.ui.forms.TB_BG");
        this.fTabFolder.setSelectionBackground(new Color[]{selectedColor, this.fToolkit.getColors().getBackground()}, new int[]{100}, true);
        this.fTabFolder.setSelectionBackground(Display.getCurrent().getSystemColor(22));
        this.fTabFolder.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                CTabItem item = BuildReportPage.this.fTabFolder.getSelection();
                Object result = item.getData();
                if (result instanceof BuildableFileBuildResult) {
                    BuildableFileBuildResult tempResult = (BuildableFileBuildResult)result;
                    BuildReportPage.this.fBuildResult = tempResult;
                    Map pageBook = null;
                    if (BuildReportPage.this.fPageBookMap != null) {
                        pageBook = (Map)BuildReportPage.this.fPageBookMap.get(tempResult);
                    }
                    if (pageBook != null) {
                        BuildReportPage.this.fPageCapacity.set(pageBook.size());
                        BuildReportPage.this.fCurrentPageNum = (AtomicInteger)BuildReportPage.this.fCurrentPageMap.get(tempResult);
                    }
                    BuildReportPage.this.toggleButtonStatus();
                    BuildReportPage.this.updateTreeNodes(BuildReportPage.this.fCurrentPageNum.get());
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        GridDataFactory.fillDefaults().grab(true, true).hint(300, 150).applyTo((Control)this.fTabFolder);
        GridLayoutFactory.fillDefaults().applyTo((Composite)this.fTabFolder);
        if (this.fSuccessBuildFiles > 0) {
            this.createSuccessBuildReportTab(this.fTabFolder);
        }
        if (this.fFailedBuildFiles > 0) {
            this.createFailedBuildReportTab(this.fTabFolder);
        }
        this.createUnBuildReportTab(this.fTabFolder);
        BuildReportUtil.setTabSelection(this.fTabFolder, this.fBuildResult);
        FetchBuildReportRootNodesJob fetchJob = new FetchBuildReportRootNodesJob(Messages.BuildReportPage_FETCH_BUILDREPORT_JOB_TITLE, true, this.fEditor, this.fTabFolder, this.fSuccessViewer, this.fFailedViewer, this.fUnbuiltViewer, this.fCache, this.fTeamRepository, this.fBuildReportContent, this.fFailedBuildReportContent, this.fBookMarkLabel, this.fPageNextBtn, this.fPageTailBtn, this.fNeedInputs, this.fResourcePrefix, this.fPageBookMap, this.fCurrentPageMap, this.navigatorComp, this.fPersonal, this.fIsZos, this.fLabelProvider, this.fFailedLabelProvider, this.fUnbuiltLabelProvider, this.fFilter, this.fBuildResult, this);
        fetchJob.schedule();
        this.updateBookMarkNavigator(this.fBuildResult);
        this.enableSubsetFromBuildReportViaLeftClick();
        this.enableSubsetFromBuildReportViaRightClick();
    }

    private void enableSubsetFromBuildReportViaLeftClick() {
        this.fTabFolder.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                BuildReportPage.this.selectionisChanging = true;
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                System.out.println();
            }
        });
        this.fTabFolder.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent event) {
                if (!BuildReportPage.this.selectionisChanging && event.button == 1) {
                    CTabFolder curFolder = (CTabFolder)event.widget;
                    Point eventLocation = new Point(event.x, event.y);
                    CTabItem item = curFolder.getItem(eventLocation);
                    if (item == null) {
                        return;
                    }
                    BuildableFileBuildResult resultType = (BuildableFileBuildResult)item.getData();
                    if (BuildReportPage.this.isSubsetContextMenutrigger(item, event.display, eventLocation.x, eventLocation.y)) {
                        Point loc = event.display.map((Control)BuildReportPage.this.fTabFolder, null, 0, 0);
                        BuildReportPage.this.displaySubsetMenu((TypedEvent)event, resultType, loc.x + event.x, loc.y + event.y);
                    }
                }
                BuildReportPage.this.selectionisChanging = false;
            }

            public void mouseDoubleClick(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
            }
        });
    }

    private void enableSubsetFromBuildReportViaRightClick() {
        this.fTabFolder.addMenuDetectListener(new MenuDetectListener(){

            public void menuDetected(MenuDetectEvent event) {
                event.doit = false;
                Point eventLocation = new Point(event.x, event.y);
                eventLocation = ((Control)event.widget).toControl(eventLocation);
                CTabFolder tabFolder = (CTabFolder)event.getSource();
                CTabItem item = tabFolder.getItem(eventLocation);
                if (item != null && tabFolder.getSelection() == item && (1 == event.detail || BuildReportPage.this.isSubsetContextMenutrigger(item, event.display, eventLocation.x, eventLocation.y))) {
                    event.doit = true;
                    BuildableFileBuildResult resultType = (BuildableFileBuildResult)item.getData();
                    BuildReportPage.this.displaySubsetMenu((TypedEvent)event, resultType, event.x, event.y);
                }
            }
        });
    }

    private void displaySubsetMenu(TypedEvent event, BuildableFileBuildResult resultType, int x, int y) {
        Display display = event.display;
        Menu menu = new Menu((Decorations)display.getActiveShell(), 8);
        this.addSubsetAction(resultType, menu, true);
        this.addSubsetAction(resultType, menu, false);
        menu.setLocation(x, y);
        menu.setVisible(true);
        while (!menu.isDisposed() && menu.isVisible()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        while (display.readAndDispatch()) {
        }
        menu.dispose();
    }

    private boolean isSubsetContextMenutrigger(CTabItem item, Display display, int x, int y) {
        boolean result = false;
        BuildableFileBuildResult resultType = (BuildableFileBuildResult)item.getData();
        String title = null;
        if (BuildableFileBuildResult.SUCCESS == resultType) {
            title = Messages.BuildReportPage_SUCCESS_TAB_LABEL;
        } else if (BuildableFileBuildResult.FAILED == resultType) {
            title = Messages.BuildReportPage_FAILED_TAB_LABEL;
        } else if (BuildableFileBuildResult.UNBUILD == resultType) {
            title = Messages.BuildReportPage_UNBUILT_TAB_LABEL;
        }
        GC gc = new GC((Drawable)Display.getCurrent().getActiveShell());
        Point tabTextExtent = gc.textExtent(title);
        gc.dispose();
        int ITEM_LEFT_MARGIN = 4;
        if (x >= item.getBounds().x + ITEM_LEFT_MARGIN + tabTextExtent.x) {
            result = true;
        }
        return result;
    }

    private void addSubsetAction(BuildableFileBuildResult resultType, Menu menu, boolean isCreateAction) {
        SubsetFromBuildReportAction subsetAction = new SubsetFromBuildReportAction(resultType, this.fTeamRepository, isCreateAction);
        subsetAction.setActivePart((IAction)subsetAction, (IWorkbenchPart)this.fEditor);
        subsetAction.setText(isCreateAction ? Messages.BuildReportPage_Action_CreateSubset : Messages.BuildReportPage_Action_AddToSubset);
        subsetAction.selectionChanged((IAction)subsetAction, (ISelection)new StructuredSelection((Object)this.fCache));
        ActionContributionItem aci = new ActionContributionItem((IAction)subsetAction);
        aci.fill(menu, -1);
    }

    private void createUnBuildReportTab(CTabFolder parent) {
        CTabItem unBuildTab = new CTabItem(parent, 0);
        unBuildTab.setData((Object)BuildableFileBuildResult.UNBUILD);
        String title = Messages.BuildReportPage_UNBUILT_TAB_LABEL;
        String titleWithDropdown = NLS.bind((String)Messages.BuildReportPage_Subsection_TabTitle_With_Dropdown, (Object)title);
        unBuildTab.setText(titleWithDropdown);
        unBuildTab.setImage(null);
        Composite composite = this.fToolkit.createComposite((Composite)parent);
        GridLayoutFactory.fillDefaults().numColumns(1).applyTo(composite);
        GridDataFactory.fillDefaults().align(0x1000008, 0x1000000).grab(true, true).applyTo((Control)composite);
        unBuildTab.setControl((Control)composite);
        Composite treeComposite = this.fToolkit.createComposite(composite);
        GridDataFactory.fillDefaults().grab(true, true).hint(300, 150).applyTo((Control)treeComposite);
        Tree fBuildReportTree = this.fToolkit.createTree(treeComposite, 0x10010800);
        fBuildReportTree.setLinesVisible(true);
        fBuildReportTree.setHeaderVisible(true);
        TreeColumnLayout treeColumnLayout = new TreeColumnLayout();
        this.fUnbuiltViewer = new TreeViewer(fBuildReportTree);
        BuildReportUtil.createTreeColumn(fBuildReportTree, this.fUnbuiltViewer, treeColumnLayout, Messages.BuildReportPage_TABLE_COLUMN_SOURCE, 20, 16384, 0, Messages.BuildReportPage_TABLE_COLUMN_SOURCE, 0);
        BuildReportUtil.createTreeColumn(fBuildReportTree, this.fUnbuiltViewer, treeColumnLayout, Messages.BuildReportPage_TABLE_COLUMN_REASON_TO_BUILD, 6, 16384, 1, Messages.BuildReportPage_REASON_TO_BUILD_TOOLTIP_OVERVIEW, 0);
        BuildReportUtil.createTreeColumn(fBuildReportTree, this.fUnbuiltViewer, treeColumnLayout, Messages.BuildReportPage_TABLE_COLUMN_LANGUAGE_DEFINITION, 15, 16384, 2, Messages.BuildReportPage_TABLE_COLUMN_LANGUAGE_DEFINITION, 0);
        treeComposite.setLayout((Layout)treeColumnLayout);
        BuildReportViewerToolTipSupport.enableFor((ColumnViewer)this.fUnbuiltViewer);
        HashSet<Integer> underlineSet = new HashSet<Integer>();
        underlineSet.add(2);
        underlineSet.add(0);
        HashSet<Integer> qualifierSet = new HashSet<Integer>();
        qualifierSet.add(0);
        this.fUnbuiltLabelProvider = new BuildReportStyledLabelProvider(underlineSet, qualifierSet, this.fPersonal, this.fIsPreview, this.fIsZos, false, this.fTeamRepository, this.fSystemDefMap, this.fResourcePrefix);
        this.fUnbuiltViewer.setLabelProvider((IBaseLabelProvider)this.fUnbuiltLabelProvider);
        this.fUnbuiltViewer.setContentProvider((IContentProvider)new BuildReportTreeContentProvider(this.fUnbuiltViewer));
        TreeViewerFocusCellManager cellManagers = new TreeViewerFocusCellManager(this.fUnbuiltViewer, (FocusCellHighlighter)new FocusCellOwnerDrawHighlighter((ColumnViewer)this.fUnbuiltViewer){});
        BuildReportTreeMouseListener mouseListener = new BuildReportTreeMouseListener(cellManagers, this.fTeamRepository, this.fBuildDefUUID, this.fBuildmapMap, this.fUuidStateIDVersionIDMap, this.fComponentUUIDNameMap, this.fSystemDefMap, true, this.fResourcePrefix, this.fPersonal, this.fIsZos, false);
        fBuildReportTree.addMouseListener((MouseListener)mouseListener);
        BuildReportTreeKeyListener keyListener = new BuildReportTreeKeyListener(cellManagers, this.fTeamRepository, this.fBuildDefUUID, this.fBuildmapMap, this.fUuidStateIDVersionIDMap, this.fComponentUUIDNameMap, this.fSystemDefMap, true, this.fResourcePrefix, this.fPersonal, this.fIsZos, false);
        fBuildReportTree.addKeyListener((KeyListener)keyListener);
        fBuildReportTree.addMouseTrackListener((MouseTrackListener)new BuildReportTreeMouseTrackListener(this.fUnbuiltViewer, false));
    }

    private void createFailedBuildReportTab(CTabFolder parent) {
        CTabItem failedTab = new CTabItem(parent, 0);
        failedTab.setData((Object)BuildableFileBuildResult.FAILED);
        String title = Messages.BuildReportPage_FAILED_TAB_LABEL;
        String titleWithDropdown = NLS.bind((String)Messages.BuildReportPage_Subsection_TabTitle_With_Dropdown, (Object)title);
        failedTab.setText(titleWithDropdown);
        Composite composite = this.fToolkit.createComposite((Composite)parent);
        GridLayoutFactory.fillDefaults().numColumns(1).applyTo(composite);
        GridDataFactory.fillDefaults().align(0x1000008, 0x1000000).grab(true, true).applyTo((Control)composite);
        failedTab.setControl((Control)composite);
        Composite treeComposite = this.fToolkit.createComposite(composite);
        GridDataFactory.fillDefaults().grab(true, true).hint(300, 150).applyTo((Control)treeComposite);
        Tree fBuildReportTree = this.fToolkit.createTree(treeComposite, 0x10010800);
        fBuildReportTree.setLinesVisible(true);
        fBuildReportTree.setHeaderVisible(true);
        TreeColumnLayout treeColumnLayout = new TreeColumnLayout();
        this.fFailedViewer = new TreeViewer(fBuildReportTree);
        BuildReportUtil.createTreeColumn(fBuildReportTree, this.fFailedViewer, treeColumnLayout, Messages.BuildReportPage_TABLE_COLUMN_SOURCE, 20, 16384, 0, Messages.BuildReportPage_TABLE_COLUMN_SOURCE, 0);
        BuildReportUtil.createTreeColumn(fBuildReportTree, this.fFailedViewer, treeColumnLayout, Messages.BuildReportPage_TABLE_COLUMN_REASON_TO_BUILD, 6, 16384, 1, Messages.BuildReportPage_REASON_TO_BUILD_TOOLTIP_OVERVIEW, 0);
        BuildReportUtil.createTreeColumn(fBuildReportTree, this.fFailedViewer, treeColumnLayout, Messages.BuildReportPage_TABLE_COLUMN_LANGUAGE_DEFINITION, 15, 16384, 2, Messages.BuildReportPage_TABLE_COLUMN_LANGUAGE_DEFINITION, 0);
        BuildReportUtil.createTreeColumn(fBuildReportTree, this.fFailedViewer, treeColumnLayout, Messages.BuildReportPage_FAILEDTABLE_COLUMN_EXPECTED_OUTPUT, 20, 16384, 3, Messages.BuildReportPage_TABLE_COLUMN_OUTPUT, 0);
        BuildReportUtil.createTreeColumn(fBuildReportTree, this.fFailedViewer, treeColumnLayout, Messages.BuildReportPage_TABLE_COLUMN_MAX_RETURN_CODE, 6, 16384, 4, Messages.BuildReportPage_TABLE_COLUMN_MAX_RETURN_CODE, 0);
        treeComposite.setLayout((Layout)treeColumnLayout);
        BuildReportViewerToolTipSupport.enableFor((ColumnViewer)this.fFailedViewer);
        HashSet<Integer> underlineSet = new HashSet<Integer>();
        underlineSet.add(2);
        underlineSet.add(0);
        HashSet<Integer> qualifierSet = new HashSet<Integer>();
        qualifierSet.add(0);
        this.fFailedLabelProvider = new BuildReportStyledLabelProvider(underlineSet, qualifierSet, this.fPersonal, this.fIsPreview, this.fIsZos, true, this.fTeamRepository, this.fSystemDefMap, this.fResourcePrefix);
        this.fFailedViewer.setLabelProvider((IBaseLabelProvider)this.fFailedLabelProvider);
        this.fFailedViewer.setContentProvider((IContentProvider)new BuildReportTreeContentProvider(this.fFailedViewer));
        TreeViewerFocusCellManager cellManagers = new TreeViewerFocusCellManager(this.fFailedViewer, (FocusCellHighlighter)new FocusCellOwnerDrawHighlighter((ColumnViewer)this.fFailedViewer){});
        BuildReportTreeMouseListener mouseListener = new BuildReportTreeMouseListener(cellManagers, this.fTeamRepository, this.fBuildDefUUID, this.fBuildmapMap, this.fUuidStateIDVersionIDMap, this.fComponentUUIDNameMap, this.fSystemDefMap, true, this.fResourcePrefix, this.fPersonal, this.fIsZos, true);
        fBuildReportTree.addMouseListener((MouseListener)mouseListener);
        BuildReportTreeKeyListener keyListener = new BuildReportTreeKeyListener(cellManagers, this.fTeamRepository, this.fBuildDefUUID, this.fBuildmapMap, this.fUuidStateIDVersionIDMap, this.fComponentUUIDNameMap, this.fSystemDefMap, true, this.fResourcePrefix, this.fPersonal, this.fIsZos, true);
        fBuildReportTree.addKeyListener((KeyListener)keyListener);
        fBuildReportTree.addMouseTrackListener((MouseTrackListener)new BuildReportTreeMouseTrackListener(this.fFailedViewer, true));
        parent.layout(true);
    }

    private void createSubsetMenu(Composite composite, BuildableFileBuildResult bfBuildResult) {
        Composite subsetComposite = this.fToolkit.createComposite(composite);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(subsetComposite);
        GridDataFactory.fillDefaults().align(1, 0x1000000).grab(false, false).applyTo((Control)subsetComposite);
        SubsetFromBuildReportAction subsetAction = new SubsetFromBuildReportAction(bfBuildResult, this.fTeamRepository, true);
        subsetAction.setActivePart((IAction)subsetAction, (IWorkbenchPart)this.fEditor);
        subsetAction.selectionChanged((IAction)subsetAction, (ISelection)new StructuredSelection((Object)this.fCache));
        ActionContributionItem aci = new ActionContributionItem((IAction)subsetAction);
        aci.fill(subsetComposite);
        Button b = (Button)aci.getWidget();
        b.setText("[nls]Create subset");
        b.setSize(150, 30);
        b.setEnabled(true);
        subsetAction = new SubsetFromBuildReportAction(bfBuildResult, this.fTeamRepository, false);
        subsetAction.setActivePart((IAction)subsetAction, (IWorkbenchPart)this.fEditor);
        subsetAction.selectionChanged((IAction)subsetAction, (ISelection)new StructuredSelection((Object)this.fCache));
        aci = new ActionContributionItem((IAction)subsetAction);
        aci.fill(subsetComposite);
        b = (Button)aci.getWidget();
        b.setText("[nls]Add to subset");
        b.setSize(150, 30);
        b.setEnabled(true);
    }

    private void createSuccessBuildReportTab(CTabFolder parent) {
        CTabItem successTab = new CTabItem(parent, 0);
        successTab.setData((Object)BuildableFileBuildResult.SUCCESS);
        String title = Messages.BuildReportPage_SUCCESS_TAB_LABEL;
        String titleWithDropdown = NLS.bind((String)Messages.BuildReportPage_Subsection_TabTitle_With_Dropdown, (Object)title);
        successTab.setText(titleWithDropdown);
        Composite composite = this.fToolkit.createComposite((Composite)parent);
        GridLayoutFactory.fillDefaults().numColumns(1).applyTo(composite);
        GridDataFactory.fillDefaults().align(0x1000008, 0x1000000).grab(true, true).applyTo((Control)composite);
        successTab.setControl((Control)composite);
        Composite treeComposite = this.fToolkit.createComposite(composite);
        GridDataFactory.fillDefaults().grab(true, true).hint(300, 150).applyTo((Control)treeComposite);
        Tree fBuildReportTree = this.fToolkit.createTree(treeComposite, 0x10010800);
        fBuildReportTree.setLinesVisible(true);
        fBuildReportTree.setHeaderVisible(true);
        TreeColumnLayout treeColumnLayout = new TreeColumnLayout();
        this.fSuccessViewer = new TreeViewer(fBuildReportTree);
        BuildReportUtil.createTreeColumn(fBuildReportTree, this.fSuccessViewer, treeColumnLayout, Messages.BuildReportPage_TABLE_COLUMN_SOURCE, 20, 16384, 0, Messages.BuildReportPage_TABLE_COLUMN_SOURCE, 0);
        BuildReportUtil.createTreeColumn(fBuildReportTree, this.fSuccessViewer, treeColumnLayout, Messages.BuildReportPage_TABLE_COLUMN_REASON_TO_BUILD, 6, 16384, 1, Messages.BuildReportPage_REASON_TO_BUILD_TOOLTIP_OVERVIEW, 0);
        BuildReportUtil.createTreeColumn(fBuildReportTree, this.fSuccessViewer, treeColumnLayout, Messages.BuildReportPage_TABLE_COLUMN_LANGUAGE_DEFINITION, 15, 16384, 2, Messages.BuildReportPage_TABLE_COLUMN_LANGUAGE_DEFINITION, 0);
        BuildReportUtil.createTreeColumn(fBuildReportTree, this.fSuccessViewer, treeColumnLayout, Messages.BuildReportPage_TABLE_COLUMN_OUTPUT, 20, 16384, 3, Messages.BuildReportPage_TABLE_COLUMN_OUTPUT, 0);
        BuildReportUtil.createTreeColumn(fBuildReportTree, this.fSuccessViewer, treeColumnLayout, Messages.BuildReportPage_TABLE_COLUMN_BUILDMAP, 5, 0x1000000, 4, Messages.BuildReportPage_TABLE_COLUMN_BUILDMAP, 0);
        BuildReportUtil.createTreeColumn(fBuildReportTree, this.fSuccessViewer, treeColumnLayout, Messages.BuildReportPage_TABLE_COLUMN_OUTPUT_TIMESTAMP, 15, 16384, 5, Messages.BuildReportPage_TABLE_COLUMN_OUTPUT_TIMESTAMP, 0);
        BuildReportUtil.createTreeColumn(fBuildReportTree, this.fSuccessViewer, treeColumnLayout, Messages.BuildReportPage_TABLE_COLUMN_MAX_RETURN_CODE, 6, 16384, 6, Messages.BuildReportPage_TABLE_COLUMN_MAX_RETURN_CODE, 0);
        treeComposite.setLayout((Layout)treeColumnLayout);
        BuildReportViewerToolTipSupport.enableFor((ColumnViewer)this.fSuccessViewer);
        HashSet<Integer> underlineSet = new HashSet<Integer>();
        underlineSet.add(2);
        underlineSet.add(0);
        HashSet<Integer> qualifierSet = new HashSet<Integer>();
        qualifierSet.add(0);
        this.fLabelProvider = new BuildReportStyledLabelProvider(underlineSet, qualifierSet, this.fPersonal, this.fIsPreview, this.fIsZos, false, this.fTeamRepository, this.fSystemDefMap, this.fResourcePrefix);
        this.fSuccessViewer.setLabelProvider((IBaseLabelProvider)this.fLabelProvider);
        this.fSuccessViewer.setContentProvider((IContentProvider)new BuildReportTreeContentProvider(this.fSuccessViewer));
        TreeViewerFocusCellManager cellManagers = new TreeViewerFocusCellManager(this.fSuccessViewer, (FocusCellHighlighter)new FocusCellOwnerDrawHighlighter((ColumnViewer)this.fSuccessViewer){});
        BuildReportTreeMouseListener mouseListener = new BuildReportTreeMouseListener(cellManagers, this.fTeamRepository, this.fBuildDefUUID, this.fBuildmapMap, this.fUuidStateIDVersionIDMap, this.fComponentUUIDNameMap, this.fSystemDefMap, this.fNeedInputs, this.fResourcePrefix, this.fPersonal, this.fIsZos, false);
        fBuildReportTree.addMouseListener((MouseListener)mouseListener);
        BuildReportTreeKeyListener keyListener = new BuildReportTreeKeyListener(cellManagers, this.fTeamRepository, this.fBuildDefUUID, this.fBuildmapMap, this.fUuidStateIDVersionIDMap, this.fComponentUUIDNameMap, this.fSystemDefMap, this.fNeedInputs, this.fResourcePrefix, this.fPersonal, this.fIsZos, false);
        fBuildReportTree.addKeyListener((KeyListener)keyListener);
        fBuildReportTree.addMouseTrackListener((MouseTrackListener)new BuildReportTreeMouseTrackListener(this.fSuccessViewer, false));
    }

    private void updateBookMarkNavigator(BuildableFileBuildResult buildResult) {
        this.fBookMarkLabel.setText(NLS.bind((String)Messages.BuildReportPage_Navigator_Label, (Object)this.fCurrentPageNum, (Object)this.fPageCapacity.get()));
        this.fBookMarkLabel.getParent().layout();
        this.fBookMarkLabel.getParent().getParent().layout();
        Map<Integer, Integer> pageBook = null;
        if (this.fPageBookMap != null) {
            pageBook = this.fPageBookMap.get(buildResult);
        }
        if (pageBook != null && 1 >= pageBook.size()) {
            this.navigatorComp.setVisible(false);
        } else {
            this.navigatorComp.setVisible(true);
        }
    }

    private void updateTreeNodes(int pageNum) {
        Map<Integer, Integer> pageBook = null;
        if (this.fPageBookMap != null) {
            pageBook = this.fPageBookMap.get(this.fBuildResult);
        }
        BuildReportTreeNode[] result = BuildReportUtil.getCurrentRootNodes(this.fCache, this.fFilter, pageNum, pageBook, this.fBuildResult);
        this.updateBookMarkNavigator(this.fBuildResult);
        BuildReportUtil.setTreeViewInput(result, this.fSuccessViewer, this.fFailedViewer, this.fUnbuiltViewer, this.fBuildResult);
    }

    protected Viewer getViewer() {
        TreeViewer result = null;
        if (this.fBuildResult != null) {
            if (BuildableFileBuildResult.SUCCESS.equals((Object)this.fBuildResult)) {
                result = this.fSuccessViewer;
            } else if (BuildableFileBuildResult.FAILED.equals((Object)this.fBuildResult)) {
                result = this.fFailedViewer;
            } else if (BuildableFileBuildResult.UNBUILD.equals((Object)this.fBuildResult)) {
                result = this.fUnbuiltViewer;
            }
        } else {
            result = this.fSuccessViewer;
        }
        return result;
    }

    public AbstractBuildResultPage.PageGroup getPageGroup() {
        return AbstractBuildResultPage.PageGroup.DOWNLOADS;
    }

    public void disposeContents() {
        super.disposeContents();
        if (this.fCache != null) {
            this.fCache.reset();
        }
        if (this.fPageCapacity != null) {
            this.fPageCapacity.set(0);
        }
        if (this.fUuidStateIDVersionIDMap != null) {
            this.fUuidStateIDVersionIDMap.clear();
        }
        if (this.fPageBookMap != null) {
            this.fPageBookMap.clear();
        }
        if (this.fBuildmapMap != null) {
            this.fBuildmapMap.clear();
        }
        if (this.fComponentUUIDNameMap != null) {
            this.fComponentUUIDNameMap.clear();
        }
        if (this.fSystemDefMap != null) {
            this.fSystemDefMap.clear();
        }
    }

    public void setBuidResult(BuildableFileBuildResult buildResult) {
        this.fBuildResult = buildResult;
    }

    public void setPageCapacity(int newValue) {
        this.fPageCapacity.set(newValue);
    }

    public void setCurrentPage(AtomicInteger currentPage) {
        this.fCurrentPageNum = currentPage;
    }
}

