/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.build.ui.editors.result;

import com.ibm.team.build.common.model.BuildState;
import com.ibm.team.build.common.model.BuildStatus;
import com.ibm.team.build.common.model.IBuildProperty;
import com.ibm.team.build.common.model.IBuildRequest;
import com.ibm.team.build.common.model.IBuildResult;
import com.ibm.team.build.common.model.IBuildResultContribution;
import com.ibm.team.build.ui.editors.result.AbstractBuildResultContributionProvider;
import com.ibm.team.build.ui.editors.result.AbstractBuildResultPage;
import com.ibm.team.build.ui.editors.result.IBuildResultContext;
import com.ibm.team.enterprise.build.common.IBuildConstants;
import com.ibm.team.enterprise.build.ui.editors.result.BuildReportPage;
import com.ibm.team.enterprise.internal.build.ui.nls.Messages;
import com.ibm.team.enterprise.internal.build.ui.utils.BuildReportUtil;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IContent;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.Properties;
import java.util.regex.Matcher;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ui.forms.editor.FormEditor;

public class BuildReportContributionProvider
extends AbstractBuildResultContributionProvider {
    private static final String ZERO_LENGTH_STRING = "";
    private IBuildResultContribution[] fContributions;
    private String label = "";
    private IContent fBuildReportContent = null;
    private IContent fFailedBuildReportContent = null;
    private ITeamRepository fTeamRepository = null;
    private int fTotalBuildFiles = -1;
    private int fFailedBuildFiles = -1;
    private String fBuildDefUUID = null;
    private boolean fIsPreview = false;
    private boolean fIsPersonal = false;
    private boolean isZos = false;
    private String fResourcePrefix = null;

    public BuildReportContributionProvider(FormEditor buildEditor, String extensionId, IBuildResultContext context) {
        super(buildEditor, extensionId, context);
        this.fTeamRepository = context.getTeamRepository();
    }

    public String[] getExtendedContributionIds() {
        return new String[]{"com.ibm.team.enterprise.build.buildReport"};
    }

    public void initializeContributionProvider(IProgressMonitor monitor) throws Exception {
        this.fContributions = this.getContributions();
        if (this.fContributions != null && this.fContributions.length > 0) {
            IBuildResultContribution contribution = this.fContributions[0];
            this.label = contribution.getLabel();
            this.fTotalBuildFiles = -1;
            if (this.label != null) {
                this.setTotalAndFailedBuildFiles(contribution);
            }
            this.fBuildDefUUID = this.getBuildResultContext().getBuildResultRecord().getBuildDefinition().getItemId().getUuidValue();
            this.fIsPersonal = this.getBuildResultContext().getBuildResult().isPersonalBuild();
            IBuildResultContribution[] contributions = this.getBuildResultContext().getBuildResultContributions(new String[]{IBuildResultContribution.ARTIFACT_EXTENDED_CONTRIBUTION_ID});
            if (contributions.length > 0) {
                IBuildResultContribution[] iBuildResultContributionArray = contributions;
                int n = contributions.length;
                int n2 = 0;
                while (n2 < n) {
                    IBuildResultContribution tempContribution = iBuildResultContributionArray[n2];
                    String fileName = tempContribution.getExtendedContributionProperty(IBuildResultContribution.PROPERTY_NAME_FILE_NAME);
                    if ("buildReport.xml".equals(fileName)) {
                        this.fBuildReportContent = tempContribution.getExtendedContributionData();
                    } else if ("build.properties".equals(tempContribution.getExtendedContributionProperty(IBuildResultContribution.PROPERTY_NAME_FILE_NAME))) {
                        String templateName;
                        Object buildTemplate;
                        IContent content = tempContribution.getExtendedContributionData();
                        ByteArrayOutputStream baos = new ByteArrayOutputStream();
                        this.fTeamRepository.contentManager().retrieveContent(content, (OutputStream)baos, null);
                        Properties properties = new Properties();
                        properties.load(new ByteArrayInputStream(baos.toByteArray()));
                        baos.close();
                        Object preObj = properties.get("team.enterprise.build.dependency.previewBuild");
                        if (preObj != null) {
                            this.fIsPreview = Boolean.valueOf(preObj.toString());
                        }
                        Object prefixObj = properties.get("team.enterprise.scm.resourcePrefix");
                        if (preObj != null) {
                            this.fResourcePrefix = String.valueOf(prefixObj.toString());
                        }
                        if ((buildTemplate = properties.get("com.ibm.team.build.internal.template.id")) != null && (templateName = buildTemplate.toString()) != null && ("com.ibm.team.enterprise.zos.build.dependency.template".equals(templateName) || "com.ibm.teamz.build.antz".equals(templateName))) {
                            this.isZos = true;
                        }
                    } else if ("failedBuildReport.xml".equals(fileName)) {
                        this.fFailedBuildReportContent = tempContribution.getExtendedContributionData();
                    }
                    ++n2;
                }
            }
        }
    }

    private void setTotalAndFailedBuildFiles(IBuildResultContribution contribution) {
        block9: {
            String failed;
            String total;
            block8: {
                IBuildProperty property;
                boolean preview = false;
                IBuildRequest request = this.getStartRequest(this.getBuildResultContext().getBuildResultRecord().getBuildRequests());
                if (request != null && (property = request.getBuildDefinitionInstance().getProperty("team.enterprise.build.dependency.previewBuild")) != null) {
                    preview = Boolean.parseBoolean(property.getValue());
                }
                total = contribution.getExtendedContributionProperty(IBuildResultContribution.PROPERTY_NAME_FILE_SIZE);
                failed = contribution.getExtendedContributionProperty(IBuildConstants.PROPERTY_NAME_FILE_FAILED);
                if (!preview && (total != null || failed != null || this.label == null)) break block8;
                Matcher paraMatch = BuildReportUtil.getMatcher(this.label, "([0-9]+)");
                while (paraMatch.find()) {
                    String numStr = paraMatch.group(1);
                    if (numStr == null || numStr.isEmpty()) continue;
                    if (-1 == this.fTotalBuildFiles) {
                        this.fTotalBuildFiles = Integer.valueOf(numStr.trim());
                        continue;
                    }
                    if (-1 != this.fFailedBuildFiles) continue;
                    this.fFailedBuildFiles = Integer.valueOf(numStr.trim());
                }
                break block9;
            }
            if (total != null) {
                try {
                    this.fTotalBuildFiles = Integer.parseInt(total);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (failed == null) break block9;
            try {
                this.fFailedBuildFiles = Integer.parseInt(failed);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private IBuildRequest getStartRequest(IBuildRequest[] allRequests) {
        IBuildRequest[] iBuildRequestArray = allRequests;
        int n = allRequests.length;
        int n2 = 0;
        while (n2 < n) {
            IBuildRequest currentRequest = iBuildRequestArray[n2];
            if (currentRequest.getBuildAction().getAction().equals("com.ibm.team.build.action.requestBuild")) {
                return currentRequest;
            }
            ++n2;
        }
        return null;
    }

    public String getSummaryText() {
        return this.label;
    }

    public String getSummaryTitle() {
        return Messages.BuildReportContributionProvider_SUMMARY_TITLE;
    }

    public BuildStatus getStatus() {
        return BuildStatus.INFO;
    }

    public boolean isSummaryLink() {
        IBuildResult buildResult;
        boolean result = false;
        IBuildResult iBuildResult = buildResult = this.getBuildResultContext() != null ? this.getBuildResultContext().getBuildResult() : null;
        if (this.label != null && this.fContributions != null && this.fContributions.length > 0 && BuildState.COMPLETED == (buildResult != null ? buildResult.getState() : null) && (this.fBuildReportContent != null || this.fFailedBuildReportContent != null)) {
            result = true;
        }
        return result;
    }

    public void summaryLinkActivated() {
        this.getBuildResultEditor().setActivePage("com.ibm.team.enterprise.build.ui.editors.result.BuildReportPage");
    }

    public AbstractBuildResultPage getBuildResultPage() {
        BuildReportPage result = null;
        if (this.isSummaryLink()) {
            result = new BuildReportPage(this.getBuildResultEditor(), Messages.BuildReportContributionProvider_PAGE_TITLE, this.getExtendedContributionIds(), this.getBuildResultContext(), this.fBuildReportContent, this.fFailedBuildReportContent, this.fTotalBuildFiles, this.fFailedBuildFiles, this.fBuildDefUUID, this.fTeamRepository, this.fIsPersonal, this.fIsPreview, this.isZos, this.fResourcePrefix);
        }
        return result;
    }
}

