/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.build.ui.editors.result;

import com.ibm.team.enterprise.build.ui.editors.result.internal.BuildReportTreeNode;
import com.ibm.team.enterprise.build.ui.editors.result.internal.IBuildReportNode;
import com.ibm.team.enterprise.common.common.utils.StringMatcher;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public class BuildReportContentFilter {
    private String pattern;
    private StringMatcher matcher;
    private ArrayList<Integer> searchColumn;
    private String fResourcePrefix = null;
    private boolean fRemovePrefix = false;
    private boolean fIsFailed = false;

    public BuildReportContentFilter(String pattern, ArrayList<Integer> searchColumn, String fResourcePrefix) {
        this.pattern = pattern;
        this.matcher = new StringMatcher("*" + pattern + "*", true, false);
        this.setSearchColumn(searchColumn);
        this.fResourcePrefix = fResourcePrefix;
    }

    public String getPattern() {
        return this.pattern;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
        this.matcher = new StringMatcher("*" + pattern + "*", true, false);
    }

    public BuildReportTreeNode[] filter(BuildReportTreeNode[] inputNodes) {
        LinkedList<BuildReportTreeNode> output = new LinkedList<BuildReportTreeNode>();
        BuildReportTreeNode[] buildReportTreeNodeArray = inputNodes;
        int n = inputNodes.length;
        int n2 = 0;
        while (n2 < n) {
            BuildReportTreeNode node = buildReportTreeNodeArray[n2];
            if (this.selected(node)) {
                output.add(node);
            } else {
                List<IBuildReportNode> children = this.filter(node.getChildren());
                if (children.size() > 0) {
                    for (IBuildReportNode child : children) {
                        child.setParentNode(node);
                    }
                    BuildReportTreeNode filteredNode = new BuildReportTreeNode(null, node.getProjectName(), node.getComponentName(), children);
                    output.add(filteredNode);
                }
            }
            ++n2;
        }
        return output.toArray(new BuildReportTreeNode[output.size()]);
    }

    private List<IBuildReportNode> filter(List<IBuildReportNode> inputNodes) {
        LinkedList<IBuildReportNode> output = new LinkedList<IBuildReportNode>();
        for (IBuildReportNode node : inputNodes) {
            List<IBuildReportNode> children;
            if (this.selected(node)) {
                try {
                    output.add(node.clone());
                }
                catch (CloneNotSupportedException e) {
                    e.printStackTrace();
                }
                continue;
            }
            if (!(node instanceof BuildReportTreeNode) || (children = this.filter(node.getChildren())).size() <= 0) continue;
            for (IBuildReportNode child : children) {
                child.setParentNode(node);
            }
            BuildReportTreeNode filteredNode = new BuildReportTreeNode(null, ((BuildReportTreeNode)node).getProjectName(), ((BuildReportTreeNode)node).getComponentName(), children);
            output.add(filteredNode);
        }
        return output;
    }

    protected boolean selected(IBuildReportNode node) {
        boolean isMatch = false;
        for (Integer columnIndex : this.searchColumn) {
            isMatch = CompareOperator.matches(this.matcher, node.getColumnText(columnIndex, this.fRemovePrefix, this.fResourcePrefix, this.fIsFailed));
            if (isMatch) break;
        }
        return isMatch;
    }

    public ArrayList<Integer> getSearchColumn() {
        return this.searchColumn;
    }

    public void setSearchColumn(ArrayList<Integer> searchColumn) {
        this.searchColumn = searchColumn;
    }

    public void setRemovePrefix(boolean fRemovePrefix) {
        this.fRemovePrefix = fRemovePrefix;
    }

    public void setFailed(boolean fIsFailed) {
        this.fIsFailed = fIsFailed;
    }

    public static class CompareOperator {
        public static boolean matches(StringMatcher pattern, String content) {
            if (pattern != null && content != null && content.length() > 0) {
                return pattern.match(content);
            }
            return false;
        }
    }
}

