/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.build.ui.editors.result;

import com.ibm.team.enterprise.internal.build.ui.nls.Messages;
import com.ibm.team.enterprise.internal.build.ui.utils.BuildReportUtil;
import com.ibm.team.enterprise.internal.buildmap.common.IBuildFile;
import java.util.Set;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.widgets.Display;

public abstract class AbstractBuildStyledLabelProvider
extends StyledCellLabelProvider {
    protected StyledString.Styler fHyperLinkStyler = new UnderLineLinkStyler();
    protected Set<Integer> fUnderLineSet = null;
    protected Set<Integer> fQualifierSet = null;

    public AbstractBuildStyledLabelProvider(Set<Integer> underLineSet, Set<Integer> qualifierSet) {
        this.fUnderLineSet = underLineSet;
        this.fQualifierSet = qualifierSet;
    }

    public void update(ViewerCell cell) {
        String resolvedTo;
        Object element = cell.getElement();
        int column = cell.getColumnIndex();
        String columnText = this.getColumnText(element, column);
        StyledString styledStr = null;
        if (columnText != null && this.isLinkStyledElement(element) && this.isLinkStyledColumn(element, column)) {
            styledStr = new StyledString(columnText, this.fHyperLinkStyler);
        } else if (columnText != null && this.isQualifierStyledElement(element, column)) {
            styledStr = this.getQualifierStyledText(element, column);
        } else if (columnText != null && column == 0 && element instanceof IBuildFile && (resolvedTo = ((IBuildFile)element).getResolvedTo()) != null && resolvedTo.length() > 0) {
            styledStr = BuildReportUtil.getQualifierSourceString(((IBuildFile)element).getBuildFile(), NLS.bind((String)Messages.BuildMapEditor_INPUTS_RESOLVED_TO_LABEL, (Object)resolvedTo));
        }
        if (styledStr != null) {
            cell.setText(styledStr.getString());
            cell.setStyleRanges(styledStr.getStyleRanges());
        } else {
            cell.setText(columnText);
        }
        cell.setImage(this.getColumnImage(element, column));
        super.update(cell);
    }

    protected boolean isLinkStyledColumn(Object element, int column) {
        return this.fUnderLineSet != null && this.fUnderLineSet.contains(column);
    }

    protected boolean isQualifierStyledElement(Object element, int columnIndex) {
        boolean result = this.fQualifierSet != null && this.fQualifierSet.contains(columnIndex);
        return result;
    }

    protected abstract boolean isLinkStyledElement(Object var1);

    protected StyledString getQualifierStyledText(Object element, int columnIndex) {
        return null;
    }

    public abstract Image getColumnImage(Object var1, int var2);

    public abstract String getColumnText(Object var1, int var2);

    public abstract String getToolTipText(Object var1, int var2);

    public abstract Image getToolTipImage(Object var1, int var2);

    protected class UnderLineLinkStyler
    extends StyledString.Styler {
        protected UnderLineLinkStyler() {
        }

        public void applyStyles(TextStyle textStyle) {
            textStyle.underline = true;
            textStyle.foreground = Display.getDefault().getSystemColor(9);
        }
    }
}

