/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.build.ui.editors.buildmap;

import com.ibm.team.enterprise.build.common.buildreport.BuildReportConstants;
import com.ibm.team.enterprise.build.ui.editors.buildmap.ResolvedInputNode;
import com.ibm.team.enterprise.internal.build.ui.utils.BuildReportUtil;
import java.util.List;

public class ResolvedInputRootNode {
    private String fProjectName = null;
    private String fComponentName = null;
    private ResolvedInputRootNode fParentNode = null;
    private List<ResolvedInputNode> fChildren = null;
    private String fName = null;

    public ResolvedInputRootNode(String projectName, String componentName, List<ResolvedInputNode> children) {
        this.fProjectName = projectName;
        this.fComponentName = componentName;
        this.fName = String.valueOf(this.fProjectName) + "(" + this.fComponentName + ")";
        this.fChildren = children;
    }

    public ResolvedInputRootNode getParentNode() {
        return this.fParentNode;
    }

    public void setParentNode(ResolvedInputRootNode fParentNode) {
        this.fParentNode = fParentNode;
    }

    public String getColumnText(int columnIndex) {
        String result = null;
        if (columnIndex == 0) {
            result = this.fName;
        }
        return result;
    }

    public String getProjectName() {
        return this.fProjectName;
    }

    public String getComponentName() {
        return this.fComponentName;
    }

    public List<ResolvedInputNode> getChildren() {
        return this.fChildren;
    }

    public void setChildren(List<ResolvedInputNode> children) {
        this.fChildren = children;
    }

    public int hashCode() {
        int result = BuildReportConstants.HASHCODE_INITIAL;
        result = BuildReportUtil.hashCode((int)result, (Object)this.fProjectName);
        result = BuildReportUtil.hashCode((int)result, (Object)this.fParentNode);
        result = BuildReportUtil.hashCode((int)result, this.fChildren);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        boolean result = false;
        if (obj instanceof ResolvedInputRootNode) {
            ResolvedInputRootNode leafNode = (ResolvedInputRootNode)obj;
            if ((this.fProjectName == null && leafNode.getProjectName() == null || this.fProjectName != null && this.fProjectName.equals(leafNode.getProjectName())) && (this.fProjectName == null && leafNode.getProjectName() == null || this.fProjectName != null && this.fProjectName.equals(leafNode.getProjectName())) && (this.fParentNode == null && leafNode.getParentNode() == null || this.fParentNode != null && this.fParentNode.equals(leafNode.getParentNode())) && (this.fChildren == null && leafNode.getChildren() == null || this.fChildren != null && this.fChildren.equals(leafNode.getChildren()))) {
                result = true;
            }
        }
        return result;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        if (this.fProjectName != null && this.fProjectName.length() > 0) {
            builder.append("Name: ").append(this.fProjectName);
        }
        if (this.fParentNode != null) {
            builder.append(" | Parent Node: ").append(this.fParentNode.getColumnText(0));
        }
        if (this.fChildren != null && this.fChildren.size() > 0) {
            builder.append(" | Children Nodes [");
            for (ResolvedInputNode child : this.fChildren) {
                builder.append("\n{");
                builder.append(child);
                builder.append("}");
            }
            builder.deleteCharAt(builder.length() - 1);
            builder.append("\n]");
        }
        return builder.toString();
    }
}

