/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.build.ui.editors.buildmap;

import com.ibm.team.enterprise.build.common.buildreport.BuildReportConstants;
import com.ibm.team.enterprise.build.ui.editors.buildmap.ResolvedInputRootNode;
import com.ibm.team.enterprise.internal.build.ui.utils.BuildReportUtil;
import com.ibm.team.enterprise.internal.buildmap.common.IBuildFile;

public class ResolvedInputNode {
    private ResolvedInputRootNode fParentNode = null;
    private IBuildFile fBuildFile = null;
    private boolean fIsZos = true;

    public ResolvedInputNode(ResolvedInputRootNode parentNode, IBuildFile fBuildFile, boolean isZos) {
        this.fParentNode = parentNode;
        this.fBuildFile = fBuildFile;
        this.fIsZos = isZos;
    }

    public ResolvedInputRootNode getParentNode() {
        return this.fParentNode;
    }

    public void setParentNode(ResolvedInputRootNode fParentNode) {
        this.fParentNode = fParentNode;
    }

    public String getColumnText(int columnIndex, String fResourcePrefix) {
        String result = null;
        if (this.fBuildFile != null) {
            switch (columnIndex) {
                case 0: {
                    result = this.fIsZos ? BuildReportUtil.generateFullPathWithoutPrefix((String)this.fBuildFile.getBuildPath(), (String)this.fBuildFile.getBuildFile(), (String)this.fBuildFile.getOutputType(), (String)this.fBuildFile.getSequential(), (String)fResourcePrefix, (boolean)this.fBuildFile.isHFS()) : BuildReportUtil.generateBuildFileFullPath((String)this.fBuildFile.getBuildPath(), (String)this.fBuildFile.getBuildFile(), (String)this.fBuildFile.getOutputType(), (String)this.fBuildFile.getSequential(), (boolean)this.fBuildFile.isHFS());
                    break;
                }
                case 1: {
                    result = this.fBuildFile.getSCMLocation();
                    break;
                }
                case 2: {
                    result = this.fBuildFile.getType();
                    break;
                }
                case 3: {
                    String versionID = this.fBuildFile.getUserPropertyValue("versionID");
                    result = versionID != null && versionID.length() > 0 ? versionID : "";
                }
            }
        }
        return result;
    }

    public IBuildFile getBuildFile() {
        return this.fBuildFile;
    }

    public void setBuildFile(IBuildFile fBuildFile) {
        this.fBuildFile = fBuildFile;
    }

    public int hashCode() {
        int result = BuildReportConstants.HASHCODE_INITIAL;
        result = BuildReportUtil.hashCode((int)result, (Object)this.fBuildFile);
        result = BuildReportUtil.hashCode((int)result, (Object)this.fParentNode);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        boolean result = false;
        if (obj instanceof ResolvedInputNode) {
            ResolvedInputNode leafNode = (ResolvedInputNode)obj;
            if ((this.fBuildFile == null && leafNode.getBuildFile() == null || this.fBuildFile != null && this.fBuildFile.equals(leafNode.getBuildFile())) && (this.fParentNode == null && leafNode.getParentNode() == null || this.fParentNode != null && this.fParentNode.equals(leafNode.getParentNode()))) {
                result = true;
            }
        }
        return result;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        if (this.fBuildFile != null) {
            builder.append("Build File: ").append(this.fBuildFile);
        }
        if (this.fParentNode != null) {
            builder.append(" | Parent Node: ").append(this.fParentNode.getColumnText(0));
        }
        return builder.toString();
    }
}

