/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.build.ui.editors.buildmap;

import com.ibm.team.build.common.model.IBuildDefinition;
import com.ibm.team.build.common.model.IBuildDefinitionHandle;
import com.ibm.team.build.common.model.IBuildResult;
import com.ibm.team.build.common.model.IBuildResultHandle;
import com.ibm.team.build.internal.ui.actions.EditBuildDefinitionActionDelegate;
import com.ibm.team.build.internal.ui.helper.BuildUIHelper;
import com.ibm.team.build.internal.ui.jobs.TeamBuildJob;
import com.ibm.team.build.ui.BuildUI;
import com.ibm.team.enterprise.build.buildmap.common.model.IBuildMap;
import com.ibm.team.enterprise.build.buildmap.common.model.IBuildMapHandle;
import com.ibm.team.enterprise.build.client.buildmap.IBuildMapClient;
import com.ibm.team.enterprise.build.ui.Activator;
import com.ibm.team.enterprise.build.ui.editors.buildmap.AbstractBuildMapFormPage;
import com.ibm.team.enterprise.build.ui.editors.buildmap.BuildMapEditor;
import com.ibm.team.enterprise.build.ui.editors.buildmap.BuildMapEditorInput;
import com.ibm.team.enterprise.common.client.util.URIUtilities;
import com.ibm.team.enterprise.common.ui.EnterpriseHyperlinkHandler;
import com.ibm.team.enterprise.internal.build.ui.nls.Messages;
import com.ibm.team.enterprise.internal.build.ui.utils.BuildReportUtil;
import com.ibm.team.enterprise.systemdefinition.common.model.ISystemDefinition;
import com.ibm.team.filesystem.ui.views.SnapshotEditorInput;
import com.ibm.team.filesystem.ui.views.TeamPlaceEditorInput;
import com.ibm.team.filesystem.ui.views.TeamPlacePart2;
import com.ibm.team.filesystem.ui.wrapper.AbstractPlaceWrapper;
import com.ibm.team.process.internal.common.NLS;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.ItemNotFoundException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.common.IBaselineSet;
import com.ibm.team.scm.common.IBaselineSetHandle;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.IWorkspaceHandle;
import com.ibm.team.scm.common.dto.IBaselineSetSearchCriteria;
import java.net.URI;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.dialogs.FilteredList;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.part.PageBook;

public class BuildMapOverviewPage
extends AbstractBuildMapFormPage {
    private Composite fTopCom = null;
    private ScrolledComposite fOverviewCom = null;
    private Composite fOverviewContent = null;
    private Text fBFileFullPathText = null;
    private Hyperlink fBuildLink = null;
    private Hyperlink fBuildDefLink = null;
    private Hyperlink fPromotionDefLink = null;
    private Hyperlink fLanguageDefLink = null;
    private Hyperlink fWorkspaceLink = null;
    private Hyperlink fSnapshotLink = null;
    private Label fSourceBuildMapLink = null;
    private Label fSourceBuildMapLabel = null;
    private Text fLoadDirectText = null;
    private PageBook fWholePageBook = null;
    private IWorkspace fWorkspace = null;
    private IBaselineSet fSnapshot = null;
    private IBuildDefinition fBuildDefinition = null;
    private IBuildResult fBuildResult = null;
    private IBuildResult fPromotionResult = null;
    private IBuildDefinition fPromotionBuildDefinition = null;
    private Label fBuildLabel;
    private Button fBuildBrowseButton = null;
    private Label fPromotionDefLabel;
    private Label fSnapshotLabel;
    private Map<String, IAuditableHandle> fBuildMapStatesMap = null;
    private int fBuildmapStatesLimit;

    public BuildMapOverviewPage(FormEditor editor, String id, String title) {
        super(editor, id, title);
    }

    @Override
    public void initializeContent() {
        if (this.fBuildMap == null) {
            this.fWholePageBook.showPage((Control)this.fNoBuildMapControl);
            this.fNoBuildMapLink.setText(NLS.bind((String)Messages.BuildMapEditor_NOMAP_LABEL, (Object)this.fBuildMapURI));
            this.fNoBuildMapControl.layout();
        } else {
            this.fWholePageBook.showPage((Control)this.fTopCom);
        }
        this.updateContent();
    }

    @Override
    protected void createContainerContent(Composite container) {
        this.fWholePageBook = new PageBook(container, 0);
        this.fWholePageBook.setBackground(container.getBackground());
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.fWholePageBook);
        this.createNoBuildMapControl((Composite)this.fWholePageBook);
        this.fTopCom = new Composite((Composite)this.fWholePageBook, 0);
        this.fTopCom.setBackground(container.getBackground());
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.fTopCom);
        GridLayoutFactory.fillDefaults().margins(5, 2).applyTo(this.fTopCom);
        this.createBuildOverviewPart(this.fTopCom);
        this.fTopCom.layout();
        container.layout();
        this.initializeContent();
    }

    protected SelectionListener getTeamArtifactsLinkSelectionListener(final IWorkbenchSite site) {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    site.getWorkbenchWindow().getActivePage().showView("com.ibm.team.process.rcp.ui.teamArtifactsNavigator");
                }
                catch (PartInitException exception) {
                    Activator.getDefault().logError(exception);
                }
            }
        };
    }

    private void createBuildOverviewPart(Composite leftPartCom) {
        Section overviewSection = this.createSection(leftPartCom, Messages.BuildMapEditor_GENERAL_SECTION_TITLE, null, 0, true, false);
        this.fOverviewCom = new ScrolledComposite((Composite)overviewSection, 768);
        this.fOverviewCom.setBackground(this.fFormToolkit.getColors().getBackground());
        this.fOverviewContent = this.fFormToolkit.createComposite((Composite)this.fOverviewCom);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.fOverviewContent);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(this.fOverviewContent);
        overviewSection.setClient((Control)this.fOverviewCom);
        this.fFormToolkit.createLabel(this.fOverviewContent, Messages.BuildMapEditor_GENERAL_SOURCE_LABEL);
        this.fBFileFullPathText = BuildUIHelper.createNonEditableText((FormToolkit)this.fFormToolkit, (Composite)this.fOverviewContent, (String)"", (int)0);
        this.fFormToolkit.createLabel(this.fOverviewContent, Messages.BuildMapEditor_GENERAL_WORKSPACE_LABEL);
        this.fWorkspaceLink = this.fFormToolkit.createHyperlink(this.fOverviewContent, "", 0);
        this.fWorkspaceLink.addHyperlinkListener(this.getWorkspaceHyperlinkListener());
        this.fFormToolkit.createLabel(this.fOverviewContent, Messages.BuildMapEditor_GENERAL_LANGUAGE_DEFINITION_LABEL);
        this.fLanguageDefLink = this.fFormToolkit.createHyperlink(this.fOverviewContent, "", 0);
        this.fLanguageDefLink.addHyperlinkListener(this.getLangDefHyperlinkListener());
        this.fFormToolkit.createLabel(this.fOverviewContent, Messages.BuildMapEditor_GENERAL_LOAD_DIRECTORY_LABEL);
        this.fLoadDirectText = BuildUIHelper.createNonEditableText((FormToolkit)this.fFormToolkit, (Composite)this.fOverviewContent, (String)"", (int)0);
        this.fFormToolkit.createLabel(this.fOverviewContent, Messages.BuildMapEditor_GENERAL_BUILD_DEFINITION_LABEL);
        this.fBuildDefLink = this.fFormToolkit.createHyperlink(this.fOverviewContent, "", 0);
        this.fBuildDefLink.addHyperlinkListener(this.getBuildDefHyperlinkListener());
        this.fPromotionDefLabel = this.fFormToolkit.createLabel(this.fOverviewContent, Messages.BuildMapEditor_GENERAL_PROMO_DEFINE_LABEL);
        this.fPromotionDefLink = this.fFormToolkit.createHyperlink(this.fOverviewContent, "", 0);
        this.fPromotionDefLink.addHyperlinkListener(this.getPromDefHyperlinkListener());
        this.setPromotionDefStatus(false);
        this.fBuildLabel = this.fFormToolkit.createLabel(this.fOverviewContent, Messages.BuildMapEditor_GENERAL_BUILD_LABEL);
        Composite composite = this.fFormToolkit.createComposite(this.fOverviewContent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.marginWidth = 0;
        composite.setLayout((Layout)gridLayout);
        this.fBuildLink = new Hyperlink(composite, Window.getDefaultOrientation());
        this.fBuildLink.setText("");
        this.fBuildLink.setForeground(this.fFormToolkit.getHyperlinkGroup().getForeground());
        this.fBuildLink.setBackground(this.fFormToolkit.getHyperlinkGroup().getBackground());
        this.fBuildLink.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.fBuildLink.addHyperlinkListener(this.getBuildResultHyperlinkListener());
        this.fBuildBrowseButton = new Button(composite, 8);
        this.fBuildBrowseButton.setText(Messages.EnterpriseBuildUI_BUTTON_BROWSE_FOR_VERSION);
        this.fBuildBrowseButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.fBuildBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                BuildMapOverviewPage.this.chooseBuildMapState();
            }
        });
        this.fSnapshotLabel = this.fFormToolkit.createLabel(this.fOverviewContent, Messages.BuildMapEditor_GENERAL_SNAPSHOT_LABEL);
        this.fSnapshotLink = this.fFormToolkit.createHyperlink(this.fOverviewContent, "", 0);
        this.fSnapshotLink.addHyperlinkListener(this.getSnapshotHyperlinkListener());
        this.fSourceBuildMapLabel = this.fFormToolkit.createLabel(this.fOverviewContent, Messages.BuildMapEditor_SOURCE_BUILD_MAP_LINK);
        this.fSourceBuildMapLink = this.fFormToolkit.createLabel(this.fOverviewContent, "", 0);
        this.fSourceBuildMapLink.setImage(Activator.getImage("icons/misc/externalLink.gif"));
        this.fSourceBuildMapLink.addMouseListener((MouseListener)new MouseAdapter(){
            private static final String BUILD_MAP_NAMESPACE = "enterprise.build.buildmap";

            public void mouseDown(MouseEvent e) {
                EnterpriseHyperlinkHandler hyperlinkHandler;
                URI buildMapURI;
                if (BuildMapOverviewPage.this.fBuildMap != null && (buildMapURI = (hyperlinkHandler = new EnterpriseHyperlinkHandler()).createHyperlink((Object)BuildMapOverviewPage.this.fBuildMap, null).getURI()) != null) {
                    final BuildMapEditorInput editorInput = new BuildMapEditorInput(buildMapURI, null, null, null, null, BuildMapOverviewPage.this.fTeamRepository);
                    PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().openEditor(editorInput, "com.ibm.team.enterprise.build.ui.editors.buildMapEditor");
                            }
                            catch (PartInitException ex) {
                                Activator.getDefault().logError(ex);
                            }
                        }
                    });
                }
            }
        });
        this.setScrolledCom(this.fOverviewCom, this.fOverviewContent);
        overviewSection.setExpanded(true);
    }

    protected IHyperlinkListener getPromotionSourceHyperlinkListener() {
        return new HyperlinkAdapter(){
            private static final String BUILD_MAP_NAMESPACE = "enterprise.build.buildmap";

            public void linkActivated(HyperlinkEvent e) {
                EnterpriseHyperlinkHandler hyperlinkHandler;
                URI buildMapURI;
                if (BuildMapOverviewPage.this.fBuildMap != null && (buildMapURI = (hyperlinkHandler = new EnterpriseHyperlinkHandler()).createHyperlink((Object)BuildMapOverviewPage.this.fBuildMap, null).getURI()) != null) {
                    final BuildMapEditorInput editorInput = new BuildMapEditorInput(buildMapURI, null, null, null, null, BuildMapOverviewPage.this.fTeamRepository);
                    PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().openEditor(editorInput, "com.ibm.team.enterprise.build.ui.editors.buildMapEditor");
                            }
                            catch (PartInitException ex) {
                                Activator.getDefault().logError(ex);
                            }
                        }
                    });
                }
            }
        };
    }

    private void setScrolledCom(ScrolledComposite com, Composite content) {
        if (com != null) {
            com.setContent((Control)content);
            com.setExpandVertical(true);
            com.setExpandHorizontal(true);
            com.layout(true);
            com.setMinSize(content.computeSize(-1, -1));
        }
    }

    public void updateContent() {
        if (this.fBuildMap == null) {
            return;
        }
        this.retrievelinkedItems();
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                String fullPath;
                if (BuildMapOverviewPage.this.fSourceFile != null && (fullPath = BuildReportUtil.generateBuildFileFullPath((String)BuildMapOverviewPage.this.fSourceFile.getBuildPath(), (String)(BuildMapOverviewPage.this.fSourceFile.isHFS() ? "" : BuildMapOverviewPage.this.fSourceFile.getBuildFile()), (String)BuildMapOverviewPage.this.fSourceFile.getOutputType(), (String)BuildMapOverviewPage.this.fSourceFile.getSequential(), (boolean)BuildMapOverviewPage.this.fSourceFile.isHFS())) != null) {
                    BuildMapOverviewPage.this.fBFileFullPathText.setText(fullPath);
                }
                if (BuildMapOverviewPage.this.fBuildMap != null) {
                    String loadDirect = BuildMapOverviewPage.this.fBuildMap.getLoadDirectory();
                    if (loadDirect != null) {
                        BuildMapOverviewPage.this.fLoadDirectText.setText(loadDirect);
                    }
                    BuildMapOverviewPage.this.fOverviewContent.layout();
                    BuildMapOverviewPage.this.updateBrowseButton();
                }
            }
        });
    }

    private void retrievelinkedItems() {
        if (this.fBuildMap == null) {
            return;
        }
        TeamBuildJob job = new TeamBuildJob(Messages.BuildMapEditor_RETRIEVE_LINKED_ITMES_JOB_TITLE, true){

            protected IStatus runProtected(IProgressMonitor monitor) throws Exception {
                try {
                    String workspaceUUId = BuildMapOverviewPage.this.fBuildMap.getWorkspaceUUID();
                    IWorkspaceHandle workspaceHandle = null;
                    if (BuildMapOverviewPage.this.fWorkspace == null || BuildMapOverviewPage.this.fWorkspace != null && !BuildMapOverviewPage.this.fWorkspace.getItemId().getUuidValue().equals(workspaceUUId)) {
                        workspaceHandle = (IWorkspaceHandle)IWorkspace.ITEM_TYPE.createItemHandle(UUID.valueOf((String)workspaceUUId), null);
                        try {
                            BuildMapOverviewPage.this.fWorkspace = (IWorkspace)BuildMapOverviewPage.this.fTeamRepository.itemManager().fetchCompleteItem((IItemHandle)workspaceHandle, 0, monitor);
                        }
                        catch (ItemNotFoundException e) {
                            BuildMapOverviewPage.this.fWorkspace = null;
                            workspaceHandle = null;
                        }
                    } else if (BuildMapOverviewPage.this.fWorkspace != null) {
                        workspaceHandle = (IWorkspaceHandle)BuildMapOverviewPage.this.fWorkspace.getItemHandle();
                    }
                    String snapshotName = BuildMapOverviewPage.this.fBuildMap.getSnapshot();
                    if (workspaceHandle != null && snapshotName != null && snapshotName.length() > 0 && (BuildMapOverviewPage.this.fSnapshot == null || BuildMapOverviewPage.this.fSnapshot != null && !BuildMapOverviewPage.this.fSnapshot.getName().equals(snapshotName))) {
                        IBaselineSetHandle baselineSetHandle = null;
                        List baselineSetHandles = SCMPlatform.getWorkspaceManager((ITeamRepository)BuildMapOverviewPage.this.fTeamRepository).findBaselineSets(IBaselineSetSearchCriteria.FACTORY.newInstance().setOwnerWorkspaceOptional(workspaceHandle).setExactName(snapshotName), Integer.MAX_VALUE, monitor);
                        if (baselineSetHandles != null && baselineSetHandles.size() > 0) {
                            baselineSetHandle = (IBaselineSetHandle)baselineSetHandles.get(0);
                        }
                        if (baselineSetHandle != null) {
                            BuildMapOverviewPage.this.fSnapshot = (IBaselineSet)BuildMapOverviewPage.this.fTeamRepository.itemManager().fetchCompleteItem((IItemHandle)baselineSetHandle, 0, monitor);
                        }
                    }
                    String buildDefUUID = BuildMapOverviewPage.this.fBuildMap.getBuildDefinitionUUID();
                    if (BuildMapOverviewPage.this.fBuildDefinition == null || BuildMapOverviewPage.this.fBuildDefinition != null && !BuildMapOverviewPage.this.fBuildDefinition.getItemId().getUuidValue().equals(buildDefUUID)) {
                        IBuildDefinitionHandle buildDefHandle = (IBuildDefinitionHandle)IBuildDefinition.ITEM_TYPE.createItemHandle(UUID.valueOf((String)buildDefUUID), null);
                        BuildMapOverviewPage.this.fBuildDefinition = (IBuildDefinition)BuildMapOverviewPage.this.fTeamRepository.itemManager().fetchCompleteItem((IItemHandle)buildDefHandle, 0, monitor);
                    }
                    String buildResultUUID = BuildMapOverviewPage.this.fBuildMap.getBuildResultUUID();
                    if (BuildMapOverviewPage.this.fBuildResult == null && buildResultUUID != null && !"".equals(buildResultUUID) || BuildMapOverviewPage.this.fBuildResult != null && !BuildMapOverviewPage.this.fBuildResult.getItemId().getUuidValue().equals(buildResultUUID)) {
                        IBuildResultHandle buildResultHandle = (IBuildResultHandle)IBuildResult.ITEM_TYPE.createItemHandle(UUID.valueOf((String)buildResultUUID), null);
                        try {
                            BuildMapOverviewPage.this.fBuildResult = (IBuildResult)BuildMapOverviewPage.this.fTeamRepository.itemManager().fetchCompleteItem((IItemHandle)buildResultHandle, 0, monitor);
                        }
                        catch (Exception e) {
                            BuildMapOverviewPage.this.fBuildResult = null;
                        }
                    }
                    if (buildResultUUID == null || buildResultUUID.length() == 0) {
                        String promotionResultUUID = BuildMapOverviewPage.this.fBuildMap.getPromotionResultUUID();
                        if (BuildMapOverviewPage.this.fPromotionResult == null && promotionResultUUID != null && promotionResultUUID.length() > 0 || BuildMapOverviewPage.this.fPromotionResult != null && !BuildMapOverviewPage.this.fPromotionResult.getItemId().getUuidValue().equals(promotionResultUUID)) {
                            IBuildResultHandle buildResultHandle = (IBuildResultHandle)IBuildResult.ITEM_TYPE.createItemHandle(UUID.valueOf((String)promotionResultUUID), null);
                            BuildMapOverviewPage.this.fPromotionResult = (IBuildResult)BuildMapOverviewPage.this.fTeamRepository.itemManager().fetchCompleteItem((IItemHandle)buildResultHandle, 0, monitor);
                            if (BuildMapOverviewPage.this.fPromotionResult != null) {
                                BuildMapOverviewPage.this.fPromotionBuildDefinition = (IBuildDefinition)BuildMapOverviewPage.this.fTeamRepository.itemManager().fetchCompleteItem((IItemHandle)BuildMapOverviewPage.this.fPromotionResult.getBuildDefinition(), 0, monitor);
                            }
                        } else if (promotionResultUUID == null || promotionResultUUID.length() == 0) {
                            BuildMapOverviewPage.this.fPromotionResult = null;
                            BuildMapOverviewPage.this.fPromotionBuildDefinition = null;
                        }
                    }
                }
                catch (Exception e) {
                    Activator.getDefault().logError(e);
                    return new Status(4, "com.ibm.team.enterprise.build.ui", Messages.BuildMapEditor_GENERAL_ERROR_RETRIEVE_LINKS, (Throwable)e);
                }
                return null;
            }

            protected void jobFinished(IStatus status) {
                BuildMapOverviewPage.this.updateHyperLinks();
            }
        };
        job.schedule();
    }

    protected void updateHyperLinks() {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (BuildMapOverviewPage.this.fWorkspace != null) {
                    BuildMapOverviewPage.this.fWorkspaceLink.setText(BuildMapOverviewPage.this.fWorkspace.getName());
                    BuildMapOverviewPage.this.fWorkspaceLink.setUnderlined(true);
                } else {
                    if (BuildMapOverviewPage.this.fBuildMap != null) {
                        BuildMapOverviewPage.this.fWorkspaceLink.setText(BuildMapOverviewPage.this.fBuildMap.getWorkspaceUUID());
                    } else {
                        BuildMapOverviewPage.this.fWorkspaceLink.setText("");
                    }
                    BuildMapOverviewPage.this.fWorkspaceLink.setUnderlined(false);
                }
                BuildMapOverviewPage.this.fSnapshotLink.setVisible(true);
                BuildMapOverviewPage.this.fSnapshotLabel.setVisible(true);
                if (BuildMapOverviewPage.this.fSnapshot != null) {
                    BuildMapOverviewPage.this.fSnapshotLink.setText(BuildMapOverviewPage.this.fSnapshot.getName());
                    BuildMapOverviewPage.this.fSnapshotLink.setUnderlined(true);
                } else {
                    if (BuildMapOverviewPage.this.fBuildMap != null) {
                        if (BuildMapOverviewPage.this.fBuildMap.getSourceBuildMapSlug() == null) {
                            BuildMapOverviewPage.this.fSnapshotLink.setText(BuildMapOverviewPage.this.fBuildMap.getSnapshot());
                        } else {
                            BuildMapOverviewPage.this.fSnapshotLink.setVisible(false);
                            BuildMapOverviewPage.this.fSnapshotLabel.setVisible(false);
                            BuildMapOverviewPage.this.fSnapshotLink.dispose();
                            BuildMapOverviewPage.this.fSnapshotLabel.dispose();
                        }
                    } else {
                        BuildMapOverviewPage.this.fSnapshotLink.setText("");
                    }
                    if (!BuildMapOverviewPage.this.fSnapshotLink.isDisposed()) {
                        BuildMapOverviewPage.this.fSnapshotLink.setUnderlined(false);
                    }
                }
                if (BuildMapOverviewPage.this.fBuildDefLink != null && BuildMapOverviewPage.this.fBuildDefinition != null) {
                    BuildMapOverviewPage.this.fBuildDefLink.setText(BuildMapOverviewPage.this.fBuildDefinition.getId());
                    BuildMapOverviewPage.this.fBuildDefLink.setUnderlined(true);
                } else {
                    if (BuildMapOverviewPage.this.fBuildMap != null) {
                        BuildMapOverviewPage.this.fBuildDefLink.setText(BuildMapOverviewPage.this.fBuildMap.getBuildDefinitionUUID());
                    } else {
                        BuildMapOverviewPage.this.fBuildDefLink.setText("");
                    }
                    BuildMapOverviewPage.this.fBuildDefLink.setUnderlined(false);
                }
                if (BuildMapOverviewPage.this.fBuildResult == null) {
                    if (BuildMapOverviewPage.this.fPromotionResult == null) {
                        BuildMapOverviewPage.this.fBuildLabel.setText(Messages.BuildMapEditor_GENERAL_BUILD_LABEL);
                        BuildMapOverviewPage.this.fBuildLink.setText(BuildMapOverviewPage.this.fBuildMap.getBuildLabel());
                        BuildMapOverviewPage.this.fBuildLink.setEnabled(false);
                        BuildMapOverviewPage.this.fBuildBrowseButton.setVisible(true);
                    } else {
                        BuildMapOverviewPage.this.fBuildLabel.setText(Messages.BuildMapEditor_GENERAL_PROMO_RESULT_LABEL);
                        BuildMapOverviewPage.this.fBuildLink.setText(BuildMapOverviewPage.this.fPromotionResult.getLabel());
                        BuildMapOverviewPage.this.fBuildLink.setUnderlined(true);
                        BuildMapOverviewPage.this.fBuildBrowseButton.setVisible(false);
                    }
                } else {
                    BuildMapOverviewPage.this.fBuildLabel.setText(Messages.BuildMapEditor_GENERAL_BUILD_LABEL);
                    BuildMapOverviewPage.this.fBuildLink.setText(BuildMapOverviewPage.this.fBuildResult.getLabel());
                    BuildMapOverviewPage.this.fBuildLink.setUnderlined(true);
                    BuildMapOverviewPage.this.fBuildBrowseButton.setVisible(true);
                }
                if (BuildMapOverviewPage.this.fPromotionResult == null) {
                    BuildMapOverviewPage.this.fPromotionDefLabel.dispose();
                    BuildMapOverviewPage.this.fPromotionDefLink.dispose();
                } else {
                    BuildMapOverviewPage.this.setPromotionDefStatus(true);
                    BuildMapOverviewPage.this.fPromotionDefLink.setText(BuildMapOverviewPage.this.fPromotionBuildDefinition.getId());
                }
                if (BuildMapOverviewPage.this.fBuildMap.getSourceBuildMapSlug() == null || BuildMapOverviewPage.this.fBuildMap.getSourceBuildMapSlug().isEmpty()) {
                    BuildMapOverviewPage.this.fSourceBuildMapLabel.dispose();
                    BuildMapOverviewPage.this.fSourceBuildMapLink.dispose();
                }
                if (BuildMapOverviewPage.this.fLangDef != null) {
                    BuildMapOverviewPage.this.fLanguageDefLink.setText(BuildMapOverviewPage.this.fLangDef.getName());
                    BuildMapOverviewPage.this.fLanguageDefLink.setUnderlined(true);
                } else {
                    if (BuildMapOverviewPage.this.fBuildMap != null) {
                        BuildMapOverviewPage.this.fLanguageDefLink.setText(BuildMapOverviewPage.this.fBuildMap.getBuild().getLanguageDefinitionName());
                    } else {
                        BuildMapOverviewPage.this.fLanguageDefLink.setText("");
                    }
                    BuildMapOverviewPage.this.fLanguageDefLink.setUnderlined(false);
                }
                BuildMapOverviewPage.this.fWorkspaceLink.getParent().layout(true);
                BuildMapOverviewPage.this.setScrolledCom(BuildMapOverviewPage.this.fOverviewCom, BuildMapOverviewPage.this.fOverviewContent);
            }
        });
    }

    private void setPromotionDefStatus(boolean visiable) {
        if (this.fPromotionDefLabel != null && !this.fPromotionDefLabel.isDisposed()) {
            this.fPromotionDefLabel.setVisible(visiable);
        }
        if (this.fPromotionDefLink != null && !this.fPromotionDefLink.isDisposed()) {
            this.fPromotionDefLink.setVisible(visiable);
            this.fPromotionDefLink.setUnderlined(visiable);
        }
    }

    protected IHyperlinkListener getBuildResultHyperlinkListener() {
        return new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                IWorkbenchPage page;
                IWorkbenchWindow window;
                IBuildResult openedBuildResult = BuildMapOverviewPage.this.fBuildResult;
                if (openedBuildResult == null) {
                    openedBuildResult = BuildMapOverviewPage.this.fPromotionResult;
                }
                if (openedBuildResult != null && (window = PlatformUI.getWorkbench().getActiveWorkbenchWindow()) != null && (page = window.getActivePage()) != null) {
                    BuildUI.getDefault().open((IBuildResultHandle)openedBuildResult, BuildMapOverviewPage.this.fTeamRepository, page);
                }
            }
        };
    }

    protected IHyperlinkListener getBuildDefHyperlinkListener() {
        return new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                IWorkbenchPage page;
                IWorkbenchWindow window;
                if (BuildMapOverviewPage.this.fBuildDefinition != null && (window = PlatformUI.getWorkbench().getActiveWorkbenchWindow()) != null && (page = window.getActivePage()) != null) {
                    EditBuildDefinitionActionDelegate.run((IBuildDefinition)BuildMapOverviewPage.this.fBuildDefinition, (IWorkbenchPage)page);
                }
            }
        };
    }

    protected IHyperlinkListener getPromDefHyperlinkListener() {
        return new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                IWorkbenchPage page;
                IWorkbenchWindow window;
                if (BuildMapOverviewPage.this.fPromotionBuildDefinition != null && (window = PlatformUI.getWorkbench().getActiveWorkbenchWindow()) != null && (page = window.getActivePage()) != null) {
                    EditBuildDefinitionActionDelegate.run((IBuildDefinition)BuildMapOverviewPage.this.fPromotionBuildDefinition, (IWorkbenchPage)page);
                }
            }
        };
    }

    protected IHyperlinkListener getWorkspaceHyperlinkListener() {
        return new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                IWorkbenchPage page;
                IWorkbenchWindow window;
                if (BuildMapOverviewPage.this.fWorkspace != null && (window = PlatformUI.getWorkbench().getActiveWorkbenchWindow()) != null && (page = window.getActivePage()) != null) {
                    TeamPlacePart2.open((IWorkbenchPage)page, (TeamPlaceEditorInput)TeamPlaceEditorInput.newForEdit((AbstractPlaceWrapper)AbstractPlaceWrapper.newWrapper((IWorkspace)BuildMapOverviewPage.this.fWorkspace)));
                }
            }
        };
    }

    protected IHyperlinkListener getSnapshotHyperlinkListener() {
        return new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                IWorkbenchPage page;
                IWorkbenchWindow window;
                if (BuildMapOverviewPage.this.fSnapshot != null && (window = PlatformUI.getWorkbench().getActiveWorkbenchWindow()) != null && (page = window.getActivePage()) != null) {
                    TeamPlacePart2.open((IWorkbenchPage)page, (SnapshotEditorInput)SnapshotEditorInput.newForEdit((IBaselineSet)BuildMapOverviewPage.this.fSnapshot));
                }
            }
        };
    }

    protected IHyperlinkListener getLangDefHyperlinkListener() {
        return new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                BuildReportUtil.openSystemDefinitionEditor(BuildMapOverviewPage.this.fProjectAreaHandle, (ISystemDefinition)BuildMapOverviewPage.this.fLangDef, BuildMapOverviewPage.this.fLangDefLatest, null);
            }
        };
    }

    private void updateBrowseButton() {
        String toTest = this.fBuildMap.getBuildLabel();
        if (toTest == null || toTest.equals("") || toTest.isEmpty() || this.getStatesLimit() == 0) {
            this.fBuildBrowseButton.setEnabled(false);
        } else {
            this.fBuildBrowseButton.setEnabled(true);
        }
    }

    private int getStatesLimit() {
        IBuildMapClient buildMapClient = null;
        buildMapClient = (IBuildMapClient)this.fTeamRepository.getClientLibrary(IBuildMapClient.class);
        this.fBuildmapStatesLimit = buildMapClient.getBuildMapStatesLimit();
        return this.fBuildmapStatesLimit;
    }

    @Override
    public void refreshContent() {
        this.fBuildMap = null;
        this.fBuildResult = null;
        this.fBuildDefinition = null;
        this.fPromotionResult = null;
        this.fPromotionBuildDefinition = null;
        this.fProjectAreaHandle = null;
        this.fLangDef = null;
        this.fLangDefLatest = true;
        this.fSourceFile = null;
        this.fWorkspace = null;
        this.fSnapshot = null;
    }

    public void chooseBuildMapState() {
        TeamBuildJob job = new TeamBuildJob(Messages.BuildMapStateDialog_RETRIEVING_STATES, true){

            protected IStatus runProtected(IProgressMonitor monitor) throws Exception {
                IBuildMapClient buildMapClient = (IBuildMapClient)BuildMapOverviewPage.this.fTeamRepository.getClientLibrary(IBuildMapClient.class);
                try {
                    BuildMapOverviewPage.this.fBuildMapStatesMap = buildMapClient.getBuildMapStates(UUID.valueOf((String)BuildMapOverviewPage.this.fBuildMap.getBuildableFile()), UUID.valueOf((String)BuildMapOverviewPage.this.fBuildMap.getBuildDefinitionUUID()), null);
                }
                catch (TeamRepositoryException e) {
                    Activator.getDefault().logError(e);
                    return new Status(4, "com.ibm.team.enterprise.build.ui", Messages.BuildMapStateDialog_ERROR_RETRIEVING_STATES, (Throwable)e);
                }
                BuildMapOverviewPage.this.fBuildmapStatesLimit = buildMapClient.getBuildMapStatesLimit();
                return Status.OK_STATUS;
            }

            protected void jobFinished(IStatus status) {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        IAuditableHandle choice = null;
                        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                        if (BuildMapOverviewPage.this.fBuildMapStatesMap != null && !BuildMapOverviewPage.this.fBuildMapStatesMap.isEmpty()) {
                            Object[] objects;
                            Set set = BuildMapOverviewPage.this.fBuildMapStatesMap.keySet();
                            LinkedHashMap<String, String> buildLabelMap = new LinkedHashMap<String, String>();
                            for (String s : set) {
                                if (s.endsWith("-")) {
                                    buildLabelMap.put(String.valueOf(s) + Messages.BuildMapStateDialog_BUILD_DELETED_SUFFIX, s);
                                    continue;
                                }
                                buildLabelMap.put(s, s);
                            }
                            Object[] contents = objects = buildLabelMap.keySet().toArray();
                            String message = null;
                            String selection = BuildMapOverviewPage.this.fBuildLink.getText();
                            if (!BuildMapOverviewPage.this.fBuildLink.isEnabled()) {
                                selection = String.valueOf(selection) + '-' + Messages.BuildMapStateDialog_BUILD_DELETED_SUFFIX;
                            }
                            if (BuildMapOverviewPage.this.fBuildmapStatesLimit > 0 && BuildMapOverviewPage.this.fBuildmapStatesLimit < objects.length) {
                                Object[] subsettedList;
                                int selectionIndex = Arrays.asList(objects).indexOf(selection);
                                int endIndex = selectionIndex + BuildMapOverviewPage.this.fBuildmapStatesLimit - 1;
                                if (endIndex >= objects.length) {
                                    subsettedList = Arrays.copyOfRange(objects, objects.length - BuildMapOverviewPage.this.fBuildmapStatesLimit, objects.length);
                                } else if (selectionIndex < BuildMapOverviewPage.this.fBuildmapStatesLimit - 1) {
                                    subsettedList = Arrays.copyOfRange(objects, 0, BuildMapOverviewPage.this.fBuildmapStatesLimit);
                                } else {
                                    int mid = BuildMapOverviewPage.this.fBuildmapStatesLimit / 2;
                                    subsettedList = Arrays.copyOfRange(objects, selectionIndex - mid, selectionIndex + (BuildMapOverviewPage.this.fBuildmapStatesLimit - mid));
                                }
                                message = NLS.bind((String)Messages.BuildMapStateDialog_PARTIAL_INFO, (Object)BuildMapOverviewPage.this.fBuildmapStatesLimit, (Object)objects.length);
                                contents = subsettedList;
                            } else {
                                message = NLS.bind((String)Messages.BuildMapStateDialog_FULL_INFO, (Object)objects.length);
                            }
                            final Object[] buildLabelContents = contents;
                            ElementListSelectionDialog dialog = new ElementListSelectionDialog(shell, (ILabelProvider)new LabelProvider()){

                                protected FilteredList createFilteredList(Composite parent) {
                                    FilteredList result = super.createFilteredList(parent);
                                    result.setComparator(new Comparator(){

                                        public int compare(Object o1, Object o2) {
                                            int o2Index;
                                            int o1Index = this.getIndex(o1);
                                            if (o1Index == (o2Index = this.getIndex(o2))) {
                                                return 0;
                                            }
                                            return o1Index < o2Index ? -1 : 1;
                                        }

                                        public int getIndex(Object o1) {
                                            int result = -1;
                                            int i = 0;
                                            while (i < buildLabelContents.length) {
                                                if (buildLabelContents[i].equals(o1.toString())) {
                                                    result = i;
                                                    break;
                                                }
                                                ++i;
                                            }
                                            return result;
                                        }
                                    });
                                    return result;
                                }
                            };
                            dialog.setMessage(message);
                            dialog.setElements(contents);
                            dialog.setTitle(Messages.BuildMapStateDialog_TITLE);
                            dialog.setInitialSelections(new Object[]{selection});
                            if (dialog.open() == 0) {
                                choice = (IAuditableHandle)BuildMapOverviewPage.this.fBuildMapStatesMap.get(buildLabelMap.get(dialog.getFirstResult()));
                                IBuildMapHandle buildMapHandle = (IBuildMapHandle)IBuildMap.ITEM_TYPE.createItemHandle(choice.getItemId(), choice.getStateId());
                                URI buildMapURI = URIUtilities.createItemURI((ITeamRepository)(this).BuildMapOverviewPage.this.fTeamRepository, (IItemHandle)buildMapHandle);
                                ((BuildMapEditorInput)BuildMapOverviewPage.this.getEditorInput()).setfBuildMapURI(buildMapURI);
                                try {
                                    ((BuildMapEditor)BuildMapOverviewPage.this.getEditor()).removePages();
                                    ((BuildMapEditor)BuildMapOverviewPage.this.getEditor()).addPages();
                                    ((BuildMapEditor)BuildMapOverviewPage.this.getEditor()).init((IEditorSite)BuildMapOverviewPage.this.getSite(), BuildMapOverviewPage.this.getEditorInput());
                                }
                                catch (PartInitException e) {
                                    e.printStackTrace();
                                }
                            }
                        }
                    }
                });
            }
        };
        job.schedule();
    }
}

