/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.build.ui.editors.buildmap;

import com.ibm.team.build.internal.common.helper.TimeFormatHelper;
import com.ibm.team.enterprise.build.ui.Activator;
import com.ibm.team.enterprise.build.ui.editors.result.AbstractBuildStyledLabelProvider;
import com.ibm.team.enterprise.internal.build.ui.utils.BuildReportUtil;
import com.ibm.team.enterprise.internal.buildmap.common.IBuildFile;
import com.ibm.team.enterprise.internal.buildmap.common.IBuildMap;
import com.ibm.team.enterprise.systemdefinition.common.model.ISystemDefinition;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

public class BuildMapOutputsStyledLabelProvider
extends AbstractBuildStyledLabelProvider {
    private ITeamRepository fTeamRepository;
    private volatile Map<String, ISystemDefinition> fSysDefCache;
    protected IBuildMap fBuildMap = null;

    public BuildMapOutputsStyledLabelProvider(Set<Integer> underLineSet, ITeamRepository teamRepository, Map<String, ISystemDefinition> fSysDefCache) {
        super(underLineSet, null);
        this.fTeamRepository = teamRepository;
        this.fSysDefCache = fSysDefCache;
    }

    public void setBuildMap(IBuildMap buildMap) {
        this.fBuildMap = buildMap;
    }

    @Override
    public Image getColumnImage(Object element, int columnIndex) {
        return null;
    }

    @Override
    public boolean isLinkStyledElement(Object element) {
        boolean result = false;
        if (element instanceof IBuildFile) {
            result = this.fBuildMap != null && this.fBuildMap.getBuild() != null && this.fBuildMap.getBuild().getLanguageDefinitionUuid() != null && !"".equals(this.fBuildMap.getBuild().getLanguageDefinitionUuid());
        }
        return result;
    }

    @Override
    public String getColumnText(final Object element, int columnIndex) {
        String result = null;
        if (element instanceof IBuildFile) {
            IBuildFile buildFile = (IBuildFile)element;
            switch (columnIndex) {
                case 0: {
                    result = BuildReportUtil.generateBuildFileFullPath((String)buildFile.getBuildPath(), (String)buildFile.getBuildFile(), (String)buildFile.getOutputType(), (String)buildFile.getSequential(), (boolean)buildFile.isHFS());
                    break;
                }
                case 1: {
                    final String resourceDefUUID = buildFile.getResourceDefinitionID();
                    Job loadResourceJob = new Job(""){

                        protected IStatus run(IProgressMonitor monitor) {
                            try {
                                BuildReportUtil.getSystemDefinition(resourceDefUUID, null, "resourcedefinition", BuildMapOutputsStyledLabelProvider.this.fSysDefCache, BuildMapOutputsStyledLabelProvider.this.fTeamRepository, null);
                            }
                            catch (TeamRepositoryException e) {
                                Activator.getDefault().logError(e);
                            }
                            return Status.OK_STATUS;
                        }
                    };
                    if (this.fSysDefCache.get(resourceDefUUID) != null) {
                        result = this.fSysDefCache.get(resourceDefUUID).getName();
                        break;
                    }
                    result = resourceDefUUID == null ? "" : resourceDefUUID;
                    loadResourceJob.setSystem(true);
                    loadResourceJob.schedule();
                    loadResourceJob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                        public void done(IJobChangeEvent event) {
                            event.getJob().removeJobChangeListener((IJobChangeListener)this);
                            Display.getDefault().asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    BuildMapOutputsStyledLabelProvider.this.fireLabelProviderChanged(new LabelProviderChangedEvent((IBaseLabelProvider)BuildMapOutputsStyledLabelProvider.this, element));
                                }
                            });
                        }
                    });
                    break;
                }
                case 2: {
                    long timeStamp = buildFile.getTimestamp();
                    if (timeStamp > 0L) {
                        result = TimeFormatHelper.getDateString((long)timeStamp);
                        break;
                    }
                    result = "";
                    break;
                }
                case 3: {
                    result = buildFile.getDeployType();
                }
            }
        }
        if (result == null) {
            result = "";
        }
        return result;
    }

    @Override
    public String getToolTipText(Object element, int columnIndex) {
        return null;
    }

    @Override
    public Image getToolTipImage(Object element, int columnIndex) {
        return null;
    }
}

