/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.build.ui.editors.buildmap;

import com.ibm.team.enterprise.build.ui.editors.buildmap.AbstractBuildMapFormPage;
import com.ibm.team.enterprise.build.ui.editors.buildmap.BuildMapOutputsStyledLabelProvider;
import com.ibm.team.enterprise.internal.build.ui.nls.Messages;
import com.ibm.team.enterprise.internal.build.ui.utils.BuildReportUtil;
import com.ibm.team.enterprise.internal.buildmap.common.IBuildFile;
import com.ibm.team.enterprise.internal.buildmap.common.IOutput;
import com.ibm.team.enterprise.systemdefinition.common.model.IIBMiPlatformObject;
import com.ibm.team.enterprise.systemdefinition.common.model.ISystemDefinition;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.FocusCellHighlighter;
import org.eclipse.jface.viewers.FocusCellOwnerDrawHighlighter;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerFocusCellManager;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.part.PageBook;

public class BuildMapOutputsPage
extends AbstractBuildMapFormPage {
    private PageBook fWholePageBook = null;
    private SashForm fViewContentParent = null;
    private Composite fTopCom = null;
    private Composite fOutputTableComposite = null;
    private Table fOutputsTable = null;
    private TableViewer fOutputsTableView = null;
    private final Composite fDefaultControl = null;
    private final Composite fNoBuildMapControl = null;
    private final Label fNoBuildMapLink = null;
    private BuildMapOutputsStyledLabelProvider fOutputTableViewerLabelProvider = null;

    public BuildMapOutputsPage(FormEditor editor, String id, String title) {
        super(editor, id, title);
    }

    @Override
    protected void createContainerContent(Composite container) {
        this.fWholePageBook = new PageBook(container, 0);
        this.fWholePageBook.setBackground(container.getBackground());
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.fWholePageBook);
        this.createNoBuildMapControl((Composite)this.fWholePageBook);
        this.fViewContentParent = new SashForm((Composite)this.fWholePageBook, 512);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.fViewContentParent);
        this.fViewContentParent.setBackground(container.getBackground());
        GridLayoutFactory.fillDefaults().applyTo((Composite)this.fViewContentParent);
        this.fTopCom = new Composite((Composite)this.fViewContentParent, 0);
        this.fTopCom.setBackground(container.getBackground());
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.fTopCom);
        GridLayoutFactory.fillDefaults().margins(5, 2).applyTo(this.fTopCom);
        this.createOutputsPart(this.fTopCom);
        this.fTopCom.layout();
        container.layout();
        this.initializeContent();
    }

    @Override
    public void initializeContent() {
        if (this.fBuildMap != null && this.fWholePageBook != null) {
            this.fWholePageBook.showPage((Control)this.fViewContentParent);
            if (this.fBuildMap == null) {
                if (this.fBuildMapURI != null) {
                    this.fWholePageBook.showPage((Control)this.fNoBuildMapControl);
                    this.fNoBuildMapLink.setText(NLS.bind((String)Messages.BuildMapEditor_NOMAP_LABEL, (Object)this.fBuildMapURI));
                    this.fNoBuildMapControl.layout();
                } else {
                    this.fWholePageBook.showPage((Control)this.fDefaultControl);
                }
            } else {
                this.fWholePageBook.showPage((Control)this.fViewContentParent);
            }
            this.updateContent();
        }
    }

    private void createOutputsPart(Composite rightPartCom) {
        Section outputsSection = this.createSection(rightPartCom, Messages.BuildMapEditor_OUTPUTS_SECTION_TITLE, null, 0, true, true);
        this.fOutputTableComposite = this.fFormToolkit.createComposite((Composite)outputsSection);
        outputsSection.setClient((Control)this.fOutputTableComposite);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.fOutputTableComposite);
        TableColumnLayout columnLayout = new TableColumnLayout();
        this.fOutputTableComposite.setLayout((Layout)columnLayout);
        this.fOutputsTable = this.fFormToolkit.createTable(this.fOutputTableComposite, 68352);
        this.fOutputsTableView = new TableViewer(this.fOutputsTable);
        BuildReportUtil.createTableColumn(this.fOutputsTableView, this.fOutputsTable, columnLayout, Messages.BuildMapEditor_OUTPUTS_FILE_LOCATION_TABLE_COLUMN, 20, 16384, 0, Messages.BuildMapEditor_OUTPUTS_FILE_LOCATION_TABLE_COLUMN, 1);
        if (this.fLangDef != null && this.fLangDef instanceof IIBMiPlatformObject) {
            TableColumn column = BuildReportUtil.createTableColumn(this.fOutputsTableView, this.fOutputsTable, columnLayout, Messages.BuildMapEditor_OUTPUTS_RESOURCE_DEFINITION_TABLE_COLUMN, 0, 16384, 1, Messages.BuildMapEditor_OUTPUTS_RESOURCE_DEFINITION_TABLE_COLUMN, 1);
            column.setResizable(false);
        } else {
            BuildReportUtil.createTableColumn(this.fOutputsTableView, this.fOutputsTable, columnLayout, Messages.BuildMapEditor_OUTPUTS_RESOURCE_DEFINITION_TABLE_COLUMN, 10, 16384, 1, Messages.BuildMapEditor_OUTPUTS_RESOURCE_DEFINITION_TABLE_COLUMN, 1);
        }
        BuildReportUtil.createTableColumn(this.fOutputsTableView, this.fOutputsTable, columnLayout, Messages.BuildMapEditor_INPUTS_LAST_MODIFIED_TABLE_COLUMN, 20, 16384, 2, Messages.BuildMapEditor_INPUTS_LAST_MODIFIED_TABLE_COLUMN, 1);
        BuildReportUtil.createTableColumn(this.fOutputsTableView, this.fOutputsTable, columnLayout, Messages.BuildMapEditor_OUTPUTS_DEPLOY_TYPE_TABLE_COLUMN, 20, 16384, 3, Messages.BuildMapEditor_OUTPUTS_DEPLOY_TYPE_TABLE_COLUMN, 1);
        this.fOutputsTable.setLinesVisible(true);
        this.fOutputsTable.setHeaderVisible(true);
        HashSet<Integer> underlineSet = new HashSet<Integer>();
        this.fOutputTableViewerLabelProvider = new BuildMapOutputsStyledLabelProvider(underlineSet, this.fTeamRepository, this.fSysDefCache);
        underlineSet.add(1);
        this.fOutputsTableView.setLabelProvider((IBaseLabelProvider)this.fOutputTableViewerLabelProvider);
        this.fOutputsTableView.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        final TableViewerFocusCellManager cellManagers = new TableViewerFocusCellManager(this.fOutputsTableView, (FocusCellHighlighter)new FocusCellOwnerDrawHighlighter((ColumnViewer)this.fOutputsTableView){});
        this.fOutputsTable.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
                BuildMapOutputsPage.this.handleResourceDefLinkEvent(cellManagers);
            }

            public void mouseDown(MouseEvent e) {
            }

            public void mouseUp(MouseEvent e) {
            }
        });
        this.fOutputsTable.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
            }

            public void keyPressed(KeyEvent e) {
                if (13 == e.keyCode) {
                    BuildMapOutputsPage.this.handleResourceDefLinkEvent(cellManagers);
                }
            }
        });
        this.fOutputsTable.addMouseTrackListener(new MouseTrackListener(){

            public void mouseHover(MouseEvent e) {
                this.doEvent(e);
            }

            public void mouseExit(MouseEvent e) {
            }

            public void mouseEnter(MouseEvent e) {
                this.doEvent(e);
            }

            private void doEvent(MouseEvent e) {
                Object element;
                ViewerCell viewerCell = BuildMapOutputsPage.this.fOutputsTableView.getCell(new Point(e.x, e.y));
                if (viewerCell != null && (element = viewerCell.getElement()) instanceof IBuildFile) {
                    int columnIndex = viewerCell.getColumnIndex();
                    if (1 == columnIndex) {
                        viewerCell.getControl().setCursor(Display.getCurrent().getSystemCursor(21));
                    } else {
                        viewerCell.getControl().setCursor(Display.getCurrent().getSystemCursor(0));
                    }
                }
            }
        });
        outputsSection.setExpanded(true);
    }

    private void handleResourceDefLinkEvent(TableViewerFocusCellManager cellManagers) {
        if (cellManagers == null) {
            return;
        }
        ViewerCell viewerCell = cellManagers.getFocusCell();
        if (viewerCell != null) {
            Object element = viewerCell.getElement();
            int columnIndex = viewerCell.getColumnIndex();
            if (element instanceof IBuildFile && 1 == columnIndex) {
                IBuildFile buildFile = (IBuildFile)element;
                String resourceDefUUID = buildFile.getResourceDefinitionID();
                ISystemDefinition sysDef = (ISystemDefinition)this.fSysDefCache.get(resourceDefUUID);
                BuildReportUtil.openSystemDefinitionEditor(this.fProjectAreaHandle, sysDef, true, null);
            }
        }
    }

    public void updateContent() {
        if (this.fBuildMap == null) {
            return;
        }
        this.fOutputTableViewerLabelProvider.setBuildMap(this.fBuildMap);
        final ArrayList<IBuildFile> outputsList = new ArrayList<IBuildFile>();
        Set outputs = this.fBuildMap.getOutputs();
        for (IOutput output : outputs) {
            IBuildFile buildFile = (IBuildFile)output.getArtifact();
            outputsList.add(buildFile);
        }
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                BuildMapOutputsPage.this.fOutputsTableView.setInput((Object)outputsList);
                BuildMapOutputsPage.this.fOutputsTable.redraw();
                BuildMapOutputsPage.this.fOutputsTable.getParent().layout();
            }
        });
    }

    @Override
    public void refreshContent() {
        this.fBuildMap = null;
    }
}

