/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.build.ui.editors.buildmap;

import com.ibm.team.build.internal.common.helper.TimeFormatHelper;
import com.ibm.team.enterprise.build.ui.Activator;
import com.ibm.team.enterprise.build.ui.editors.result.AbstractBuildStyledLabelProvider;
import com.ibm.team.enterprise.internal.build.ui.nls.Messages;
import com.ibm.team.enterprise.internal.build.ui.utils.BuildReportUtil;
import com.ibm.team.enterprise.internal.build.ui.utils.MVSMemberHyperLinkUtils;
import com.ibm.team.enterprise.internal.buildmap.common.IBuildFile;
import com.ibm.team.enterprise.internal.buildmap.common.IBuildMap;
import com.ibm.team.enterprise.systemdefinition.common.model.ISystemDefinition;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

public class BuildMapLogsStyledLabelProvider
extends AbstractBuildStyledLabelProvider {
    private ITeamRepository fTeamRepository;
    private volatile Map<String, ISystemDefinition> fSysDefCache;
    protected IBuildMap fBuildMap = null;
    private boolean fIsOldBuildMap = false;

    public BuildMapLogsStyledLabelProvider(Set<Integer> underLineSet, ITeamRepository teamRepository, Map<String, ISystemDefinition> fSysDefCache) {
        super(underLineSet, null);
        this.fTeamRepository = teamRepository;
        this.fSysDefCache = fSysDefCache;
    }

    public void setBuildMap(IBuildMap buildMap) {
        this.fBuildMap = buildMap;
    }

    public void setIsOldBuildMap(boolean fIsOldBuildMap) {
        this.fIsOldBuildMap = fIsOldBuildMap;
    }

    @Override
    public Image getColumnImage(Object element, int columnIndex) {
        return null;
    }

    @Override
    public boolean isLinkStyledElement(Object element) {
        boolean result = false;
        if (element instanceof IBuildFile) {
            result = this.fBuildMap != null && this.fBuildMap.getBuild() != null && this.fBuildMap.getBuild().getLanguageDefinitionUuid() != null && !"".equals(this.fBuildMap.getBuild().getLanguageDefinitionUuid());
        }
        return result;
    }

    @Override
    protected boolean isLinkStyledColumn(Object element, int column) {
        if (column == 0 && element instanceof IBuildFile && ((IBuildFile)element).isUsedAsInput() && !MVSMemberHyperLinkUtils.getInstance().isMVSCMemberHyperLink()) {
            return false;
        }
        return super.isLinkStyledColumn(element, column);
    }

    @Override
    public String getColumnText(final Object element, int columnIndex) {
        String result = null;
        if (element instanceof IBuildFile) {
            IBuildFile buildFile = (IBuildFile)element;
            switch (columnIndex) {
                case 0: {
                    result = BuildReportUtil.generateBuildFileFullPath((String)buildFile.getBuildPath(), (String)buildFile.getBuildFile(), (String)buildFile.getOutputType(), (String)buildFile.getSequential(), (boolean)buildFile.isHFS());
                    break;
                }
                case 1: {
                    String resourceDefkey;
                    final String resourceDefUUID = buildFile.getResourceDefinitionID();
                    final String resourceDefStateUUID = buildFile.getResourceDefinitionStateID();
                    Job loadResourceJob = new Job(Messages.BuildMapEditor_LOGS_RETRIEVE_RESOURCEDEF_JOB_TITLE){

                        protected IStatus run(IProgressMonitor monitor) {
                            try {
                                BuildReportUtil.getSystemDefinition(resourceDefUUID, resourceDefStateUUID, "resourcedefinition", BuildMapLogsStyledLabelProvider.this.fSysDefCache, BuildMapLogsStyledLabelProvider.this.fTeamRepository, null);
                            }
                            catch (TeamRepositoryException e) {
                                Activator.getDefault().logError(e);
                            }
                            return Status.OK_STATUS;
                        }
                    };
                    String string = resourceDefkey = resourceDefStateUUID != null ? String.valueOf(resourceDefUUID) + resourceDefStateUUID : resourceDefUUID;
                    if (this.fSysDefCache.get(resourceDefkey) != null) {
                        result = this.fSysDefCache.get(resourceDefkey).getName();
                        break;
                    }
                    result = resourceDefUUID == null ? "" : resourceDefUUID;
                    loadResourceJob.setSystem(true);
                    loadResourceJob.schedule();
                    loadResourceJob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                        public void done(IJobChangeEvent event) {
                            event.getJob().removeJobChangeListener((IJobChangeListener)this);
                            Display.getDefault().asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    BuildMapLogsStyledLabelProvider.this.fireLabelProviderChanged(new LabelProviderChangedEvent((IBaseLabelProvider)BuildMapLogsStyledLabelProvider.this, element));
                                }
                            });
                        }
                    });
                    break;
                }
                case 2: {
                    String translatorkey;
                    final String translatorUUID = buildFile.getDataSetDefinitionUUID();
                    final String translatorStateUUID = buildFile.getDataSetDefinitionStateUUID();
                    Job loadResourceJob = new Job(Messages.BuildMapEditor_LOGS_RETRIEVE_TRANSLATOR_JOB_TITLE){

                        protected IStatus run(IProgressMonitor monitor) {
                            try {
                                BuildReportUtil.getSystemDefinition(translatorUUID, translatorStateUUID, "translator", BuildMapLogsStyledLabelProvider.this.fSysDefCache, BuildMapLogsStyledLabelProvider.this.fTeamRepository, null);
                            }
                            catch (TeamRepositoryException e) {
                                Activator.getDefault().logError(e);
                            }
                            return Status.OK_STATUS;
                        }
                    };
                    String string = translatorkey = translatorStateUUID != null ? String.valueOf(translatorUUID) + translatorStateUUID : translatorUUID;
                    if (this.fSysDefCache.get(translatorkey) != null) {
                        result = this.fSysDefCache.get(translatorkey).getName();
                        break;
                    }
                    result = translatorUUID == null ? "" : translatorUUID;
                    loadResourceJob.setSystem(true);
                    loadResourceJob.schedule();
                    loadResourceJob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                        public void done(IJobChangeEvent event) {
                            event.getJob().removeJobChangeListener((IJobChangeListener)this);
                            Display.getDefault().asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    BuildMapLogsStyledLabelProvider.this.fireLabelProviderChanged(new LabelProviderChangedEvent((IBaseLabelProvider)BuildMapLogsStyledLabelProvider.this, element));
                                }
                            });
                        }
                    });
                    break;
                }
                case 3: {
                    long timeStamp = buildFile.getTimestamp();
                    if (timeStamp > 0L) {
                        result = TimeFormatHelper.getDateString((long)timeStamp);
                        break;
                    }
                    result = "";
                    break;
                }
                case 4: {
                    boolean isCompacted = buildFile.isUsedAsInput();
                    result = isCompacted ? Messages.BuildableSubsetEditorCriteriaPage_TRUE : Messages.BuildableSubsetEditorCriteriaPage_FALSE;
                }
            }
        }
        if (result == null) {
            result = "";
        }
        return result;
    }

    @Override
    public String getToolTipText(Object element, int columnIndex) {
        String result = null;
        if (this.fUnderLineSet != null && this.fUnderLineSet.contains(0) && element instanceof IBuildFile) {
            IBuildFile buildFile = (IBuildFile)element;
            switch (columnIndex) {
                case 0: {
                    result = this.fIsOldBuildMap ? Messages.BuildMapEditor_LOGS_NOT_CURRENT_MAP_TOOLTIP : (buildFile.isUsedAsInput() ? Messages.BuildMapEditor_LOGS_FILE_LINK_COMPACTED_TOOLTIP : Messages.BuildMapEditor_LOGS_FILE_LINK_TOOLTIP);
                }
            }
        }
        return result;
    }

    @Override
    public Image getToolTipImage(Object element, int columnIndex) {
        return null;
    }
}

