/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.build.ui.editors.buildmap;

import com.ibm.team.enterprise.build.ui.editors.buildmap.AbstractBuildMapFormPage;
import com.ibm.team.enterprise.build.ui.editors.buildmap.BuildMapLogsStyledLabelProvider;
import com.ibm.team.enterprise.build.ui.editors.result.BuildReportViewerToolTipSupport;
import com.ibm.team.enterprise.internal.build.ui.nls.Messages;
import com.ibm.team.enterprise.internal.build.ui.utils.BuildReportUtil;
import com.ibm.team.enterprise.internal.build.ui.utils.MVSMemberHyperLinkUtils;
import com.ibm.team.enterprise.internal.buildmap.common.IBuildFile;
import com.ibm.team.enterprise.internal.buildmap.common.IOutput;
import com.ibm.team.enterprise.systemdefinition.common.model.IIBMiPlatformObject;
import com.ibm.team.enterprise.systemdefinition.common.model.ISystemDefinition;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.FocusCellHighlighter;
import org.eclipse.jface.viewers.FocusCellOwnerDrawHighlighter;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerFocusCellManager;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.part.PageBook;

public class BuildMapLogsPage
extends AbstractBuildMapFormPage {
    private PageBook fWholePageBook = null;
    private SashForm fViewContentParent = null;
    private Composite fTopCom = null;
    private Composite fLogsTableComposite = null;
    private Table fLogsTable = null;
    private TableViewer fLogsTableView = null;
    private final Composite fDefaultControl = null;
    private final Composite fNoBuildMapControl = null;
    private final Label fNoBuildMapLink = null;
    private BuildMapLogsStyledLabelProvider fLogsTableViewerLabelProvider = null;
    private boolean fIsFileLocationLinked = false;
    private Set<Integer> fUnderlineSet = null;

    public BuildMapLogsPage(FormEditor editor, String id, String title) {
        super(editor, id, title);
    }

    @Override
    protected void createContainerContent(Composite container) {
        this.fWholePageBook = new PageBook(container, 0);
        this.fWholePageBook.setBackground(container.getBackground());
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.fWholePageBook);
        this.createNoBuildMapControl((Composite)this.fWholePageBook);
        this.fViewContentParent = new SashForm((Composite)this.fWholePageBook, 512);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.fViewContentParent);
        this.fViewContentParent.setBackground(container.getBackground());
        GridLayoutFactory.fillDefaults().applyTo((Composite)this.fViewContentParent);
        this.fTopCom = new Composite((Composite)this.fViewContentParent, 0);
        this.fTopCom.setBackground(container.getBackground());
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.fTopCom);
        GridLayoutFactory.fillDefaults().margins(5, 2).applyTo(this.fTopCom);
        this.createLogsPart(this.fTopCom);
        this.fTopCom.layout();
        container.layout();
        this.initializeContent();
    }

    @Override
    public void initializeContent() {
        if (this.fBuildMap != null && this.fWholePageBook != null) {
            this.fWholePageBook.showPage((Control)this.fViewContentParent);
            if (this.fBuildMap == null) {
                if (this.fBuildMapURI != null) {
                    this.fWholePageBook.showPage((Control)this.fNoBuildMapControl);
                    this.fNoBuildMapLink.setText(NLS.bind((String)Messages.BuildMapEditor_NOMAP_LABEL, (Object)this.fBuildMapURI));
                    this.fNoBuildMapControl.layout();
                } else {
                    this.fWholePageBook.showPage((Control)this.fDefaultControl);
                }
            } else {
                this.fWholePageBook.showPage((Control)this.fViewContentParent);
            }
            this.updateContent();
        }
    }

    private void createLogsPart(Composite rightPartCom) {
        Section outputsSection = this.createSection(rightPartCom, Messages.BuildMapEditor_LOGS_SECTION_TITLE, null, 0, true, true);
        this.fLogsTableComposite = this.fFormToolkit.createComposite((Composite)outputsSection);
        outputsSection.setClient((Control)this.fLogsTableComposite);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.fLogsTableComposite);
        TableColumnLayout columnLayout = new TableColumnLayout();
        this.fLogsTableComposite.setLayout((Layout)columnLayout);
        this.fLogsTable = this.fFormToolkit.createTable(this.fLogsTableComposite, 68352);
        this.fLogsTableView = new TableViewer(this.fLogsTable);
        BuildReportUtil.createTableColumn(this.fLogsTableView, this.fLogsTable, columnLayout, Messages.BuildMapEditor_OUTPUTS_FILE_LOCATION_TABLE_COLUMN, 20, 16384, 0, Messages.BuildMapEditor_OUTPUTS_FILE_LOCATION_TABLE_COLUMN, 4);
        if (this.fLangDef != null && this.fLangDef instanceof IIBMiPlatformObject) {
            TableColumn column = BuildReportUtil.createTableColumn(this.fLogsTableView, this.fLogsTable, columnLayout, Messages.BuildMapEditor_OUTPUTS_RESOURCE_DEFINITION_TABLE_COLUMN, 0, 16384, 1, Messages.BuildMapEditor_OUTPUTS_RESOURCE_DEFINITION_TABLE_COLUMN, 4);
            column.setResizable(false);
            TableColumn translatorColumn = BuildReportUtil.createTableColumn(this.fLogsTableView, this.fLogsTable, columnLayout, Messages.BuildMapEditor_LOGS_TRANSLATOR_TABLE_COLUMN, 0, 16384, 2, Messages.BuildMapEditor_LOGS_TRANSLATOR_TABLE_COLUMN, 4);
            translatorColumn.setResizable(false);
        } else {
            BuildReportUtil.createTableColumn(this.fLogsTableView, this.fLogsTable, columnLayout, Messages.BuildMapEditor_OUTPUTS_RESOURCE_DEFINITION_TABLE_COLUMN, 10, 16384, 1, Messages.BuildMapEditor_OUTPUTS_RESOURCE_DEFINITION_TABLE_COLUMN, 4);
            BuildReportUtil.createTableColumn(this.fLogsTableView, this.fLogsTable, columnLayout, Messages.BuildMapEditor_LOGS_TRANSLATOR_TABLE_COLUMN, 10, 16384, 2, Messages.BuildMapEditor_LOGS_TRANSLATOR_TABLE_COLUMN, 4);
        }
        BuildReportUtil.createTableColumn(this.fLogsTableView, this.fLogsTable, columnLayout, Messages.BuildMapEditor_INPUTS_LAST_MODIFIED_TABLE_COLUMN, 20, 16384, 3, Messages.BuildMapEditor_INPUTS_LAST_MODIFIED_TABLE_COLUMN, 4);
        BuildReportUtil.createTableColumn(this.fLogsTableView, this.fLogsTable, columnLayout, Messages.BuildMapEditor_LOGS_COMPACTED_TABLE_COLUMN, 20, 16384, 4, Messages.BuildMapEditor_LOGS_COMPACTED_TABLE_COLUMN, 4);
        BuildReportViewerToolTipSupport.enableFor((ColumnViewer)this.fLogsTableView);
        this.fLogsTable.setLinesVisible(true);
        this.fLogsTable.setHeaderVisible(true);
        this.fUnderlineSet = new HashSet<Integer>();
        this.fLogsTableViewerLabelProvider = new BuildMapLogsStyledLabelProvider(this.fUnderlineSet, this.fTeamRepository, this.fSysDefCache);
        this.fLogsTableView.setLabelProvider((IBaseLabelProvider)this.fLogsTableViewerLabelProvider);
        this.fLogsTableView.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        final TableViewerFocusCellManager cellManagers = new TableViewerFocusCellManager(this.fLogsTableView, (FocusCellHighlighter)new FocusCellOwnerDrawHighlighter((ColumnViewer)this.fLogsTableView){});
        this.fLogsTable.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
                BuildMapLogsPage.this.handleHyperLinkEvent(cellManagers);
            }

            public void mouseDown(MouseEvent e) {
            }

            public void mouseUp(MouseEvent e) {
            }
        });
        this.fLogsTable.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
            }

            public void keyPressed(KeyEvent e) {
                if (13 == e.keyCode) {
                    BuildMapLogsPage.this.handleHyperLinkEvent(cellManagers);
                }
            }
        });
        this.fLogsTable.addMouseTrackListener(new MouseTrackListener(){

            public void mouseHover(MouseEvent e) {
                this.doEvent(e);
            }

            public void mouseExit(MouseEvent e) {
            }

            public void mouseEnter(MouseEvent e) {
                this.doEvent(e);
            }

            private void doEvent(MouseEvent e) {
                Object element;
                ViewerCell viewerCell = BuildMapLogsPage.this.fLogsTableView.getCell(new Point(e.x, e.y));
                if (viewerCell != null && (element = viewerCell.getElement()) instanceof IBuildFile) {
                    int columnIndex = viewerCell.getColumnIndex();
                    if (1 == columnIndex || BuildMapLogsPage.this.fIsFileLocationLinked && columnIndex == 0) {
                        viewerCell.getControl().setCursor(Display.getCurrent().getSystemCursor(21));
                    } else {
                        viewerCell.getControl().setCursor(Display.getCurrent().getSystemCursor(0));
                    }
                }
            }
        });
        outputsSection.setExpanded(true);
    }

    private void handleUnderlineSet() {
        this.fUnderlineSet.clear();
        this.fUnderlineSet.add(1);
        if (MVSMemberHyperLinkUtils.getInstance().isMVSMemberHyperLink()) {
            this.fUnderlineSet.add(0);
            this.fIsFileLocationLinked = true;
        }
        this.fUnderlineSet.add(2);
    }

    private void handleHyperLinkEvent(TableViewerFocusCellManager cellManagers) {
        if (cellManagers == null) {
            return;
        }
        ViewerCell viewerCell = cellManagers.getFocusCell();
        if (viewerCell != null) {
            Object element = viewerCell.getElement();
            int columnIndex = viewerCell.getColumnIndex();
            if (element instanceof IBuildFile && 1 == columnIndex) {
                IBuildFile buildFile = (IBuildFile)element;
                String resourceDefUUID = buildFile.getResourceDefinitionID();
                String resourceDefStateUUID = buildFile.getResourceDefinitionStateID();
                String resouorceDefKey = resourceDefStateUUID == null ? resourceDefUUID : String.valueOf(resourceDefUUID) + resourceDefStateUUID;
                ISystemDefinition sysDef = (ISystemDefinition)this.fSysDefCache.get(resouorceDefKey);
                BuildReportUtil.openSystemDefinitionEditor(this.fProjectAreaHandle, sysDef, true, null);
            } else if (element instanceof IBuildFile && 2 == columnIndex) {
                IBuildFile buildFile = (IBuildFile)element;
                String translatorUUID = buildFile.getDataSetDefinitionUUID();
                String translatorStateUUID = buildFile.getDataSetDefinitionStateUUID();
                String translatorKey = translatorStateUUID == null ? translatorUUID : String.valueOf(translatorUUID) + translatorStateUUID;
                ISystemDefinition sysDef = (ISystemDefinition)this.fSysDefCache.get(translatorKey);
                BuildReportUtil.openSystemDefinitionEditor(this.fProjectAreaHandle, sysDef, true, null);
            } else if (this.fIsFileLocationLinked && element instanceof IBuildFile && columnIndex == 0) {
                if (this.fIsOldBuildMap) {
                    MessageDialog.openWarning((Shell)Display.getCurrent().getActiveShell(), (String)Messages.BuildMapEditor_LOGS_MESSAGE_DIALOG_TITLE, (String)Messages.BuildMapEditor_LOGS_MESSAGE_DIALOG_MESSAGE);
                } else {
                    IBuildFile buildFile = (IBuildFile)element;
                    String hostName = buildFile.getResourceName();
                    BuildReportUtil.handleOpenMVSMember(hostName, buildFile.getBuildPath(), buildFile.getBuildFile(), buildFile.isUsedAsInput());
                }
            }
        }
    }

    public void updateContent() {
        if (this.fBuildMap == null) {
            return;
        }
        this.fIsFileLocationLinked = false;
        this.handleUnderlineSet();
        this.fLogsTableViewerLabelProvider.setBuildMap(this.fBuildMap);
        this.fLogsTableViewerLabelProvider.setIsOldBuildMap(this.fIsOldBuildMap);
        final ArrayList<IBuildFile> logsList = new ArrayList<IBuildFile>();
        Set logs = this.fBuildMap.getLogs();
        for (IOutput log : logs) {
            IBuildFile buildFile = (IBuildFile)log.getArtifact();
            logsList.add(buildFile);
        }
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                BuildMapLogsPage.this.fLogsTableView.setInput((Object)logsList);
                BuildMapLogsPage.this.fLogsTable.redraw();
                BuildMapLogsPage.this.fLogsTable.getParent().layout();
            }
        });
    }

    @Override
    public void refreshContent() {
        this.fBuildMap = null;
    }
}

