/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.build.ui.editors.buildmap;

import com.ibm.team.enterprise.build.ui.editors.result.AbstractBuildStyledLabelProvider;
import com.ibm.team.enterprise.internal.build.ui.nls.Messages;
import com.ibm.team.enterprise.internal.build.ui.utils.BuildReportUtil;
import com.ibm.team.enterprise.internal.buildmap.common.IBuildFile;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.graphics.Image;

public class BuildMapInputsUnresolvedStyledLabelProvider
extends AbstractBuildStyledLabelProvider {
    private List<IBuildFile> fGeneratedSources = null;

    public BuildMapInputsUnresolvedStyledLabelProvider(Set<Integer> underLineSet, Set<Integer> qualifierSet) {
        super(underLineSet, qualifierSet);
    }

    @Override
    protected boolean isQualifierStyledElement(Object element, int columnIndex) {
        boolean result = false;
        if (element != null && element instanceof IBuildFile && super.isQualifierStyledElement(element, columnIndex) && this.fGeneratedSources != null) {
            String[] pathArray;
            IBuildFile fUnresolvedInput = (IBuildFile)element;
            String buildPath = fUnresolvedInput.getBuildPath();
            String[] stringArray = pathArray = buildPath != null ? buildPath.split(":") : null;
            if (pathArray != null && pathArray.length > 0) {
                String[] stringArray2 = pathArray;
                int n = pathArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String path = stringArray2[n2];
                    String fullPath = BuildReportUtil.generateBuildFileFullPath((String)path, (String)fUnresolvedInput.getBuildFile(), (String)fUnresolvedInput.getOutputType(), (String)fUnresolvedInput.getSequential(), (boolean)fUnresolvedInput.isHFS());
                    for (IBuildFile fGeneratedSource : this.fGeneratedSources) {
                        String gFullPath = BuildReportUtil.generateBuildFileFullPath((String)fGeneratedSource.getBuildPath(), (String)fGeneratedSource.getBuildFile(), (String)fGeneratedSource.getOutputType(), (String)fGeneratedSource.getSequential(), (boolean)fGeneratedSource.isHFS());
                        if (gFullPath == null || !gFullPath.equals(fullPath)) continue;
                        result = true;
                        break;
                    }
                    if (result) break;
                    ++n2;
                }
            }
        }
        return result;
    }

    @Override
    protected StyledString getQualifierStyledText(Object element, int columnIndex) {
        StyledString st = null;
        if (element != null && element instanceof IBuildFile) {
            IBuildFile node = (IBuildFile)element;
            st = BuildReportUtil.getQualifierSourceString(node.getBuildFile(), Messages.BuildMapEditor_INPUTS_UNRESOLVED_GENERATED_SOURCES_LABEL);
        }
        return st;
    }

    public void setGeneratedSources(List<IBuildFile> fGeneratedSources) {
        this.fGeneratedSources = fGeneratedSources;
    }

    @Override
    public Image getColumnImage(Object element, int columnIndex) {
        return null;
    }

    @Override
    public boolean isLinkStyledElement(Object element) {
        boolean result = false;
        if (element instanceof IBuildFile) {
            result = true;
        }
        return result;
    }

    @Override
    public String getColumnText(Object element, int columnIndex) {
        String result = null;
        if (element instanceof IBuildFile) {
            IBuildFile buildFile = (IBuildFile)element;
            switch (columnIndex) {
                case 0: {
                    result = buildFile.getBuildFile();
                    break;
                }
                case 1: {
                    result = buildFile.getBuildPath();
                    break;
                }
                case 2: {
                    result = buildFile.getType();
                }
            }
        }
        if (result == null) {
            result = "";
        }
        return result;
    }

    @Override
    public String getToolTipText(Object element, int columnIndex) {
        return null;
    }

    @Override
    public Image getToolTipImage(Object element, int columnIndex) {
        return null;
    }
}

