/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.build.ui.editors.buildmap;

import com.ibm.team.enterprise.build.ui.editors.buildmap.AbstractBuildMapComparator;
import com.ibm.team.enterprise.build.ui.editors.buildmap.ResolvedInputNode;
import com.ibm.team.enterprise.build.ui.editors.buildmap.ResolvedInputRootNode;
import com.ibm.team.enterprise.internal.build.ui.utils.BuildReportUtil;
import com.ibm.team.enterprise.internal.buildmap.common.IBuildFile;
import org.eclipse.jface.viewers.Viewer;

public class BuildMapInputsResolvedComparator
extends AbstractBuildMapComparator {
    public BuildMapInputsResolvedComparator(int colIndex, int sortDirection) {
        super(colIndex, sortDirection);
    }

    @Override
    public int compare(Viewer viewer, Object sourceCol, Object targetCol) {
        int result = 0;
        if (sourceCol != null && targetCol != null && sourceCol instanceof IBuildFile && targetCol instanceof IBuildFile || sourceCol instanceof ResolvedInputNode && targetCol instanceof ResolvedInputNode) {
            IBuildFile sourceFile = null;
            IBuildFile targetFile = null;
            if (sourceCol instanceof IBuildFile) {
                sourceFile = (IBuildFile)sourceCol;
                targetFile = (IBuildFile)targetCol;
            } else if (sourceCol instanceof ResolvedInputNode) {
                sourceFile = ((ResolvedInputNode)sourceCol).getBuildFile();
                targetFile = ((ResolvedInputNode)targetCol).getBuildFile();
            }
            if (this.fColIndex == 0) {
                String sourceFullPath = BuildReportUtil.generateBuildFileFullPath((String)sourceFile.getBuildPath(), (String)sourceFile.getBuildFile(), (String)sourceFile.getOutputType(), (String)sourceFile.getSequential(), (boolean)sourceFile.isHFS());
                String targetFullPath = BuildReportUtil.generateBuildFileFullPath((String)targetFile.getBuildPath(), (String)targetFile.getBuildFile(), (String)targetFile.getOutputType(), (String)targetFile.getSequential(), (boolean)targetFile.isHFS());
                result = this.compareString(sourceFullPath, targetFullPath);
            } else if (1 == this.fColIndex) {
                result = this.compareString(sourceFile.getSCMLocation(), targetFile.getSCMLocation());
            } else if (2 == this.fColIndex) {
                result = this.compareString(sourceFile.getType(), targetFile.getType());
            } else if (3 == this.fColIndex) {
                result = this.compareString(sourceFile.getUserPropertyValue("versionID"), targetFile.getUserPropertyValue("versionID"));
            }
        } else if (sourceCol instanceof ResolvedInputRootNode) {
            ResolvedInputRootNode nodeSource = (ResolvedInputRootNode)sourceCol;
            ResolvedInputRootNode nodeTarget = (ResolvedInputRootNode)targetCol;
            result = nodeSource.getProjectName().compareTo(nodeTarget.getProjectName());
        }
        result = this.fSortDirection == 128 ? result : result * -1;
        return result;
    }
}

